/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DirectByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.MappedByteBuffer;
import java.nio.MappedByteBufferAdapter;
import java.nio.ReadOnlyFileChannel;
import java.nio.ReadWriteFileChannel;
import java.nio.WriteOnlyFileChannel;
import java.nio.channels.FileChannel;

public class NioUtils {
    public static int getDirectBufferAddress(Buffer buffer) {
        return buffer.effectiveDirectAddress;
    }

    public static void freeDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer instanceof DirectByteBuffer) {
            ((DirectByteBuffer)buffer).free();
        } else if (buffer instanceof MappedByteBuffer) {
            ((MappedByteBufferAdapter)buffer).free();
        } else {
            throw new AssertionError();
        }
    }

    public static int getFd(FileChannel fc) {
        return ((FileChannelImpl)fc).getHandle();
    }

    public static FileChannel newFileChannel(Object stream, int fd, int mode) {
        switch (mode) {
            case 0: {
                return new ReadOnlyFileChannel(stream, fd);
            }
            case 1: {
                return new WriteOnlyFileChannel(stream, fd);
            }
            case 16: {
                return new ReadWriteFileChannel(stream, fd);
            }
            case 32: {
                return new ReadWriteFileChannel(stream, fd);
            }
            case 256: {
                return new WriteOnlyFileChannel(stream, fd, true);
            }
        }
        throw new RuntimeException("Unknown mode: " + mode);
    }
}

