/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FileChannelImpl;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;

public class ReadOnlyFileChannel
extends FileChannelImpl {
    public ReadOnlyFileChannel(Object stream, int handle) {
        super(stream, handle);
    }

    public int write(ByteBuffer buffer, long position) throws IOException {
        if (buffer == null) {
            throw new NullPointerException();
        }
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        throw new NonWritableChannelException();
    }

    public int write(ByteBuffer buffer) throws IOException {
        this.openCheck();
        throw new NonWritableChannelException();
    }

    public long write(ByteBuffer[] buffers, int offset, int length) throws IOException {
        Arrays.checkOffsetAndCount((int)buffers.length, (int)offset, (int)length);
        this.openCheck();
        throw new NonWritableChannelException();
    }

    public FileChannel truncate(long size) throws IOException {
        this.openCheck();
        if (size < 0L) {
            throw new IllegalArgumentException();
        }
        throw new NonWritableChannelException();
    }

    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this.openCheck();
        if (!src.isOpen()) {
            throw new ClosedChannelException();
        }
        throw new NonWritableChannelException();
    }

    public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
        this.openCheck();
        if (mode == null) {
            throw new NullPointerException();
        }
        if (position < 0L || size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (mode != FileChannel.MapMode.READ_ONLY) {
            throw new NonWritableChannelException();
        }
        return super.mapImpl(mode, position, size);
    }

    public void force(boolean metadata) throws IOException {
        this.openCheck();
    }

    public FileLock basicLock(long position, long size, boolean shared, boolean wait) throws IOException {
        if (!shared) {
            throw new NonWritableChannelException();
        }
        return super.basicLock(position, size, shared, true);
    }
}

