/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import libcore.io.BufferIterator;
import org.apache.harmony.luni.platform.OSMemory;

public class NioBufferIterator
extends BufferIterator {
    public final int address;
    public final int size;
    public final boolean swap;
    public int position;

    public NioBufferIterator(int address, int size, boolean swap) {
        this.address = address;
        this.size = size;
        this.swap = swap;
    }

    public void seek(int offset) {
        this.position = offset;
    }

    public void skip(int byteCount) {
        this.position += byteCount;
    }

    public void readByteArray(byte[] dst, int dstOffset, int byteCount) {
        OSMemory.peekByteArray(this.address + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
    }

    public byte readByte() {
        byte result = OSMemory.peekByte(this.address + this.position);
        ++this.position;
        return result;
    }

    public int readInt() {
        int result = OSMemory.peekInt(this.address + this.position, this.swap);
        this.position += 4;
        return result;
    }

    public void readIntArray(int[] dst, int dstOffset, int intCount) {
        OSMemory.peekIntArray(this.address + this.position, dst, dstOffset, intCount, this.swap);
        this.position += 4 * intCount;
    }

    public short readShort() {
        short result = OSMemory.peekShort(this.address + this.position, this.swap);
        this.position += 2;
        return result;
    }
}

