/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.net;

import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.harmony.luni.net.SocketInputStream;
import org.apache.harmony.luni.net.SocketOutputStream;
import org.apache.harmony.luni.net.Socks4Message;
import org.apache.harmony.luni.platform.OSMemory;
import org.apache.harmony.luni.platform.Platform;

public class PlainSocketImpl
extends SocketImpl {
    public static InetAddress lastConnectedAddress;
    public static int lastConnectedPort;
    public static Field fdField;
    public boolean streaming = true;
    public boolean shutdownInput;
    public Proxy proxy;
    public final CloseGuard guard = CloseGuard.get();

    public PlainSocketImpl(FileDescriptor fd) {
        this.fd = fd;
        if (fd.valid()) {
            this.guard.open("close");
        }
    }

    public PlainSocketImpl(Proxy proxy) {
        this(new FileDescriptor());
        this.proxy = proxy;
    }

    public PlainSocketImpl() {
        this(new FileDescriptor());
    }

    public PlainSocketImpl(FileDescriptor fd, int localport, InetAddress addr, int port) {
        this.fd = fd;
        this.localport = localport;
        this.address = addr;
        this.port = port;
        if (fd.valid()) {
            this.guard.open("close");
        }
    }

    public void accept(SocketImpl newImpl) throws IOException {
        if (this.usingSocks()) {
            ((PlainSocketImpl)newImpl).socksBind();
            ((PlainSocketImpl)newImpl).socksAccept();
            return;
        }
        try {
            if (newImpl instanceof PlainSocketImpl) {
                PlainSocketImpl newPlainSocketImpl = (PlainSocketImpl)newImpl;
                Platform.NETWORK.accept(this.fd, newImpl, newPlainSocketImpl.getFileDescriptor());
            } else {
                if (fdField == null) {
                    fdField = this.getSocketImplField("fd");
                }
                FileDescriptor newFd = (FileDescriptor)fdField.get(newImpl);
                Platform.NETWORK.accept(this.fd, newImpl, newFd);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public boolean usingSocks() {
        return this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS;
    }

    public Field getSocketImplField(final String fieldName) {
        return AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                Field field = null;
                try {
                    field = SocketImpl.class.getDeclaredField(fieldName);
                    field.setAccessible(true);
                }
                catch (NoSuchFieldException e) {
                    throw new Error(e);
                }
                return field;
            }
        });
    }

    public void initLocalPort(int localPort) {
        this.localport = localPort;
    }

    public void initRemoteAddressAndPort(InetAddress remoteAddress, int remotePort) {
        this.address = remoteAddress;
        this.port = remotePort;
    }

    public void checkNotClosed() throws IOException {
        if (!this.fd.valid()) {
            throw new SocketException("Socket is closed");
        }
    }

    public synchronized int available() throws IOException {
        this.checkNotClosed();
        if (this.shutdownInput) {
            return 0;
        }
        return Platform.FILE_SYSTEM.ioctlAvailable(this.fd);
    }

    public void bind(InetAddress address, int port) throws IOException {
        Platform.NETWORK.bind(this.fd, address, port);
        this.address = address;
        this.localport = port != 0 ? port : Platform.NETWORK.getSocketLocalPort(this.fd);
    }

    public synchronized void close() throws IOException {
        this.guard.close();
        Platform.NETWORK.close(this.fd);
    }

    public void connect(String aHost, int aPort) throws IOException {
        this.connect(InetAddress.getByName(aHost), aPort);
    }

    public void connect(InetAddress anAddr, int aPort) throws IOException {
        this.connect(anAddr, aPort, 0);
    }

    public void connect(InetAddress anAddr, int aPort, int timeout) throws IOException {
        InetAddress normalAddr = anAddr.isAnyLocalAddress() ? InetAddress.getLocalHost() : anAddr;
        try {
            if (this.streaming && this.usingSocks()) {
                this.socksConnect(anAddr, aPort, 0);
            } else {
                Platform.NETWORK.connect(this.fd, normalAddr, aPort, timeout);
            }
        }
        catch (ConnectException e) {
            throw new ConnectException(anAddr + ":" + aPort + " - " + e.getMessage());
        }
        this.address = normalAddr;
        this.port = aPort;
    }

    public void create(boolean streaming) throws IOException {
        this.streaming = streaming;
        Platform.NETWORK.socket(this.fd, streaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.checkNotClosed();
        return new SocketInputStream(this);
    }

    public Object getOption(int optID) throws SocketException {
        return Platform.NETWORK.getSocketOption(this.fd, optID);
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.checkNotClosed();
        return new SocketOutputStream(this);
    }

    public void listen(int backlog) throws IOException {
        if (this.usingSocks()) {
            return;
        }
        Platform.NETWORK.listen(this.fd, backlog);
    }

    public void setOption(int optID, Object val) throws SocketException {
        Platform.NETWORK.setSocketOption(this.fd, optID, val);
    }

    public int socksGetServerPort() {
        InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
        return addr.getPort();
    }

    public InetAddress socksGetServerAddress() throws UnknownHostException {
        InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
        String proxyName = addr.getHostName();
        if (proxyName == null) {
            proxyName = addr.getAddress().getHostAddress();
        }
        return InetAddress.getByName(proxyName);
    }

    public void socksConnect(InetAddress applicationServerAddress, int applicationServerPort, int timeout) throws IOException {
        try {
            Platform.NETWORK.connect(this.fd, this.socksGetServerAddress(), this.socksGetServerPort(), timeout);
        }
        catch (Exception e) {
            throw new SocketException("SOCKS connection failed: " + e);
        }
        this.socksRequestConnection(applicationServerAddress, applicationServerPort);
        lastConnectedAddress = applicationServerAddress;
        lastConnectedPort = applicationServerPort;
    }

    public void socksRequestConnection(InetAddress applicationServerAddress, int applicationServerPort) throws IOException {
        this.socksSendRequest(1, applicationServerAddress, applicationServerPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    public void socksAccept() throws IOException {
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    public void shutdownInput() throws IOException {
        this.shutdownInput = true;
        Platform.NETWORK.shutdownInput(this.fd);
    }

    public void shutdownOutput() throws IOException {
        Platform.NETWORK.shutdownOutput(this.fd);
    }

    public void socksBind() throws IOException {
        try {
            Platform.NETWORK.connect(this.fd, this.socksGetServerAddress(), this.socksGetServerPort(), 0);
        }
        catch (Exception e) {
            throw new IOException("Unable to connect to SOCKS server: " + e);
        }
        if (lastConnectedAddress == null) {
            throw new SocketException("Invalid SOCKS client");
        }
        this.socksSendRequest(2, lastConnectedAddress, lastConnectedPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
        if (reply.getIP() == 0) {
            this.address = this.socksGetServerAddress();
        } else {
            byte[] replyBytes = new byte[4];
            OSMemory.pokeInt(replyBytes, 0, reply.getIP(), ByteOrder.BIG_ENDIAN);
            this.address = InetAddress.getByAddress(replyBytes);
        }
        this.localport = reply.getPort();
    }

    public void socksSendRequest(int command, InetAddress address, int port) throws IOException {
        Socks4Message request = new Socks4Message();
        request.setCommandOrResult(command);
        request.setPort(port);
        request.setIP(address.getAddress());
        request.setUserId("default");
        this.getOutputStream().write(request.getBytes(), 0, request.getLength());
    }

    public Socks4Message socksReadReply() throws IOException {
        int bytesRead;
        int count;
        Socks4Message reply = new Socks4Message();
        for (bytesRead = 0; bytesRead < 8 && -1 != (count = this.getInputStream().read(reply.getBytes(), bytesRead, 8 - bytesRead)); bytesRead += count) {
        }
        if (8 != bytesRead) {
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return reply;
    }

    public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        this.connect(inetAddr.getAddress(), inetAddr.getPort(), timeout);
    }

    public boolean supportsUrgentData() {
        return true;
    }

    public void sendUrgentData(int value) throws IOException {
        Platform.NETWORK.sendUrgentData(this.fd, (byte)value);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.shutdownInput) {
            return -1;
        }
        int read = Platform.NETWORK.read(this.fd, buffer, offset, count);
        if (read == 0) {
            throw new SocketTimeoutException();
        }
        if (read == -1) {
            this.shutdownInput = true;
        }
        return read;
    }

    public int write(byte[] buffer, int offset, int count) throws IOException {
        if (this.streaming) {
            return Platform.NETWORK.write(this.fd, buffer, offset, count);
        }
        return Platform.NETWORK.send(this.fd, buffer, offset, count, this.port, this.address);
    }
}

