/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketImpl;
import java.util.Arrays;
import org.apache.harmony.luni.net.PlainSocketImpl;

public class SocketInputStream
extends InputStream {
    public final PlainSocketImpl socket;

    public SocketInputStream(SocketImpl socket) {
        this.socket = (PlainSocketImpl)socket;
    }

    public int available() throws IOException {
        return this.socket.available();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        int result = this.socket.read(buffer, 0, 1);
        return result == -1 ? result : buffer[0] & 0xFF;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int byteCount) throws IOException {
        if (byteCount == 0) {
            return 0;
        }
        Arrays.checkOffsetAndCount((int)buffer.length, (int)offset, (int)byteCount);
        return this.socket.read(buffer, offset, byteCount);
    }
}

