/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.util;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoKeyHashMap<E, K, V>
extends AbstractMap<String, V> {
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final int DEFAULT_INITIAL_SIZE = 16;
    public Set<Map.Entry<String, V>> entrySet;
    public Collection<V> values;
    public int size;
    public int arrSize;
    public int modCount;
    public Entry<E, K, V>[] arr;
    public float loadFactor;
    public int threshold = 0;

    public TwoKeyHashMap() {
        this(16, 0.75f);
    }

    public TwoKeyHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public TwoKeyHashMap(int initialCapacity, float initialLoadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity should be >= 0");
        }
        if (initialLoadFactor <= 0.0f) {
            throw new IllegalArgumentException("initialLoadFactor should be > 0");
        }
        this.loadFactor = initialLoadFactor;
        if (initialCapacity == Integer.MAX_VALUE) {
            --initialCapacity;
        }
        this.arrSize = initialCapacity > 0 ? initialCapacity : 1;
        this.threshold = (int)((float)this.arrSize * this.loadFactor);
        this.arr = new Entry[this.arrSize + 1];
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ValuesCollectionImpl();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySetImpl();
        }
        return this.entrySet;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.size = 0;
        Arrays.fill(this.arr, 0, this.arr.length, null);
    }

    public V remove(Object key1, Object key2) {
        Entry<E, K, V> e = this.removeEntry(key1, key2);
        return e != null ? (V)e.value : null;
    }

    public V put(E key1, K key2, V value) {
        if (key1 == null && key2 == null) {
            int index = this.arrSize;
            if (this.arr[index] == null) {
                this.arr[index] = this.createEntry(0, null, null, value, null);
                ++this.size;
                ++this.modCount;
                return null;
            }
            Object oldValue = this.arr[index].value;
            this.arr[index].value = value;
            return oldValue;
        }
        int hash = key1.hashCode() + key2.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> e = this.arr[index];
        while (e != null) {
            if (hash == e.hash && key1.equals(e.getKey1()) && key2.equals(e.getKey2())) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        this.arr[index] = this.createEntry(hash, key1, key2, value, this.arr[index]);
        ++this.size;
        ++this.modCount;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return null;
    }

    public void rehash() {
        int newArrSize = (this.arrSize + 1) * 2 + 1;
        if (newArrSize < 0) {
            newArrSize = 0x7FFFFFFE;
        }
        Entry[] newArr = new Entry[newArrSize + 1];
        for (int i = 0; i < this.arr.length - 1; ++i) {
            Entry<E, K, V> entry = this.arr[i];
            while (entry != null) {
                Entry next = entry.next;
                int newIndex = (entry.hash & Integer.MAX_VALUE) % newArrSize;
                entry.next = newArr[newIndex];
                newArr[newIndex] = entry;
                entry = next;
            }
        }
        newArr[newArrSize] = this.arr[this.arrSize];
        this.arrSize = newArrSize;
        if (this.arrSize == Integer.MAX_VALUE) {
            this.loadFactor *= 10.0f;
        }
        this.threshold = (int)((float)this.arrSize * this.loadFactor);
        this.arr = newArr;
    }

    public boolean containsKey(Object key1, Object key2) {
        return this.findEntry(key1, key2) != null;
    }

    public V get(Object key1, Object key2) {
        Entry<E, K, V> e = this.findEntry(key1, key2);
        if (e != null) {
            return e.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public Entry<E, K, V> createEntry(int hashCode, E key1, K key2, V value, Entry<E, K, V> next) {
        return new Entry<E, K, V>(hashCode, key1, key2, value, next);
    }

    public Iterator<Map.Entry<String, V>> createEntrySetIterator() {
        return new EntryIteratorImpl();
    }

    public Iterator<V> createValueCollectionIterator() {
        return new ValueIteratorImpl();
    }

    public Entry<E, K, V> findEntry(Object key1, Object key2) {
        if (key1 == null && key2 == null) {
            return this.arr[this.arrSize];
        }
        int hash = key1.hashCode() + key2.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> e = this.arr[index];
        while (e != null) {
            if (hash == e.hash && key1.equals(e.getKey1()) && key2.equals(e.getKey2())) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public Entry<E, K, V> removeEntry(Object key1, Object key2) {
        Entry<E, K, V> e;
        if (key1 == null && key2 == null) {
            int index = this.arrSize;
            if (this.arr[index] != null) {
                Entry<E, K, V> ret = this.arr[index];
                this.arr[index] = null;
                --this.size;
                ++this.modCount;
                return ret;
            }
            return null;
        }
        int hash = key1.hashCode() + key2.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.arrSize;
        Entry<E, K, V> prev = e = this.arr[index];
        while (e != null) {
            if (hash == e.hash && key1.equals(e.getKey1()) && key2.equals(e.getKey2())) {
                if (prev == e) {
                    this.arr[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.size;
                ++this.modCount;
                return e;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIteratorImpl
    implements Iterator<V> {
        public EntryIteratorImpl itr;

        public ValueIteratorImpl() {
            this.itr = new EntryIteratorImpl();
        }

        @Override
        public V next() {
            return this.itr.next().getValue();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValuesCollectionImpl
    extends AbstractCollection<V> {
        @Override
        public int size() {
            return TwoKeyHashMap.this.size;
        }

        @Override
        public void clear() {
            TwoKeyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return TwoKeyHashMap.this.size == 0;
        }

        @Override
        public Iterator<V> iterator() {
            return TwoKeyHashMap.this.createValueCollectionIterator();
        }

        @Override
        public boolean contains(Object obj) {
            return TwoKeyHashMap.this.containsValue(obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntryIteratorImpl
    implements Iterator<Map.Entry<String, V>> {
        public int startModCount;
        public boolean found;
        public int curr = -1;
        public int returned_index = -1;
        public Entry<E, K, V> curr_entry;
        public Entry<E, K, V> returned_entry;

        public EntryIteratorImpl() {
            this.startModCount = TwoKeyHashMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            if (this.found) {
                return true;
            }
            if (this.curr_entry != null) {
                this.curr_entry = this.curr_entry.next;
            }
            if (this.curr_entry == null) {
                ++this.curr;
                while (this.curr < TwoKeyHashMap.this.arr.length && TwoKeyHashMap.this.arr[this.curr] == null) {
                    ++this.curr;
                }
                if (this.curr < TwoKeyHashMap.this.arr.length) {
                    this.curr_entry = TwoKeyHashMap.this.arr[this.curr];
                }
            }
            this.found = this.curr_entry != null;
            return this.found;
        }

        @Override
        public Map.Entry<String, V> next() {
            if (TwoKeyHashMap.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.found = false;
            this.returned_index = this.curr;
            this.returned_entry = this.curr_entry;
            return this.curr_entry;
        }

        @Override
        public void remove() {
            if (this.returned_index == -1) {
                throw new IllegalStateException();
            }
            if (TwoKeyHashMap.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            Entry p = null;
            Entry e = TwoKeyHashMap.this.arr[this.returned_index];
            while (e != this.returned_entry) {
                p = e;
                e = e.next;
            }
            if (p != null) {
                p.next = this.returned_entry.next;
            } else {
                ((TwoKeyHashMap)TwoKeyHashMap.this).arr[this.returned_index] = this.returned_entry.next;
            }
            TwoKeyHashMap.this.size--;
            TwoKeyHashMap.this.modCount++;
            ++this.startModCount;
            this.returned_index = -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EntrySetImpl
    extends AbstractSet<Map.Entry<String, V>> {
        @Override
        public int size() {
            return TwoKeyHashMap.this.size;
        }

        @Override
        public void clear() {
            TwoKeyHashMap.this.clear();
        }

        @Override
        public boolean isEmpty() {
            return TwoKeyHashMap.this.size == 0;
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            Entry entry2 = TwoKeyHashMap.this.findEntry(entry.getKey1(), entry.getKey2());
            if (entry2 == null) {
                return false;
            }
            Object value = entry.getValue();
            Object value2 = entry2.getValue();
            return value == null ? value2 == null : value.equals(value2);
        }

        @Override
        public boolean remove(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            return TwoKeyHashMap.this.removeEntry(((Entry)obj).getKey1(), ((Entry)obj).getKey2()) != null;
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return TwoKeyHashMap.this.createEntrySetIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<E, K, V>
    implements Map.Entry<String, V> {
        public int hash;
        public E key1;
        public K key2;
        public V value;
        public Entry<E, K, V> next;

        public Entry(int hash, E key1, K key2, V value, Entry<E, K, V> next) {
            this.hash = hash;
            this.key1 = key1;
            this.key2 = key2;
            this.value = value;
            this.next = next;
        }

        @Override
        public String getKey() {
            return this.key1.toString() + this.key2.toString();
        }

        public E getKey1() {
            return this.key1;
        }

        public K getKey2() {
            return this.key2;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            E getKey1 = e.getKey1();
            K getKey2 = e.getKey2();
            V getValue = e.getValue();
            return !(this.key1 == null && getKey1 != null || this.key2 == null && getKey2 != null || this.value == null && getValue != null || !this.key1.equals(e.getKey1()) || !this.key2.equals(e.getKey2())) && this.value.equals(getValue);
        }

        @Override
        public int hashCode() {
            int hash1 = this.key1 == null ? 0 : this.key1.hashCode();
            int hash2 = this.key2 == null ? 0 : this.key2.hashCode();
            return hash1 + hash2 ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

