/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.List;
import org.apache.harmony.security.x509.ExtensionValue;
import org.apache.harmony.security.x509.GeneralNames;

public class AlternativeName
extends ExtensionValue {
    public static final boolean ISSUER = false;
    public static final boolean SUBJECT = true;
    public boolean which;
    public GeneralNames alternativeNames;

    public AlternativeName(boolean which, GeneralNames alternativeNames) {
        this.which = which;
        this.alternativeNames = alternativeNames;
    }

    public AlternativeName(boolean which, byte[] encoding) throws IOException {
        super(encoding);
        this.which = which;
        this.alternativeNames = (GeneralNames)GeneralNames.ASN1.decode(encoding);
    }

    public List getAlternativeNames() {
        return this.alternativeNames.getPairsList();
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = GeneralNames.ASN1.encode(this.alternativeNames);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append(this.which ? "Subject" : "Issuer").append(" Alternative Names [\n");
        this.alternativeNames.dumpValue(buffer, prefix + "  ");
        buffer.append(prefix).append("]\n");
    }
}

