/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.harmony.xnet.provider.jsse.ClientSessionContext;
import org.apache.harmony.xnet.provider.jsse.DefaultSSLContextImpl;
import org.apache.harmony.xnet.provider.jsse.SSLEngineImpl;
import org.apache.harmony.xnet.provider.jsse.SSLParametersImpl;
import org.apache.harmony.xnet.provider.jsse.SSLServerSocketFactoryImpl;
import org.apache.harmony.xnet.provider.jsse.SSLSocketFactoryImpl;
import org.apache.harmony.xnet.provider.jsse.ServerSessionContext;

public class SSLContextImpl
extends SSLContextSpi {
    public static DefaultSSLContextImpl DEFAULT_SSL_CONTEXT_IMPL;
    public final ClientSessionContext clientSessionContext;
    public final ServerSessionContext serverSessionContext;
    public SSLParametersImpl sslParameters;

    public SSLContextImpl() {
        this.clientSessionContext = new ClientSessionContext();
        this.serverSessionContext = new ServerSessionContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLContextImpl(DefaultSSLContextImpl dummy) throws GeneralSecurityException, IOException {
        Class<DefaultSSLContextImpl> clazz = DefaultSSLContextImpl.class;
        synchronized (DefaultSSLContextImpl.class) {
            if (DEFAULT_SSL_CONTEXT_IMPL == null) {
                this.clientSessionContext = new ClientSessionContext();
                this.serverSessionContext = new ServerSessionContext();
                DEFAULT_SSL_CONTEXT_IMPL = (DefaultSSLContextImpl)this;
            } else {
                this.clientSessionContext = DEFAULT_SSL_CONTEXT_IMPL.engineGetClientSessionContext();
                this.serverSessionContext = DEFAULT_SSL_CONTEXT_IMPL.engineGetServerSessionContext();
            }
            this.sslParameters = new SSLParametersImpl(DEFAULT_SSL_CONTEXT_IMPL.getKeyManagers(), DEFAULT_SSL_CONTEXT_IMPL.getTrustManagers(), null, this.clientSessionContext, this.serverSessionContext);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void engineInit(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        this.sslParameters = new SSLParametersImpl(kms, tms, sr, this.clientSessionContext, this.serverSessionContext);
    }

    public SSLSocketFactory engineGetSocketFactory() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initialized.");
        }
        return new SSLSocketFactoryImpl(this.sslParameters);
    }

    public SSLServerSocketFactory engineGetServerSocketFactory() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initialized.");
        }
        return new SSLServerSocketFactoryImpl(this.sslParameters);
    }

    public SSLEngine engineCreateSSLEngine(String host, int port) {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initialized.");
        }
        SSLParametersImpl p = (SSLParametersImpl)this.sslParameters.clone();
        p.setUseClientMode(false);
        return new SSLEngineImpl(host, port, p);
    }

    public SSLEngine engineCreateSSLEngine() {
        if (this.sslParameters == null) {
            throw new IllegalStateException("SSLContext is not initialized.");
        }
        SSLParametersImpl p = (SSLParametersImpl)this.sslParameters.clone();
        p.setUseClientMode(false);
        return new SSLEngineImpl(p);
    }

    public ServerSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    public ClientSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }
}

