/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Keyframe;
import android.animation.KeyframeSet;
import android.animation.TimeInterpolator;
import java.util.ArrayList;

public class FloatKeyframeSet
extends KeyframeSet {
    public float firstValue;
    public float lastValue;
    public float deltaValue;
    public boolean firstTime = true;

    public FloatKeyframeSet(Keyframe.FloatKeyframe ... keyframes) {
        super(keyframes);
    }

    public Object getValue(float fraction2) {
        return Float.valueOf(this.getFloatValue(fraction2));
    }

    public FloatKeyframeSet clone() {
        ArrayList keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.FloatKeyframe[] newKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
        for (int i = 0; i < numKeyframes; ++i) {
            newKeyframes[i] = (Keyframe.FloatKeyframe)((Keyframe)keyframes.get(i)).clone();
        }
        FloatKeyframeSet newSet = new FloatKeyframeSet(newKeyframes);
        return newSet;
    }

    public float getFloatValue(float fraction2) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(0)).getFloatValue();
                this.lastValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(1)).getFloatValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                fraction2 = this.mInterpolator.getInterpolation(fraction2);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + fraction2 * this.deltaValue;
            }
            return ((Number)this.mEvaluator.evaluate(fraction2, Float.valueOf(this.firstValue), Float.valueOf(this.lastValue))).floatValue();
        }
        if (fraction2 <= 0.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(1);
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            TimeInterpolator interpolator2 = nextKeyframe.getInterpolator();
            if (interpolator2 != null) {
                fraction2 = interpolator2.getInterpolation(fraction2);
            }
            float intervalFraction = (fraction2 - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
        }
        if (fraction2 >= 1.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            TimeInterpolator interpolator3 = nextKeyframe.getInterpolator();
            if (interpolator3 != null) {
                fraction2 = interpolator3.getInterpolation(fraction2);
            }
            float intervalFraction = (fraction2 - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
        }
        Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
        for (int i = 1; i < this.mNumKeyframes; ++i) {
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(i);
            if (fraction2 < nextKeyframe.getFraction()) {
                TimeInterpolator interpolator4 = nextKeyframe.getInterpolator();
                if (interpolator4 != null) {
                    fraction2 = interpolator4.getInterpolation(fraction2);
                }
                float intervalFraction = (fraction2 - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                float prevValue = prevKeyframe.getFloatValue();
                float nextValue = nextKeyframe.getFloatValue();
                return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
            }
            prevKeyframe = nextKeyframe;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).floatValue();
    }
}

