/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.app.FragmentTransaction;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

public class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable {
    public static final String TAG = "BackStackEntry";
    public final FragmentManagerImpl mManager;
    public static final int OP_NULL = 0;
    public static final int OP_ADD = 1;
    public static final int OP_REPLACE = 2;
    public static final int OP_REMOVE = 3;
    public static final int OP_HIDE = 4;
    public static final int OP_SHOW = 5;
    public Op mHead;
    public Op mTail;
    public int mNumOp;
    public int mEnterAnim;
    public int mExitAnim;
    public int mTransition;
    public int mTransitionStyle;
    public boolean mAddToBackStack;
    public boolean mAllowAddToBackStack = true;
    public String mName;
    public boolean mCommitted;
    public int mIndex;
    public int mBreadCrumbTitleRes;
    public CharSequence mBreadCrumbTitleText;
    public int mBreadCrumbShortTitleRes;
    public CharSequence mBreadCrumbShortTitleText;

    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        writer.print(prefix);
        writer.print("mName=");
        writer.print(this.mName);
        writer.print(" mIndex=");
        writer.print(this.mIndex);
        writer.print(" mCommitted=");
        writer.println(this.mCommitted);
        if (this.mTransition != 0) {
            writer.print(prefix);
            writer.print("mTransition=#");
            writer.print(Integer.toHexString(this.mTransition));
            writer.print(" mTransitionStyle=#");
            writer.println(Integer.toHexString(this.mTransitionStyle));
        }
        if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
            writer.print(prefix);
            writer.print("mEnterAnim=#");
            writer.print(Integer.toHexString(this.mEnterAnim));
            writer.print(" mExitAnim=#");
            writer.println(Integer.toHexString(this.mExitAnim));
        }
        if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
            writer.print(prefix);
            writer.print("mBreadCrumbTitleRes=#");
            writer.print(Integer.toHexString(this.mBreadCrumbTitleRes));
            writer.print(" mBreadCrumbTitleText=");
            writer.println(this.mBreadCrumbTitleText);
        }
        if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
            writer.print(prefix);
            writer.print("mBreadCrumbShortTitleRes=#");
            writer.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
            writer.print(" mBreadCrumbShortTitleText=");
            writer.println(this.mBreadCrumbShortTitleText);
        }
        if (this.mHead != null) {
            writer.print(prefix);
            writer.println("Operations:");
            String innerPrefix = prefix + "    ";
            Op op = this.mHead;
            int num = 0;
            while (op != null) {
                writer.print(prefix);
                writer.print("  Op #");
                writer.print(num);
                writer.println(":");
                writer.print(innerPrefix);
                writer.print("cmd=");
                writer.print(op.cmd);
                writer.print(" fragment=");
                writer.println(op.fragment);
                if (op.enterAnim != 0 || op.exitAnim != 0) {
                    writer.print(prefix);
                    writer.print("enterAnim=");
                    writer.print(op.enterAnim);
                    writer.print(" exitAnim=");
                    writer.println(op.exitAnim);
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        writer.print(innerPrefix);
                        if (op.removed.size() == 1) {
                            writer.print("Removed: ");
                        } else {
                            writer.println("Removed:");
                            writer.print(innerPrefix);
                            writer.print("  #");
                            writer.print(num);
                            writer.print(": ");
                        }
                        writer.println(op.removed.get(i));
                    }
                }
                op = op.next;
            }
        }
    }

    public BackStackRecord(FragmentManagerImpl manager) {
        this.mManager = manager;
    }

    public int getId() {
        return this.mIndex;
    }

    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    public void addOp(Op op) {
        if (this.mHead == null) {
            this.mHead = this.mTail = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        ++this.mNumOp;
    }

    public FragmentTransaction add(Fragment fragment, String tag) {
        this.doAddOp(0, fragment, tag, 1);
        return this;
    }

    public FragmentTransaction add(int containerViewId, Fragment fragment) {
        this.doAddOp(containerViewId, fragment, null, 1);
        return this;
    }

    public FragmentTransaction add(int containerViewId, Fragment fragment, String tag) {
        this.doAddOp(containerViewId, fragment, tag, 1);
        return this;
    }

    public void doAddOp(int containerViewId, Fragment fragment, String tag, int opcmd) {
        if (fragment.mImmediateActivity != null) {
            throw new IllegalStateException("Fragment already added: " + fragment);
        }
        fragment.mImmediateActivity = this.mManager.mActivity;
        fragment.mFragmentManager = this.mManager;
        if (tag != null) {
            if (fragment.mTag != null && !tag.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + tag);
            }
            fragment.mTag = tag;
        }
        if (containerViewId != 0) {
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != containerViewId) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + containerViewId);
            }
            fragment.mContainerId = fragment.mFragmentId = containerViewId;
        }
        Op op = new Op();
        op.cmd = opcmd;
        op.fragment = fragment;
        this.addOp(op);
    }

    public FragmentTransaction replace(int containerViewId, Fragment fragment) {
        return this.replace(containerViewId, fragment, null);
    }

    public FragmentTransaction replace(int containerViewId, Fragment fragment, String tag) {
        if (containerViewId == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(containerViewId, fragment, tag, 2);
        return this;
    }

    public FragmentTransaction remove(Fragment fragment) {
        if (fragment.mImmediateActivity == null) {
            throw new IllegalStateException("Fragment not added: " + fragment);
        }
        fragment.mImmediateActivity = null;
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    public FragmentTransaction hide(Fragment fragment) {
        if (fragment.mImmediateActivity == null) {
            throw new IllegalStateException("Fragment not added: " + fragment);
        }
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    public FragmentTransaction show(Fragment fragment) {
        if (fragment.mImmediateActivity == null) {
            throw new IllegalStateException("Fragment not added: " + fragment);
        }
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    public FragmentTransaction setCustomAnimations(int enter, int exit) {
        this.mEnterAnim = enter;
        this.mExitAnim = exit;
        return this;
    }

    public FragmentTransaction setTransition(int transition) {
        this.mTransition = transition;
        return this;
    }

    public FragmentTransaction setTransitionStyle(int styleRes) {
        this.mTransitionStyle = styleRes;
        return this;
    }

    public FragmentTransaction addToBackStack(String name) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = name;
        return this;
    }

    public boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    public FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    public FragmentTransaction setBreadCrumbTitle(int res) {
        this.mBreadCrumbTitleRes = res;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    public FragmentTransaction setBreadCrumbTitle(CharSequence text) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = text;
        return this;
    }

    public FragmentTransaction setBreadCrumbShortTitle(int res) {
        this.mBreadCrumbShortTitleRes = res;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    public FragmentTransaction setBreadCrumbShortTitle(CharSequence text) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = text;
        return this;
    }

    public void bumpBackStackNesting(int amt) {
        if (!this.mAddToBackStack) {
            return;
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Bump nesting in " + this + " by " + amt);
        }
        Op op = this.mHead;
        while (op != null) {
            op.fragment.mBackStackNesting += amt;
            if (FragmentManagerImpl.DEBUG) {
                Log.v(TAG, "Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting);
            }
            if (op.removed != null) {
                for (int i = op.removed.size() - 1; i >= 0; --i) {
                    Fragment r = op.removed.get(i);
                    r.mBackStackNesting += amt;
                    if (!FragmentManagerImpl.DEBUG) continue;
                    Log.v(TAG, "Bump nesting of " + r + " to " + r.mBackStackNesting);
                }
            }
            op = op.next;
        }
    }

    public int commit() {
        return this.commitInternal(false);
    }

    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    public int commitInternal(boolean allowStateLoss) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Commit: " + this);
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, allowStateLoss);
        return this.mIndex;
    }

    public void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Run: " + this);
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment old = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v(TAG, "OP_REPLACE: adding=" + f + " old=" + old);
                            }
                            if (old.mContainerId != f.mContainerId) continue;
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(old);
                            old.mNextAnim = op.exitAnim;
                            if (this.mAddToBackStack) {
                                ++old.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v(TAG, "Bump nesting of " + old + " to " + old.mBackStackNesting);
                                }
                            }
                            this.mManager.removeFragment(old, this.mTransition, this.mTransitionStyle);
                        }
                    }
                    f.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.removeFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.exitAnim;
                    this.mManager.hideFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    f.mNextAnim = op.enterAnim;
                    this.mManager.showFragment(f, this.mTransition, this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    public void popFromBackStack(boolean doStateMove) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "popFromBackStack: " + this);
        }
        this.bumpBackStackNesting(-1);
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                case 1: {
                    Fragment f = op.fragment;
                    f.mImmediateActivity = null;
                    this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment f = op.fragment;
                    f.mImmediateActivity = null;
                    this.mManager.removeFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment old = op.removed.get(i);
                        f.mImmediateActivity = this.mManager.mActivity;
                        this.mManager.addFragment(old, false);
                    }
                    break;
                }
                case 3: {
                    Fragment f = op.fragment;
                    f.mImmediateActivity = this.mManager.mActivity;
                    this.mManager.addFragment(f, false);
                    break;
                }
                case 4: {
                    Fragment f = op.fragment;
                    this.mManager.showFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment f = op.fragment;
                    this.mManager.hideFragment(f, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
            }
            op = op.prev;
        }
        if (doStateMove) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
    }

    public String getName() {
        return this.mName;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    public boolean isEmpty() {
        return this.mNumOp == 0;
    }

    public static class Op {
        public Op next;
        public Op prev;
        public int cmd;
        public Fragment fragment;
        public int enterAnim;
        public int exitAnim;
        public ArrayList<Fragment> removed;
    }
}

