/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SearchView;
import android.widget.TextView;

public class SearchDialog
extends Dialog {
    public static final boolean DBG = false;
    public static final String LOG_TAG = "SearchDialog";
    public static final String INSTANCE_KEY_COMPONENT = "comp";
    public static final String INSTANCE_KEY_APPDATA = "data";
    public static final String INSTANCE_KEY_USER_QUERY = "uQry";
    public static final String IME_OPTION_NO_MICROPHONE = "nm";
    public static final int SEARCH_PLATE_LEFT_PADDING_NON_GLOBAL = 7;
    public TextView mBadgeLabel;
    public ImageView mAppIcon;
    public AutoCompleteTextView mSearchAutoComplete;
    public View mSearchPlate;
    public SearchView mSearchView;
    public Drawable mWorkingSpinner;
    public SearchableInfo mSearchable;
    public ComponentName mLaunchComponent;
    public Bundle mAppSearchData;
    public Context mActivityContext;
    public final Intent mVoiceWebSearchIntent;
    public final Intent mVoiceAppSearchIntent;
    public String mUserQuery;
    public int mSearchAutoCompleteImeOptions;
    public BroadcastReceiver mConfChangeListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("android.intent.action.CONFIGURATION_CHANGED")) {
                SearchDialog.this.onConfigurationChanged();
            }
        }
    };
    public final SearchView.OnCloseListener mOnCloseListener = new SearchView.OnCloseListener(){

        public boolean onClose() {
            return SearchDialog.this.onClosePressed();
        }
    };
    public final SearchView.OnQueryTextListener mOnQueryChangeListener = new SearchView.OnQueryTextListener(){

        public boolean onQueryTextSubmit(String query) {
            SearchDialog.this.dismiss();
            return false;
        }

        public boolean onQueryTextChange(String newText) {
            return false;
        }
    };
    public final SearchView.OnSuggestionListener mOnSuggestionSelectionListener = new SearchView.OnSuggestionListener(){

        public boolean onSuggestionSelect(int position) {
            return false;
        }

        public boolean onSuggestionClick(int position) {
            SearchDialog.this.dismiss();
            return false;
        }
    };

    public SearchDialog(Context context, SearchManager searchManager) {
        super(context, 16974286);
        this.mVoiceWebSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceWebSearchIntent.addFlags(0x10000000);
        this.mVoiceWebSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceAppSearchIntent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        this.mVoiceAppSearchIntent.addFlags(0x10000000);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window theWindow = this.getWindow();
        WindowManager.LayoutParams lp = theWindow.getAttributes();
        lp.width = -1;
        lp.height = -1;
        lp.gravity = 55;
        lp.softInputMode = 16;
        theWindow.setAttributes(lp);
        this.setCanceledOnTouchOutside(true);
    }

    public void createContentView() {
        this.setContentView(17367162);
        SearchBar searchBar = (SearchBar)this.findViewById(16908970);
        searchBar.setSearchDialog(this);
        this.mSearchView = (SearchView)this.findViewById(16908972);
        this.mSearchView.setSubmitButtonEnabled(true);
        this.mSearchView.setOnCloseListener(this.mOnCloseListener);
        this.mSearchView.setOnQueryTextListener(this.mOnQueryChangeListener);
        this.mSearchView.setOnSuggestionListener(this.mOnSuggestionSelectionListener);
        this.mBadgeLabel = (TextView)this.mSearchView.findViewById(16908974);
        this.mSearchAutoComplete = (AutoCompleteTextView)this.mSearchView.findViewById(16908978);
        this.mAppIcon = (ImageView)this.findViewById(16908971);
        this.mSearchPlate = this.mSearchView.findViewById(16908977);
        this.mWorkingSpinner = this.getContext().getResources().getDrawable(17302640);
        this.mSearchAutoComplete.setCompoundDrawablesWithIntrinsicBounds(null, null, this.mWorkingSpinner, null);
        this.setWorking(false);
        this.mBadgeLabel.setVisibility(8);
        this.mSearchAutoCompleteImeOptions = this.mSearchAutoComplete.getImeOptions();
    }

    public boolean show(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        boolean success = this.doShow(initialQuery, selectInitialQuery, componentName, appSearchData);
        if (success) {
            this.mSearchAutoComplete.showDropDownAfterLayout();
        }
        return success;
    }

    public boolean doShow(String initialQuery, boolean selectInitialQuery, ComponentName componentName, Bundle appSearchData) {
        if (!this.show(componentName, appSearchData)) {
            return false;
        }
        this.setUserQuery(initialQuery);
        if (selectInitialQuery) {
            this.mSearchAutoComplete.selectAll();
        }
        return true;
    }

    public boolean show(ComponentName componentName, Bundle appSearchData) {
        SearchManager searchManager = (SearchManager)this.mContext.getSystemService("search");
        this.mSearchable = searchManager.getSearchableInfo(componentName);
        if (this.mSearchable == null) {
            return false;
        }
        this.mLaunchComponent = componentName;
        this.mAppSearchData = appSearchData;
        this.mActivityContext = this.mSearchable.getActivityContext(this.getContext());
        if (!this.isShowing()) {
            this.createContentView();
            this.mSearchView.setSearchableInfo(this.mSearchable);
            this.mSearchView.setAppSearchData(this.mAppSearchData);
            this.show();
        }
        this.updateUI();
        return true;
    }

    public void onStart() {
        super.onStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
        this.getContext().registerReceiver(this.mConfChangeListener, filter);
    }

    public void onStop() {
        super.onStop();
        this.getContext().unregisterReceiver(this.mConfChangeListener);
        this.mLaunchComponent = null;
        this.mAppSearchData = null;
        this.mSearchable = null;
        this.mUserQuery = null;
    }

    public void setWorking(boolean working) {
        this.mWorkingSpinner.setAlpha(working ? 255 : 0);
        this.mWorkingSpinner.setVisible(working, false);
        this.mWorkingSpinner.invalidateSelf();
    }

    public Bundle onSaveInstanceState() {
        if (!this.isShowing()) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(INSTANCE_KEY_COMPONENT, this.mLaunchComponent);
        bundle.putBundle(INSTANCE_KEY_APPDATA, this.mAppSearchData);
        bundle.putString(INSTANCE_KEY_USER_QUERY, this.mUserQuery);
        return bundle;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        ComponentName launchComponent = (ComponentName)savedInstanceState.getParcelable(INSTANCE_KEY_COMPONENT);
        Bundle appSearchData = savedInstanceState.getBundle(INSTANCE_KEY_APPDATA);
        String userQuery = savedInstanceState.getString(INSTANCE_KEY_USER_QUERY);
        if (!this.doShow(userQuery, false, launchComponent, appSearchData)) {
            return;
        }
    }

    public void onConfigurationChanged() {
        if (this.mSearchable != null && this.isShowing()) {
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            if (SearchDialog.isLandscapeMode(this.getContext())) {
                this.mSearchAutoComplete.ensureImeVisible(true);
            }
        }
    }

    public static boolean isLandscapeMode(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public void updateUI() {
        if (this.mSearchable != null) {
            this.mDecor.setVisibility(0);
            this.updateSearchAutoComplete();
            this.updateSearchAppIcon();
            this.updateSearchBadge();
            int inputType = this.mSearchable.getInputType();
            if ((inputType & 0xF) == 1) {
                inputType &= 0xFFFEFFFF;
                if (this.mSearchable.getSuggestAuthority() != null) {
                    inputType |= 0x10000;
                }
            }
            this.mSearchAutoComplete.setInputType(inputType);
            this.mSearchAutoCompleteImeOptions = this.mSearchable.getImeOptions();
            this.mSearchAutoComplete.setImeOptions(this.mSearchAutoCompleteImeOptions);
            if (this.mSearchable.getVoiceSearchEnabled()) {
                this.mSearchAutoComplete.setPrivateImeOptions(IME_OPTION_NO_MICROPHONE);
            } else {
                this.mSearchAutoComplete.setPrivateImeOptions(null);
            }
        }
    }

    public void updateSearchAutoComplete() {
        this.mSearchAutoComplete.setDropDownDismissedOnCompletion(false);
        this.mSearchAutoComplete.setForceIgnoreOutsideTouch(false);
    }

    public void updateSearchAppIcon() {
        Drawable icon;
        PackageManager pm = this.getContext().getPackageManager();
        try {
            ActivityInfo info = pm.getActivityInfo(this.mLaunchComponent, 0);
            icon = pm.getApplicationIcon(info.applicationInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            icon = pm.getDefaultActivityIcon();
            Log.w(LOG_TAG, this.mLaunchComponent + " not found, using generic app icon");
        }
        this.mAppIcon.setImageDrawable(icon);
        this.mAppIcon.setVisibility(0);
        this.mSearchPlate.setPadding(7, this.mSearchPlate.getPaddingTop(), this.mSearchPlate.getPaddingRight(), this.mSearchPlate.getPaddingBottom());
    }

    public void updateSearchBadge() {
        int visibility = 8;
        Drawable icon = null;
        String text = null;
        if (this.mSearchable.useBadgeIcon()) {
            icon = this.mActivityContext.getResources().getDrawable(this.mSearchable.getIconId());
            visibility = 0;
        } else if (this.mSearchable.useBadgeLabel()) {
            text = ((Object)this.mActivityContext.getResources().getText(this.mSearchable.getLabelId())).toString();
            visibility = 0;
        }
        this.mBadgeLabel.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        this.mBadgeLabel.setText(text);
        this.mBadgeLabel.setVisibility(visibility);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mSearchAutoComplete.isPopupShowing() && this.isOutOfBounds(this.mSearchPlate, event)) {
            this.cancel();
            return true;
        }
        return super.onTouchEvent(event);
    }

    public boolean isOutOfBounds(View v, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int slop = ViewConfiguration.get(this.mContext).getScaledWindowTouchSlop();
        return x < -slop || y < -slop || x > v.getWidth() + slop || y > v.getHeight() + slop;
    }

    public void hide() {
        if (!this.isShowing()) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        }
        super.hide();
    }

    public void launchQuerySearch() {
        this.launchQuerySearch(0, null);
    }

    public void launchQuerySearch(int actionKey, String actionMsg) {
        String query = this.mSearchAutoComplete.getText().toString();
        String action = "android.intent.action.SEARCH";
        Intent intent = this.createIntent(action, null, null, query, actionKey, actionMsg);
        this.launchIntent(intent);
    }

    public void launchIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        Log.d(LOG_TAG, "launching " + intent);
        try {
            Log.i(LOG_TAG, "Starting (as ourselves) " + intent.toUri(0));
            this.getContext().startActivity(intent);
            this.dismiss();
        }
        catch (RuntimeException ex) {
            Log.e(LOG_TAG, "Failed launch activity: " + intent, ex);
        }
    }

    public void setListSelection(int index) {
        this.mSearchAutoComplete.setListSelection(index);
    }

    public Intent createIntent(String action, Uri data, String extraData, String query, int actionKey, String actionMsg) {
        Intent intent = new Intent(action);
        intent.addFlags(0x10000000);
        if (data != null) {
            intent.setData(data);
        }
        intent.putExtra("user_query", this.mUserQuery);
        if (query != null) {
            intent.putExtra("query", query);
        }
        if (extraData != null) {
            intent.putExtra("intent_extra_data_key", extraData);
        }
        if (this.mAppSearchData != null) {
            intent.putExtra("app_data", this.mAppSearchData);
        }
        if (actionKey != 0) {
            intent.putExtra("action_key", actionKey);
            intent.putExtra("action_msg", actionMsg);
        }
        intent.setComponent(this.mSearchable.getSearchActivity());
        return intent;
    }

    public boolean isEmpty(AutoCompleteTextView actv) {
        return TextUtils.getTrimmedLength(actv.getText()) == 0;
    }

    public void onBackPressed() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        if (imm != null && imm.isFullscreenMode() && imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0)) {
            return;
        }
        this.cancel();
    }

    public boolean onClosePressed() {
        if (this.isEmpty(this.mSearchAutoComplete)) {
            this.dismiss();
            return true;
        }
        return false;
    }

    public void setUserQuery(String query) {
        if (query == null) {
            query = "";
        }
        this.mUserQuery = query;
        this.mSearchAutoComplete.setText(query);
        this.mSearchAutoComplete.setSelection(query.length());
    }

    public static class SearchBar
    extends LinearLayout {
        public SearchDialog mSearchDialog;

        public SearchBar(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public SearchBar(Context context) {
            super(context);
        }

        public void setSearchDialog(SearchDialog searchDialog) {
            this.mSearchDialog = searchDialog;
        }

        public boolean dispatchKeyEventPreIme(KeyEvent event) {
            KeyEvent.DispatcherState state;
            if (this.mSearchDialog != null && event.getKeyCode() == 4 && (state = this.getKeyDispatcherState()) != null) {
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    state.startTracking(event, this);
                    return true;
                }
                if (event.getAction() == 1 && !event.isCanceled() && state.isTracking(event)) {
                    this.mSearchDialog.onBackPressed();
                    return true;
                }
            }
            return super.dispatchKeyEventPreIme(event);
        }
    }
}

