/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.content.Context;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothA2dp
implements BluetoothProfile {
    public static final String TAG = "BluetoothA2dp";
    public static final boolean DBG = false;
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";
    public static final int STATE_PLAYING = 10;
    public static final int STATE_NOT_PLAYING = 11;
    public BluetoothProfile.ServiceListener mServiceListener;
    public IBluetoothA2dp mService;
    public BluetoothAdapter mAdapter;

    public BluetoothA2dp(Context mContext, BluetoothProfile.ServiceListener l) {
        IBinder b = ServiceManager.getService("bluetooth_a2dp");
        this.mServiceListener = l;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        if (b != null) {
            this.mService = IBluetoothA2dp.Stub.asInterface(b);
            if (this.mServiceListener != null) {
                this.mServiceListener.onServiceConnected(2, this);
            }
        } else {
            Log.w(TAG, "Bluetooth A2DP service not available!");
            this.mService = null;
        }
    }

    @Override
    public boolean connect(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.connect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    public boolean disconnect(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.disconnect(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getConnectedDevices();
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        if (this.mService != null && this.isEnabled()) {
            try {
                return this.mService.getDevicesMatchingConnectionStates(states);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    @Override
    public int getConnectionState(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getConnectionState(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    @Override
    public boolean setPriority(BluetoothDevice device, int priority) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            if (priority != 0 && priority != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(device, priority);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    @Override
    public int getPriority(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.getPriority(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return 0;
    }

    public boolean isA2dpPlaying(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.isA2dpPlaying(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean suspendSink(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.suspendSink(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean resumeSink(BluetoothDevice device) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(device)) {
            try {
                return this.mService.resumeSink(device);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return false;
    }

    public boolean shouldSendVolumeKeys(BluetoothDevice device) {
        if (this.isEnabled() && this.isValidDevice(device)) {
            ParcelUuid[] uuids = device.getUuids();
            if (uuids == null) {
                return false;
            }
            for (ParcelUuid uuid : uuids) {
                if (!BluetoothUuid.isAvrcpTarget(uuid)) continue;
                return true;
            }
        }
        return false;
    }

    public static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: {
                return "not playing";
            }
        }
        return "<unknown state " + state + ">";
    }

    public boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    public boolean isValidDevice(BluetoothDevice device) {
        if (device == null) {
            return false;
        }
        return BluetoothAdapter.checkBluetoothAddress(device.getAddress());
    }

    public static void log(String msg) {
        Log.d(TAG, msg);
    }
}

