/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.XmlSerializerAndParser;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Environment;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.os.AtomicFile;
import com.android.internal.util.FastXmlSerializer;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegisteredServicesCache<V> {
    public static final String TAG = "PackageManager";
    public final Context mContext;
    public final String mInterfaceName;
    public final String mMetaDataName;
    public final String mAttributesName;
    public final XmlSerializerAndParser<V> mSerializerAndParser;
    public final AtomicReference<BroadcastReceiver> mReceiver;
    public final Object mServicesLock = new Object();
    public HashMap<V, Integer> mPersistentServices;
    public Map<V, ServiceInfo<V>> mServices;
    public boolean mPersistentServicesFileDidNotExist;
    public final AtomicFile mPersistentServicesFile;
    public RegisteredServicesCacheListener<V> mListener;
    public Handler mHandler;

    public RegisteredServicesCache(Context context, String interfaceName, String metaDataName, String attributeName, XmlSerializerAndParser<V> serializerAndParser) {
        this.mContext = context;
        this.mInterfaceName = interfaceName;
        this.mMetaDataName = metaDataName;
        this.mAttributesName = attributeName;
        this.mSerializerAndParser = serializerAndParser;
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File syncDir = new File(systemDir, "registered_services");
        this.mPersistentServicesFile = new AtomicFile(new File(syncDir, interfaceName + ".xml"));
        this.generateServicesMap();
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context1, Intent intent) {
                RegisteredServicesCache.this.generateServicesMap();
            }
        };
        this.mReceiver = new AtomicReference<1>(receiver);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiver(receiver, intentFilter);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(receiver, sdFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        Map<V, ServiceInfo<V>> services;
        Object object = this.mServicesLock;
        synchronized (object) {
            services = this.mServices;
        }
        fout.println("RegisteredServicesCache: " + services.size() + " services");
        for (ServiceInfo<V> info : services.values()) {
            fout.println("  " + info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredServicesCacheListener<V> getListener() {
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(RegisteredServicesCacheListener<V> listener, Handler handler) {
        if (handler == null) {
            handler = new Handler(this.mContext.getMainLooper());
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            this.mHandler = handler;
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListener(final V type, final boolean removed) {
        Handler handler;
        RegisteredServicesCacheListener<V> listener;
        if (Log.isLoggable(TAG, 2)) {
            Log.d(TAG, "notifyListener: " + type + " is " + (removed ? "removed" : "added"));
        }
        RegisteredServicesCache registeredServicesCache = this;
        synchronized (registeredServicesCache) {
            listener = this.mListener;
            handler = this.mHandler;
        }
        if (listener == null) {
            return;
        }
        final RegisteredServicesCacheListener<V> listener2 = listener;
        handler.post(new Runnable(){

            public void run() {
                listener2.onServiceChanged(type, removed);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceInfo<V> getServiceInfo(V type) {
        Object object = this.mServicesLock;
        synchronized (object) {
            return this.mServices.get(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServiceInfo<V>> getAllServices() {
        Object object = this.mServicesLock;
        synchronized (object) {
            return Collections.unmodifiableCollection(this.mServices.values());
        }
    }

    public void close() {
        BroadcastReceiver receiver = this.mReceiver.getAndSet(null);
        if (receiver != null) {
            this.mContext.unregisterReceiver(receiver);
        }
    }

    public void finalize() throws Throwable {
        if (this.mReceiver.get() != null) {
            Log.e(TAG, "RegisteredServicesCache finalized without being closed");
        }
        this.close();
        super.finalize();
    }

    public boolean inSystemImage(int callerUid) {
        String[] packages;
        for (String name : packages = this.mContext.getPackageManager().getPackagesForUid(callerUid)) {
            try {
                PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(name, 0);
                if ((packageInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateServicesMap() {
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<ServiceInfo<V>> serviceInfos = new ArrayList<ServiceInfo<V>>();
        List<ResolveInfo> resolveInfos = pm.queryIntentServices(new Intent(this.mInterfaceName), 128);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                ServiceInfo<V> info = this.parseServiceInfo(resolveInfo);
                if (info == null) {
                    Log.w(TAG, "Unable to load service info " + resolveInfo.toString());
                    continue;
                }
                serviceInfos.add(info);
            }
            catch (XmlPullParserException e) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), e);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to load service info " + resolveInfo.toString(), e);
            }
        }
        Object object = this.mServicesLock;
        synchronized (object) {
            if (this.mPersistentServices == null) {
                this.readPersistentServicesLocked();
            }
            this.mServices = Maps.newHashMap();
            StringBuilder changes = new StringBuilder();
            for (ServiceInfo serviceInfo : serviceInfos) {
                Integer previousUid = this.mPersistentServices.get(serviceInfo.type);
                if (previousUid == null) {
                    changes.append("  New service added: ").append(serviceInfo).append("\n");
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    this.mPersistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    if (this.mPersistentServicesFileDidNotExist) continue;
                    this.notifyListener(serviceInfo.type, false);
                    continue;
                }
                if (previousUid == serviceInfo.uid) {
                    if (Log.isLoggable(TAG, 2)) {
                        changes.append("  Existing service (nop): ").append(serviceInfo).append("\n");
                    }
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    continue;
                }
                if (this.inSystemImage(serviceInfo.uid) || !this.containsTypeAndUid(serviceInfos, serviceInfo.type, previousUid)) {
                    if (this.inSystemImage(serviceInfo.uid)) {
                        changes.append("  System service replacing existing: ").append(serviceInfo).append("\n");
                    } else {
                        changes.append("  Existing service replacing a removed service: ").append(serviceInfo).append("\n");
                    }
                    this.mServices.put((ServiceInfo)serviceInfo.type, serviceInfo);
                    this.mPersistentServices.put((Integer)serviceInfo.type, serviceInfo.uid);
                    this.notifyListener(serviceInfo.type, false);
                    continue;
                }
                changes.append("  Existing service with new uid ignored: ").append(serviceInfo).append("\n");
            }
            ArrayList<V> toBeRemoved = Lists.newArrayList();
            for (Object v1 : this.mPersistentServices.keySet()) {
                if (this.containsType(serviceInfos, v1)) continue;
                toBeRemoved.add(v1);
            }
            for (Object v1 : toBeRemoved) {
                this.mPersistentServices.remove(v1);
                changes.append("  Service removed: ").append(v1).append("\n");
                this.notifyListener(v1, true);
            }
            if (changes.length() > 0) {
                Log.d(TAG, "generateServicesMap(" + this.mInterfaceName + "): " + serviceInfos.size() + " services:\n" + changes);
                this.writePersistentServicesLocked();
            } else {
                Log.d(TAG, "generateServicesMap(" + this.mInterfaceName + "): " + serviceInfos.size() + " services unchanged");
            }
            this.mPersistentServicesFileDidNotExist = false;
        }
    }

    public boolean containsType(ArrayList<ServiceInfo<V>> serviceInfos, V type) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            if (!serviceInfos.get((int)i).type.equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTypeAndUid(ArrayList<ServiceInfo<V>> serviceInfos, V type, int uid) {
        int N = serviceInfos.size();
        for (int i = 0; i < N; ++i) {
            ServiceInfo<V> serviceInfo = serviceInfos.get(i);
            if (!serviceInfo.type.equals(type) || serviceInfo.uid != uid) continue;
            return true;
        }
        return false;
    }

    public ServiceInfo<V> parseServiceInfo(ResolveInfo service) throws XmlPullParserException, IOException {
        android.content.pm.ServiceInfo si = service.serviceInfo;
        ComponentName componentName = new ComponentName(si.packageName, si.name);
        PackageManager pm = this.mContext.getPackageManager();
        XmlResourceParser parser = null;
        try {
            int type;
            parser = si.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!this.mAttributesName.equals(nodeName)) {
                throw new XmlPullParserException("Meta-data does not start with " + this.mAttributesName + " tag");
            }
            V v = this.parseServiceAttributes(pm.getResourcesForApplication(si.applicationInfo), si.packageName, attrs);
            if (v == null) {
                ServiceInfo<V> serviceInfo = null;
                return serviceInfo;
            }
            android.content.pm.ServiceInfo serviceInfo = service.serviceInfo;
            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
            int uid = applicationInfo.uid;
            ServiceInfo<V> serviceInfo2 = new ServiceInfo<V>(v, componentName, uid);
            return serviceInfo2;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new XmlPullParserException("Unable to load resources for pacakge " + si.packageName);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readPersistentServicesLocked() {
        block20: {
            this.mPersistentServices = Maps.newHashMap();
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileInputStream fis = null;
            try {
                boolean bl = this.mPersistentServicesFileDidNotExist = !this.mPersistentServicesFile.getBaseFile().exists();
                if (this.mPersistentServicesFileDidNotExist) {
                    return;
                }
                fis = this.mPersistentServicesFile.openRead();
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(fis, null);
                int eventType = parser.getEventType();
                while (eventType != 2) {
                    eventType = parser.next();
                }
                String tagName = parser.getName();
                if (!"services".equals(tagName)) break block20;
                eventType = parser.next();
                do {
                    if (eventType != 2 || parser.getDepth() != 2 || !"service".equals(tagName = parser.getName())) continue;
                    V service = this.mSerializerAndParser.createFromXml(parser);
                    if (service == null) {
                        break;
                    }
                    String uidString = parser.getAttributeValue(null, "uid");
                    int uid = Integer.parseInt(uidString);
                    this.mPersistentServices.put((Integer)service, uid);
                } while ((eventType = parser.next()) != 1);
            }
            catch (Exception e) {
                Log.w(TAG, "Error reading persistent services, starting from scratch", e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public void writePersistentServicesLocked() {
        block4: {
            if (this.mSerializerAndParser == null) {
                return;
            }
            FileOutputStream fos = null;
            try {
                fos = this.mPersistentServicesFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, "utf-8");
                out.startDocument(null, true);
                out.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                out.startTag(null, "services");
                for (Map.Entry<V, Integer> service : this.mPersistentServices.entrySet()) {
                    out.startTag(null, "service");
                    out.attribute(null, "uid", Integer.toString(service.getValue()));
                    this.mSerializerAndParser.writeAsXml(service.getKey(), out);
                    out.endTag(null, "service");
                }
                out.endTag(null, "services");
                out.endDocument();
                this.mPersistentServicesFile.finishWrite(fos);
            }
            catch (IOException e1) {
                Log.w(TAG, "Error writing accounts", e1);
                if (fos == null) break block4;
                this.mPersistentServicesFile.failWrite(fos);
            }
        }
    }

    public abstract V parseServiceAttributes(Resources var1, String var2, AttributeSet var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ServiceInfo<V> {
        public final V type;
        public final ComponentName componentName;
        public final int uid;

        public ServiceInfo(V type, ComponentName componentName, int uid) {
            this.type = type;
            this.componentName = componentName;
            this.uid = uid;
        }

        public String toString() {
            return "ServiceInfo: " + this.type + ", " + this.componentName + ", uid " + this.uid;
        }
    }
}

