/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.pm.ApplicationInfo;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Region;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.WindowManager;

public class CompatibilityInfo {
    public static final boolean DBG = false;
    public static final String TAG = "CompatibilityInfo";
    public static final CompatibilityInfo DEFAULT_COMPATIBILITY_INFO = new CompatibilityInfo(){

        public void setExpandable(boolean expandable) {
            throw new UnsupportedOperationException("trying to change default compatibility info");
        }
    };
    public static final int DEFAULT_PORTRAIT_WIDTH = 320;
    public static final int DEFAULT_PORTRAIT_HEIGHT = 480;
    public int mCompatibilityFlags;
    public static final int SCALING_REQUIRED = 1;
    public static final int EXPANDABLE = 2;
    public static final int CONFIGURED_EXPANDABLE = 4;
    public static final int LARGE_SCREENS = 8;
    public static final int CONFIGURED_LARGE_SCREENS = 16;
    public static final int XLARGE_SCREENS = 32;
    public static final int CONFIGURED_XLARGE_SCREENS = 64;
    public final int applicationDensity;
    public final float applicationScale;
    public final float applicationInvertedScale;
    public final int appFlags;

    public CompatibilityInfo(ApplicationInfo appInfo) {
        this.appFlags = appInfo.flags;
        if ((appInfo.flags & 0x800) != 0) {
            this.mCompatibilityFlags |= 0x7E;
        }
        if ((appInfo.flags & 0x80000) != 0) {
            this.mCompatibilityFlags |= 0x66;
        }
        if ((appInfo.flags & 0x1000) != 0) {
            this.mCompatibilityFlags |= 6;
        }
        if ((appInfo.flags & 0x2000) != 0) {
            this.applicationDensity = DisplayMetrics.DENSITY_DEVICE;
            this.applicationScale = 1.0f;
            this.applicationInvertedScale = 1.0f;
        } else {
            this.applicationDensity = 160;
            this.applicationScale = (float)DisplayMetrics.DENSITY_DEVICE / 160.0f;
            this.applicationInvertedScale = 1.0f / this.applicationScale;
            this.mCompatibilityFlags |= 1;
        }
    }

    public CompatibilityInfo(int appFlags, int compFlags, int dens, float scale, float invertedScale) {
        this.appFlags = appFlags;
        this.mCompatibilityFlags = compFlags;
        this.applicationDensity = dens;
        this.applicationScale = scale;
        this.applicationInvertedScale = invertedScale;
    }

    public CompatibilityInfo() {
        this(531968, 6, DisplayMetrics.DENSITY_DEVICE, 1.0f, 1.0f);
    }

    public CompatibilityInfo copy() {
        CompatibilityInfo info = new CompatibilityInfo(this.appFlags, this.mCompatibilityFlags, this.applicationDensity, this.applicationScale, this.applicationInvertedScale);
        return info;
    }

    public void setExpandable(boolean expandable) {
        this.mCompatibilityFlags = expandable ? (this.mCompatibilityFlags |= 2) : (this.mCompatibilityFlags &= 0xFFFFFFFD);
    }

    public void setLargeScreens(boolean expandable) {
        this.mCompatibilityFlags = expandable ? (this.mCompatibilityFlags |= 8) : (this.mCompatibilityFlags &= 0xFFFFFFF7);
    }

    public void setXLargeScreens(boolean expandable) {
        this.mCompatibilityFlags = expandable ? (this.mCompatibilityFlags |= 0x20) : (this.mCompatibilityFlags &= 0xFFFFFFDF);
    }

    public boolean isConfiguredExpandable() {
        return (this.mCompatibilityFlags & 4) != 0;
    }

    public boolean isConfiguredLargeScreens() {
        return (this.mCompatibilityFlags & 0x10) != 0;
    }

    public boolean isConfiguredXLargeScreens() {
        return (this.mCompatibilityFlags & 0x40) != 0;
    }

    public boolean isScalingRequired() {
        return (this.mCompatibilityFlags & 1) != 0;
    }

    public boolean supportsScreen() {
        return (this.mCompatibilityFlags & 0xA) == 10;
    }

    public String toString() {
        return "CompatibilityInfo{scale=" + this.applicationScale + ", supports screen=" + this.supportsScreen() + "}";
    }

    public Translator getTranslator() {
        return this.isScalingRequired() ? new Translator() : null;
    }

    public static void updateCompatibleScreenFrame(DisplayMetrics dm, int orientation, Rect outRect) {
        int width = dm.widthPixels;
        int portraitHeight = (int)(480.0f * dm.density + 0.5f);
        int portraitWidth = (int)(320.0f * dm.density + 0.5f);
        if (orientation == 2) {
            int xOffset = (width - portraitHeight) / 2;
            outRect.set(xOffset, 0, xOffset + portraitHeight, portraitWidth);
        } else {
            int xOffset = (width - portraitWidth) / 2;
            outRect.set(xOffset, 0, xOffset + portraitWidth, portraitHeight);
        }
    }

    public /* synthetic */ CompatibilityInfo(1 x0) {
        this();
    }

    public class Translator {
        public final float applicationScale;
        public final float applicationInvertedScale;
        public Rect mContentInsetsBuffer = null;
        public Rect mVisibleInsetsBuffer = null;
        public Region mTouchableAreaBuffer = null;

        public Translator(float applicationScale, float applicationInvertedScale) {
            this.applicationScale = applicationScale;
            this.applicationInvertedScale = applicationInvertedScale;
        }

        public Translator() {
            this(compatibilityInfo.applicationScale, compatibilityInfo.applicationInvertedScale);
        }

        public void translateRectInScreenToAppWinFrame(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translateRegionInWindowToScreen(Region transparentRegion) {
            transparentRegion.scale(this.applicationScale);
        }

        public void translateCanvas(Canvas canvas) {
            if (this.applicationScale == 1.5f) {
                float tinyOffset = 0.0026143792f;
                canvas.translate(0.0026143792f, 0.0026143792f);
            }
            canvas.scale(this.applicationScale, this.applicationScale);
        }

        public void translateEventInScreenToAppWindow(MotionEvent event) {
            event.scale(this.applicationInvertedScale);
        }

        public void translateWindowLayout(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        public void translateRectInAppWindowToScreen(Rect rect) {
            rect.scale(this.applicationScale);
        }

        public void translateRectInScreenToAppWindow(Rect rect) {
            rect.scale(this.applicationInvertedScale);
        }

        public void translatePointInScreenToAppWindow(PointF point) {
            float scale = this.applicationInvertedScale;
            if (scale != 1.0f) {
                point.x *= scale;
                point.y *= scale;
            }
        }

        public void translateLayoutParamsInAppWindowToScreen(WindowManager.LayoutParams params) {
            params.scale(this.applicationScale);
        }

        public Rect getTranslatedContentInsets(Rect contentInsets) {
            if (this.mContentInsetsBuffer == null) {
                this.mContentInsetsBuffer = new Rect();
            }
            this.mContentInsetsBuffer.set(contentInsets);
            this.translateRectInAppWindowToScreen(this.mContentInsetsBuffer);
            return this.mContentInsetsBuffer;
        }

        public Rect getTranslatedVisibleInsets(Rect visibleInsets) {
            if (this.mVisibleInsetsBuffer == null) {
                this.mVisibleInsetsBuffer = new Rect();
            }
            this.mVisibleInsetsBuffer.set(visibleInsets);
            this.translateRectInAppWindowToScreen(this.mVisibleInsetsBuffer);
            return this.mVisibleInsetsBuffer;
        }

        public Region getTranslatedTouchableArea(Region touchableArea) {
            if (this.mTouchableAreaBuffer == null) {
                this.mTouchableAreaBuffer = new Region();
            }
            this.mTouchableAreaBuffer.set(touchableArea);
            this.mTouchableAreaBuffer.scale(this.applicationScale);
            return this.mTouchableAreaBuffer;
        }
    }
}

