/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;

public class SQLiteDebug {
    public static final boolean DEBUG_SQL_STATEMENTS = Log.isLoggable("SQLiteStatements", 2);
    public static final boolean DEBUG_SQL_TIME = Log.isLoggable("SQLiteTime", 2);
    public static final boolean DEBUG_SQL_CACHE = Log.isLoggable("SQLiteCompiledSql", 2);
    public static final boolean DEBUG_ACTIVE_CURSOR_FINALIZATION = Log.isLoggable("SQLiteCursorClosing", 2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING = Log.isLoggable("SQLiteLockTime", 2);
    public static final boolean DEBUG_LOCK_TIME_TRACKING_STACK_TRACE = Log.isLoggable("SQLiteLockStackTrace", 2);
    public static int sNumActiveCursorsFinalized = 0;

    public static PagerStats getDatabaseInfo() {
        PagerStats stats = new PagerStats();
        SQLiteDebug.getPagerStats(stats);
        stats.dbStats = SQLiteDatabase.getDbStats();
        return stats;
    }

    public static void getPagerStats(PagerStats pagerStats) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDebug#getPagerStats(Landroid/database/sqlite/SQLiteDebug$PagerStats;)V", true, null);
    }

    public static long getHeapSize() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteDebug#getHeapSize()J", true, null);
    }

    public static long getHeapAllocatedSize() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteDebug#getHeapAllocatedSize()J", true, null);
    }

    public static long getHeapFreeSize() {
        return OverrideMethod.invokeL("android.database.sqlite.SQLiteDebug#getHeapFreeSize()J", true, null);
    }

    public static void getHeapDirtyPages(int[] nArray) {
        OverrideMethod.invokeV("android.database.sqlite.SQLiteDebug#getHeapDirtyPages([I)V", true, null);
    }

    public static int getNumActiveCursorsFinalized() {
        return sNumActiveCursorsFinalized;
    }

    public static synchronized void notifyActiveCursorFinalized() {
        ++sNumActiveCursorsFinalized;
    }

    public static class DbStats {
        public String dbName;
        public long pageSize;
        public long dbSize;
        public int lookaside;
        public String cache;

        public DbStats(String dbName, long pageCount, long pageSize, int lookaside, int hits, int misses, int cachesize) {
            this.dbName = dbName;
            this.pageSize = pageSize / 1024L;
            this.dbSize = pageCount * pageSize / 1024L;
            this.lookaside = lookaside;
            this.cache = hits + "/" + misses + "/" + cachesize;
        }
    }

    public static class PagerStats {
        @Deprecated
        public long totalBytes;
        @Deprecated
        public long referencedBytes;
        @Deprecated
        public long databaseBytes;
        @Deprecated
        public int numPagers;
        public int memoryUsed;
        public int pageCacheOverflo;
        public int largestMemAlloc;
        public ArrayList<DbStats> dbStats;
    }
}

