/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas_Delegate;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Picture;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.TemporaryBuffer;
import android.text.GraphicsOperations;
import android.text.SpannableString;
import android.text.SpannedString;
import android.text.TextUtils;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import javax.microedition.khronos.opengles.GL;

public class Canvas {
    public final int mNativeCanvas;
    public Bitmap mBitmap;
    public DrawFilter mDrawFilter;
    public int mDensity = 0;
    public int mScreenDensity = 0;
    public int mSurfaceFormat;
    public static final int DIRECTION_LTR = 0;
    public static final int DIRECTION_RTL = 1;
    public final CanvasFinalizer mFinalizer;
    public static final int MATRIX_SAVE_FLAG = 1;
    public static final int CLIP_SAVE_FLAG = 2;
    public static final int HAS_ALPHA_LAYER_SAVE_FLAG = 4;
    public static final int FULL_COLOR_LAYER_SAVE_FLAG = 8;
    public static final int CLIP_TO_LAYER_SAVE_FLAG = 16;
    public static final int ALL_SAVE_FLAG = 31;

    public Canvas() {
        this.mNativeCanvas = Canvas.initRaster(0);
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvas);
    }

    public Canvas(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException("Immutable bitmap passed to Canvas constructor");
        }
        Canvas.throwIfRecycled(bitmap);
        this.mNativeCanvas = Canvas.initRaster(bitmap.ni());
        this.mFinalizer = new CanvasFinalizer(this.mNativeCanvas);
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public Canvas(int nativeCanvas) {
        if (nativeCanvas == 0) {
            throw new IllegalStateException();
        }
        this.mNativeCanvas = nativeCanvas;
        this.mFinalizer = new CanvasFinalizer(nativeCanvas);
        this.mDensity = Bitmap.getDefaultDensity();
    }

    @Deprecated
    public GL getGL() {
        return null;
    }

    public boolean isHardwareAccelerated() {
        return false;
    }

    public void setBitmap(Bitmap bitmap) {
        if (!bitmap.isMutable()) {
            throw new IllegalStateException();
        }
        if (this.isHardwareAccelerated()) {
            throw new RuntimeException("Can't set a bitmap device on a GL canvas");
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_setBitmap(this.mNativeCanvas, bitmap.ni());
        this.mBitmap = bitmap;
        this.mDensity = bitmap.mDensity;
    }

    public void setViewport(int width, int height) {
    }

    @LayoutlibDelegate
    public boolean isOpaque() {
        return Canvas_Delegate.isOpaque(this);
    }

    @LayoutlibDelegate
    public int getWidth() {
        return Canvas_Delegate.getWidth(this);
    }

    @LayoutlibDelegate
    public int getHeight() {
        return Canvas_Delegate.getHeight(this);
    }

    public int getDensity() {
        return this.mDensity;
    }

    public void setDensity(int density) {
        if (this.mBitmap != null) {
            this.mBitmap.setDensity(density);
        }
        this.mDensity = density;
    }

    public void setScreenDensity(int density) {
        this.mScreenDensity = density;
    }

    @LayoutlibDelegate
    public int save() {
        return Canvas_Delegate.save(this);
    }

    @LayoutlibDelegate
    public int save(int n) {
        return Canvas_Delegate.save(this, n);
    }

    public int saveLayer(RectF bounds, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, bounds, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayer(float left, float top, float right, float bottom, Paint paint, int saveFlags) {
        return Canvas.native_saveLayer(this.mNativeCanvas, left, top, right, bottom, paint != null ? paint.mNativePaint : 0, saveFlags);
    }

    public int saveLayerAlpha(RectF bounds, int alpha, int saveFlags) {
        alpha = Math.min(255, Math.max(0, alpha));
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, bounds, alpha, saveFlags);
    }

    public int saveLayerAlpha(float left, float top, float right, float bottom, int alpha, int saveFlags) {
        return Canvas.native_saveLayerAlpha(this.mNativeCanvas, left, top, right, bottom, alpha, saveFlags);
    }

    @LayoutlibDelegate
    public void restore() {
        Canvas_Delegate.restore(this);
    }

    @LayoutlibDelegate
    public int getSaveCount() {
        return Canvas_Delegate.getSaveCount(this);
    }

    @LayoutlibDelegate
    public void restoreToCount(int n) {
        Canvas_Delegate.restoreToCount(this, n);
    }

    @LayoutlibDelegate
    public void translate(float f, float f2) {
        Canvas_Delegate.translate(this, f, f2);
    }

    @LayoutlibDelegate
    public void scale(float f, float f2) {
        Canvas_Delegate.scale(this, f, f2);
    }

    public void scale(float sx, float sy, float px, float py) {
        this.translate(px, py);
        this.scale(sx, sy);
        this.translate(-px, -py);
    }

    @LayoutlibDelegate
    public void rotate(float f) {
        Canvas_Delegate.rotate(this, f);
    }

    public void rotate(float degrees, float px, float py) {
        this.translate(px, py);
        this.rotate(degrees);
        this.translate(-px, -py);
    }

    @LayoutlibDelegate
    public void skew(float f, float f2) {
        Canvas_Delegate.skew(this, f, f2);
    }

    public void concat(Matrix matrix) {
        Canvas.native_concat(this.mNativeCanvas, matrix.native_instance);
    }

    public void setMatrix(Matrix matrix) {
        Canvas.native_setMatrix(this.mNativeCanvas, matrix == null ? 0 : matrix.native_instance);
    }

    public void getMatrix(Matrix ctm) {
        Canvas.native_getCTM(this.mNativeCanvas, ctm.native_instance);
    }

    public int getNativeMatrix() {
        return 0;
    }

    public Matrix getMatrix() {
        Matrix m = new Matrix();
        this.getMatrix(m);
        return m;
    }

    public boolean clipRect(RectF rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    public boolean clipRect(Rect rect, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, rect.left, rect.top, rect.right, rect.bottom, op.nativeInt);
    }

    @LayoutlibDelegate
    public boolean clipRect(RectF rectF) {
        return Canvas_Delegate.clipRect(this, rectF);
    }

    @LayoutlibDelegate
    public boolean clipRect(Rect rect) {
        return Canvas_Delegate.clipRect(this, rect);
    }

    public boolean clipRect(float left, float top, float right, float bottom, Region.Op op) {
        return Canvas.native_clipRect(this.mNativeCanvas, left, top, right, bottom, op.nativeInt);
    }

    @LayoutlibDelegate
    public boolean clipRect(float f, float f2, float f3, float f4) {
        return Canvas_Delegate.clipRect(this, f, f2, f3, f4);
    }

    @LayoutlibDelegate
    public boolean clipRect(int n, int n2, int n3, int n4) {
        return Canvas_Delegate.clipRect(this, n, n2, n3, n4);
    }

    public boolean clipPath(Path path, Region.Op op) {
        return Canvas.native_clipPath(this.mNativeCanvas, path.ni(), op.nativeInt);
    }

    public boolean clipPath(Path path) {
        return this.clipPath(path, Region.Op.INTERSECT);
    }

    public boolean clipRegion(Region region, Region.Op op) {
        return Canvas.native_clipRegion(this.mNativeCanvas, region.ni(), op.nativeInt);
    }

    public boolean clipRegion(Region region) {
        return this.clipRegion(region, Region.Op.INTERSECT);
    }

    public DrawFilter getDrawFilter() {
        return this.mDrawFilter;
    }

    public void setDrawFilter(DrawFilter filter) {
        int nativeFilter = 0;
        if (filter != null) {
            nativeFilter = filter.mNativeInt;
        }
        this.mDrawFilter = filter;
        Canvas.nativeSetDrawFilter(this.mNativeCanvas, nativeFilter);
    }

    public boolean quickReject(RectF rect, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, rect, type.nativeInt);
    }

    public boolean quickReject(Path path, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, path.ni(), type.nativeInt);
    }

    public boolean quickReject(float left, float top, float right, float bottom, EdgeType type) {
        return Canvas.native_quickReject(this.mNativeCanvas, left, top, right, bottom, type.nativeInt);
    }

    public boolean getClipBounds(Rect bounds) {
        return Canvas.native_getClipBounds(this.mNativeCanvas, bounds);
    }

    public Rect getClipBounds() {
        Rect r = new Rect();
        this.getClipBounds(r);
        return r;
    }

    public void drawRGB(int r, int g, int b) {
        Canvas.native_drawRGB(this.mNativeCanvas, r, g, b);
    }

    public void drawARGB(int a, int r, int g, int b) {
        Canvas.native_drawARGB(this.mNativeCanvas, a, r, g, b);
    }

    public void drawColor(int color2) {
        Canvas.native_drawColor(this.mNativeCanvas, color2);
    }

    public void drawColor(int color2, PorterDuff.Mode mode) {
        Canvas.native_drawColor(this.mNativeCanvas, color2, mode.nativeInt);
    }

    public void drawPaint(Paint paint) {
        Canvas.native_drawPaint(this.mNativeCanvas, paint.mNativePaint);
    }

    @LayoutlibDelegate
    public void drawPoints(float[] fArray, int n, int n2, Paint paint) {
        Canvas_Delegate.drawPoints(this, fArray, n, n2, paint);
    }

    public void drawPoints(float[] pts, Paint paint) {
        this.drawPoints(pts, 0, pts.length, paint);
    }

    @LayoutlibDelegate
    public void drawPoint(float f, float f2, Paint paint) {
        Canvas_Delegate.drawPoint(this, f, f2, paint);
    }

    public void drawLine(float startX, float startY, float stopX, float stopY, Paint paint) {
        Canvas.native_drawLine(this.mNativeCanvas, startX, startY, stopX, stopY, paint.mNativePaint);
    }

    @LayoutlibDelegate
    public void drawLines(float[] fArray, int n, int n2, Paint paint) {
        Canvas_Delegate.drawLines(this, fArray, n, n2, paint);
    }

    public void drawLines(float[] pts, Paint paint) {
        this.drawLines(pts, 0, pts.length, paint);
    }

    public void drawRect(RectF rect, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, rect, paint.mNativePaint);
    }

    public void drawRect(Rect r, Paint paint) {
        this.drawRect(r.left, r.top, r.right, r.bottom, paint);
    }

    public void drawRect(float left, float top, float right, float bottom, Paint paint) {
        Canvas.native_drawRect(this.mNativeCanvas, left, top, right, bottom, paint.mNativePaint);
    }

    public void drawOval(RectF oval, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawOval(this.mNativeCanvas, oval, paint.mNativePaint);
    }

    public void drawCircle(float cx, float cy, float radius, Paint paint) {
        Canvas.native_drawCircle(this.mNativeCanvas, cx, cy, radius, paint.mNativePaint);
    }

    public void drawArc(RectF oval, float startAngle, float sweepAngle, boolean useCenter, Paint paint) {
        if (oval == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawArc(this.mNativeCanvas, oval, startAngle, sweepAngle, useCenter, paint.mNativePaint);
    }

    public void drawRoundRect(RectF rect, float rx, float ry, Paint paint) {
        if (rect == null) {
            throw new NullPointerException();
        }
        Canvas.native_drawRoundRect(this.mNativeCanvas, rect, rx, ry, paint.mNativePaint);
    }

    public void drawPath(Path path, Paint paint) {
        Canvas.native_drawPath(this.mNativeCanvas, path.ni(), paint.mNativePaint);
    }

    public static void throwIfRecycled(Bitmap bitmap) {
        if (bitmap.isRecycled()) {
            throw new RuntimeException("Canvas: trying to use a recycled bitmap " + bitmap);
        }
    }

    public void drawPatch(Bitmap bitmap, byte[] chunks, RectF dst, Paint paint) {
    }

    public void drawBitmap(Bitmap bitmap, float left, float top, Paint paint) {
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), left, top, paint != null ? paint.mNativePaint : 0, this.mDensity, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, RectF dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        this.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(Bitmap bitmap, Rect src, Rect dst, Paint paint) {
        if (dst == null) {
            throw new NullPointerException();
        }
        Canvas.throwIfRecycled(bitmap);
        Canvas.native_drawBitmap(this.mNativeCanvas, bitmap.ni(), src, dst, paint != null ? paint.mNativePaint : 0, this.mScreenDensity, bitmap.mDensity);
    }

    public void drawBitmap(int[] colors, int offset, int stride, float x, float y, int width, int height, boolean hasAlpha, Paint paint) {
        if (width < 0) {
            throw new IllegalArgumentException("width must be >= 0");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height must be >= 0");
        }
        if (Math.abs(stride) < width) {
            throw new IllegalArgumentException("abs(stride) must be >= width");
        }
        int lastScanline = offset + (height - 1) * stride;
        int length = colors.length;
        if (offset < 0 || offset + width > length || lastScanline < 0 || lastScanline + width > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (width == 0 || height == 0) {
            return;
        }
        Canvas.native_drawBitmap(this.mNativeCanvas, colors, offset, stride, x, y, width, height, hasAlpha, paint != null ? paint.mNativePaint : 0);
    }

    public void drawBitmap(int[] colors, int offset, int stride, int x, int y, int width, int height, boolean hasAlpha, Paint paint) {
        this.drawBitmap(colors, offset, stride, (float)x, (float)y, width, height, hasAlpha, paint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Paint paint) {
        Canvas.nativeDrawBitmapMatrix(this.mNativeCanvas, bitmap.ni(), matrix.ni(), paint != null ? paint.mNativePaint : 0);
    }

    public static void checkRange(int length, int offset, int count) {
        if ((offset | count) < 0 || offset + count > length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void drawBitmapMesh(Bitmap bitmap, int meshWidth, int meshHeight, float[] verts, int vertOffset, int[] colors, int colorOffset, Paint paint) {
        if ((meshWidth | meshHeight | vertOffset | colorOffset) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (meshWidth == 0 || meshHeight == 0) {
            return;
        }
        int count = (meshWidth + 1) * (meshHeight + 1);
        Canvas.checkRange(verts.length, vertOffset, count * 2);
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, count);
        }
        Canvas.nativeDrawBitmapMesh(this.mNativeCanvas, bitmap.ni(), meshWidth, meshHeight, verts, vertOffset, colors, colorOffset, paint != null ? paint.mNativePaint : 0);
    }

    public void drawVertices(VertexMode mode, int vertexCount, float[] verts, int vertOffset, float[] texs, int texOffset, int[] colors, int colorOffset, short[] indices, int indexOffset, int indexCount, Paint paint) {
        Canvas.checkRange(verts.length, vertOffset, vertexCount);
        if (texs != null) {
            Canvas.checkRange(texs.length, texOffset, vertexCount);
        }
        if (colors != null) {
            Canvas.checkRange(colors.length, colorOffset, vertexCount / 2);
        }
        if (indices != null) {
            Canvas.checkRange(indices.length, indexOffset, indexCount);
        }
        Canvas.nativeDrawVertices(this.mNativeCanvas, mode.nativeInt, vertexCount, verts, vertOffset, texs, texOffset, colors, colorOffset, indices, indexOffset, indexCount, paint.mNativePaint);
    }

    public void drawText(char[] text, int index, int count, float x, float y, Paint paint) {
        if ((index | count | index + count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, index, count, x, y, paint.mBidiFlags, paint.mNativePaint);
    }

    public void drawText(String text, float x, float y, Paint paint) {
        Canvas.native_drawText(this.mNativeCanvas, text, 0, text.length(), x, y, paint.mBidiFlags, paint.mNativePaint);
    }

    public void drawText(String text, int start, int end, float x, float y, Paint paint) {
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawText(this.mNativeCanvas, text, start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
    }

    public void drawText(CharSequence text, int start, int end, float x, float y, Paint paint) {
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawText(this.mNativeCanvas, ((Object)text).toString(), start, end, x, y, paint.mBidiFlags, paint.mNativePaint);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawText(this, start, end, x, y, paint);
        } else {
            char[] buf = TemporaryBuffer.obtain(end - start);
            TextUtils.getChars(text, start, end, buf, 0);
            Canvas.native_drawText(this.mNativeCanvas, buf, 0, end - start, x, y, paint.mBidiFlags, paint.mNativePaint);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawTextRun(char[] text, int index, int count, int contextIndex, int contextCount, float x, float y, int dir, Paint paint) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((index | count | text.length - index - count) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dir != 0 && dir != 1) {
            throw new IllegalArgumentException("unknown dir: " + dir);
        }
        Canvas.native_drawTextRun(this.mNativeCanvas, text, index, count, contextIndex, contextCount, x, y, dir, paint.mNativePaint);
    }

    public void drawTextRun(CharSequence text, int start, int end, int contextStart, int contextEnd, float x, float y, int dir, Paint paint) {
        int flags;
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        if (paint == null) {
            throw new NullPointerException("paint is null");
        }
        if ((start | end | end - start | text.length() - end) < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = flags = dir == 0 ? 0 : 1;
        if (text instanceof String || text instanceof SpannedString || text instanceof SpannableString) {
            Canvas.native_drawTextRun(this.mNativeCanvas, ((Object)text).toString(), start, end, contextStart, contextEnd, x, y, flags, paint.mNativePaint);
        } else if (text instanceof GraphicsOperations) {
            ((GraphicsOperations)text).drawTextRun(this, start, end, contextStart, contextEnd, x, y, flags, paint);
        } else {
            int contextLen = contextEnd - contextStart;
            int len = end - start;
            char[] buf = TemporaryBuffer.obtain(contextLen);
            TextUtils.getChars(text, contextStart, contextEnd, buf, 0);
            Canvas.native_drawTextRun(this.mNativeCanvas, buf, start - contextStart, len, 0, contextLen, x, y, flags, paint.mNativePaint);
            TemporaryBuffer.recycle(buf);
        }
    }

    public void drawPosText(char[] text, int index, int count, float[] pos, Paint paint) {
        if (index < 0 || index + count > text.length || count * 2 > pos.length) {
            throw new IndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, index, count, pos, paint.mNativePaint);
    }

    public void drawPosText(String text, float[] pos, Paint paint) {
        if (text.length() * 2 > pos.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawPosText(this.mNativeCanvas, text, pos, paint.mNativePaint);
    }

    public void drawTextOnPath(char[] text, int index, int count, Path path, float hOffset, float vOffset, Paint paint) {
        if (index < 0 || index + count > text.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Canvas.native_drawTextOnPath(this.mNativeCanvas, text, index, count, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
    }

    public void drawTextOnPath(String text, Path path, float hOffset, float vOffset, Paint paint) {
        if (text.length() > 0) {
            Canvas.native_drawTextOnPath(this.mNativeCanvas, text, path.ni(), hOffset, vOffset, paint.mBidiFlags, paint.mNativePaint);
        }
    }

    public void drawPicture(Picture picture) {
        picture.endRecording();
        Canvas.native_drawPicture(this.mNativeCanvas, picture.ni());
    }

    public void drawPicture(Picture picture, RectF dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale(dst.width() / (float)picture.getWidth(), dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    public void drawPicture(Picture picture, Rect dst) {
        this.save();
        this.translate(dst.left, dst.top);
        if (picture.getWidth() > 0 && picture.getHeight() > 0) {
            this.scale((float)dst.width() / (float)picture.getWidth(), (float)dst.height() / (float)picture.getHeight());
        }
        this.drawPicture(picture);
        this.restore();
    }

    @LayoutlibDelegate
    public static void freeCaches() {
        Canvas_Delegate.freeCaches();
    }

    @LayoutlibDelegate
    public static int initRaster(int n) {
        return Canvas_Delegate.initRaster(n);
    }

    @LayoutlibDelegate
    public static void native_setBitmap(int n, int n2) {
        Canvas_Delegate.native_setBitmap(n, n2);
    }

    @LayoutlibDelegate
    public static int native_saveLayer(int n, RectF rectF, int n2, int n3) {
        return Canvas_Delegate.native_saveLayer(n, rectF, n2, n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayer(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return Canvas_Delegate.native_saveLayer(n, f, f2, f3, f4, n2, n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayerAlpha(int n, RectF rectF, int n2, int n3) {
        return Canvas_Delegate.native_saveLayerAlpha(n, rectF, n2, n3);
    }

    @LayoutlibDelegate
    public static int native_saveLayerAlpha(int n, float f, float f2, float f3, float f4, int n2, int n3) {
        return Canvas_Delegate.native_saveLayerAlpha(n, f, f2, f3, f4, n2, n3);
    }

    @LayoutlibDelegate
    public static void native_concat(int n, int n2) {
        Canvas_Delegate.native_concat(n, n2);
    }

    @LayoutlibDelegate
    public static void native_setMatrix(int n, int n2) {
        Canvas_Delegate.native_setMatrix(n, n2);
    }

    @LayoutlibDelegate
    public static boolean native_clipRect(int n, float f, float f2, float f3, float f4, int n2) {
        return Canvas_Delegate.native_clipRect(n, f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    public static boolean native_clipPath(int n, int n2, int n3) {
        return Canvas_Delegate.native_clipPath(n, n2, n3);
    }

    @LayoutlibDelegate
    public static boolean native_clipRegion(int n, int n2, int n3) {
        return Canvas_Delegate.native_clipRegion(n, n2, n3);
    }

    @LayoutlibDelegate
    public static void nativeSetDrawFilter(int n, int n2) {
        Canvas_Delegate.nativeSetDrawFilter(n, n2);
    }

    @LayoutlibDelegate
    public static boolean native_getClipBounds(int n, Rect rect) {
        return Canvas_Delegate.native_getClipBounds(n, rect);
    }

    @LayoutlibDelegate
    public static void native_getCTM(int n, int n2) {
        Canvas_Delegate.native_getCTM(n, n2);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, RectF rectF, int n2) {
        return Canvas_Delegate.native_quickReject(n, rectF, n2);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, int n2, int n3) {
        return Canvas_Delegate.native_quickReject(n, n2, n3);
    }

    @LayoutlibDelegate
    public static boolean native_quickReject(int n, float f, float f2, float f3, float f4, int n2) {
        return Canvas_Delegate.native_quickReject(n, f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    public static void native_drawRGB(int n, int n2, int n3, int n4) {
        Canvas_Delegate.native_drawRGB(n, n2, n3, n4);
    }

    @LayoutlibDelegate
    public static void native_drawARGB(int n, int n2, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawARGB(n, n2, n3, n4, n5);
    }

    @LayoutlibDelegate
    public static void native_drawColor(int n, int n2) {
        Canvas_Delegate.native_drawColor(n, n2);
    }

    @LayoutlibDelegate
    public static void native_drawColor(int n, int n2, int n3) {
        Canvas_Delegate.native_drawColor(n, n2, n3);
    }

    @LayoutlibDelegate
    public static void native_drawPaint(int n, int n2) {
        Canvas_Delegate.native_drawPaint(n, n2);
    }

    @LayoutlibDelegate
    public static void native_drawLine(int n, float f, float f2, float f3, float f4, int n2) {
        Canvas_Delegate.native_drawLine(n, f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    public static void native_drawRect(int n, RectF rectF, int n2) {
        Canvas_Delegate.native_drawRect(n, rectF, n2);
    }

    @LayoutlibDelegate
    public static void native_drawRect(int n, float f, float f2, float f3, float f4, int n2) {
        Canvas_Delegate.native_drawRect(n, f, f2, f3, f4, n2);
    }

    @LayoutlibDelegate
    public static void native_drawOval(int n, RectF rectF, int n2) {
        Canvas_Delegate.native_drawOval(n, rectF, n2);
    }

    @LayoutlibDelegate
    public static void native_drawCircle(int n, float f, float f2, float f3, int n2) {
        Canvas_Delegate.native_drawCircle(n, f, f2, f3, n2);
    }

    @LayoutlibDelegate
    public static void native_drawArc(int n, RectF rectF, float f, float f2, boolean bl, int n2) {
        Canvas_Delegate.native_drawArc(n, rectF, f, f2, bl, n2);
    }

    @LayoutlibDelegate
    public static void native_drawRoundRect(int n, RectF rectF, float f, float f2, int n2) {
        Canvas_Delegate.native_drawRoundRect(n, rectF, f, f2, n2);
    }

    @LayoutlibDelegate
    public static void native_drawPath(int n, int n2, int n3) {
        Canvas_Delegate.native_drawPath(n, n2, n3);
    }

    @LayoutlibDelegate
    public void native_drawBitmap(int n, int n2, float f, float f2, int n3, int n4, int n5, int n6) {
        Canvas_Delegate.native_drawBitmap(this, n, n2, f, f2, n3, n4, n5, n6);
    }

    @LayoutlibDelegate
    public void native_drawBitmap(int n, int n2, Rect rect, RectF rectF, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawBitmap(this, n, n2, rect, rectF, n3, n4, n5);
    }

    @LayoutlibDelegate
    public static void native_drawBitmap(int n, int n2, Rect rect, Rect rect2, int n3, int n4, int n5) {
        Canvas_Delegate.native_drawBitmap(n, n2, rect, rect2, n3, n4, n5);
    }

    @LayoutlibDelegate
    public static void native_drawBitmap(int n, int[] nArray, int n2, int n3, float f, float f2, int n4, int n5, boolean bl, int n6) {
        Canvas_Delegate.native_drawBitmap(n, nArray, n2, n3, f, f2, n4, n5, bl, n6);
    }

    @LayoutlibDelegate
    public static void nativeDrawBitmapMatrix(int n, int n2, int n3, int n4) {
        Canvas_Delegate.nativeDrawBitmapMatrix(n, n2, n3, n4);
    }

    @LayoutlibDelegate
    public static void nativeDrawBitmapMesh(int n, int n2, int n3, int n4, float[] fArray, int n5, int[] nArray, int n6, int n7) {
        Canvas_Delegate.nativeDrawBitmapMesh(n, n2, n3, n4, fArray, n5, nArray, n6, n7);
    }

    @LayoutlibDelegate
    public static void nativeDrawVertices(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2, int n5, int[] nArray, int n6, short[] sArray, int n7, int n8, int n9) {
        Canvas_Delegate.nativeDrawVertices(n, n2, n3, fArray, n4, fArray2, n5, nArray, n6, sArray, n7, n8, n9);
    }

    @LayoutlibDelegate
    public static void native_drawText(int n, char[] cArray, int n2, int n3, float f, float f2, int n4, int n5) {
        Canvas_Delegate.native_drawText(n, cArray, n2, n3, f, f2, n4, n5);
    }

    @LayoutlibDelegate
    public static void native_drawText(int n, String string2, int n2, int n3, float f, float f2, int n4, int n5) {
        Canvas_Delegate.native_drawText(n, string2, n2, n3, f, f2, n4, n5);
    }

    @LayoutlibDelegate
    public static void native_drawTextRun(int n, String string2, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        Canvas_Delegate.native_drawTextRun(n, string2, n2, n3, n4, n5, f, f2, n6, n7);
    }

    @LayoutlibDelegate
    public static void native_drawTextRun(int n, char[] cArray, int n2, int n3, int n4, int n5, float f, float f2, int n6, int n7) {
        Canvas_Delegate.native_drawTextRun(n, cArray, n2, n3, n4, n5, f, f2, n6, n7);
    }

    @LayoutlibDelegate
    public static void native_drawPosText(int n, char[] cArray, int n2, int n3, float[] fArray, int n4) {
        Canvas_Delegate.native_drawPosText(n, cArray, n2, n3, fArray, n4);
    }

    @LayoutlibDelegate
    public static void native_drawPosText(int n, String string2, float[] fArray, int n2) {
        Canvas_Delegate.native_drawPosText(n, string2, fArray, n2);
    }

    @LayoutlibDelegate
    public static void native_drawTextOnPath(int n, char[] cArray, int n2, int n3, int n4, float f, float f2, int n5, int n6) {
        Canvas_Delegate.native_drawTextOnPath(n, cArray, n2, n3, n4, f, f2, n5, n6);
    }

    @LayoutlibDelegate
    public static void native_drawTextOnPath(int n, String string2, int n2, float f, float f2, int n3, int n4) {
        Canvas_Delegate.native_drawTextOnPath(n, string2, n2, f, f2, n3, n4);
    }

    @LayoutlibDelegate
    public static void native_drawPicture(int n, int n2) {
        Canvas_Delegate.native_drawPicture(n, n2);
    }

    @LayoutlibDelegate
    public static void finalizer(int n) {
        Canvas_Delegate.finalizer(n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexMode {
        TRIANGLES(0),
        TRIANGLE_STRIP(1),
        TRIANGLE_FAN(2);

        public final int nativeInt;

        public VertexMode(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeType {
        BW(0),
        AA(1);

        public final int nativeInt;

        public EdgeType(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }

    public static class CanvasFinalizer {
        public final int mNativeCanvas;

        public CanvasFinalizer(int nativeCanvas) {
            this.mNativeCanvas = nativeCanvas;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalize() throws Throwable {
            try {
                if (this.mNativeCanvas != 0) {
                    Canvas.finalizer(this.mNativeCanvas);
                }
            }
            finally {
                super.finalize();
            }
        }
    }
}

