/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.util.AttributeSet;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MipmapDrawable
extends DrawableContainer {
    public final MipmapContainerState mMipmapContainerState;
    public boolean mMutated;

    public MipmapDrawable() {
        this(null, null);
    }

    public void addDrawable(Drawable drawable2) {
        if (drawable2 != null) {
            this.mMipmapContainerState.addDrawable(drawable2);
            this.onDrawableAdded();
        }
    }

    public void onDrawableAdded() {
        this.selectDrawable(-1);
        this.onBoundsChange(this.getBounds());
    }

    public void onBoundsChange(Rect bounds) {
        int index = this.mMipmapContainerState.indexForBounds(bounds);
        this.selectDrawable(index);
        super.onBoundsChange(bounds);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int depth;
        int type;
        super.inflate(r, parser, attrs);
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            Drawable dr;
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = r.obtainAttributes(attrs, R.styleable.MipmapDrawableItem);
            int drawableRes = a.getResourceId(0, 0);
            a.recycle();
            if (drawableRes != 0) {
                dr = r.getDrawable(drawableRes);
            } else {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or " + "child tag defining a drawable");
                }
                dr = Drawable.createFromXmlInner(r, parser, attrs);
            }
            this.mMipmapContainerState.addDrawable(dr);
        }
        this.onDrawableAdded();
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            MipmapContainerState.access$002(this.mMipmapContainerState, (int[])this.mMipmapContainerState.mMipmapHeights.clone());
            this.mMutated = true;
        }
        return this;
    }

    public MipmapDrawable(MipmapContainerState state, Resources res) {
        MipmapContainerState as;
        this.mMipmapContainerState = as = new MipmapContainerState(state, this, res);
        this.setConstantState(as);
        this.onDrawableAdded();
    }

    public /* synthetic */ MipmapDrawable(MipmapContainerState x0, Resources x1, 1 x2) {
        this(x0, x1);
    }

    public static class 1 {
    }

    public static class MipmapContainerState
    extends DrawableContainer.DrawableContainerState {
        public int[] mMipmapHeights;

        public MipmapContainerState(MipmapContainerState orig, MipmapDrawable owner, Resources res) {
            super(orig, owner, res);
            this.mMipmapHeights = orig != null ? orig.mMipmapHeights : new int[this.getChildren().length];
            this.setConstantSize(true);
        }

        public int indexForBounds(Rect bounds) {
            int boundsHeight = bounds.height();
            int N = this.getChildCount();
            for (int i = 0; i < N; ++i) {
                if (boundsHeight > this.mMipmapHeights[i]) continue;
                return i;
            }
            if (N > 0) {
                return N - 1;
            }
            return -1;
        }

        public void addDrawable(Drawable drawable2) {
            Drawable previousDrawable;
            int previousIntrinsicHeight;
            int drawableHeight = drawable2.getIntrinsicHeight();
            for (int pos = this.addChild(drawable2); pos > 0 && drawableHeight < (previousIntrinsicHeight = (previousDrawable = this.mDrawables[pos - 1]).getIntrinsicHeight()); --pos) {
                this.mDrawables[pos] = previousDrawable;
                this.mMipmapHeights[pos] = previousIntrinsicHeight;
                this.mDrawables[pos - 1] = drawable2;
                this.mMipmapHeights[pos - 1] = drawableHeight;
            }
        }

        public void computeConstantSize() {
            int N = this.getChildCount();
            if (N > 0) {
                Drawable smallestDrawable = this.mDrawables[0];
                this.mConstantMinimumWidth = smallestDrawable.getMinimumWidth();
                this.mConstantMinimumHeight = smallestDrawable.getMinimumHeight();
                Drawable largestDrawable = this.mDrawables[N - 1];
                this.mConstantWidth = largestDrawable.getIntrinsicWidth();
                this.mConstantHeight = largestDrawable.getIntrinsicHeight();
            } else {
                this.mConstantHeight = -1;
                this.mConstantWidth = -1;
                this.mConstantMinimumHeight = 0;
                this.mConstantMinimumWidth = 0;
            }
            this.mComputedConstantSize = true;
        }

        public Drawable newDrawable() {
            return new MipmapDrawable(this, null, null);
        }

        public Drawable newDrawable(Resources res) {
            return new MipmapDrawable(this, res, null);
        }

        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[] newInts = new int[newSize];
            System.arraycopy(this.mMipmapHeights, 0, newInts, 0, oldSize);
            this.mMipmapHeights = newInts;
        }

        public static /* synthetic */ int[] access$002(MipmapContainerState x0, int[] x1) {
            x0.mMipmapHeights = x1;
            return x1;
        }
    }
}

