/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.shapes.Shape;
import android.util.AttributeSet;
import android.util.Log;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ShapeDrawable
extends Drawable {
    public ShapeState mShapeState;
    public boolean mMutated;

    public ShapeDrawable() {
        this((ShapeState)null);
    }

    public ShapeDrawable(Shape s) {
        this((ShapeState)null);
        this.mShapeState.mShape = s;
    }

    public ShapeDrawable(ShapeState state) {
        this.mShapeState = new ShapeState(state);
    }

    public Shape getShape() {
        return this.mShapeState.mShape;
    }

    public void setShape(Shape s) {
        this.mShapeState.mShape = s;
        this.updateShape();
    }

    public void setShaderFactory(ShaderFactory fact) {
        this.mShapeState.mShaderFactory = fact;
    }

    public ShaderFactory getShaderFactory() {
        return this.mShapeState.mShaderFactory;
    }

    public Paint getPaint() {
        return this.mShapeState.mPaint;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if ((left | top | right | bottom) == 0) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(left, top, right, bottom);
        }
        this.invalidateSelf();
    }

    public void setPadding(Rect padding) {
        if (padding == null) {
            this.mShapeState.mPadding = null;
        } else {
            if (this.mShapeState.mPadding == null) {
                this.mShapeState.mPadding = new Rect();
            }
            this.mShapeState.mPadding.set(padding);
        }
        this.invalidateSelf();
    }

    public void setIntrinsicWidth(int width) {
        this.mShapeState.mIntrinsicWidth = width;
        this.invalidateSelf();
    }

    public void setIntrinsicHeight(int height) {
        this.mShapeState.mIntrinsicHeight = height;
        this.invalidateSelf();
    }

    public int getIntrinsicWidth() {
        return this.mShapeState.mIntrinsicWidth;
    }

    public int getIntrinsicHeight() {
        return this.mShapeState.mIntrinsicHeight;
    }

    public boolean getPadding(Rect padding) {
        if (this.mShapeState.mPadding != null) {
            padding.set(this.mShapeState.mPadding);
            return true;
        }
        return super.getPadding(padding);
    }

    public static int modulateAlpha(int paintAlpha, int alpha) {
        int scale = alpha + (alpha >>> 7);
        return paintAlpha * scale >>> 8;
    }

    public void onDraw(Shape shape, Canvas canvas, Paint paint) {
        shape.draw(canvas, paint);
    }

    public void draw(Canvas canvas) {
        Rect r = this.getBounds();
        Paint paint = this.mShapeState.mPaint;
        int prevAlpha = paint.getAlpha();
        paint.setAlpha(ShapeDrawable.modulateAlpha(prevAlpha, this.mShapeState.mAlpha));
        if (this.mShapeState.mShape != null) {
            int count = canvas.save();
            canvas.translate(r.left, r.top);
            this.onDraw(this.mShapeState.mShape, canvas, paint);
            canvas.restoreToCount(count);
        } else {
            canvas.drawRect(r, paint);
        }
        paint.setAlpha(prevAlpha);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mShapeState.mChangingConfigurations;
    }

    public void setAlpha(int alpha) {
        this.mShapeState.mAlpha = alpha;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter cf) {
        this.mShapeState.mPaint.setColorFilter(cf);
        this.invalidateSelf();
    }

    public int getOpacity() {
        Paint p;
        if (this.mShapeState.mShape == null && (p = this.mShapeState.mPaint).getXfermode() == null) {
            int alpha = p.getAlpha();
            if (alpha == 0) {
                return -2;
            }
            if (alpha == 255) {
                return -1;
            }
        }
        return -3;
    }

    public void setDither(boolean dither) {
        this.mShapeState.mPaint.setDither(dither);
        this.invalidateSelf();
    }

    public void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updateShape();
    }

    public boolean inflateTag(String name, Resources r, XmlPullParser parser, AttributeSet attrs) {
        if ("padding".equals(name)) {
            TypedArray a = r.obtainAttributes(attrs, R.styleable.ShapeDrawablePadding);
            this.setPadding(a.getDimensionPixelOffset(0, 0), a.getDimensionPixelOffset(1, 0), a.getDimensionPixelOffset(2, 0), a.getDimensionPixelOffset(3, 0));
            a.recycle();
            return true;
        }
        return false;
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.ShapeDrawable);
        int color2 = this.mShapeState.mPaint.getColor();
        color2 = a.getColor(3, color2);
        this.mShapeState.mPaint.setColor(color2);
        boolean dither = a.getBoolean(0, false);
        this.mShapeState.mPaint.setDither(dither);
        this.setIntrinsicWidth((int)a.getDimension(2, 0.0f));
        this.setIntrinsicHeight((int)a.getDimension(1, 0.0f));
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            String name;
            if (type != 2 || this.inflateTag(name = parser.getName(), r, parser, attrs)) continue;
            Log.w("drawable", "Unknown element: " + name + " for ShapeDrawable " + this);
        }
    }

    public void updateShape() {
        if (this.mShapeState.mShape != null) {
            Rect r = this.getBounds();
            int w = r.width();
            int h = r.height();
            this.mShapeState.mShape.resize(w, h);
            if (this.mShapeState.mShaderFactory != null) {
                this.mShapeState.mPaint.setShader(this.mShapeState.mShaderFactory.resize(w, h));
            }
        }
        this.invalidateSelf();
    }

    public Drawable.ConstantState getConstantState() {
        this.mShapeState.mChangingConfigurations = this.getChangingConfigurations();
        return this.mShapeState;
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mShapeState.mPaint = new Paint(this.mShapeState.mPaint);
            this.mShapeState.mPadding = new Rect(this.mShapeState.mPadding);
            try {
                this.mShapeState.mShape = this.mShapeState.mShape.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
            this.mMutated = true;
        }
        return this;
    }

    public /* synthetic */ ShapeDrawable(ShapeState x0, 1 x1) {
        this(x0);
    }

    public static class 1 {
    }

    public static abstract class ShaderFactory {
        public abstract Shader resize(int var1, int var2);
    }

    public static class ShapeState
    extends Drawable.ConstantState {
        public int mChangingConfigurations;
        public Paint mPaint;
        public Shape mShape;
        public Rect mPadding;
        public int mIntrinsicWidth;
        public int mIntrinsicHeight;
        public int mAlpha = 255;
        public ShaderFactory mShaderFactory;

        public ShapeState(ShapeState orig) {
            if (orig != null) {
                this.mPaint = orig.mPaint;
                this.mShape = orig.mShape;
                this.mPadding = orig.mPadding;
                this.mIntrinsicWidth = orig.mIntrinsicWidth;
                this.mIntrinsicHeight = orig.mIntrinsicHeight;
                this.mAlpha = orig.mAlpha;
                this.mShaderFactory = orig.mShaderFactory;
            } else {
                this.mPaint = new Paint(1);
            }
        }

        public Drawable newDrawable() {
            return new ShapeDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new ShapeDrawable(this, null);
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }
    }
}

