/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.R;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.Region;
import android.inputmethodservice.AbstractInputMethodService;
import android.inputmethodservice.ExtractEditText;
import android.inputmethodservice.SoftInputWindow;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.Layout;
import android.text.method.MovementMethod;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputBinding;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class InputMethodService
extends AbstractInputMethodService {
    public static final String TAG = "InputMethodService";
    public static final boolean DEBUG = false;
    public static final int BACK_DISPOSITION_DEFAULT = 0;
    public static final int BACK_DISPOSITION_WILL_NOT_DISMISS = 1;
    public static final int BACK_DISPOSITION_WILL_DISMISS = 2;
    public static final int IME_ACTIVE = 1;
    public static final int IME_VISIBLE = 2;
    public InputMethodManager mImm;
    public int mTheme = 0;
    public LayoutInflater mInflater;
    public TypedArray mThemeAttrs;
    public View mRootView;
    public SoftInputWindow mWindow;
    public boolean mInitialized;
    public boolean mWindowCreated;
    public boolean mWindowAdded;
    public boolean mWindowVisible;
    public boolean mWindowWasVisible;
    public boolean mInShowWindow;
    public ViewGroup mFullscreenArea;
    public FrameLayout mExtractFrame;
    public FrameLayout mCandidatesFrame;
    public FrameLayout mInputFrame;
    public IBinder mToken;
    public InputBinding mInputBinding;
    public InputConnection mInputConnection;
    public boolean mInputStarted;
    public boolean mInputViewStarted;
    public boolean mCandidatesViewStarted;
    public InputConnection mStartedInputConnection;
    public EditorInfo mInputEditorInfo;
    public int mShowInputFlags;
    public boolean mShowInputRequested;
    public boolean mLastShowInputRequested;
    public int mCandidatesVisibility;
    public CompletionInfo[] mCurCompletions;
    public boolean mShowInputForced;
    public boolean mFullscreenApplied;
    public boolean mIsFullscreen;
    public View mExtractView;
    public boolean mExtractViewHidden;
    public ExtractEditText mExtractEditText;
    public ViewGroup mExtractAccessories;
    public Button mExtractAction;
    public ExtractedText mExtractedText;
    public int mExtractedToken;
    public View mInputView;
    public boolean mIsInputViewShown;
    public int mStatusIcon;
    public int mBackDisposition;
    public final Insets mTmpInsets = new Insets();
    public final int[] mTmpLocation = new int[2];
    public final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

        public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo info) {
            if (InputMethodService.this.isExtractViewShown()) {
                View decor = InputMethodService.this.getWindow().getWindow().getDecorView();
                info.contentInsets.top = info.visibleInsets.top = decor.getHeight();
                info.touchableRegion.setEmpty();
                info.setTouchableInsets(0);
            } else {
                InputMethodService.this.onComputeInsets(InputMethodService.this.mTmpInsets);
                info.contentInsets.top = InputMethodService.this.mTmpInsets.contentTopInsets;
                info.visibleInsets.top = InputMethodService.this.mTmpInsets.visibleTopInsets;
                info.touchableRegion.set(InputMethodService.this.mTmpInsets.touchableRegion);
                info.setTouchableInsets(InputMethodService.this.mTmpInsets.touchableInsets);
            }
        }
    };
    public final View.OnClickListener mActionClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            EditorInfo ei = InputMethodService.this.getCurrentInputEditorInfo();
            InputConnection ic = InputMethodService.this.getCurrentInputConnection();
            if (ei != null && ic != null) {
                if (ei.actionId != 0) {
                    ic.performEditorAction(ei.actionId);
                } else if ((ei.imeOptions & 0xFF) != 1) {
                    ic.performEditorAction(ei.imeOptions & 0xFF);
                }
            }
        }
    };
    public static final int MOVEMENT_DOWN = -1;
    public static final int MOVEMENT_UP = -2;

    public void setTheme(int theme) {
        if (this.mWindow != null) {
            throw new IllegalStateException("Must be called before onCreate()");
        }
        this.mTheme = theme;
    }

    public void onCreate() {
        this.mTheme = Resources.selectSystemTheme(this.mTheme, this.getApplicationInfo().targetSdkVersion, 16973908, 16973951);
        super.setTheme(this.mTheme);
        super.onCreate();
        this.mImm = (InputMethodManager)this.getSystemService("input_method");
        this.mInflater = (LayoutInflater)this.getSystemService("layout_inflater");
        this.mWindow = new SoftInputWindow((Context)this, this.mTheme, this.mDispatcherState);
        this.initViews();
        this.mWindow.getWindow().setLayout(-1, -2);
    }

    public void onInitializeInterface() {
    }

    public void initialize() {
        if (!this.mInitialized) {
            this.mInitialized = true;
            this.onInitializeInterface();
        }
    }

    public void initViews() {
        this.mInitialized = false;
        this.mWindowCreated = false;
        this.mShowInputRequested = false;
        this.mShowInputForced = false;
        this.mThemeAttrs = this.obtainStyledAttributes(R.styleable.InputMethodService);
        this.mRootView = this.mInflater.inflate(17367101, null);
        this.mWindow.setContentView(this.mRootView);
        this.mRootView.getViewTreeObserver().addOnComputeInternalInsetsListener(this.mInsetsComputer);
        if (Settings.System.getInt(this.getContentResolver(), "fancy_ime_animations", 0) != 0) {
            this.mWindow.getWindow().setWindowAnimations(16974078);
        }
        this.mFullscreenArea = (ViewGroup)this.mRootView.findViewById(16908861);
        this.mExtractViewHidden = false;
        this.mExtractFrame = (FrameLayout)this.mRootView.findViewById(16908316);
        this.mExtractView = null;
        this.mExtractEditText = null;
        this.mExtractAccessories = null;
        this.mExtractAction = null;
        this.mFullscreenApplied = false;
        this.mCandidatesFrame = (FrameLayout)this.mRootView.findViewById(16908317);
        this.mInputFrame = (FrameLayout)this.mRootView.findViewById(16908318);
        this.mInputView = null;
        this.mIsInputViewShown = false;
        this.mExtractFrame.setVisibility(8);
        this.mCandidatesVisibility = this.getCandidatesHiddenVisibility();
        this.mCandidatesFrame.setVisibility(this.mCandidatesVisibility);
        this.mInputFrame.setVisibility(8);
    }

    public void onDestroy() {
        super.onDestroy();
        this.mRootView.getViewTreeObserver().removeOnComputeInternalInsetsListener(this.mInsetsComputer);
        if (this.mWindowAdded) {
            this.mWindow.dismiss();
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        boolean visible = this.mWindowVisible;
        int showFlags = this.mShowInputFlags;
        boolean showingInput = this.mShowInputRequested;
        CompletionInfo[] completions = this.mCurCompletions;
        this.initViews();
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.doStartInput(this.getCurrentInputConnection(), this.getCurrentInputEditorInfo(), true);
        }
        if (visible) {
            boolean showing;
            if (showingInput) {
                if (this.onShowInputRequested(showFlags, true)) {
                    this.showWindow(true);
                    if (completions != null) {
                        this.mCurCompletions = completions;
                        this.onDisplayCompletions(completions);
                    }
                } else {
                    this.hideWindow();
                }
            } else if (this.mCandidatesVisibility == 0) {
                this.showWindow(false);
            } else {
                this.hideWindow();
            }
            this.mImm.setImeWindowStatus(this.mToken, 1 | ((showing = this.onEvaluateInputViewShown()) ? 2 : 0), this.mBackDisposition);
        }
    }

    public AbstractInputMethodService.AbstractInputMethodImpl onCreateInputMethodInterface() {
        return new InputMethodImpl();
    }

    public AbstractInputMethodService.AbstractInputMethodSessionImpl onCreateInputMethodSessionInterface() {
        return new InputMethodSessionImpl();
    }

    public LayoutInflater getLayoutInflater() {
        return this.mInflater;
    }

    public Dialog getWindow() {
        return this.mWindow;
    }

    public void setBackDisposition(int disposition) {
        this.mBackDisposition = disposition;
    }

    public int getBackDisposition() {
        return this.mBackDisposition;
    }

    public int getMaxWidth() {
        WindowManager wm = (WindowManager)this.getSystemService("window");
        return wm.getDefaultDisplay().getWidth();
    }

    public InputBinding getCurrentInputBinding() {
        return this.mInputBinding;
    }

    public InputConnection getCurrentInputConnection() {
        InputConnection ic = this.mStartedInputConnection;
        if (ic != null) {
            return ic;
        }
        return this.mInputConnection;
    }

    public boolean getCurrentInputStarted() {
        return this.mInputStarted;
    }

    public EditorInfo getCurrentInputEditorInfo() {
        return this.mInputEditorInfo;
    }

    public void updateFullscreenMode() {
        boolean changed;
        boolean isFullscreen = this.mShowInputRequested && this.onEvaluateFullscreenMode();
        boolean bl = changed = this.mLastShowInputRequested != this.mShowInputRequested;
        if (this.mIsFullscreen != isFullscreen || !this.mFullscreenApplied) {
            changed = true;
            this.mIsFullscreen = isFullscreen;
            InputConnection ic = this.getCurrentInputConnection();
            if (ic != null) {
                ic.reportFullscreenMode(isFullscreen);
            }
            this.mFullscreenApplied = true;
            this.initialize();
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mFullscreenArea.getLayoutParams();
            if (isFullscreen) {
                this.mFullscreenArea.setBackgroundDrawable(this.mThemeAttrs.getDrawable(0));
                lp.height = 0;
                lp.weight = 1.0f;
            } else {
                this.mFullscreenArea.setBackgroundDrawable(null);
                lp.height = -2;
                lp.weight = 0.0f;
            }
            ((ViewGroup)this.mFullscreenArea.getParent()).updateViewLayout(this.mFullscreenArea, lp);
            if (isFullscreen) {
                View v;
                if (this.mExtractView == null && (v = this.onCreateExtractTextView()) != null) {
                    this.setExtractView(v);
                }
                this.startExtractingText(false);
            }
            this.updateExtractFrameVisibility();
        }
        if (changed) {
            this.onConfigureWindow(this.mWindow.getWindow(), isFullscreen, !this.mShowInputRequested);
            this.mLastShowInputRequested = this.mShowInputRequested;
        }
    }

    public void onConfigureWindow(Window win, boolean isFullscreen, boolean isCandidatesOnly) {
        if (isFullscreen) {
            this.mWindow.getWindow().setLayout(-1, -1);
        } else {
            this.mWindow.getWindow().setLayout(-1, -2);
        }
    }

    public boolean isFullscreenMode() {
        return this.mIsFullscreen;
    }

    public boolean onEvaluateFullscreenMode() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation != 2) {
            return false;
        }
        return this.mInputEditorInfo == null || (this.mInputEditorInfo.imeOptions & 0x2000000) == 0;
    }

    public void setExtractViewShown(boolean shown) {
        if (this.mExtractViewHidden == shown) {
            this.mExtractViewHidden = !shown;
            this.updateExtractFrameVisibility();
        }
    }

    public boolean isExtractViewShown() {
        return this.mIsFullscreen && !this.mExtractViewHidden;
    }

    public void updateExtractFrameVisibility() {
        int animRes;
        int vis;
        if (this.isFullscreenMode()) {
            vis = this.mExtractViewHidden ? 4 : 0;
            this.mExtractFrame.setVisibility(0);
        } else {
            vis = 0;
            this.mExtractFrame.setVisibility(8);
        }
        this.updateCandidatesVisibility(this.mCandidatesVisibility == 0);
        if (this.mWindowWasVisible && this.mFullscreenArea.getVisibility() != vis && (animRes = this.mThemeAttrs.getResourceId(vis == 0 ? 1 : 2, 0)) != 0) {
            this.mFullscreenArea.startAnimation(AnimationUtils.loadAnimation(this, animRes));
        }
        this.mFullscreenArea.setVisibility(vis);
    }

    public void onComputeInsets(Insets outInsets) {
        View decor;
        int[] loc = this.mTmpLocation;
        if (this.mInputFrame.getVisibility() == 0) {
            this.mInputFrame.getLocationInWindow(loc);
        } else {
            decor = this.getWindow().getWindow().getDecorView();
            loc[1] = decor.getHeight();
        }
        if (this.isFullscreenMode()) {
            decor = this.getWindow().getWindow().getDecorView();
            outInsets.contentTopInsets = decor.getHeight();
        } else {
            outInsets.contentTopInsets = loc[1];
        }
        if (this.mCandidatesFrame.getVisibility() == 0) {
            this.mCandidatesFrame.getLocationInWindow(loc);
        }
        outInsets.visibleTopInsets = loc[1];
        outInsets.touchableInsets = 2;
        outInsets.touchableRegion.setEmpty();
    }

    public void updateInputViewShown() {
        boolean isShown;
        boolean bl = isShown = this.mShowInputRequested && this.onEvaluateInputViewShown();
        if (this.mIsInputViewShown != isShown && this.mWindowVisible) {
            this.mIsInputViewShown = isShown;
            this.mInputFrame.setVisibility(isShown ? 0 : 8);
            if (this.mInputView == null) {
                this.initialize();
                View v = this.onCreateInputView();
                if (v != null) {
                    this.setInputView(v);
                }
            }
        }
    }

    public boolean isShowInputRequested() {
        return this.mShowInputRequested;
    }

    public boolean isInputViewShown() {
        return this.mIsInputViewShown && this.mWindowVisible;
    }

    public boolean onEvaluateInputViewShown() {
        Configuration config = this.getResources().getConfiguration();
        return config.keyboard == 1 || config.hardKeyboardHidden == 2;
    }

    public void setCandidatesViewShown(boolean shown) {
        this.updateCandidatesVisibility(shown);
        if (!this.mShowInputRequested && this.mWindowVisible != shown) {
            if (shown) {
                this.showWindow(false);
            } else {
                this.hideWindow();
            }
        }
    }

    public void updateCandidatesVisibility(boolean shown) {
        int vis;
        int n = vis = shown ? 0 : this.getCandidatesHiddenVisibility();
        if (this.mCandidatesVisibility != vis) {
            this.mCandidatesFrame.setVisibility(vis);
            this.mCandidatesVisibility = vis;
        }
    }

    public int getCandidatesHiddenVisibility() {
        return this.isExtractViewShown() ? 8 : 4;
    }

    public void showStatusIcon(int iconResId) {
        this.mStatusIcon = iconResId;
        this.mImm.showStatusIcon(this.mToken, this.getPackageName(), iconResId);
    }

    public void hideStatusIcon() {
        this.mStatusIcon = 0;
        this.mImm.hideStatusIcon(this.mToken);
    }

    public void switchInputMethod(String id2) {
        this.mImm.setInputMethod(this.mToken, id2);
    }

    public void setExtractView(View view) {
        this.mExtractFrame.removeAllViews();
        this.mExtractFrame.addView(view, new FrameLayout.LayoutParams(-1, -1));
        this.mExtractView = view;
        if (view != null) {
            this.mExtractEditText = (ExtractEditText)view.findViewById(16908325);
            this.mExtractEditText.setIME(this);
            this.mExtractAction = (Button)view.findViewById(16908863);
            if (this.mExtractAction != null) {
                this.mExtractAccessories = (ViewGroup)view.findViewById(16908862);
            }
            this.startExtractingText(false);
        } else {
            this.mExtractEditText = null;
            this.mExtractAccessories = null;
            this.mExtractAction = null;
        }
    }

    public void setCandidatesView(View view) {
        this.mCandidatesFrame.removeAllViews();
        this.mCandidatesFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
    }

    public void setInputView(View view) {
        this.mInputFrame.removeAllViews();
        this.mInputFrame.addView(view, new FrameLayout.LayoutParams(-1, -2));
        this.mInputView = view;
    }

    public View onCreateExtractTextView() {
        return this.mInflater.inflate(17367102, null);
    }

    public View onCreateCandidatesView() {
        return null;
    }

    public View onCreateInputView() {
        return null;
    }

    public void onStartInputView(EditorInfo info, boolean restarting) {
    }

    public void onFinishInputView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public void onStartCandidatesView(EditorInfo info, boolean restarting) {
    }

    public void onFinishCandidatesView(boolean finishingInput) {
        InputConnection ic;
        if (!finishingInput && (ic = this.getCurrentInputConnection()) != null) {
            ic.finishComposingText();
        }
    }

    public boolean onShowInputRequested(int flags, boolean configChange) {
        if (!this.onEvaluateInputViewShown()) {
            return false;
        }
        if ((flags & 1) == 0) {
            if (!configChange && this.onEvaluateFullscreenMode()) {
                return false;
            }
            Configuration config = this.getResources().getConfiguration();
            if (config.keyboard != 1) {
                return false;
            }
        }
        if ((flags & 2) != 0) {
            this.mShowInputForced = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showWindow(boolean showInput) {
        if (this.mInShowWindow) {
            Log.w(TAG, "Re-entrance in to showWindow");
            return;
        }
        try {
            this.mWindowWasVisible = this.mWindowVisible;
            this.mInShowWindow = true;
            this.showWindowInner(showInput);
            Object var3_2 = null;
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mWindowWasVisible = true;
            this.mInShowWindow = false;
            throw throwable;
        }
    }

    public void showWindowInner(boolean showInput) {
        boolean doShowInput = false;
        boolean wasVisible = this.mWindowVisible;
        this.mWindowVisible = true;
        if (!this.mShowInputRequested) {
            if (this.mInputStarted && showInput) {
                doShowInput = true;
                this.mShowInputRequested = true;
            }
        } else {
            showInput = true;
        }
        this.initialize();
        this.updateFullscreenMode();
        this.updateInputViewShown();
        if (!this.mWindowAdded || !this.mWindowCreated) {
            this.mWindowAdded = true;
            this.mWindowCreated = true;
            this.initialize();
            View v = this.onCreateCandidatesView();
            if (v != null) {
                this.setCandidatesView(v);
            }
        }
        if (this.mShowInputRequested) {
            if (!this.mInputViewStarted) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, false);
            }
        } else if (!this.mCandidatesViewStarted) {
            this.mCandidatesViewStarted = true;
            this.onStartCandidatesView(this.mInputEditorInfo, false);
        }
        if (doShowInput) {
            this.startExtractingText(false);
        }
        if (!wasVisible) {
            this.mImm.setImeWindowStatus(this.mToken, 1, this.mBackDisposition);
            this.onWindowShown();
            this.mWindow.show();
        }
    }

    public void hideWindow() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(false);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(false);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        this.mImm.setImeWindowStatus(this.mToken, 0, this.mBackDisposition);
        if (this.mWindowVisible) {
            this.mWindow.hide();
            this.mWindowVisible = false;
            this.onWindowHidden();
            this.mWindowWasVisible = false;
        }
    }

    public void onWindowShown() {
    }

    public void onWindowHidden() {
    }

    public void onBindInput() {
    }

    public void onUnbindInput() {
    }

    public void onStartInput(EditorInfo attribute, boolean restarting) {
    }

    public void doFinishInput() {
        if (this.mInputViewStarted) {
            this.onFinishInputView(true);
        } else if (this.mCandidatesViewStarted) {
            this.onFinishCandidatesView(true);
        }
        this.mInputViewStarted = false;
        this.mCandidatesViewStarted = false;
        if (this.mInputStarted) {
            this.onFinishInput();
        }
        this.mInputStarted = false;
        this.mStartedInputConnection = null;
        this.mCurCompletions = null;
    }

    public void doStartInput(InputConnection ic, EditorInfo attribute, boolean restarting) {
        if (!restarting) {
            this.doFinishInput();
        }
        this.mInputStarted = true;
        this.mStartedInputConnection = ic;
        this.mInputEditorInfo = attribute;
        this.initialize();
        this.onStartInput(attribute, restarting);
        if (this.mWindowVisible) {
            if (this.mShowInputRequested) {
                this.mInputViewStarted = true;
                this.onStartInputView(this.mInputEditorInfo, restarting);
                this.startExtractingText(true);
            } else if (this.mCandidatesVisibility == 0) {
                this.mCandidatesViewStarted = true;
                this.onStartCandidatesView(this.mInputEditorInfo, restarting);
            }
        }
    }

    public void onFinishInput() {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.finishComposingText();
        }
    }

    public void onDisplayCompletions(CompletionInfo[] completions) {
    }

    public void onUpdateExtractedText(int token, ExtractedText text) {
        if (this.mExtractedToken != token) {
            return;
        }
        if (text != null && this.mExtractEditText != null) {
            this.mExtractedText = text;
            this.mExtractEditText.setExtractedText(text);
        }
    }

    public void onUpdateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.isFullscreenMode() && this.mExtractedText != null) {
            int off = this.mExtractedText.startOffset;
            eet.startInternalChanges();
            newSelEnd -= off;
            int len = eet.getText().length();
            if ((newSelStart -= off) < 0) {
                newSelStart = 0;
            } else if (newSelStart > len) {
                newSelStart = len;
            }
            if (newSelEnd < 0) {
                newSelEnd = 0;
            } else if (newSelEnd > len) {
                newSelEnd = len;
            }
            eet.setSelection(newSelStart, newSelEnd);
            eet.finishInternalChanges();
        }
    }

    public void onUpdateCursor(Rect newCursor) {
    }

    public void requestHideSelf(int flags) {
        this.mImm.hideSoftInputFromInputMethod(this.mToken, flags);
    }

    public void requestShowSelf(int flags) {
        this.mImm.showSoftInputFromInputMethod(this.mToken, flags);
    }

    public boolean handleBack(boolean doIt) {
        if (this.mShowInputRequested) {
            if (doIt) {
                this.requestHideSelf(0);
            }
            return true;
        }
        if (this.mWindowVisible) {
            if (this.mCandidatesVisibility == 0) {
                if (doIt) {
                    this.setCandidatesViewShown(false);
                }
            } else if (doIt) {
                this.hideWindow();
            }
            return true;
        }
        return false;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4) {
            if (this.handleBack(false)) {
                event.startTracking();
                return true;
            }
            return false;
        }
        return this.doMovementKey(keyCode, event, -1);
    }

    public boolean onKeyLongPress(int keyCode, KeyEvent event) {
        return false;
    }

    public boolean onKeyMultiple(int keyCode, int count, KeyEvent event) {
        return this.doMovementKey(keyCode, event, count);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (event.getKeyCode() == 4 && event.isTracking() && !event.isCanceled()) {
            return this.handleBack(true);
        }
        return this.doMovementKey(keyCode, event, -2);
    }

    public boolean onTrackballEvent(MotionEvent event) {
        return false;
    }

    public void onAppPrivateCommand(String action, Bundle data) {
    }

    public void onToggleSoftInput(int showFlags, int hideFlags) {
        if (this.isInputViewShown()) {
            this.requestHideSelf(hideFlags);
        } else {
            this.requestShowSelf(showFlags);
        }
    }

    public void reportExtractedMovement(int keyCode, int count) {
        int dx = 0;
        int dy = 0;
        switch (keyCode) {
            case 21: {
                dx = -count;
                break;
            }
            case 22: {
                dx = count;
                break;
            }
            case 19: {
                dy = -count;
                break;
            }
            case 20: {
                dy = count;
            }
        }
        this.onExtractedCursorMovement(dx, dy);
    }

    public boolean doMovementKey(int keyCode, KeyEvent event, int count) {
        ExtractEditText eet = this.mExtractEditText;
        if (this.isExtractViewShown() && this.isInputViewShown() && eet != null) {
            MovementMethod movement = eet.getMovementMethod();
            Layout layout2 = eet.getLayout();
            if (movement != null && layout2 != null) {
                if (count == -1) {
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, event)) {
                        this.reportExtractedMovement(keyCode, 1);
                        return true;
                    }
                } else if (count == -2) {
                    if (movement.onKeyUp(eet, eet.getText(), keyCode, event)) {
                        return true;
                    }
                } else if (movement.onKeyOther(eet, eet.getText(), event)) {
                    this.reportExtractedMovement(keyCode, count);
                } else {
                    KeyEvent down = KeyEvent.changeAction(event, 0);
                    if (movement.onKeyDown(eet, eet.getText(), keyCode, down)) {
                        KeyEvent up = KeyEvent.changeAction(event, 1);
                        movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        while (--count > 0) {
                            movement.onKeyDown(eet, eet.getText(), keyCode, down);
                            movement.onKeyUp(eet, eet.getText(), keyCode, up);
                        }
                        this.reportExtractedMovement(keyCode, count);
                    }
                }
            }
            switch (keyCode) {
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    return true;
                }
            }
        }
        return false;
    }

    public void sendDownUpKeyEvents(int keyEventCode) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic == null) {
            return;
        }
        long eventTime = SystemClock.uptimeMillis();
        ic.sendKeyEvent(new KeyEvent(eventTime, eventTime, 0, keyEventCode, 0, 0, -1, 0, 6));
        ic.sendKeyEvent(new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, keyEventCode, 0, 0, -1, 0, 6));
    }

    public boolean sendDefaultEditorAction(boolean fromEnterKey) {
        EditorInfo ei = this.getCurrentInputEditorInfo();
        if (!(ei == null || fromEnterKey && (ei.imeOptions & 0x40000000) != 0 || (ei.imeOptions & 0xFF) == 1)) {
            InputConnection ic = this.getCurrentInputConnection();
            if (ic != null) {
                ic.performEditorAction(ei.imeOptions & 0xFF);
            }
            return true;
        }
        return false;
    }

    public void sendKeyChar(char charCode) {
        switch (charCode) {
            case '\n': {
                if (this.sendDefaultEditorAction(true)) break;
                this.sendDownUpKeyEvents(66);
                break;
            }
            default: {
                if (charCode >= '0' && charCode <= '9') {
                    this.sendDownUpKeyEvents(charCode - 48 + 7);
                    break;
                }
                InputConnection ic = this.getCurrentInputConnection();
                if (ic == null) break;
                ic.commitText(String.valueOf(charCode), 1);
            }
        }
    }

    public void onExtractedSelectionChanged(int start, int end) {
        InputConnection conn = this.getCurrentInputConnection();
        if (conn != null) {
            conn.setSelection(start, end);
        }
    }

    public void onExtractedTextClicked() {
        if (this.mExtractEditText == null) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public void onExtractedCursorMovement(int dx, int dy) {
        if (this.mExtractEditText == null || dy == 0) {
            return;
        }
        if (this.mExtractEditText.hasVerticalScrollBar()) {
            this.setCandidatesViewShown(false);
        }
    }

    public boolean onExtractTextContextMenuItem(int id2) {
        InputConnection ic = this.getCurrentInputConnection();
        if (ic != null) {
            ic.performContextMenuAction(id2);
        }
        return true;
    }

    public CharSequence getTextForImeAction(int imeOptions) {
        switch (imeOptions & 0xFF) {
            case 1: {
                return null;
            }
            case 2: {
                return this.getText(17040294);
            }
            case 3: {
                return this.getText(17040295);
            }
            case 4: {
                return this.getText(17040296);
            }
            case 5: {
                return this.getText(17040297);
            }
            case 6: {
                return this.getText(17040298);
            }
            case 7: {
                return this.getText(17040299);
            }
        }
        return this.getText(17040300);
    }

    public void onUpdateExtractingVisibility(EditorInfo ei) {
        if (ei.inputType == 0 || (ei.imeOptions & 0x10000000) != 0) {
            this.setExtractViewShown(false);
            return;
        }
        this.setExtractViewShown(true);
    }

    public void onUpdateExtractingViews(EditorInfo ei) {
        boolean hasAction;
        if (!this.isExtractViewShown()) {
            return;
        }
        if (this.mExtractAccessories == null) {
            return;
        }
        boolean bl = hasAction = ei.actionLabel != null || (ei.imeOptions & 0xFF) != 1 && (ei.imeOptions & 0x20000000) == 0 && ei.inputType != 0;
        if (hasAction) {
            this.mExtractAccessories.setVisibility(0);
            if (this.mExtractAction != null) {
                if (ei.actionLabel != null) {
                    this.mExtractAction.setText(ei.actionLabel);
                } else {
                    this.mExtractAction.setText(this.getTextForImeAction(ei.imeOptions));
                }
                this.mExtractAction.setOnClickListener(this.mActionClickListener);
            }
        } else {
            this.mExtractAccessories.setVisibility(8);
            if (this.mExtractAction != null) {
                this.mExtractAction.setOnClickListener(null);
            }
        }
    }

    public void onExtractingInputChanged(EditorInfo ei) {
        if (ei.inputType == 0) {
            this.requestHideSelf(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startExtractingText(boolean inputChanged) {
        ExtractEditText eet = this.mExtractEditText;
        if (eet != null && this.getCurrentInputStarted() && this.isFullscreenMode()) {
            ++this.mExtractedToken;
            ExtractedTextRequest req = new ExtractedTextRequest();
            req.token = this.mExtractedToken;
            req.flags = 1;
            req.hintMaxLines = 10;
            req.hintMaxChars = 10000;
            InputConnection ic = this.getCurrentInputConnection();
            ExtractedText extractedText = this.mExtractedText = ic == null ? null : ic.getExtractedText(req, 1);
            if (this.mExtractedText == null || ic == null) {
                Log.e(TAG, "Unexpected null in startExtractingText : mExtractedText = " + this.mExtractedText + ", input connection = " + ic);
            }
            EditorInfo ei = this.getCurrentInputEditorInfo();
            try {
                eet.startInternalChanges();
                this.onUpdateExtractingVisibility(ei);
                this.onUpdateExtractingViews(ei);
                int inputType = ei.inputType;
                if ((inputType & 0xF) == 1 && (inputType & 0x40000) != 0) {
                    inputType |= 0x20000;
                }
                eet.setInputType(inputType);
                eet.setHint(ei.hintText);
                if (this.mExtractedText != null) {
                    eet.setEnabled(true);
                    eet.setExtractedText(this.mExtractedText);
                } else {
                    eet.setEnabled(false);
                    eet.setText("");
                }
                Object var8_7 = null;
                eet.finishInternalChanges();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                eet.finishInternalChanges();
                throw throwable;
            }
            if (inputChanged) {
                this.onExtractingInputChanged(ei);
            }
        }
    }

    public void onCurrentInputMethodSubtypeChanged(InputMethodSubtype newSubtype) {
    }

    public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        PrintWriterPrinter p = new PrintWriterPrinter(fout);
        p.println("Input method service state for " + this + ":");
        p.println("  mWindowCreated=" + this.mWindowCreated + " mWindowAdded=" + this.mWindowAdded);
        p.println("  mWindowVisible=" + this.mWindowVisible + " mWindowWasVisible=" + this.mWindowWasVisible + " mInShowWindow=" + this.mInShowWindow);
        p.println("  Configuration=" + this.getResources().getConfiguration());
        p.println("  mToken=" + this.mToken);
        p.println("  mInputBinding=" + this.mInputBinding);
        p.println("  mInputConnection=" + this.mInputConnection);
        p.println("  mStartedInputConnection=" + this.mStartedInputConnection);
        p.println("  mInputStarted=" + this.mInputStarted + " mInputViewStarted=" + this.mInputViewStarted + " mCandidatesViewStarted=" + this.mCandidatesViewStarted);
        if (this.mInputEditorInfo != null) {
            p.println("  mInputEditorInfo:");
            this.mInputEditorInfo.dump(p, "    ");
        } else {
            p.println("  mInputEditorInfo: null");
        }
        p.println("  mShowInputRequested=" + this.mShowInputRequested + " mLastShowInputRequested=" + this.mLastShowInputRequested + " mShowInputForced=" + this.mShowInputForced + " mShowInputFlags=0x" + Integer.toHexString(this.mShowInputFlags));
        p.println("  mCandidatesVisibility=" + this.mCandidatesVisibility + " mFullscreenApplied=" + this.mFullscreenApplied + " mIsFullscreen=" + this.mIsFullscreen + " mExtractViewHidden=" + this.mExtractViewHidden);
        if (this.mExtractedText != null) {
            p.println("  mExtractedText:");
            p.println("    text=" + this.mExtractedText.text.length() + " chars" + " startOffset=" + this.mExtractedText.startOffset);
            p.println("    selectionStart=" + this.mExtractedText.selectionStart + " selectionEnd=" + this.mExtractedText.selectionEnd + " flags=0x" + Integer.toHexString(this.mExtractedText.flags));
        } else {
            p.println("  mExtractedText: null");
        }
        p.println("  mExtractedToken=" + this.mExtractedToken);
        p.println("  mIsInputViewShown=" + this.mIsInputViewShown + " mStatusIcon=" + this.mStatusIcon);
        p.println("Last computed insets:");
        p.println("  contentTopInsets=" + this.mTmpInsets.contentTopInsets + " visibleTopInsets=" + this.mTmpInsets.visibleTopInsets + " touchableInsets=" + this.mTmpInsets.touchableInsets + " touchableRegion=" + this.mTmpInsets.touchableRegion);
    }

    public static class Insets {
        public int contentTopInsets;
        public int visibleTopInsets;
        public final Region touchableRegion = new Region();
        public static final int TOUCHABLE_INSETS_FRAME = 0;
        public static final int TOUCHABLE_INSETS_CONTENT = 1;
        public static final int TOUCHABLE_INSETS_VISIBLE = 2;
        public static final int TOUCHABLE_INSETS_REGION = 3;
        public int touchableInsets;
    }

    public class InputMethodSessionImpl
    extends AbstractInputMethodService.AbstractInputMethodSessionImpl {
        public void finishInput() {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.doFinishInput();
        }

        public void displayCompletions(CompletionInfo[] completions) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.mCurCompletions = completions;
            InputMethodService.this.onDisplayCompletions(completions);
        }

        public void updateExtractedText(int token, ExtractedText text) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateExtractedText(token, text);
        }

        public void updateSelection(int oldSelStart, int oldSelEnd, int newSelStart, int newSelEnd, int candidatesStart, int candidatesEnd) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateSelection(oldSelStart, oldSelEnd, newSelStart, newSelEnd, candidatesStart, candidatesEnd);
        }

        public void updateCursor(Rect newCursor) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onUpdateCursor(newCursor);
        }

        public void appPrivateCommand(String action, Bundle data) {
            if (!this.isEnabled()) {
                return;
            }
            InputMethodService.this.onAppPrivateCommand(action, data);
        }

        public void toggleSoftInput(int showFlags, int hideFlags) {
            InputMethodService.this.onToggleSoftInput(showFlags, hideFlags);
        }
    }

    public class InputMethodImpl
    extends AbstractInputMethodService.AbstractInputMethodImpl {
        public void attachToken(IBinder token) {
            if (InputMethodService.this.mToken == null) {
                InputMethodService.this.mToken = token;
                InputMethodService.this.mWindow.setToken(token);
            }
        }

        public void bindInput(InputBinding binding) {
            InputMethodService.this.mInputBinding = binding;
            InputMethodService.this.mInputConnection = binding.getConnection();
            InputConnection ic = InputMethodService.this.getCurrentInputConnection();
            if (ic != null) {
                ic.reportFullscreenMode(InputMethodService.this.mIsFullscreen);
            }
            InputMethodService.this.initialize();
            InputMethodService.this.onBindInput();
        }

        public void unbindInput() {
            InputMethodService.this.onUnbindInput();
            InputMethodService.this.mInputStarted = false;
            InputMethodService.this.mInputBinding = null;
            InputMethodService.this.mInputConnection = null;
        }

        public void startInput(InputConnection ic, EditorInfo attribute) {
            InputMethodService.this.doStartInput(ic, attribute, false);
        }

        public void restartInput(InputConnection ic, EditorInfo attribute) {
            InputMethodService.this.doStartInput(ic, attribute, true);
        }

        public void hideSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            InputMethodService.this.mShowInputRequested = false;
            InputMethodService.this.mShowInputForced = false;
            InputMethodService.this.hideWindow();
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != InputMethodService.this.isInputViewShown() ? 3 : (wasVis ? 0 : 1), null);
            }
        }

        public void showSoftInput(int flags, ResultReceiver resultReceiver) {
            boolean wasVis = InputMethodService.this.isInputViewShown();
            InputMethodService.this.mShowInputFlags = 0;
            if (InputMethodService.this.onShowInputRequested(flags, false)) {
                InputMethodService.this.showWindow(true);
            }
            boolean showing = InputMethodService.this.onEvaluateInputViewShown();
            InputMethodService.this.mImm.setImeWindowStatus(InputMethodService.this.mToken, 1 | (showing ? 2 : 0), InputMethodService.this.mBackDisposition);
            if (resultReceiver != null) {
                resultReceiver.send(wasVis != InputMethodService.this.isInputViewShown() ? 2 : (wasVis ? 0 : 1), null);
            }
        }

        public void changeInputMethodSubtype(InputMethodSubtype subtype) {
            InputMethodService.this.onCurrentInputMethodSubtypeChanged(subtype);
        }
    }
}

