/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.DhcpInfoInternal;
import android.util.Log;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class NetworkUtils {
    public static final String TAG = "NetworkUtils";

    public static int enableInterface(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#enableInterface(Ljava/lang/String;)I", true, null);
    }

    public static int disableInterface(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#disableInterface(Ljava/lang/String;)I", true, null);
    }

    public static int addRoute(String string2, String string3, int n, String string4) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#addRoute(Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;)I", true, null);
    }

    public static InetAddress getDefaultRoute(String interfaceName) {
        int addr = NetworkUtils.getDefaultRouteNative(interfaceName);
        return NetworkUtils.intToInetAddress(addr);
    }

    public static int getDefaultRouteNative(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#getDefaultRouteNative(Ljava/lang/String;)I", true, null);
    }

    public static int removeHostRoutes(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#removeHostRoutes(Ljava/lang/String;)I", true, null);
    }

    public static int removeDefaultRoute(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#removeDefaultRoute(Ljava/lang/String;)I", true, null);
    }

    public static int resetConnections(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#resetConnections(Ljava/lang/String;)I", true, null);
    }

    public static boolean runDhcp(String string2, DhcpInfoInternal dhcpInfoInternal) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#runDhcp(Ljava/lang/String;Landroid/net/DhcpInfoInternal;)Z", true, null) != 0;
    }

    public static boolean stopDhcp(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#stopDhcp(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static boolean releaseDhcpLease(String string2) {
        return OverrideMethod.invokeI("android.net.NetworkUtils#releaseDhcpLease(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static String getDhcpError() {
        return (String)OverrideMethod.invokeA("android.net.NetworkUtils#getDhcpError()Ljava/lang/String;", true, null);
    }

    public static InetAddress intToInetAddress(int hostAddress) {
        byte[] addressBytes = new byte[]{(byte)(0xFF & hostAddress), (byte)(0xFF & hostAddress >> 8), (byte)(0xFF & hostAddress >> 16), (byte)(0xFF & hostAddress >> 24)};
        try {
            return InetAddress.getByAddress(addressBytes);
        }
        catch (UnknownHostException e) {
            throw new AssertionError();
        }
    }

    public static int inetAddressToInt(InetAddress inetAddr) throws IllegalArgumentException {
        byte[] addr = inetAddr.getAddress();
        if (addr.length != 4) {
            throw new IllegalArgumentException("Not an IPv4 address");
        }
        return (addr[3] & 0xFF) << 24 | (addr[2] & 0xFF) << 16 | (addr[1] & 0xFF) << 8 | addr[0] & 0xFF;
    }

    public static int prefixLengthToNetmaskInt(int prefixLength) throws IllegalArgumentException {
        if (prefixLength < 0 || prefixLength > 32) {
            throw new IllegalArgumentException("Invalid prefix length (0 <= prefix <= 32)");
        }
        int value = -1 << 32 - prefixLength;
        return Integer.reverseBytes(value);
    }

    public static InetAddress numericToInetAddress(String addrString) throws IllegalArgumentException {
        return InetAddress.parseNumericAddress((String)addrString);
    }

    public static boolean addDefaultRoute(String interfaceName, InetAddress gw) {
        String dstStr;
        String gwStr = gw.getHostAddress();
        if (gw instanceof Inet4Address) {
            dstStr = "0.0.0.0";
        } else if (gw instanceof Inet6Address) {
            dstStr = "::";
        } else {
            Log.w(TAG, "addDefaultRoute failure: address is neither IPv4 nor IPv6(" + gwStr + ")");
            return false;
        }
        return NetworkUtils.addRoute(interfaceName, dstStr, 0, gwStr) == 0;
    }

    public static boolean addHostRoute(String interfaceName, InetAddress dst, InetAddress gw) {
        int prefixLength;
        String gwStr;
        if (dst == null) {
            Log.w(TAG, "addHostRoute: dst should not be null");
            return false;
        }
        String dstStr = dst.getHostAddress();
        String string2 = gwStr = gw != null ? gw.getHostAddress() : null;
        if (dst instanceof Inet4Address) {
            prefixLength = 32;
        } else if (dst instanceof Inet6Address) {
            prefixLength = 128;
        } else {
            Log.w(TAG, "addHostRoute failure: address is neither IPv4 nor IPv6(" + dst + ")");
            return false;
        }
        return NetworkUtils.addRoute(interfaceName, dstStr, prefixLength, gwStr) == 0;
    }
}

