/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.StrictMode;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class Binder
implements IBinder {
    public static final boolean FIND_POTENTIAL_LEAKS = false;
    public static final String TAG = "Binder";
    public int mObject;
    public IInterface mOwner;
    public String mDescriptor;

    public static int getCallingPid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingPid()I", true, null);
    }

    public static int getCallingUid() {
        return OverrideMethod.invokeI("android.os.Binder#getCallingUid()I", true, null);
    }

    public static long clearCallingIdentity() {
        return OverrideMethod.invokeL("android.os.Binder#clearCallingIdentity()J", true, null);
    }

    public static void restoreCallingIdentity(long l) {
        OverrideMethod.invokeV("android.os.Binder#restoreCallingIdentity(J)V", true, null);
    }

    public static void setThreadStrictModePolicy(int n) {
        OverrideMethod.invokeV("android.os.Binder#setThreadStrictModePolicy(I)V", true, null);
    }

    public static int getThreadStrictModePolicy() {
        return OverrideMethod.invokeI("android.os.Binder#getThreadStrictModePolicy()I", true, null);
    }

    public static void flushPendingCommands() {
        OverrideMethod.invokeV("android.os.Binder#flushPendingCommands()V", true, null);
    }

    public static void joinThreadPool() {
        OverrideMethod.invokeV("android.os.Binder#joinThreadPool()V", true, null);
    }

    public Binder() {
        this.init();
    }

    public void attachInterface(IInterface owner, String descriptor) {
        this.mOwner = owner;
        this.mDescriptor = descriptor;
    }

    public String getInterfaceDescriptor() {
        return this.mDescriptor;
    }

    public boolean pingBinder() {
        return true;
    }

    public boolean isBinderAlive() {
        return true;
    }

    public IInterface queryLocalInterface(String descriptor) {
        if (this.mDescriptor.equals(descriptor)) {
            return this.mOwner;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1598968902) {
            reply.writeString(this.getInterfaceDescriptor());
            return true;
        }
        if (code == 1598311760) {
            ParcelFileDescriptor fd = data.readFileDescriptor();
            String[] args = data.readStringArray();
            if (fd != null) {
                try {
                    this.dump(fd.getFileDescriptor(), args);
                }
                finally {
                    try {
                        fd.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (reply != null) {
                reply.writeNoException();
            } else {
                StrictMode.clearGatheredViolations();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, String[] args) {
        FileOutputStream fout = new FileOutputStream(fd);
        PrintWriter pw = new PrintWriter(fout);
        try {
            this.dump(fd, pw, args);
        }
        finally {
            pw.flush();
        }
    }

    public void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
    }

    public boolean transact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (data != null) {
            data.setDataPosition(0);
        }
        boolean r = this.onTransact(code, data, reply, flags);
        if (reply != null) {
            reply.setDataPosition(0);
        }
        return r;
    }

    public void linkToDeath(IBinder.DeathRecipient recipient, int flags) {
    }

    public boolean unlinkToDeath(IBinder.DeathRecipient recipient, int flags) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    public void init() {
        OverrideMethod.invokeV("android.os.Binder#init()V", true, this);
    }

    public void destroy() {
        OverrideMethod.invokeV("android.os.Binder#destroy()V", true, this);
    }

    public boolean execTransact(int code, int dataObj, int replyObj, int flags) {
        boolean res;
        Parcel data = Parcel.obtain(dataObj);
        Parcel reply = Parcel.obtain(replyObj);
        try {
            res = this.onTransact(code, data, reply, flags);
        }
        catch (RemoteException e) {
            reply.writeException(e);
            res = true;
        }
        catch (RuntimeException e) {
            reply.writeException(e);
            res = true;
        }
        catch (OutOfMemoryError e) {
            RuntimeException re = new RuntimeException("Out of memory", e);
            reply.writeException(re);
            res = true;
        }
        reply.recycle();
        data.recycle();
        return res;
    }
}

