/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import com.android.internal.os.IDropBoxManagerService;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class DropBoxManager {
    public static final String TAG = "DropBoxManager";
    public final IDropBoxManagerService mService;
    public static final int IS_EMPTY = 1;
    public static final int IS_TEXT = 2;
    public static final int IS_GZIPPED = 4;
    public static final int HAS_BYTE_ARRAY = 8;
    public static final String ACTION_DROPBOX_ENTRY_ADDED = "android.intent.action.DROPBOX_ENTRY_ADDED";
    public static final String EXTRA_TAG = "tag";
    public static final String EXTRA_TIME = "time";

    public DropBoxManager(IDropBoxManagerService service) {
        this.mService = service;
    }

    public DropBoxManager() {
        this.mService = null;
    }

    public void addText(String tag, String data) {
        try {
            this.mService.add(new Entry(tag, 0L, data));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void addData(String tag, byte[] data, int flags) {
        if (data == null) {
            throw new NullPointerException("data == null");
        }
        try {
            this.mService.add(new Entry(tag, 0L, data, flags));
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(String tag, File file, int flags) throws IOException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        Entry entry = new Entry(tag, 0L, file, flags);
        try {
            this.mService.add(entry);
        }
        catch (RemoteException e) {
        }
        finally {
            entry.close();
        }
    }

    public boolean isTagEnabled(String tag) {
        try {
            return this.mService.isTagEnabled(tag);
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Entry getNextEntry(String tag, long msec) {
        try {
            return this.mService.getNextEntry(tag, msec);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    public static class Entry
    implements Parcelable,
    Closeable {
        public final String mTag;
        public final long mTimeMillis;
        public final byte[] mData;
        public final ParcelFileDescriptor mFileDescriptor;
        public final int mFlags;
        public static final Parcelable.Creator<Entry> CREATOR = new Parcelable.Creator(){

            public Entry[] newArray(int size) {
                return new Entry[size];
            }

            public Entry createFromParcel(Parcel in) {
                String tag = in.readString();
                long millis = in.readLong();
                int flags = in.readInt();
                if ((flags & 8) != 0) {
                    return new Entry(tag, millis, in.createByteArray(), flags & 0xFFFFFFF7);
                }
                return new Entry(tag, millis, in.readFileDescriptor(), flags);
            }
        };

        public Entry(String tag, long millis) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = null;
            this.mFlags = 1;
        }

        public Entry(String tag, long millis, String text) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if (text == null) {
                throw new NullPointerException("text == null");
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = text.getBytes();
            this.mFileDescriptor = null;
            this.mFlags = 2;
        }

        public Entry(String tag, long millis, byte[] data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = data;
            this.mFileDescriptor = null;
            this.mFlags = flags;
        }

        public Entry(String tag, long millis, ParcelFileDescriptor data, int flags) {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0 != (data == null)) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = data;
            this.mFlags = flags;
        }

        public Entry(String tag, long millis, File data, int flags) throws IOException {
            if (tag == null) {
                throw new NullPointerException("tag == null");
            }
            if ((flags & 1) != 0) {
                throw new IllegalArgumentException("Bad flags: " + flags);
            }
            this.mTag = tag;
            this.mTimeMillis = millis;
            this.mData = null;
            this.mFileDescriptor = ParcelFileDescriptor.open(data, 0x10000000);
            this.mFlags = flags;
        }

        public void close() {
            try {
                if (this.mFileDescriptor != null) {
                    this.mFileDescriptor.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String getTag() {
            return this.mTag;
        }

        public long getTimeMillis() {
            return this.mTimeMillis;
        }

        public int getFlags() {
            return this.mFlags & 0xFFFFFFFB;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getText(int maxBytes) {
            String string2;
            if ((this.mFlags & 2) == 0) {
                return null;
            }
            if (this.mData != null) {
                return new String(this.mData, 0, Math.min(maxBytes, this.mData.length));
            }
            InputStream is = null;
            try {
                is = this.getInputStream();
                if (is == null) {
                    String string3 = null;
                    return string3;
                }
                byte[] buf = new byte[maxBytes];
                int readBytes = 0;
                int n = 0;
                while (n >= 0 && (readBytes += n) < maxBytes) {
                    n = is.read(buf, readBytes, maxBytes - readBytes);
                }
                string2 = new String(buf, 0, readBytes);
            }
            catch (IOException e) {
                String string4 = null;
                return string4;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            return string2;
        }

        public InputStream getInputStream() throws IOException {
            InputStream is;
            if (this.mData != null) {
                is = new ByteArrayInputStream(this.mData);
            } else if (this.mFileDescriptor != null) {
                is = new ParcelFileDescriptor.AutoCloseInputStream(this.mFileDescriptor);
            } else {
                return null;
            }
            return (this.mFlags & 4) != 0 ? new GZIPInputStream(is) : is;
        }

        public int describeContents() {
            return this.mFileDescriptor != null ? 1 : 0;
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeString(this.mTag);
            out.writeLong(this.mTimeMillis);
            if (this.mFileDescriptor != null) {
                out.writeInt(this.mFlags & 0xFFFFFFF7);
                this.mFileDescriptor.writeToParcel(out, flags);
            } else {
                out.writeInt(this.mFlags | 8);
                out.writeByteArray(this.mData);
            }
        }
    }
}

