/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.animation.ValueAnimator;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.IActivityManager;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.NetworkOnMainThreadException;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import android.util.Printer;
import android.util.Singleton;
import android.view.IWindowManager;
import com.android.internal.os.RuntimeInit;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import dalvik.system.VMDebug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class StrictMode {
    public static final String TAG = "StrictMode";
    public static final boolean LOG_V = Log.isLoggable("StrictMode", 2);
    public static final boolean IS_USER_BUILD = "user".equals(Build.TYPE);
    public static final boolean IS_ENG_BUILD = "eng".equals(Build.TYPE);
    public static final String VISUAL_PROPERTY = "persist.sys.strictmode.visual";
    public static final long MIN_LOG_INTERVAL_MS = 1000L;
    public static final long MIN_DIALOG_INTERVAL_MS = 30000L;
    public static final int MAX_SPAN_TAGS = 20;
    public static final int MAX_OFFENSES_PER_LOOP = 10;
    public static final int DETECT_DISK_WRITE = 1;
    public static final int DETECT_DISK_READ = 2;
    public static final int DETECT_NETWORK = 4;
    public static final int DETECT_CUSTOM = 8;
    public static final int ALL_THREAD_DETECT_BITS = 15;
    public static final int DETECT_VM_CURSOR_LEAKS = 512;
    public static final int DETECT_VM_CLOSABLE_LEAKS = 1024;
    public static final int DETECT_VM_ACTIVITY_LEAKS = 2048;
    public static final int DETECT_VM_INSTANCE_LEAKS = 4096;
    public static final int ALL_VM_DETECT_BITS = 7680;
    public static final int PENALTY_LOG = 16;
    public static final int PENALTY_DIALOG = 32;
    public static final int PENALTY_DEATH = 64;
    public static final int PENALTY_DEATH_ON_NETWORK = 512;
    public static final int PENALTY_FLASH = 2048;
    public static final int PENALTY_DROPBOX = 128;
    public static final int PENALTY_GATHER = 256;
    public static final int THREAD_PENALTY_MASK = 3056;
    public static final int VM_PENALTY_MASK = 208;
    public static final HashMap<Class, Integer> EMPTY_CLASS_LIMIT_MAP = new HashMap();
    public static volatile int sVmPolicyMask = 0;
    public static volatile VmPolicy sVmPolicy = VmPolicy.LAX;
    public static final AtomicInteger sDropboxCallsInFlight = new AtomicInteger(0);
    public static final ThreadLocal<ArrayList<ViolationInfo>> gatheredViolations = new ThreadLocal<ArrayList<ViolationInfo>>(){

        @Override
        public ArrayList<ViolationInfo> initialValue() {
            return null;
        }
    };
    public static final ThreadLocal<ArrayList<ViolationInfo>> violationsBeingTimed = new ThreadLocal<ArrayList<ViolationInfo>>(){

        @Override
        public ArrayList<ViolationInfo> initialValue() {
            return new ArrayList<ViolationInfo>();
        }
    };
    public static final ThreadLocal<Handler> threadHandler = new ThreadLocal<Handler>(){

        @Override
        public Handler initialValue() {
            return new Handler();
        }
    };
    public static long sLastInstanceCountCheckMillis = 0L;
    public static boolean sIsIdlerRegistered = false;
    public static final MessageQueue.IdleHandler sProcessIdleHandler = new MessageQueue.IdleHandler(){

        public boolean queueIdle() {
            long now = SystemClock.uptimeMillis();
            if (now - sLastInstanceCountCheckMillis > 30000L) {
                sLastInstanceCountCheckMillis = now;
                StrictMode.conditionallyCheckInstanceCounts();
            }
            return true;
        }
    };
    public static final HashMap<Integer, Long> sLastVmViolationTime = new HashMap();
    public static final Span NO_OP_SPAN = new Span(){

        public void finish() {
        }
    };
    public static final ThreadLocal<ThreadSpanState> sThisThreadSpanState = new ThreadLocal<ThreadSpanState>(){

        @Override
        public ThreadSpanState initialValue() {
            return new ThreadSpanState(null);
        }
    };
    public static Singleton<IWindowManager> sWindowManager = new Singleton<IWindowManager>(){

        @Override
        public IWindowManager create() {
            return IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        }
    };
    public static final HashMap<Class, Integer> sExpectedActivityInstanceCount = new HashMap();

    public static void setThreadPolicy(ThreadPolicy policy) {
        StrictMode.setThreadPolicyMask(policy.mask);
    }

    public static void setThreadPolicyMask(int policyMask) {
        StrictMode.setBlockGuardPolicy(policyMask);
        Binder.setThreadStrictModePolicy(policyMask);
    }

    public static void setBlockGuardPolicy(int policyMask) {
        if (policyMask == 0) {
            BlockGuard.setThreadPolicy(BlockGuard.LAX_POLICY);
            return;
        }
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            BlockGuard.setThreadPolicy(new AndroidBlockGuardPolicy(policyMask));
        } else {
            AndroidBlockGuardPolicy androidPolicy = (AndroidBlockGuardPolicy)policy;
            androidPolicy.setPolicyMask(policyMask);
        }
    }

    public static void setCloseGuardEnabled(boolean enabled) {
        if (!(CloseGuard.getReporter() instanceof AndroidCloseGuardReporter)) {
            CloseGuard.setReporter(new AndroidCloseGuardReporter(null));
        }
        CloseGuard.setEnabled(enabled);
    }

    public static int getThreadPolicyMask() {
        return BlockGuard.getThreadPolicy().getPolicyMask();
    }

    public static ThreadPolicy getThreadPolicy() {
        return new ThreadPolicy(StrictMode.getThreadPolicyMask(), null);
    }

    public static ThreadPolicy allowThreadDiskWrites() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFC;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask, null);
    }

    public static ThreadPolicy allowThreadDiskReads() {
        int oldPolicyMask = StrictMode.getThreadPolicyMask();
        int newPolicyMask = oldPolicyMask & 0xFFFFFFFD;
        if (newPolicyMask != oldPolicyMask) {
            StrictMode.setThreadPolicyMask(newPolicyMask);
        }
        return new ThreadPolicy(oldPolicyMask, null);
    }

    public static boolean amTheSystemServerProcess() {
        if (Process.myUid() != 1000) {
            return false;
        }
        Throwable stack = new Throwable();
        stack.fillInStackTrace();
        for (StackTraceElement ste : stack.getStackTrace()) {
            String clsName = ste.getClassName();
            if (clsName == null || !clsName.startsWith("com.android.server.")) continue;
            return true;
        }
        return false;
    }

    public static boolean conditionallyEnableDebugLogging() {
        boolean doFlashes;
        boolean bl = doFlashes = !StrictMode.amTheSystemServerProcess() && SystemProperties.getBoolean(VISUAL_PROPERTY, IS_ENG_BUILD);
        if (IS_USER_BUILD && !doFlashes) {
            StrictMode.setCloseGuardEnabled(false);
            return false;
        }
        int threadPolicyMask = 7;
        if (!IS_USER_BUILD) {
            threadPolicyMask |= 0x80;
        }
        if (doFlashes) {
            threadPolicyMask |= 0x800;
        }
        StrictMode.setThreadPolicyMask(threadPolicyMask);
        if (IS_USER_BUILD) {
            StrictMode.setCloseGuardEnabled(false);
        } else {
            StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyDropBox().build());
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
        }
        return true;
    }

    public static void enableDeathOnNetwork() {
        int oldPolicy = StrictMode.getThreadPolicyMask();
        int newPolicy = oldPolicy | 4 | 0x200;
        StrictMode.setThreadPolicyMask(newPolicy);
    }

    public static int parsePolicyFromMessage(String message) {
        if (message == null || !message.startsWith("policy=")) {
            return 0;
        }
        int spaceIndex = message.indexOf(32);
        if (spaceIndex == -1) {
            return 0;
        }
        String policyString = message.substring(7, spaceIndex);
        try {
            return Integer.valueOf(policyString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parseViolationFromMessage(String message) {
        if (message == null) {
            return 0;
        }
        int violationIndex = message.indexOf("violation=");
        if (violationIndex == -1) {
            return 0;
        }
        int numberStartIndex = violationIndex + "violation=".length();
        int numberEndIndex = message.indexOf(32, numberStartIndex);
        if (numberEndIndex == -1) {
            numberEndIndex = message.length();
        }
        String violationString = message.substring(numberStartIndex, numberEndIndex);
        try {
            return Integer.valueOf(violationString);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean tooManyViolationsThisLoop() {
        return violationsBeingTimed.get().size() >= 10;
    }

    public static void executeDeathPenalty(ViolationInfo info) {
        int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
        throw new StrictModeViolation(info.policy, violationBit, null);
    }

    public static void dropboxViolationAsync(final int violationMaskSubset, final ViolationInfo info) {
        int outstanding = sDropboxCallsInFlight.incrementAndGet();
        if (outstanding > 20) {
            sDropboxCallsInFlight.decrementAndGet();
            return;
        }
        if (LOG_V) {
            Log.d(TAG, "Dropboxing async; in-flight=" + outstanding);
        }
        new Thread("callActivityManagerForStrictModeDropbox"){

            public void run() {
                Process.setThreadPriority(10);
                try {
                    IActivityManager am = ActivityManagerNative.getDefault();
                    if (am == null) {
                        Log.d(StrictMode.TAG, "No activity manager; failed to Dropbox violation.");
                    } else {
                        am.handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                    }
                }
                catch (RemoteException e) {
                    Log.e(StrictMode.TAG, "RemoteException handling StrictMode violation", e);
                }
                int outstanding = sDropboxCallsInFlight.decrementAndGet();
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Dropbox complete; in-flight=" + outstanding);
                }
            }
        }.start();
    }

    public static boolean hasGatheredViolations() {
        return gatheredViolations.get() != null;
    }

    public static void clearGatheredViolations() {
        gatheredViolations.set(null);
    }

    public static void conditionallyCheckInstanceCounts() {
        VmPolicy policy = StrictMode.getVmPolicy();
        if (policy.classInstanceLimit.size() == 0) {
            return;
        }
        Runtime.getRuntime().gc();
        for (Map.Entry<Class, Integer> entry : policy.classInstanceLimit.entrySet()) {
            Class klass = entry.getKey();
            int limit = entry.getValue();
            long instances = VMDebug.countInstancesOfClass(klass, false);
            if (instances <= (long)limit) continue;
            InstanceCountViolation tr = new InstanceCountViolation(klass, instances, limit);
            StrictMode.onVmPolicyViolation(tr.getMessage(), tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVmPolicy(VmPolicy policy) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            sVmPolicy = policy;
            sVmPolicyMask = policy.mask;
            StrictMode.setCloseGuardEnabled(StrictMode.vmClosableObjectLeaksEnabled());
            Looper looper = Looper.getMainLooper();
            if (looper != null) {
                MessageQueue mq = looper.mQueue;
                if (policy.classInstanceLimit.size() == 0 || (sVmPolicyMask & 0xD0) == 0) {
                    mq.removeIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = false;
                } else if (!sIsIdlerRegistered) {
                    mq.addIdleHandler(sProcessIdleHandler);
                    sIsIdlerRegistered = true;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VmPolicy getVmPolicy() {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sVmPolicy;
        }
    }

    public static void enableDefaults() {
        StrictMode.setThreadPolicy(new ThreadPolicy.Builder().detectAll().penaltyLog().build());
        StrictMode.setVmPolicy(new VmPolicy.Builder().detectAll().penaltyLog().build());
    }

    public static boolean vmSqliteObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x200) != 0;
    }

    public static boolean vmClosableObjectLeaksEnabled() {
        return (sVmPolicyMask & 0x400) != 0;
    }

    public static void onSqliteObjectLeaked(String message, Throwable originStack) {
        StrictMode.onVmPolicyViolation(message, originStack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void onVmPolicyViolation(String message, Throwable originStack) {
        boolean penaltyDropbox = (sVmPolicyMask & 0x80) != 0;
        boolean penaltyDeath = (sVmPolicyMask & 0x40) != 0;
        boolean penaltyLog = (sVmPolicyMask & 0x10) != 0;
        ViolationInfo info = new ViolationInfo(originStack, sVmPolicyMask);
        info.numAnimationsRunning = 0;
        info.tags = null;
        info.broadcastIntentAction = null;
        Integer fingerprint = info.hashCode();
        long now = SystemClock.uptimeMillis();
        long lastViolationTime = 0L;
        long timeSinceLastViolationMillis = Long.MAX_VALUE;
        HashMap<Integer, Long> hashMap = sLastVmViolationTime;
        // MONITORENTER : hashMap
        if (sLastVmViolationTime.containsKey(fingerprint)) {
            lastViolationTime = sLastVmViolationTime.get(fingerprint);
            timeSinceLastViolationMillis = now - lastViolationTime;
        }
        if (timeSinceLastViolationMillis > 1000L) {
            sLastVmViolationTime.put(fingerprint, now);
        }
        // MONITOREXIT : hashMap
        if (penaltyLog && timeSinceLastViolationMillis > 1000L) {
            Log.e(TAG, message, originStack);
        }
        int violationMaskSubset = 0x80 | 0x1E00 & sVmPolicyMask;
        if (penaltyDropbox && !penaltyDeath) {
            StrictMode.dropboxViolationAsync(violationMaskSubset, info);
            return;
        }
        if (penaltyDropbox && lastViolationTime == 0L) {
            int savedPolicyMask = StrictMode.getThreadPolicyMask();
            try {
                try {
                    StrictMode.setThreadPolicyMask(0);
                    ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "RemoteException trying to handle StrictMode violation", e);
                    Object var17_14 = null;
                    StrictMode.setThreadPolicyMask(savedPolicyMask);
                }
                Object var17_13 = null;
                StrictMode.setThreadPolicyMask(savedPolicyMask);
            }
            catch (Throwable throwable) {
                Object var17_15 = null;
                StrictMode.setThreadPolicyMask(savedPolicyMask);
                throw throwable;
            }
        }
        if (!penaltyDeath) return;
        System.err.println("StrictMode VmPolicy violation with POLICY_DEATH; shutting down.");
        Process.killProcess(Process.myPid());
        System.exit(10);
    }

    public static void writeGatheredViolationsToParcel(Parcel p) {
        ArrayList<ViolationInfo> violations = gatheredViolations.get();
        if (violations == null) {
            p.writeInt(0);
        } else {
            p.writeInt(violations.size());
            for (int i = 0; i < violations.size(); ++i) {
                violations.get(i).writeToParcel(p, 0);
            }
            if (LOG_V) {
                Log.d(TAG, "wrote violations to response parcel; num=" + violations.size());
            }
            violations.clear();
        }
        gatheredViolations.set(null);
    }

    public static void readAndHandleBinderCallViolations(Parcel p) {
        StringWriter sw = new StringWriter();
        new LogStackTrace(null).printStackTrace(new PrintWriter(sw));
        String ourStack = sw.toString();
        int policyMask = StrictMode.getThreadPolicyMask();
        boolean currentlyGathering = (policyMask & 0x100) != 0;
        int numViolations = p.readInt();
        for (int i = 0; i < numViolations; ++i) {
            if (LOG_V) {
                Log.d(TAG, "strict mode violation stacks read from binder call.  i=" + i);
            }
            ViolationInfo info = new ViolationInfo(p, !currentlyGathering);
            info.crashInfo.stackTrace = info.crashInfo.stackTrace + "# via Binder call with stack:\n" + ourStack;
            BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
            if (!(policy instanceof AndroidBlockGuardPolicy)) continue;
            ((AndroidBlockGuardPolicy)policy).handleViolationWithTimingAttempt(info);
        }
    }

    public static void onBinderStrictModePolicyChange(int newPolicy) {
        StrictMode.setBlockGuardPolicy(newPolicy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Span enterCriticalSpan(String name) {
        if (IS_USER_BUILD) {
            return NO_OP_SPAN;
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must be non-null and non-empty");
        }
        ThreadSpanState state = sThisThreadSpanState.get();
        Span span = null;
        ThreadSpanState threadSpanState = state;
        synchronized (threadSpanState) {
            if (state.mFreeListHead != null) {
                span = state.mFreeListHead;
                state.mFreeListHead = span.mNext;
                --state.mFreeListSize;
            } else {
                span = new Span(state);
            }
            span.mName = name;
            span.mCreateMillis = SystemClock.uptimeMillis();
            span.mNext = state.mActiveHead;
            span.mPrev = null;
            state.mActiveHead = span;
            ++state.mActiveSize;
            if (span.mNext != null) {
                span.mNext.mPrev = span;
            }
            if (LOG_V) {
                Log.d(TAG, "Span enter=" + name + "; size=" + state.mActiveSize);
            }
        }
        return span;
    }

    public static void noteSlowCall(String name) {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onCustomSlowCall(name);
    }

    public static void noteDiskRead() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onReadFromDisk();
    }

    public static void noteDiskWrite() {
        BlockGuard.Policy policy = BlockGuard.getThreadPolicy();
        if (!(policy instanceof AndroidBlockGuardPolicy)) {
            return;
        }
        ((AndroidBlockGuardPolicy)policy).onWriteToDisk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementExpectedActivityCount(Class klass) {
        if (klass == null || (StrictMode.sVmPolicy.mask & 0x800) == 0) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null ? 1 : expected + 1;
            sExpectedActivityInstanceCount.put(klass, newExpected);
            StrictMode.setExpectedClassInstanceCount(klass, newExpected + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementExpectedActivityCount(Class klass) {
        if (klass == null || (StrictMode.sVmPolicy.mask & 0x800) == 0) {
            return;
        }
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            Integer expected = sExpectedActivityInstanceCount.get(klass);
            Integer newExpected = expected == null || expected == 0 ? 0 : expected - 1;
            if (newExpected == 0) {
                sExpectedActivityInstanceCount.remove(klass);
            } else {
                sExpectedActivityInstanceCount.put(klass, newExpected);
            }
            StrictMode.setExpectedClassInstanceCount(klass, newExpected + 1);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpectedClassInstanceCount(Class klass, int count) {
        Class<StrictMode> clazz = StrictMode.class;
        synchronized (StrictMode.class) {
            StrictMode.setVmPolicy(new VmPolicy.Builder(sVmPolicy).setClassInstanceLimit(klass, count).build());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static class InstanceCountViolation
    extends Throwable {
        public final Class mClass;
        public final long mInstances;
        public final int mLimit;
        public static final StackTraceElement[] FAKE_STACK = new StackTraceElement[]{new StackTraceElement("android.os.StrictMode", "setClassInstanceLimit", "StrictMode.java", 1)};

        public InstanceCountViolation(Class klass, long instances, int limit) {
            super(klass.toString() + "; instances=" + instances + "; limit=" + limit);
            this.setStackTrace(FAKE_STACK);
            this.mClass = klass;
            this.mInstances = instances;
            this.mLimit = limit;
        }
    }

    public static class ViolationInfo {
        public final ApplicationErrorReport.CrashInfo crashInfo;
        public final int policy;
        public int durationMillis = -1;
        public int numAnimationsRunning = 0;
        public String[] tags;
        public int violationNumThisLoop;
        public long violationUptimeMillis;
        public String broadcastIntentAction;
        public long numInstances = -1L;

        public ViolationInfo() {
            this.crashInfo = null;
            this.policy = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ViolationInfo(Throwable tr, int policy) {
            this.crashInfo = new ApplicationErrorReport.CrashInfo(tr);
            this.violationUptimeMillis = SystemClock.uptimeMillis();
            this.policy = policy;
            this.numAnimationsRunning = ValueAnimator.getCurrentAnimationsCount();
            Intent broadcastIntent = ActivityThread.getIntentBeingBroadcast();
            if (broadcastIntent != null) {
                this.broadcastIntentAction = broadcastIntent.getAction();
            }
            ThreadSpanState state = (ThreadSpanState)sThisThreadSpanState.get();
            if (tr instanceof InstanceCountViolation) {
                this.numInstances = ((InstanceCountViolation)tr).mInstances;
            }
            ThreadSpanState threadSpanState = state;
            synchronized (threadSpanState) {
                int spanActiveCount = state.mActiveSize;
                if (spanActiveCount > 20) {
                    spanActiveCount = 20;
                }
                if (spanActiveCount != 0) {
                    this.tags = new String[spanActiveCount];
                    Span iter = state.mActiveHead;
                    for (int index = 0; iter != null && index < spanActiveCount; ++index) {
                        this.tags[index] = iter.mName;
                        iter = iter.mNext;
                    }
                }
            }
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.crashInfo.stackTrace.hashCode();
            if (this.numAnimationsRunning != 0) {
                result *= 37;
            }
            if (this.broadcastIntentAction != null) {
                result = 37 * result + this.broadcastIntentAction.hashCode();
            }
            if (this.tags != null) {
                for (String tag : this.tags) {
                    result = 37 * result + tag.hashCode();
                }
            }
            return result;
        }

        public ViolationInfo(Parcel in) {
            this(in, false);
        }

        public ViolationInfo(Parcel in, boolean unsetGatheringBit) {
            this.crashInfo = new ApplicationErrorReport.CrashInfo(in);
            int rawPolicy = in.readInt();
            this.policy = unsetGatheringBit ? rawPolicy & 0xFFFFFEFF : rawPolicy;
            this.durationMillis = in.readInt();
            this.violationNumThisLoop = in.readInt();
            this.numAnimationsRunning = in.readInt();
            this.violationUptimeMillis = in.readLong();
            this.numInstances = in.readLong();
            this.broadcastIntentAction = in.readString();
            this.tags = in.readStringArray();
        }

        public void writeToParcel(Parcel dest, int flags) {
            this.crashInfo.writeToParcel(dest, flags);
            dest.writeInt(this.policy);
            dest.writeInt(this.durationMillis);
            dest.writeInt(this.violationNumThisLoop);
            dest.writeInt(this.numAnimationsRunning);
            dest.writeLong(this.violationUptimeMillis);
            dest.writeLong(this.numInstances);
            dest.writeString(this.broadcastIntentAction);
            dest.writeStringArray(this.tags);
        }

        public void dump(Printer pw, String prefix) {
            this.crashInfo.dump(pw, prefix);
            pw.println(prefix + "policy: " + this.policy);
            if (this.durationMillis != -1) {
                pw.println(prefix + "durationMillis: " + this.durationMillis);
            }
            if (this.numInstances != -1L) {
                pw.println(prefix + "numInstances: " + this.numInstances);
            }
            if (this.violationNumThisLoop != 0) {
                pw.println(prefix + "violationNumThisLoop: " + this.violationNumThisLoop);
            }
            if (this.numAnimationsRunning != 0) {
                pw.println(prefix + "numAnimationsRunning: " + this.numAnimationsRunning);
            }
            pw.println(prefix + "violationUptimeMillis: " + this.violationUptimeMillis);
            if (this.broadcastIntentAction != null) {
                pw.println(prefix + "broadcastIntentAction: " + this.broadcastIntentAction);
            }
            if (this.tags != null) {
                int index = 0;
                for (String tag : this.tags) {
                    pw.println(prefix + "tag[" + index++ + "]: " + tag);
                }
            }
        }
    }

    public static class ThreadSpanState {
        public Span mActiveHead;
        public int mActiveSize;
        public Span mFreeListHead;
        public int mFreeListSize;

        public ThreadSpanState() {
        }

        public /* synthetic */ ThreadSpanState(1 x0) {
            this();
        }
    }

    public static class Span {
        public String mName;
        public long mCreateMillis;
        public Span mNext;
        public Span mPrev;
        public final ThreadSpanState mContainerState;

        public Span(ThreadSpanState threadState) {
            this.mContainerState = threadState;
        }

        public Span() {
            this.mContainerState = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            ThreadSpanState state;
            ThreadSpanState threadSpanState = state = this.mContainerState;
            synchronized (threadSpanState) {
                if (this.mName == null) {
                    return;
                }
                if (this.mPrev != null) {
                    this.mPrev.mNext = this.mNext;
                }
                if (this.mNext != null) {
                    this.mNext.mPrev = this.mPrev;
                }
                if (state.mActiveHead == this) {
                    state.mActiveHead = this.mNext;
                }
                --state.mActiveSize;
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "Span finished=" + this.mName + "; size=" + state.mActiveSize);
                }
                this.mCreateMillis = -1L;
                this.mName = null;
                this.mPrev = null;
                this.mNext = null;
                if (state.mFreeListSize < 5) {
                    this.mNext = state.mFreeListHead;
                    state.mFreeListHead = this;
                    ++state.mFreeListSize;
                }
            }
        }
    }

    public static class LogStackTrace
    extends Exception {
        public LogStackTrace() {
        }

        public /* synthetic */ LogStackTrace(1 x0) {
            this();
        }
    }

    public static class AndroidCloseGuardReporter
    implements CloseGuard.Reporter {
        public AndroidCloseGuardReporter() {
        }

        public void report(String message, Throwable allocationSite) {
            StrictMode.onVmPolicyViolation(message, allocationSite);
        }

        public /* synthetic */ AndroidCloseGuardReporter(1 x0) {
            this();
        }
    }

    public static class AndroidBlockGuardPolicy
    implements BlockGuard.Policy {
        public int mPolicyMask;
        public final HashMap<Integer, Long> mLastViolationTime = new HashMap();

        public AndroidBlockGuardPolicy(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        public String toString() {
            return "AndroidBlockGuardPolicy; mPolicyMask=" + this.mPolicyMask;
        }

        public int getPolicyMask() {
            return this.mPolicyMask;
        }

        public void onWriteToDisk() {
            if ((this.mPolicyMask & 1) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskWriteViolation e = new StrictModeDiskWriteViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        public void onCustomSlowCall(String name) {
            if ((this.mPolicyMask & 8) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeCustomViolation e = new StrictModeCustomViolation(this.mPolicyMask, name);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        public void onReadFromDisk() {
            if ((this.mPolicyMask & 2) == 0) {
                return;
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeDiskReadViolation e = new StrictModeDiskReadViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        public void onNetwork() {
            if ((this.mPolicyMask & 4) == 0) {
                return;
            }
            if ((this.mPolicyMask & 0x200) != 0) {
                throw new NetworkOnMainThreadException();
            }
            if (StrictMode.tooManyViolationsThisLoop()) {
                return;
            }
            StrictModeNetworkViolation e = new StrictModeNetworkViolation(this.mPolicyMask);
            e.fillInStackTrace();
            this.startHandlingViolationException(e);
        }

        public void setPolicyMask(int policyMask) {
            this.mPolicyMask = policyMask;
        }

        public void startHandlingViolationException(BlockGuard.BlockGuardPolicyException e) {
            ViolationInfo info = new ViolationInfo(e, e.getPolicy());
            info.violationUptimeMillis = SystemClock.uptimeMillis();
            this.handleViolationWithTimingAttempt(info);
        }

        public void handleViolationWithTimingAttempt(ViolationInfo info) {
            IWindowManager windowManager;
            Looper looper = Looper.myLooper();
            if (looper == null || (info.policy & 0xBF0) == 64) {
                info.durationMillis = -1;
                this.handleViolation(info);
                return;
            }
            final ArrayList records = (ArrayList)violationsBeingTimed.get();
            if (records.size() >= 10) {
                return;
            }
            records.add(info);
            if (records.size() > 1) {
                return;
            }
            IWindowManager iWindowManager = windowManager = (info.policy & 0x800) != 0 ? (IWindowManager)sWindowManager.get() : null;
            if (windowManager != null) {
                try {
                    windowManager.showStrictModeViolation(true);
                }
                catch (RemoteException unused) {
                    // empty catch block
                }
            }
            ((Handler)threadHandler.get()).post(new Runnable(){

                public void run() {
                    long loopFinishTime = SystemClock.uptimeMillis();
                    if (windowManager != null) {
                        try {
                            windowManager.showStrictModeViolation(false);
                        }
                        catch (RemoteException unused) {
                            // empty catch block
                        }
                    }
                    for (int n = 0; n < records.size(); ++n) {
                        ViolationInfo v = (ViolationInfo)records.get(n);
                        v.violationNumThisLoop = n + 1;
                        v.durationMillis = (int)(loopFinishTime - v.violationUptimeMillis);
                        AndroidBlockGuardPolicy.this.handleViolation(v);
                    }
                    records.clear();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleViolation(ViolationInfo info) {
            block21: {
                long timeSinceLastViolationMillis;
                if (info == null || info.crashInfo == null || info.crashInfo.stackTrace == null) {
                    Log.wtf(StrictMode.TAG, "unexpected null stacktrace");
                    return;
                }
                if (LOG_V) {
                    Log.d(StrictMode.TAG, "handleViolation; policy=" + info.policy);
                }
                if ((info.policy & 0x100) != 0) {
                    ViolationInfo previous;
                    ArrayList<ViolationInfo> violations = (ArrayList<ViolationInfo>)gatheredViolations.get();
                    if (violations == null) {
                        violations = new ArrayList<ViolationInfo>(1);
                        gatheredViolations.set(violations);
                    } else if (violations.size() >= 5) {
                        return;
                    }
                    Iterator i$ = violations.iterator();
                    do {
                        if (!i$.hasNext()) {
                            violations.add(info);
                            return;
                        }
                        previous = (ViolationInfo)i$.next();
                    } while (!info.crashInfo.stackTrace.equals(previous.crashInfo.stackTrace));
                    return;
                }
                Integer crashFingerprint = info.hashCode();
                long lastViolationTime = 0L;
                if (this.mLastViolationTime.containsKey(crashFingerprint)) {
                    lastViolationTime = this.mLastViolationTime.get(crashFingerprint);
                }
                long now = SystemClock.uptimeMillis();
                this.mLastViolationTime.put(crashFingerprint, now);
                long l = timeSinceLastViolationMillis = lastViolationTime == 0L ? Long.MAX_VALUE : now - lastViolationTime;
                if ((info.policy & 0x10) != 0 && timeSinceLastViolationMillis > 1000L) {
                    if (info.durationMillis != -1) {
                        Log.d(StrictMode.TAG, "StrictMode policy violation; ~duration=" + info.durationMillis + " ms: " + info.crashInfo.stackTrace);
                    } else {
                        Log.d(StrictMode.TAG, "StrictMode policy violation: " + info.crashInfo.stackTrace);
                    }
                }
                int violationMaskSubset = 0;
                if ((info.policy & 0x20) != 0 && timeSinceLastViolationMillis > 30000L) {
                    violationMaskSubset |= 0x20;
                }
                if ((info.policy & 0x80) != 0 && lastViolationTime == 0L) {
                    violationMaskSubset |= 0x80;
                }
                if (violationMaskSubset != 0) {
                    boolean justDropBox;
                    int violationBit = StrictMode.parseViolationFromMessage(info.crashInfo.exceptionMessage);
                    violationMaskSubset |= violationBit;
                    int savedPolicyMask = StrictMode.getThreadPolicyMask();
                    boolean bl = justDropBox = (info.policy & 0xBF0) == 128;
                    if (justDropBox) {
                        StrictMode.dropboxViolationAsync(violationMaskSubset, info);
                        return;
                    }
                    try {
                        try {
                            StrictMode.setThreadPolicyMask(0);
                            ActivityManagerNative.getDefault().handleApplicationStrictModeViolation(RuntimeInit.getApplicationObject(), violationMaskSubset, info);
                        }
                        catch (RemoteException e) {
                            Log.e(StrictMode.TAG, "RemoteException trying to handle StrictMode violation", e);
                            Object var15_14 = null;
                            StrictMode.setThreadPolicyMask(savedPolicyMask);
                            break block21;
                        }
                        Object var15_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var15_15 = null;
                        StrictMode.setThreadPolicyMask(savedPolicyMask);
                        throw throwable;
                    }
                    StrictMode.setThreadPolicyMask(savedPolicyMask);
                }
            }
            if ((info.policy & 0x40) != 0) {
                StrictMode.executeDeathPenalty(info);
            }
        }
    }

    public static class StrictModeCustomViolation
    extends StrictModeViolation {
        public StrictModeCustomViolation(int policyMask, String name) {
            super(policyMask, 8, name);
        }
    }

    public static class StrictModeDiskWriteViolation
    extends StrictModeViolation {
        public StrictModeDiskWriteViolation(int policyMask) {
            super(policyMask, 1, null);
        }
    }

    public static class StrictModeDiskReadViolation
    extends StrictModeViolation {
        public StrictModeDiskReadViolation(int policyMask) {
            super(policyMask, 2, null);
        }
    }

    public static class StrictModeNetworkViolation
    extends StrictModeViolation {
        public StrictModeNetworkViolation(int policyMask) {
            super(policyMask, 4, null);
        }
    }

    public static class StrictModeViolation
    extends BlockGuard.BlockGuardPolicyException {
        public StrictModeViolation(int policyState, int policyViolated, String message) {
            super(policyState, policyViolated, message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VmPolicy {
        public static final VmPolicy LAX = new VmPolicy(0, StrictMode.access$100());
        public final int mask;
        public final HashMap<Class, Integer> classInstanceLimit;

        public VmPolicy(int mask, HashMap<Class, Integer> classInstanceLimit) {
            if (classInstanceLimit == null) {
                throw new NullPointerException("classInstanceLimit == null");
            }
            this.mask = mask;
            this.classInstanceLimit = classInstanceLimit;
        }

        public String toString() {
            return "[StrictMode.VmPolicy; mask=" + this.mask + "]";
        }

        public /* synthetic */ VmPolicy(int x0, HashMap x1, 1 x2) {
            this(x0, x1);
        }

        public static class Builder {
            public int mMask;
            public HashMap<Class, Integer> mClassInstanceLimit;
            public boolean mClassInstanceLimitNeedCow = false;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(VmPolicy base) {
                this.mMask = base.mask;
                this.mClassInstanceLimitNeedCow = true;
                this.mClassInstanceLimit = base.classInstanceLimit;
            }

            public Builder setClassInstanceLimit(Class klass, int instanceLimit) {
                if (klass == null) {
                    throw new NullPointerException("klass == null");
                }
                if (this.mClassInstanceLimitNeedCow) {
                    if (this.mClassInstanceLimit.containsKey(klass) && this.mClassInstanceLimit.get(klass) == instanceLimit) {
                        return this;
                    }
                    this.mClassInstanceLimitNeedCow = false;
                    this.mClassInstanceLimit = (HashMap)this.mClassInstanceLimit.clone();
                } else if (this.mClassInstanceLimit == null) {
                    this.mClassInstanceLimit = new HashMap();
                }
                this.mMask |= 0x1000;
                this.mClassInstanceLimit.put(klass, instanceLimit);
                return this;
            }

            public Builder detectActivityLeaks() {
                return this.enable(2048);
            }

            public Builder detectAll() {
                return this.enable(3584);
            }

            public Builder detectLeakedSqlLiteObjects() {
                return this.enable(512);
            }

            public Builder detectLeakedClosableObjects() {
                return this.enable(1024);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            public VmPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0xF0) == 0) {
                    this.penaltyLog();
                }
                return new VmPolicy(this.mMask, this.mClassInstanceLimit != null ? this.mClassInstanceLimit : EMPTY_CLASS_LIMIT_MAP, null);
            }
        }
    }

    public static class ThreadPolicy {
        public static final ThreadPolicy LAX = new ThreadPolicy(0);
        public final int mask;

        public ThreadPolicy(int mask) {
            this.mask = mask;
        }

        public String toString() {
            return "[StrictMode.ThreadPolicy; mask=" + this.mask + "]";
        }

        public /* synthetic */ ThreadPolicy(int x0, 1 x1) {
            this(x0);
        }

        public static class Builder {
            public int mMask = 0;

            public Builder() {
                this.mMask = 0;
            }

            public Builder(ThreadPolicy policy) {
                this.mMask = policy.mask;
            }

            public Builder detectAll() {
                return this.enable(15);
            }

            public Builder permitAll() {
                return this.disable(15);
            }

            public Builder detectNetwork() {
                return this.enable(4);
            }

            public Builder permitNetwork() {
                return this.disable(4);
            }

            public Builder detectDiskReads() {
                return this.enable(2);
            }

            public Builder permitDiskReads() {
                return this.disable(2);
            }

            public Builder detectCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder permitCustomSlowCalls() {
                return this.enable(8);
            }

            public Builder detectDiskWrites() {
                return this.enable(1);
            }

            public Builder permitDiskWrites() {
                return this.disable(1);
            }

            public Builder penaltyDialog() {
                return this.enable(32);
            }

            public Builder penaltyDeath() {
                return this.enable(64);
            }

            public Builder penaltyDeathOnNetwork() {
                return this.enable(512);
            }

            public Builder penaltyFlashScreen() {
                return this.enable(2048);
            }

            public Builder penaltyLog() {
                return this.enable(16);
            }

            public Builder penaltyDropBox() {
                return this.enable(128);
            }

            public Builder enable(int bit) {
                this.mMask |= bit;
                return this;
            }

            public Builder disable(int bit) {
                this.mMask &= ~bit;
                return this;
            }

            public ThreadPolicy build() {
                if (this.mMask != 0 && (this.mMask & 0xF0) == 0) {
                    this.penaltyLog();
                }
                return new ThreadPolicy(this.mMask, null);
            }
        }
    }
}

