/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Binder;
import android.os.IVibratorService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class Vibrator {
    public static final String TAG = "Vibrator";
    public IVibratorService mService;
    public final Binder mToken = new Binder();

    public Vibrator() {
        this.mService = IVibratorService.Stub.asInterface(ServiceManager.getService("vibrator"));
    }

    public boolean hasVibrator() {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return false;
        }
        try {
            return this.mService.hasVibrator();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void vibrate(long milliseconds) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        try {
            this.mService.vibrate(milliseconds, this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to vibrate.", e);
        }
    }

    public void vibrate(long[] pattern, int repeat) {
        if (this.mService == null) {
            Log.w(TAG, "Failed to vibrate; no vibrator service.");
            return;
        }
        if (repeat < pattern.length) {
            try {
                this.mService.vibratePattern(pattern, repeat, this.mToken);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to vibrate.", e);
            }
        } else {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public void cancel() {
        if (this.mService == null) {
            return;
        }
        try {
            this.mService.cancelVibrate(this.mToken);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to cancel vibration.", e);
        }
    }
}

