/*
 * Decompiled with CFR 0.152.
 */
package android.pim;

import android.content.ContentValues;
import android.database.Cursor;
import android.pim.EventRecurrence;
import android.pim.ICalendar;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import java.util.List;
import java.util.regex.Pattern;

public class RecurrenceSet {
    public static final String TAG = "CalendarProvider";
    public static final String RULE_SEPARATOR = "\n";
    public static final String FOLDING_SEPARATOR = "\n ";
    public EventRecurrence[] rrules = null;
    public long[] rdates = null;
    public EventRecurrence[] exrules = null;
    public long[] exdates = null;
    public static final Pattern IGNORABLE_ICAL_WHITESPACE_RE = Pattern.compile("(?:\\r\\n?|\\n)[ \t]");
    public static final Pattern FOLD_RE = Pattern.compile(".{75}");

    public RecurrenceSet(ContentValues values) throws EventRecurrence.InvalidFormatException {
        String rruleStr = values.getAsString("rrule");
        String rdateStr = values.getAsString("rdate");
        String exruleStr = values.getAsString("exrule");
        String exdateStr = values.getAsString("exdate");
        this.init(rruleStr, rdateStr, exruleStr, exdateStr);
    }

    public RecurrenceSet(Cursor cursor) throws EventRecurrence.InvalidFormatException {
        int rruleColumn = cursor.getColumnIndex("rrule");
        int rdateColumn = cursor.getColumnIndex("rdate");
        int exruleColumn = cursor.getColumnIndex("exrule");
        int exdateColumn = cursor.getColumnIndex("exdate");
        String rruleStr = cursor.getString(rruleColumn);
        String rdateStr = cursor.getString(rdateColumn);
        String exruleStr = cursor.getString(exruleColumn);
        String exdateStr = cursor.getString(exdateColumn);
        this.init(rruleStr, rdateStr, exruleStr, exdateStr);
    }

    public RecurrenceSet(String rruleStr, String rdateStr, String exruleStr, String exdateStr) throws EventRecurrence.InvalidFormatException {
        this.init(rruleStr, rdateStr, exruleStr, exdateStr);
    }

    public void init(String rruleStr, String rdateStr, String exruleStr, String exdateStr) throws EventRecurrence.InvalidFormatException {
        if (!TextUtils.isEmpty(rruleStr) || !TextUtils.isEmpty(rdateStr)) {
            int i;
            if (!TextUtils.isEmpty(rruleStr)) {
                String[] rruleStrs = rruleStr.split(RULE_SEPARATOR);
                this.rrules = new EventRecurrence[rruleStrs.length];
                for (i = 0; i < rruleStrs.length; ++i) {
                    EventRecurrence rrule = new EventRecurrence();
                    rrule.parse(rruleStrs[i]);
                    this.rrules[i] = rrule;
                }
            }
            if (!TextUtils.isEmpty(rdateStr)) {
                this.rdates = RecurrenceSet.parseRecurrenceDates(rdateStr);
            }
            if (!TextUtils.isEmpty(exruleStr)) {
                String[] exruleStrs = exruleStr.split(RULE_SEPARATOR);
                this.exrules = new EventRecurrence[exruleStrs.length];
                for (i = 0; i < exruleStrs.length; ++i) {
                    EventRecurrence exrule = new EventRecurrence();
                    exrule.parse(exruleStr);
                    this.exrules[i] = exrule;
                }
            }
            if (!TextUtils.isEmpty(exdateStr)) {
                this.exdates = RecurrenceSet.parseRecurrenceDates(exdateStr);
            }
        }
    }

    public boolean hasRecurrence() {
        return this.rrules != null || this.rdates != null;
    }

    public static long[] parseRecurrenceDates(String recurrence) {
        String tz = "UTC";
        int tzidx = recurrence.indexOf(";");
        if (tzidx != -1) {
            tz = recurrence.substring(0, tzidx);
            recurrence = recurrence.substring(tzidx + 1);
        }
        Time time = new Time(tz);
        String[] rawDates = recurrence.split(",");
        int n = rawDates.length;
        long[] dates = new long[n];
        for (int i = 0; i < n; ++i) {
            time.parse(rawDates[i]);
            dates[i] = time.toMillis(false);
            time.timezone = tz;
        }
        return dates;
    }

    public static boolean populateContentValues(ICalendar.Component component, ContentValues values) {
        ICalendar.Property dtstartProperty = component.getFirstProperty("DTSTART");
        String dtstart = dtstartProperty.getValue();
        ICalendar.Parameter tzidParam = dtstartProperty.getFirstParameter("TZID");
        String tzid = tzidParam == null ? null : tzidParam.value;
        Time start = new Time(tzidParam == null ? "UTC" : tzid);
        boolean inUtc = start.parse(dtstart);
        boolean allDay = start.allDay;
        if (inUtc || allDay) {
            tzid = "UTC";
        }
        String duration = RecurrenceSet.computeDuration(start, component);
        String rrule = RecurrenceSet.flattenProperties(component, "RRULE");
        String rdate = RecurrenceSet.extractDates(component.getFirstProperty("RDATE"));
        String exrule = RecurrenceSet.flattenProperties(component, "EXRULE");
        String exdate = RecurrenceSet.extractDates(component.getFirstProperty("EXDATE"));
        if (TextUtils.isEmpty(dtstart) || TextUtils.isEmpty(duration) || TextUtils.isEmpty(rrule) && TextUtils.isEmpty(rdate)) {
            Log.d(TAG, "Recurrence missing DTSTART, DTEND/DURATION, or RRULE/RDATE: " + component.toString());
            return false;
        }
        if (allDay) {
            start.timezone = "UTC";
        }
        long millis = start.toMillis(false);
        values.put("dtstart", millis);
        if (millis == -1L) {
            Log.d(TAG, "DTSTART is out of range: " + component.toString());
            return false;
        }
        values.put("rrule", rrule);
        values.put("rdate", rdate);
        values.put("exrule", exrule);
        values.put("exdate", exdate);
        values.put("eventTimezone", tzid);
        values.put("duration", duration);
        values.put("allDay", allDay ? 1 : 0);
        return true;
    }

    public static boolean populateComponent(Cursor cursor, ICalendar.Component component) {
        boolean allDay;
        int dtstartColumn = cursor.getColumnIndex("dtstart");
        int durationColumn = cursor.getColumnIndex("duration");
        int tzidColumn = cursor.getColumnIndex("eventTimezone");
        int rruleColumn = cursor.getColumnIndex("rrule");
        int rdateColumn = cursor.getColumnIndex("rdate");
        int exruleColumn = cursor.getColumnIndex("exrule");
        int exdateColumn = cursor.getColumnIndex("exdate");
        int allDayColumn = cursor.getColumnIndex("allDay");
        long dtstart = -1L;
        if (!cursor.isNull(dtstartColumn)) {
            dtstart = cursor.getLong(dtstartColumn);
        }
        String duration = cursor.getString(durationColumn);
        String tzid = cursor.getString(tzidColumn);
        String rruleStr = cursor.getString(rruleColumn);
        String rdateStr = cursor.getString(rdateColumn);
        String exruleStr = cursor.getString(exruleColumn);
        String exdateStr = cursor.getString(exdateColumn);
        boolean bl = allDay = cursor.getInt(allDayColumn) == 1;
        if (dtstart == -1L || TextUtils.isEmpty(duration) || TextUtils.isEmpty(rruleStr) && TextUtils.isEmpty(rdateStr)) {
            return false;
        }
        ICalendar.Property dtstartProp = new ICalendar.Property("DTSTART");
        Time dtstartTime = null;
        if (!TextUtils.isEmpty(tzid)) {
            if (!allDay) {
                dtstartProp.addParameter(new ICalendar.Parameter("TZID", tzid));
            }
            dtstartTime = new Time(tzid);
        } else {
            dtstartTime = new Time("UTC");
        }
        dtstartTime.set(dtstart);
        if (allDay) {
            dtstartProp.addParameter(new ICalendar.Parameter("VALUE", "DATE"));
            dtstartTime.allDay = true;
            dtstartTime.hour = 0;
            dtstartTime.minute = 0;
            dtstartTime.second = 0;
        }
        dtstartProp.setValue(dtstartTime.format2445());
        component.addProperty(dtstartProp);
        ICalendar.Property durationProp = new ICalendar.Property("DURATION");
        durationProp.setValue(duration);
        component.addProperty(durationProp);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", rruleStr);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", rdateStr);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", exruleStr);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", exdateStr);
        return true;
    }

    public static boolean populateComponent(ContentValues values, ICalendar.Component component) {
        boolean allDay;
        long dtstart = -1L;
        if (values.containsKey("dtstart")) {
            dtstart = values.getAsLong("dtstart");
        }
        String duration = values.getAsString("duration");
        String tzid = values.getAsString("eventTimezone");
        String rruleStr = values.getAsString("rrule");
        String rdateStr = values.getAsString("rdate");
        String exruleStr = values.getAsString("exrule");
        String exdateStr = values.getAsString("exdate");
        Integer allDayInteger = values.getAsInteger("allDay");
        boolean bl = null != allDayInteger ? allDayInteger == 1 : (allDay = false);
        if (dtstart == -1L || TextUtils.isEmpty(duration) || TextUtils.isEmpty(rruleStr) && TextUtils.isEmpty(rdateStr)) {
            return false;
        }
        ICalendar.Property dtstartProp = new ICalendar.Property("DTSTART");
        Time dtstartTime = null;
        if (!TextUtils.isEmpty(tzid)) {
            if (!allDay) {
                dtstartProp.addParameter(new ICalendar.Parameter("TZID", tzid));
            }
            dtstartTime = new Time(tzid);
        } else {
            dtstartTime = new Time("UTC");
        }
        dtstartTime.set(dtstart);
        if (allDay) {
            dtstartProp.addParameter(new ICalendar.Parameter("VALUE", "DATE"));
            dtstartTime.allDay = true;
            dtstartTime.hour = 0;
            dtstartTime.minute = 0;
            dtstartTime.second = 0;
        }
        dtstartProp.setValue(dtstartTime.format2445());
        component.addProperty(dtstartProp);
        ICalendar.Property durationProp = new ICalendar.Property("DURATION");
        durationProp.setValue(duration);
        component.addProperty(durationProp);
        RecurrenceSet.addPropertiesForRuleStr(component, "RRULE", rruleStr);
        RecurrenceSet.addPropertyForDateStr(component, "RDATE", rdateStr);
        RecurrenceSet.addPropertiesForRuleStr(component, "EXRULE", exruleStr);
        RecurrenceSet.addPropertyForDateStr(component, "EXDATE", exdateStr);
        return true;
    }

    public static void addPropertiesForRuleStr(ICalendar.Component component, String propertyName, String ruleStr) {
        String[] rrules;
        if (TextUtils.isEmpty(ruleStr)) {
            return;
        }
        for (String rrule : rrules = RecurrenceSet.getRuleStrings(ruleStr)) {
            ICalendar.Property prop = new ICalendar.Property(propertyName);
            prop.setValue(rrule);
            component.addProperty(prop);
        }
    }

    public static String[] getRuleStrings(String ruleStr) {
        if (null == ruleStr) {
            return new String[0];
        }
        String unfoldedRuleStr = RecurrenceSet.unfold(ruleStr);
        String[] split = unfoldedRuleStr.split(RULE_SEPARATOR);
        int count = split.length;
        for (int n = 0; n < count; ++n) {
            split[n] = RecurrenceSet.fold(split[n]);
        }
        return split;
    }

    public static String fold(String unfoldedIcalContent) {
        return FOLD_RE.matcher(unfoldedIcalContent).replaceAll("$0\r\n ");
    }

    public static String unfold(String foldedIcalContent) {
        return IGNORABLE_ICAL_WHITESPACE_RE.matcher(foldedIcalContent).replaceAll("");
    }

    public static void addPropertyForDateStr(ICalendar.Component component, String propertyName, String dateStr) {
        if (TextUtils.isEmpty(dateStr)) {
            return;
        }
        ICalendar.Property prop = new ICalendar.Property(propertyName);
        String tz = null;
        int tzidx = dateStr.indexOf(";");
        if (tzidx != -1) {
            tz = dateStr.substring(0, tzidx);
            dateStr = dateStr.substring(tzidx + 1);
        }
        if (!TextUtils.isEmpty(tz)) {
            prop.addParameter(new ICalendar.Parameter("TZID", tz));
        }
        prop.setValue(dateStr);
        component.addProperty(prop);
    }

    public static String computeDuration(Time start, ICalendar.Component component) {
        ICalendar.Property durationProperty = component.getFirstProperty("DURATION");
        if (durationProperty != null) {
            return durationProperty.getValue();
        }
        ICalendar.Property dtendProperty = component.getFirstProperty("DTEND");
        if (dtendProperty == null) {
            return "+P0S";
        }
        ICalendar.Parameter endTzidParameter = dtendProperty.getFirstParameter("TZID");
        String endTzid = endTzidParameter == null ? start.timezone : endTzidParameter.value;
        Time end = new Time(endTzid);
        end.parse(dtendProperty.getValue());
        long durationMillis = end.toMillis(false) - start.toMillis(false);
        long durationSeconds = durationMillis / 1000L;
        if (start.allDay && durationSeconds % 86400L == 0L) {
            return "P" + durationSeconds / 86400L + "D";
        }
        return "P" + durationSeconds + "S";
    }

    public static String flattenProperties(ICalendar.Component component, String name) {
        List<ICalendar.Property> properties = component.getProperties(name);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        if (properties.size() == 1) {
            return properties.get(0).getValue();
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ICalendar.Property property : component.getProperties(name)) {
            if (first) {
                first = false;
            } else {
                sb.append(RULE_SEPARATOR);
            }
            sb.append(property.getValue());
        }
        return sb.toString();
    }

    public static String extractDates(ICalendar.Property recurrence) {
        if (recurrence == null) {
            return null;
        }
        ICalendar.Parameter tzidParam = recurrence.getFirstParameter("TZID");
        if (tzidParam != null) {
            return tzidParam.value + ";" + recurrence.getValue();
        }
        return recurrence.getValue();
    }
}

