/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.FieldPacker;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Type;

public class AllocationAdapter
extends Allocation {
    public int mSelectedDimX;
    public int mSelectedDimY;
    public int mSelectedCount;
    public Allocation mAlloc;
    public int mSelectedLOD = 0;
    public Type.CubemapFace mSelectedFace = Type.CubemapFace.POSITVE_X;

    public AllocationAdapter(int id2, RenderScript rs, Allocation alloc) {
        super(id2, rs, null, alloc.mUsage);
        Type t = alloc.getType();
        this.mSelectedDimX = t.getX();
        this.mSelectedDimY = t.getY();
        this.mSelectedCount = t.getCount();
    }

    public void copyFrom(BaseObj[] d) {
        this.mRS.validate();
        if (d.length != this.mSelectedCount) {
            throw new RSIllegalArgumentException("Array size mismatch, allocation size = " + this.mSelectedCount + ", array length = " + d.length);
        }
        int[] i = new int[d.length];
        for (int ct = 0; ct < d.length; ++ct) {
            i[ct] = d[ct].getID();
        }
        this.subData1D(0, this.mType.getCount(), i);
    }

    public void validateBitmap(Bitmap b) {
        this.mRS.validate();
        if (this.mSelectedDimX != b.getWidth() || this.mSelectedDimY != b.getHeight()) {
            throw new RSIllegalArgumentException("Cannot update allocation from bitmap, sizes mismatch");
        }
    }

    public void copyFrom(int[] d) {
        this.mRS.validate();
        this.subData1D(0, this.mSelectedCount, d);
    }

    public void copyFrom(short[] d) {
        this.mRS.validate();
        this.subData1D(0, this.mSelectedCount, d);
    }

    public void copyFrom(byte[] d) {
        this.mRS.validate();
        this.subData1D(0, this.mSelectedCount, d);
    }

    public void copyFrom(float[] d) {
        this.mRS.validate();
        this.subData1D(0, this.mSelectedCount, d);
    }

    public void copyFrom(Bitmap b) {
        this.validateBitmap(b);
        this.mRS.nAllocationCopyFromBitmap(this.getID(), b);
    }

    public void copyTo(Bitmap b) {
        this.validateBitmap(b);
        this.mRS.nAllocationCopyToBitmap(this.getID(), b);
    }

    public void subData(int xoff, FieldPacker fp) {
        byte[] data;
        int count;
        int eSize = this.mType.mElement.getSizeBytes();
        if (eSize * (count = (data = fp.getData()).length / eSize) != data.length) {
            throw new RSIllegalArgumentException("Field packer length " + data.length + " not divisible by element size " + eSize + ".");
        }
        this.data1DChecks(xoff, count, data.length, data.length);
        this.mRS.nAllocationData1D(this.getID(), xoff, this.mSelectedLOD, count, data, data.length);
    }

    public void subElementData(int xoff, int component_number, FieldPacker fp) {
        int eSize;
        if (component_number >= this.mType.mElement.mElements.length) {
            throw new RSIllegalArgumentException("Component_number " + component_number + " out of range.");
        }
        if (xoff < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        byte[] data = fp.getData();
        if (data.length != (eSize = this.mType.mElement.mElements[component_number].getSizeBytes())) {
            throw new RSIllegalArgumentException("Field packer sizelength " + data.length + " does not match component size " + eSize + ".");
        }
        this.mRS.nAllocationElementData1D(this.getID(), xoff, this.mSelectedLOD, component_number, data, data.length);
    }

    public void data1DChecks(int off, int count, int len, int dataSize) {
        this.mRS.validate();
        if (off < 0) {
            throw new RSIllegalArgumentException("Offset must be >= 0.");
        }
        if (count < 1) {
            throw new RSIllegalArgumentException("Count must be >= 1.");
        }
        if (off + count > this.mSelectedDimX * this.mSelectedDimY) {
            throw new RSIllegalArgumentException("Overflow, Available count " + this.mType.getCount() + ", got " + count + " at offset " + off + ".");
        }
        if (len < dataSize) {
            throw new RSIllegalArgumentException("Array too small for allocation type.");
        }
    }

    public void subData1D(int off, int count, int[] d) {
        int dataSize = this.mAlloc.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void subData1D(int off, int count, short[] d) {
        int dataSize = this.mAlloc.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 2, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void subData1D(int off, int count, byte[] d) {
        int dataSize = this.mAlloc.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void subData1D(int off, int count, float[] d) {
        int dataSize = this.mAlloc.mType.mElement.getSizeBytes() * count;
        this.data1DChecks(off, count, d.length * 4, dataSize);
        this.mRS.nAllocationData1D(this.getID(), off, this.mSelectedLOD, count, d, dataSize);
    }

    public void subData2D(int xoff, int yoff, int w, int h, int[] d) {
        this.mRS.validate();
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, d, d.length * 4);
    }

    public void subData2D(int xoff, int yoff, int w, int h, float[] d) {
        this.mRS.validate();
        this.mRS.nAllocationData2D(this.getID(), xoff, yoff, this.mSelectedLOD, this.mSelectedFace.mID, w, h, d, d.length * 4);
    }

    public void readData(int[] d) {
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public void readData(float[] d) {
        this.mRS.validate();
        this.mRS.nAllocationRead(this.getID(), d);
    }

    public void setLOD(int lod) {
    }

    public void setFace(Type.CubemapFace cf) {
    }

    public void setY(int y) {
    }

    public void setZ(int z) {
    }

    public static AllocationAdapter create2D(RenderScript rs, Allocation a) {
        rs.validate();
        AllocationAdapter aa = new AllocationAdapter(0, rs, a);
        return aa;
    }
}

