/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import java.io.UnsupportedEncodingException;

public class BaseObj {
    public int mID;
    public boolean mDestroyed;
    public String mName;
    public RenderScript mRS;

    public BaseObj(int id2, RenderScript rs) {
        rs.validate();
        this.mRS = rs;
        this.mID = id2;
        this.mDestroyed = false;
    }

    public void setID(int id2) {
        if (this.mID != 0) {
            throw new RSRuntimeException("Internal Error, reset of object ID.");
        }
        this.mID = id2;
    }

    public int getID() {
        if (this.mDestroyed) {
            throw new RSInvalidStateException("using a destroyed object.");
        }
        if (this.mID == 0) {
            throw new RSRuntimeException("Internal error: Object id 0.");
        }
        return this.mID;
    }

    public void checkValid() {
        if (this.mID == 0) {
            throw new RSIllegalArgumentException("Invalid object.");
        }
    }

    public void setName(String name) {
        if (name == null) {
            throw new RSIllegalArgumentException("setName requires a string of non-zero length.");
        }
        if (name.length() < 1) {
            throw new RSIllegalArgumentException("setName does not accept a zero length string.");
        }
        if (this.mName != null) {
            throw new RSIllegalArgumentException("setName object already has a name.");
        }
        try {
            byte[] bytes = name.getBytes("UTF-8");
            this.mRS.nAssignName(this.mID, bytes);
            this.mName = name;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void finalize() throws Throwable {
        if (!this.mDestroyed) {
            if (this.mID != 0 && this.mRS.isAlive()) {
                this.mRS.nObjDestroy(this.mID);
            }
            this.mRS = null;
            this.mID = 0;
            this.mDestroyed = true;
        }
        super.finalize();
    }

    public synchronized void destroy() {
        if (this.mDestroyed) {
            throw new RSInvalidStateException("Object already destroyed.");
        }
        this.mDestroyed = true;
        this.mRS.nObjDestroy(this.mID);
    }

    public void updateFromNative() {
        this.mRS.validate();
        this.mName = this.mRS.nGetName(this.getID());
    }
}

