/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.Sampler;
import android.util.Log;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;

public class RenderScript {
    public static final String LOG_TAG = "RenderScript_jni";
    public static final boolean DEBUG = false;
    public static final boolean LOG_ENABLED = false;
    public Context mApplicationContext;
    public static boolean sInitialized = false;
    public int mDev;
    public int mContext;
    public MessageThread mMessageThread;
    public Element mElement_U8;
    public Element mElement_I8;
    public Element mElement_U16;
    public Element mElement_I16;
    public Element mElement_U32;
    public Element mElement_I32;
    public Element mElement_U64;
    public Element mElement_I64;
    public Element mElement_F32;
    public Element mElement_F64;
    public Element mElement_BOOLEAN;
    public Element mElement_ELEMENT;
    public Element mElement_TYPE;
    public Element mElement_ALLOCATION;
    public Element mElement_SAMPLER;
    public Element mElement_SCRIPT;
    public Element mElement_MESH;
    public Element mElement_PROGRAM_FRAGMENT;
    public Element mElement_PROGRAM_VERTEX;
    public Element mElement_PROGRAM_RASTER;
    public Element mElement_PROGRAM_STORE;
    public Element mElement_A_8;
    public Element mElement_RGB_565;
    public Element mElement_RGB_888;
    public Element mElement_RGBA_5551;
    public Element mElement_RGBA_4444;
    public Element mElement_RGBA_8888;
    public Element mElement_FLOAT_2;
    public Element mElement_FLOAT_3;
    public Element mElement_FLOAT_4;
    public Element mElement_UCHAR_4;
    public Element mElement_MATRIX_4X4;
    public Element mElement_MATRIX_3X3;
    public Element mElement_MATRIX_2X2;
    public Sampler mSampler_CLAMP_NEAREST;
    public Sampler mSampler_CLAMP_LINEAR;
    public Sampler mSampler_CLAMP_LINEAR_MIP_LINEAR;
    public Sampler mSampler_WRAP_NEAREST;
    public Sampler mSampler_WRAP_LINEAR;
    public Sampler mSampler_WRAP_LINEAR_MIP_LINEAR;
    public ProgramStore mProgramStore_BLEND_NONE_DEPTH_TEST;
    public ProgramStore mProgramStore_BLEND_NONE_DEPTH_NO_DEPTH;
    public ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_TEST;
    public ProgramStore mProgramStore_BLEND_ALPHA_DEPTH_NO_DEPTH;
    public ProgramRaster mProgramRaster_CULL_BACK;
    public ProgramRaster mProgramRaster_CULL_FRONT;
    public ProgramRaster mProgramRaster_CULL_NONE;
    public RSMessageHandler mMessageCallback = null;
    public RSErrorHandler mErrorCallback = null;

    public static void _nInit() {
        OverrideMethod.invokeV("android.renderscript.RenderScript#_nInit()V", true, null);
    }

    public int nDeviceCreate() {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nDeviceCreate()I", true, this);
    }

    public void nDeviceDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceDestroy(I)V", true, this);
    }

    public void nDeviceSetConfig(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nDeviceSetConfig(III)V", true, this);
    }

    public void nContextGetUserMessage(int n, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextGetUserMessage(I[I)V", true, this);
    }

    public String nContextGetErrorMessage(int n) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#nContextGetErrorMessage(I)Ljava/lang/String;", true, this);
    }

    public int nContextPeekMessage(int n, int[] nArray, boolean bl) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#nContextPeekMessage(I[IZ)I", true, this);
    }

    public void nContextInitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextInitToClient(I)V", true, this);
    }

    public void nContextDeinitToClient(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#nContextDeinitToClient(I)V", true, this);
    }

    public int rsnContextCreateGL(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, float f, int n13) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreateGL(IIIIIIIIIIIIFI)I", true, this);
    }

    public synchronized int nContextCreateGL(int dev, int ver, int colorMin, int colorPref, int alphaMin, int alphaPref, int depthMin, int depthPref, int stencilMin, int stencilPref, int samplesMin, int samplesPref, float samplesQ, int dpi) {
        return this.rsnContextCreateGL(dev, ver, colorMin, colorPref, alphaMin, alphaPref, depthMin, depthPref, stencilMin, stencilPref, samplesMin, samplesPref, samplesQ, dpi);
    }

    public int rsnContextCreate(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnContextCreate(II)I", true, this);
    }

    public synchronized int nContextCreate(int dev, int ver) {
        return this.rsnContextCreate(dev, ver);
    }

    public void rsnContextDestroy(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDestroy(I)V", true, this);
    }

    public synchronized void nContextDestroy() {
        this.validate();
        this.rsnContextDestroy(this.mContext);
    }

    public void rsnContextSetSurface(int n, int n2, int n3, Surface surface) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetSurface(IIILandroid/view/Surface;)V", true, this);
    }

    public synchronized void nContextSetSurface(int w, int h, Surface sur) {
        this.validate();
        this.rsnContextSetSurface(this.mContext, w, h, sur);
    }

    public void rsnContextSetPriority(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextSetPriority(II)V", true, this);
    }

    public synchronized void nContextSetPriority(int p) {
        this.validate();
        this.rsnContextSetPriority(this.mContext, p);
    }

    public void rsnContextDump(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextDump(II)V", true, this);
    }

    public synchronized void nContextDump(int bits) {
        this.validate();
        this.rsnContextDump(this.mContext, bits);
    }

    public void rsnContextFinish(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextFinish(I)V", true, this);
    }

    public synchronized void nContextFinish() {
        this.validate();
        this.rsnContextFinish(this.mContext);
    }

    public void rsnContextBindRootScript(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindRootScript(II)V", true, this);
    }

    public synchronized void nContextBindRootScript(int script) {
        this.validate();
        this.rsnContextBindRootScript(this.mContext, script);
    }

    public void rsnContextBindSampler(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindSampler(III)V", true, this);
    }

    public synchronized void nContextBindSampler(int sampler, int slot) {
        this.validate();
        this.rsnContextBindSampler(this.mContext, sampler, slot);
    }

    public void rsnContextBindProgramStore(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramStore(II)V", true, this);
    }

    public synchronized void nContextBindProgramStore(int pfs) {
        this.validate();
        this.rsnContextBindProgramStore(this.mContext, pfs);
    }

    public void rsnContextBindProgramFragment(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramFragment(II)V", true, this);
    }

    public synchronized void nContextBindProgramFragment(int pf) {
        this.validate();
        this.rsnContextBindProgramFragment(this.mContext, pf);
    }

    public void rsnContextBindProgramVertex(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramVertex(II)V", true, this);
    }

    public synchronized void nContextBindProgramVertex(int pv) {
        this.validate();
        this.rsnContextBindProgramVertex(this.mContext, pv);
    }

    public void rsnContextBindProgramRaster(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextBindProgramRaster(II)V", true, this);
    }

    public synchronized void nContextBindProgramRaster(int pr) {
        this.validate();
        this.rsnContextBindProgramRaster(this.mContext, pr);
    }

    public void rsnContextPause(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextPause(I)V", true, this);
    }

    public synchronized void nContextPause() {
        this.validate();
        this.rsnContextPause(this.mContext);
    }

    public void rsnContextResume(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnContextResume(I)V", true, this);
    }

    public synchronized void nContextResume() {
        this.validate();
        this.rsnContextResume(this.mContext);
    }

    public void rsnAssignName(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAssignName(II[B)V", true, this);
    }

    public synchronized void nAssignName(int obj, byte[] name) {
        this.validate();
        this.rsnAssignName(this.mContext, obj, name);
    }

    public String rsnGetName(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.renderscript.RenderScript#rsnGetName(II)Ljava/lang/String;", true, this);
    }

    public synchronized String nGetName(int obj) {
        this.validate();
        return this.rsnGetName(this.mContext, obj);
    }

    public void rsnObjDestroy(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnObjDestroy(II)V", true, this);
    }

    public synchronized void nObjDestroy(int id2) {
        if (this.mContext != 0) {
            this.rsnObjDestroy(this.mContext, id2);
        }
    }

    public int rsnElementCreate(int n, int n2, int n3, boolean bl, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate(IIIZI)I", true, this);
    }

    public synchronized int nElementCreate(int type, int kind, boolean norm, int vecSize) {
        this.validate();
        return this.rsnElementCreate(this.mContext, type, kind, norm, vecSize);
    }

    public int rsnElementCreate2(int n, int[] nArray, String[] stringArray, int[] nArray2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnElementCreate2(I[I[Ljava/lang/String;[I)I", true, this);
    }

    public synchronized int nElementCreate2(int[] elements, String[] names, int[] arraySizes) {
        this.validate();
        return this.rsnElementCreate2(this.mContext, elements, names, arraySizes);
    }

    public void rsnElementGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetNativeData(II[I)V", true, this);
    }

    public synchronized void nElementGetNativeData(int id2, int[] elementData) {
        this.validate();
        this.rsnElementGetNativeData(this.mContext, id2, elementData);
    }

    public void rsnElementGetSubElements(int n, int n2, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnElementGetSubElements(II[I[Ljava/lang/String;)V", true, this);
    }

    public synchronized void nElementGetSubElements(int id2, int[] IDs, String[] names) {
        this.validate();
        this.rsnElementGetSubElements(this.mContext, id2, IDs, names);
    }

    public int rsnTypeCreate(int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnTypeCreate(IIIIIZZ)I", true, this);
    }

    public synchronized int nTypeCreate(int eid, int x, int y, int z, boolean mips, boolean faces) {
        this.validate();
        return this.rsnTypeCreate(this.mContext, eid, x, y, z, mips, faces);
    }

    public void rsnTypeGetNativeData(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnTypeGetNativeData(II[I)V", true, this);
    }

    public synchronized void nTypeGetNativeData(int id2, int[] typeData) {
        this.validate();
        this.rsnTypeGetNativeData(this.mContext, id2, typeData);
    }

    public int rsnAllocationCreateTyped(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateTyped(IIII)I", true, this);
    }

    public synchronized int nAllocationCreateTyped(int type, int mip, int usage) {
        this.validate();
        return this.rsnAllocationCreateTyped(this.mContext, type, mip, usage);
    }

    public int rsnAllocationCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    public synchronized int nAllocationCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    public int rsnAllocationCubeCreateFromBitmap(int n, int n2, int n3, Bitmap bitmap, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCubeCreateFromBitmap(IIILandroid/graphics/Bitmap;I)I", true, this);
    }

    public synchronized int nAllocationCubeCreateFromBitmap(int type, int mip, Bitmap bmp, int usage) {
        this.validate();
        return this.rsnAllocationCubeCreateFromBitmap(this.mContext, type, mip, bmp, usage);
    }

    public int rsnAllocationCreateBitmapRef(int n, int n2, Bitmap bitmap) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateBitmapRef(IILandroid/graphics/Bitmap;)I", true, this);
    }

    public synchronized int nAllocationCreateBitmapRef(int type, Bitmap bmp) {
        this.validate();
        return this.rsnAllocationCreateBitmapRef(this.mContext, type, bmp);
    }

    public int rsnAllocationCreateFromAssetStream(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationCreateFromAssetStream(IIII)I", true, this);
    }

    public synchronized int nAllocationCreateFromAssetStream(int mips, int assetStream, int usage) {
        this.validate();
        return this.rsnAllocationCreateFromAssetStream(this.mContext, mips, assetStream, usage);
    }

    public void rsnAllocationCopyToBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyToBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    public synchronized void nAllocationCopyToBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyToBitmap(this.mContext, alloc, bmp);
    }

    public void rsnAllocationSyncAll(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationSyncAll(III)V", true, this);
    }

    public synchronized void nAllocationSyncAll(int alloc, int src) {
        this.validate();
        this.rsnAllocationSyncAll(this.mContext, alloc, src);
    }

    public void rsnAllocationGenerateMipmaps(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationGenerateMipmaps(II)V", true, this);
    }

    public synchronized void nAllocationGenerateMipmaps(int alloc) {
        this.validate();
        this.rsnAllocationGenerateMipmaps(this.mContext, alloc);
    }

    public void rsnAllocationCopyFromBitmap(int n, int n2, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationCopyFromBitmap(IILandroid/graphics/Bitmap;)V", true, this);
    }

    public synchronized void nAllocationCopyFromBitmap(int alloc, Bitmap bmp) {
        this.validate();
        this.rsnAllocationCopyFromBitmap(this.mContext, alloc, bmp);
    }

    public void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[II)V", true, this);
    }

    public synchronized void nAllocationData1D(int id2, int off, int mip, int count, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    public void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, short[] sArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[SI)V", true, this);
    }

    public synchronized void nAllocationData1D(int id2, int off, int mip, int count, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    public void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[BI)V", true, this);
    }

    public synchronized void nAllocationData1D(int id2, int off, int mip, int count, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    public void rsnAllocationData1D(int n, int n2, int n3, int n4, int n5, float[] fArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData1D(IIIII[FI)V", true, this);
    }

    public synchronized void nAllocationData1D(int id2, int off, int mip, int count, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData1D(this.mContext, id2, off, mip, count, d, sizeBytes);
    }

    public void rsnAllocationElementData1D(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationElementData1D(IIIII[BI)V", true, this);
    }

    public synchronized void nAllocationElementData1D(int id2, int xoff, int mip, int compIdx, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationElementData1D(this.mContext, id2, xoff, mip, compIdx, d, sizeBytes);
    }

    public void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, byte[] byArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[BI)V", true, this);
    }

    public synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, byte[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    public void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, short[] sArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[SI)V", true, this);
    }

    public synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, short[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    public void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[II)V", true, this);
    }

    public synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, int[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    public void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray, int n9) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIIII[FI)V", true, this);
    }

    public synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, int w, int h, float[] d, int sizeBytes) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, w, h, d, sizeBytes);
    }

    public void rsnAllocationData2D(int n, int n2, int n3, int n4, int n5, int n6, Bitmap bitmap) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationData2D(IIIIIILandroid/graphics/Bitmap;)V", true, this);
    }

    public synchronized void nAllocationData2D(int id2, int xoff, int yoff, int mip, int face, Bitmap b) {
        this.validate();
        this.rsnAllocationData2D(this.mContext, id2, xoff, yoff, mip, face, b);
    }

    public void rsnAllocationRead(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[B)V", true, this);
    }

    public synchronized void nAllocationRead(int id2, byte[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    public void rsnAllocationRead(int n, int n2, short[] sArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[S)V", true, this);
    }

    public synchronized void nAllocationRead(int id2, short[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    public void rsnAllocationRead(int n, int n2, int[] nArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[I)V", true, this);
    }

    public synchronized void nAllocationRead(int id2, int[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    public void rsnAllocationRead(int n, int n2, float[] fArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationRead(II[F)V", true, this);
    }

    public synchronized void nAllocationRead(int id2, float[] d) {
        this.validate();
        this.rsnAllocationRead(this.mContext, id2, d);
    }

    public int rsnAllocationGetType(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnAllocationGetType(II)I", true, this);
    }

    public synchronized int nAllocationGetType(int id2) {
        this.validate();
        return this.rsnAllocationGetType(this.mContext, id2);
    }

    public void rsnAllocationResize1D(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize1D(III)V", true, this);
    }

    public synchronized void nAllocationResize1D(int id2, int dimX) {
        this.validate();
        this.rsnAllocationResize1D(this.mContext, id2, dimX);
    }

    public void rsnAllocationResize2D(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnAllocationResize2D(IIII)V", true, this);
    }

    public synchronized void nAllocationResize2D(int id2, int dimX, int dimY) {
        this.validate();
        this.rsnAllocationResize2D(this.mContext, id2, dimX, dimY);
    }

    public int rsnFileA3DCreateFromAssetStream(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAssetStream(II)I", true, this);
    }

    public synchronized int nFileA3DCreateFromAssetStream(int assetStream) {
        this.validate();
        return this.rsnFileA3DCreateFromAssetStream(this.mContext, assetStream);
    }

    public int rsnFileA3DCreateFromFile(int n, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromFile(ILjava/lang/String;)I", true, this);
    }

    public synchronized int nFileA3DCreateFromFile(String path) {
        this.validate();
        return this.rsnFileA3DCreateFromFile(this.mContext, path);
    }

    public int rsnFileA3DCreateFromAsset(int n, AssetManager assetManager, String string2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;)I", true, this);
    }

    public synchronized int nFileA3DCreateFromAsset(AssetManager mgr, String path) {
        this.validate();
        return this.rsnFileA3DCreateFromAsset(this.mContext, mgr, path);
    }

    public int rsnFileA3DGetNumIndexEntries(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetNumIndexEntries(II)I", true, this);
    }

    public synchronized int nFileA3DGetNumIndexEntries(int fileA3D) {
        this.validate();
        return this.rsnFileA3DGetNumIndexEntries(this.mContext, fileA3D);
    }

    public void rsnFileA3DGetIndexEntries(int n, int n2, int n3, int[] nArray, String[] stringArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnFileA3DGetIndexEntries(III[I[Ljava/lang/String;)V", true, this);
    }

    public synchronized void nFileA3DGetIndexEntries(int fileA3D, int numEntries, int[] IDs, String[] names) {
        this.validate();
        this.rsnFileA3DGetIndexEntries(this.mContext, fileA3D, numEntries, IDs, names);
    }

    public int rsnFileA3DGetEntryByIndex(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFileA3DGetEntryByIndex(III)I", true, this);
    }

    public synchronized int nFileA3DGetEntryByIndex(int fileA3D, int index) {
        this.validate();
        return this.rsnFileA3DGetEntryByIndex(this.mContext, fileA3D, index);
    }

    public int rsnFontCreateFromFile(int n, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromFile(ILjava/lang/String;FI)I", true, this);
    }

    public synchronized int nFontCreateFromFile(String fileName, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromFile(this.mContext, fileName, size, dpi);
    }

    public int rsnFontCreateFromAssetStream(int n, String string2, float f, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAssetStream(ILjava/lang/String;FII)I", true, this);
    }

    public synchronized int nFontCreateFromAssetStream(String name, float size, int dpi, int assetStream) {
        this.validate();
        return this.rsnFontCreateFromAssetStream(this.mContext, name, size, dpi, assetStream);
    }

    public int rsnFontCreateFromAsset(int n, AssetManager assetManager, String string2, float f, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnFontCreateFromAsset(ILandroid/content/res/AssetManager;Ljava/lang/String;FI)I", true, this);
    }

    public synchronized int nFontCreateFromAsset(AssetManager mgr, String path, float size, int dpi) {
        this.validate();
        return this.rsnFontCreateFromAsset(this.mContext, mgr, path, size, dpi);
    }

    public void rsnScriptBindAllocation(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptBindAllocation(IIII)V", true, this);
    }

    public synchronized void nScriptBindAllocation(int script, int alloc, int slot) {
        this.validate();
        this.rsnScriptBindAllocation(this.mContext, script, alloc, slot);
    }

    public void rsnScriptSetTimeZone(int n, int n2, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetTimeZone(II[B)V", true, this);
    }

    public synchronized void nScriptSetTimeZone(int script, byte[] timeZone) {
        this.validate();
        this.rsnScriptSetTimeZone(this.mContext, script, timeZone);
    }

    public void rsnScriptInvoke(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvoke(III)V", true, this);
    }

    public synchronized void nScriptInvoke(int id2, int slot) {
        this.validate();
        this.rsnScriptInvoke(this.mContext, id2, slot);
    }

    public void rsnScriptInvokeV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptInvokeV(III[B)V", true, this);
    }

    public synchronized void nScriptInvokeV(int id2, int slot, byte[] params) {
        this.validate();
        this.rsnScriptInvokeV(this.mContext, id2, slot, params);
    }

    public void rsnScriptSetVarI(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarI(IIII)V", true, this);
    }

    public synchronized void nScriptSetVarI(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarI(this.mContext, id2, slot, val);
    }

    public void rsnScriptSetVarJ(int n, int n2, int n3, long l) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarJ(IIIJ)V", true, this);
    }

    public synchronized void nScriptSetVarJ(int id2, int slot, long val) {
        this.validate();
        this.rsnScriptSetVarJ(this.mContext, id2, slot, val);
    }

    public void rsnScriptSetVarF(int n, int n2, int n3, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarF(IIIF)V", true, this);
    }

    public synchronized void nScriptSetVarF(int id2, int slot, float val) {
        this.validate();
        this.rsnScriptSetVarF(this.mContext, id2, slot, val);
    }

    public void rsnScriptSetVarD(int n, int n2, int n3, double d) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarD(IIID)V", true, this);
    }

    public synchronized void nScriptSetVarD(int id2, int slot, double val) {
        this.validate();
        this.rsnScriptSetVarD(this.mContext, id2, slot, val);
    }

    public void rsnScriptSetVarV(int n, int n2, int n3, byte[] byArray) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarV(III[B)V", true, this);
    }

    public synchronized void nScriptSetVarV(int id2, int slot, byte[] val) {
        this.validate();
        this.rsnScriptSetVarV(this.mContext, id2, slot, val);
    }

    public void rsnScriptSetVarObj(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptSetVarObj(IIII)V", true, this);
    }

    public synchronized void nScriptSetVarObj(int id2, int slot, int val) {
        this.validate();
        this.rsnScriptSetVarObj(this.mContext, id2, slot, val);
    }

    public void rsnScriptCBegin(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptCBegin(I)V", true, this);
    }

    public synchronized void nScriptCBegin() {
        this.validate();
        this.rsnScriptCBegin(this.mContext);
    }

    public void rsnScriptCSetScript(int n, byte[] byArray, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnScriptCSetScript(I[BII)V", true, this);
    }

    public synchronized void nScriptCSetScript(byte[] script, int offset, int length) {
        this.validate();
        this.rsnScriptCSetScript(this.mContext, script, offset, length);
    }

    public int rsnScriptCCreate(int n, String string2, String string3, String string4) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnScriptCCreate(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)I", true, this);
    }

    public synchronized int nScriptCCreate(String packageName, String resName, String cacheDir) {
        this.validate();
        return this.rsnScriptCCreate(this.mContext, packageName, resName, cacheDir);
    }

    public void rsnSamplerBegin(int n) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnSamplerBegin(I)V", true, this);
    }

    public synchronized void nSamplerBegin() {
        this.validate();
        this.rsnSamplerBegin(this.mContext);
    }

    public void rsnSamplerSet(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnSamplerSet(III)V", true, this);
    }

    public synchronized void nSamplerSet(int param, int value) {
        this.validate();
        this.rsnSamplerSet(this.mContext, param, value);
    }

    public void rsnSamplerSet2(int n, int n2, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnSamplerSet2(IIF)V", true, this);
    }

    public synchronized void nSamplerSet2(int param, float value) {
        this.validate();
        this.rsnSamplerSet2(this.mContext, param, value);
    }

    public int rsnSamplerCreate(int n) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnSamplerCreate(I)I", true, this);
    }

    public synchronized int nSamplerCreate() {
        this.validate();
        return this.rsnSamplerCreate(this.mContext);
    }

    public void rsnProgramStoreBegin(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreBegin(III)V", true, this);
    }

    public synchronized void nProgramStoreBegin(int in, int out) {
        this.validate();
        this.rsnProgramStoreBegin(this.mContext, in, out);
    }

    public void rsnProgramStoreDepthFunc(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreDepthFunc(II)V", true, this);
    }

    public synchronized void nProgramStoreDepthFunc(int func) {
        this.validate();
        this.rsnProgramStoreDepthFunc(this.mContext, func);
    }

    public void rsnProgramStoreDepthMask(int n, boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreDepthMask(IZ)V", true, this);
    }

    public synchronized void nProgramStoreDepthMask(boolean enable) {
        this.validate();
        this.rsnProgramStoreDepthMask(this.mContext, enable);
    }

    public void rsnProgramStoreColorMask(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreColorMask(IZZZZ)V", true, this);
    }

    public synchronized void nProgramStoreColorMask(boolean r, boolean g, boolean b, boolean a) {
        this.validate();
        this.rsnProgramStoreColorMask(this.mContext, r, g, b, a);
    }

    public void rsnProgramStoreBlendFunc(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreBlendFunc(III)V", true, this);
    }

    public synchronized void nProgramStoreBlendFunc(int src, int dst) {
        this.validate();
        this.rsnProgramStoreBlendFunc(this.mContext, src, dst);
    }

    public void rsnProgramStoreDither(int n, boolean bl) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramStoreDither(IZ)V", true, this);
    }

    public synchronized void nProgramStoreDither(boolean enable) {
        this.validate();
        this.rsnProgramStoreDither(this.mContext, enable);
    }

    public int rsnProgramStoreCreate(int n) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramStoreCreate(I)I", true, this);
    }

    public synchronized int nProgramStoreCreate() {
        this.validate();
        return this.rsnProgramStoreCreate(this.mContext);
    }

    public int rsnProgramRasterCreate(int n, boolean bl, boolean bl2, boolean bl3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramRasterCreate(IZZZ)I", true, this);
    }

    public synchronized int nProgramRasterCreate(boolean pointSmooth, boolean lineSmooth, boolean pointSprite) {
        this.validate();
        return this.rsnProgramRasterCreate(this.mContext, pointSmooth, lineSmooth, pointSprite);
    }

    public void rsnProgramRasterSetLineWidth(int n, int n2, float f) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramRasterSetLineWidth(IIF)V", true, this);
    }

    public synchronized void nProgramRasterSetLineWidth(int pr, float v) {
        this.validate();
        this.rsnProgramRasterSetLineWidth(this.mContext, pr, v);
    }

    public void rsnProgramRasterSetCullMode(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramRasterSetCullMode(III)V", true, this);
    }

    public synchronized void nProgramRasterSetCullMode(int pr, int mode) {
        this.validate();
        this.rsnProgramRasterSetCullMode(this.mContext, pr, mode);
    }

    public void rsnProgramBindConstants(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindConstants(IIII)V", true, this);
    }

    public synchronized void nProgramBindConstants(int pv, int slot, int mID) {
        this.validate();
        this.rsnProgramBindConstants(this.mContext, pv, slot, mID);
    }

    public void rsnProgramBindTexture(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindTexture(IIII)V", true, this);
    }

    public synchronized void nProgramBindTexture(int vpf, int slot, int a) {
        this.validate();
        this.rsnProgramBindTexture(this.mContext, vpf, slot, a);
    }

    public void rsnProgramBindSampler(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnProgramBindSampler(IIII)V", true, this);
    }

    public synchronized void nProgramBindSampler(int vpf, int slot, int s) {
        this.validate();
        this.rsnProgramBindSampler(this.mContext, vpf, slot, s);
    }

    public int rsnProgramFragmentCreate(int n, String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramFragmentCreate(ILjava/lang/String;[I)I", true, this);
    }

    public synchronized int nProgramFragmentCreate(String shader, int[] params) {
        this.validate();
        return this.rsnProgramFragmentCreate(this.mContext, shader, params);
    }

    public int rsnProgramVertexCreate(int n, String string2, int[] nArray) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnProgramVertexCreate(ILjava/lang/String;[I)I", true, this);
    }

    public synchronized int nProgramVertexCreate(String shader, int[] params) {
        this.validate();
        return this.rsnProgramVertexCreate(this.mContext, shader, params);
    }

    public int rsnMeshCreate(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshCreate(III)I", true, this);
    }

    public synchronized int nMeshCreate(int vtxCount, int indexCount) {
        this.validate();
        return this.rsnMeshCreate(this.mContext, vtxCount, indexCount);
    }

    public void rsnMeshBindVertex(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshBindVertex(IIII)V", true, this);
    }

    public synchronized void nMeshBindVertex(int id2, int alloc, int slot) {
        this.validate();
        this.rsnMeshBindVertex(this.mContext, id2, alloc, slot);
    }

    public void rsnMeshBindIndex(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshBindIndex(IIIII)V", true, this);
    }

    public synchronized void nMeshBindIndex(int id2, int alloc, int prim, int slot) {
        this.validate();
        this.rsnMeshBindIndex(this.mContext, id2, alloc, prim, slot);
    }

    public void rsnMeshInitVertexAttribs(int n, int n2) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshInitVertexAttribs(II)V", true, this);
    }

    public synchronized void nMeshInitVertexAttribs(int id2) {
        this.validate();
        this.rsnMeshInitVertexAttribs(this.mContext, id2);
    }

    public int rsnMeshGetVertexBufferCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetVertexBufferCount(II)I", true, this);
    }

    public synchronized int nMeshGetVertexBufferCount(int id2) {
        this.validate();
        return this.rsnMeshGetVertexBufferCount(this.mContext, id2);
    }

    public int rsnMeshGetIndexCount(int n, int n2) {
        return OverrideMethod.invokeI("android.renderscript.RenderScript#rsnMeshGetIndexCount(II)I", true, this);
    }

    public synchronized int nMeshGetIndexCount(int id2) {
        this.validate();
        return this.rsnMeshGetIndexCount(this.mContext, id2);
    }

    public void rsnMeshGetVertices(int n, int n2, int[] nArray, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetVertices(II[II)V", true, this);
    }

    public synchronized void nMeshGetVertices(int id2, int[] vtxIds, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetVertices(this.mContext, id2, vtxIds, vtxIdCount);
    }

    public void rsnMeshGetIndices(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        OverrideMethod.invokeV("android.renderscript.RenderScript#rsnMeshGetIndices(II[I[II)V", true, this);
    }

    public synchronized void nMeshGetIndices(int id2, int[] idxIds, int[] primitives, int vtxIdCount) {
        this.validate();
        this.rsnMeshGetIndices(this.mContext, id2, idxIds, primitives, vtxIdCount);
    }

    public void setMessageHandler(RSMessageHandler msg) {
        this.mMessageCallback = msg;
    }

    public RSMessageHandler getMessageHandler() {
        return this.mMessageCallback;
    }

    public void setErrorHandler(RSErrorHandler msg) {
        this.mErrorCallback = msg;
    }

    public RSErrorHandler getErrorHandler() {
        return this.mErrorCallback;
    }

    public void validate() {
        if (this.mContext == 0) {
            throw new RSInvalidStateException("Calling RS with no Context active.");
        }
    }

    public void setPriority(Priority p) {
        this.validate();
        this.nContextSetPriority(p.mID);
    }

    public RenderScript(Context ctx) {
        this.mApplicationContext = ctx.getApplicationContext();
    }

    public Context getApplicationContext() {
        return this.mApplicationContext;
    }

    public static RenderScript create(Context ctx) {
        RenderScript rs = new RenderScript(ctx);
        rs.mDev = rs.nDeviceCreate();
        rs.mContext = rs.nContextCreate(rs.mDev, 0);
        rs.mMessageThread = new MessageThread(rs);
        rs.mMessageThread.start();
        return rs;
    }

    public void contextDump() {
        this.validate();
        this.nContextDump(0);
    }

    public void finish() {
        this.nContextFinish();
    }

    public void destroy() {
        this.validate();
        this.nContextDeinitToClient(this.mContext);
        this.mMessageThread.mRun = false;
        try {
            this.mMessageThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.nContextDestroy();
        this.mContext = 0;
        this.nDeviceDestroy(this.mDev);
        this.mDev = 0;
    }

    public boolean isAlive() {
        return this.mContext != 0;
    }

    public int safeID(BaseObj o) {
        if (o != null) {
            return o.getID();
        }
        return 0;
    }

    static {
        try {
            System.loadLibrary("rs_jni");
            RenderScript._nInit();
            sInitialized = true;
        }
        catch (UnsatisfiedLinkError e) {
            Log.e(LOG_TAG, "Error loading RS jni library: " + e);
            throw new RSRuntimeException("Error loading RS jni library: " + e);
        }
    }

    public static class MessageThread
    extends Thread {
        public RenderScript mRS;
        public boolean mRun = true;
        public int[] mAuxData = new int[2];
        public static final int RS_MESSAGE_TO_CLIENT_NONE = 0;
        public static final int RS_MESSAGE_TO_CLIENT_EXCEPTION = 1;
        public static final int RS_MESSAGE_TO_CLIENT_RESIZE = 2;
        public static final int RS_MESSAGE_TO_CLIENT_ERROR = 3;
        public static final int RS_MESSAGE_TO_CLIENT_USER = 4;
        public static final int RS_ERROR_FATAL_UNKNOWN = 4096;

        public MessageThread(RenderScript rs) {
            super("RSMessageThread");
            this.mRS = rs;
        }

        public void run() {
            int[] rbuf = new int[16];
            this.mRS.nContextInitToClient(this.mRS.mContext);
            while (this.mRun) {
                rbuf[0] = 0;
                int msg = this.mRS.nContextPeekMessage(this.mRS.mContext, this.mAuxData, true);
                int size = this.mAuxData[1];
                int subID = this.mAuxData[0];
                if (msg == 4) {
                    if (size >> 2 >= rbuf.length) {
                        rbuf = new int[size + 3 >> 2];
                    }
                    this.mRS.nContextGetUserMessage(this.mRS.mContext, rbuf);
                    if (this.mRS.mMessageCallback != null) {
                        this.mRS.mMessageCallback.mData = rbuf;
                        this.mRS.mMessageCallback.mID = subID;
                        this.mRS.mMessageCallback.mLength = size;
                        this.mRS.mMessageCallback.run();
                        continue;
                    }
                    throw new RSInvalidStateException("Received a message from the script with no message handler installed.");
                }
                if (msg == 3) {
                    String e = this.mRS.nContextGetErrorMessage(this.mRS.mContext);
                    if (subID >= 4096) {
                        throw new RSRuntimeException("Fatal error " + subID + ", details: " + e);
                    }
                    if (this.mRS.mErrorCallback == null) continue;
                    this.mRS.mErrorCallback.mErrorMessage = e;
                    this.mRS.mErrorCallback.mErrorNum = subID;
                    this.mRS.mErrorCallback.run();
                    continue;
                }
                try {
                    MessageThread.sleep(1L, 0);
                }
                catch (InterruptedException e) {}
            }
            Log.d(RenderScript.LOG_TAG, "MessageThread exiting.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        LOW(5),
        NORMAL(-4);

        public int mID;

        public Priority(int id2) {
            this.mID = id2;
        }
    }

    public static class RSErrorHandler
    implements Runnable {
        public String mErrorMessage;
        public int mErrorNum;

        public void run() {
        }
    }

    public static class RSMessageHandler
    implements Runnable {
        public int[] mData;
        public int mID;
        public int mLength;

        public void run() {
        }
    }
}

