/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.BaseObj;
import android.renderscript.RenderScript;

public class Sampler
extends BaseObj {
    public Sampler(int id2, RenderScript rs) {
        super(id2, rs);
    }

    public static Sampler CLAMP_NEAREST(RenderScript rs) {
        if (rs.mSampler_CLAMP_NEAREST == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.NEAREST);
            b.setMagnification(Value.NEAREST);
            b.setWrapS(Value.CLAMP);
            b.setWrapT(Value.CLAMP);
            rs.mSampler_CLAMP_NEAREST = b.create();
        }
        return rs.mSampler_CLAMP_NEAREST;
    }

    public static Sampler CLAMP_LINEAR(RenderScript rs) {
        if (rs.mSampler_CLAMP_LINEAR == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.LINEAR);
            b.setMagnification(Value.LINEAR);
            b.setWrapS(Value.CLAMP);
            b.setWrapT(Value.CLAMP);
            rs.mSampler_CLAMP_LINEAR = b.create();
        }
        return rs.mSampler_CLAMP_LINEAR;
    }

    public static Sampler CLAMP_LINEAR_MIP_LINEAR(RenderScript rs) {
        if (rs.mSampler_CLAMP_LINEAR_MIP_LINEAR == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.LINEAR_MIP_LINEAR);
            b.setMagnification(Value.LINEAR);
            b.setWrapS(Value.CLAMP);
            b.setWrapT(Value.CLAMP);
            rs.mSampler_CLAMP_LINEAR_MIP_LINEAR = b.create();
        }
        return rs.mSampler_CLAMP_LINEAR_MIP_LINEAR;
    }

    public static Sampler WRAP_NEAREST(RenderScript rs) {
        if (rs.mSampler_WRAP_NEAREST == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.NEAREST);
            b.setMagnification(Value.NEAREST);
            b.setWrapS(Value.WRAP);
            b.setWrapT(Value.WRAP);
            rs.mSampler_WRAP_NEAREST = b.create();
        }
        return rs.mSampler_WRAP_NEAREST;
    }

    public static Sampler WRAP_LINEAR(RenderScript rs) {
        if (rs.mSampler_WRAP_LINEAR == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.LINEAR);
            b.setMagnification(Value.LINEAR);
            b.setWrapS(Value.WRAP);
            b.setWrapT(Value.WRAP);
            rs.mSampler_WRAP_LINEAR = b.create();
        }
        return rs.mSampler_WRAP_LINEAR;
    }

    public static Sampler WRAP_LINEAR_MIP_LINEAR(RenderScript rs) {
        if (rs.mSampler_WRAP_LINEAR_MIP_LINEAR == null) {
            Builder b = new Builder(rs);
            b.setMinification(Value.LINEAR_MIP_LINEAR);
            b.setMagnification(Value.LINEAR);
            b.setWrapS(Value.WRAP);
            b.setWrapT(Value.WRAP);
            rs.mSampler_WRAP_LINEAR_MIP_LINEAR = b.create();
        }
        return rs.mSampler_WRAP_LINEAR_MIP_LINEAR;
    }

    public static class Builder {
        public RenderScript mRS;
        public Value mMin;
        public Value mMag;
        public Value mWrapS;
        public Value mWrapT;
        public Value mWrapR;
        public float mAniso;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mMin = Value.NEAREST;
            this.mMag = Value.NEAREST;
            this.mWrapS = Value.WRAP;
            this.mWrapT = Value.WRAP;
            this.mWrapR = Value.WRAP;
            this.mAniso = 1.0f;
        }

        public void setMinification(Value v) {
            if (v != Value.NEAREST && v != Value.LINEAR && v != Value.LINEAR_MIP_LINEAR && v != Value.LINEAR_MIP_NEAREST) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mMin = v;
        }

        public void setMagnification(Value v) {
            if (v != Value.NEAREST && v != Value.LINEAR) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mMag = v;
        }

        public void setWrapS(Value v) {
            if (v != Value.WRAP && v != Value.CLAMP) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mWrapS = v;
        }

        public void setWrapT(Value v) {
            if (v != Value.WRAP && v != Value.CLAMP) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mWrapT = v;
        }

        public void setAnisotropy(float v) {
            if (!(v >= 0.0f)) {
                throw new IllegalArgumentException("Invalid value");
            }
            this.mAniso = v;
        }

        public static synchronized Sampler internalCreate(RenderScript rs, Builder b) {
            rs.nSamplerBegin();
            rs.nSamplerSet(0, b.mMin.mID);
            rs.nSamplerSet(1, b.mMag.mID);
            rs.nSamplerSet(2, b.mWrapS.mID);
            rs.nSamplerSet(3, b.mWrapT.mID);
            rs.nSamplerSet(4, b.mWrapR.mID);
            rs.nSamplerSet2(5, b.mAniso);
            int id2 = rs.nSamplerCreate();
            return new Sampler(id2, rs);
        }

        public Sampler create() {
            this.mRS.validate();
            return Builder.internalCreate(this.mRS, this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Value {
        NEAREST(0),
        LINEAR(1),
        LINEAR_MIP_LINEAR(2),
        LINEAR_MIP_NEAREST(5),
        WRAP(3),
        CLAMP(4);

        public int mID;

        public Value(int id2) {
            this.mID = id2;
        }
    }
}

