/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Bitmap;
import android.graphics.Paint;
import android.text.AndroidBidi;
import android.text.Layout;
import android.text.MeasuredText;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.TabStopSpan;
import com.android.internal.util.ArrayUtils;

public class StaticLayout
extends Layout {
    public int mLineCount;
    public int mTopPadding;
    public int mBottomPadding;
    public int mColumns;
    public int mEllipsizedWidth;
    public static final int COLUMNS_NORMAL = 3;
    public static final int COLUMNS_ELLIPSIZE = 5;
    public static final int START = 0;
    public static final int DIR = 0;
    public static final int TAB = 0;
    public static final int TOP = 1;
    public static final int DESCENT = 2;
    public static final int ELLIPSIS_START = 3;
    public static final int ELLIPSIS_COUNT = 4;
    public int[] mLines;
    public Layout.Directions[] mLineDirections;
    public int mMaximumVisibleLineCount = 0;
    public static final int START_MASK = 0x1FFFFFFF;
    public static final int DIR_SHIFT = 30;
    public static final int TAB_MASK = 0x20000000;
    public static final int TAB_INCREMENT = 20;
    public static final char CHAR_FIRST_CJK = '\u2e80';
    public static final char CHAR_NEW_LINE = '\n';
    public static final char CHAR_TAB = '\t';
    public static final char CHAR_SPACE = ' ';
    public static final char CHAR_DOT = '.';
    public static final char CHAR_COMMA = ',';
    public static final char CHAR_COLON = ':';
    public static final char CHAR_SEMICOLON = ';';
    public static final char CHAR_SLASH = '/';
    public static final char CHAR_HYPHEN = '-';
    public static final double EXTRA_ROUNDING = 0.5;
    public static final String HORIZONTAL_ELLIPSIS = "\u2026";
    public static final int CHAR_FIRST_HIGH_SURROGATE = 55296;
    public static final int CHAR_LAST_LOW_SURROGATE = 57343;
    public MeasuredText mMeasured;
    public Paint.FontMetricsInt mFontMetricsInt = new Paint.FontMetricsInt();

    public StaticLayout(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, 0, source.length(), paint, width, align, spacingmult, spacingadd, includepad);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad) {
        this(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, null, 0);
    }

    public StaticLayout(CharSequence source, int bufstart, int bufend, TextPaint paint, int outerwidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, TextUtils.TruncateAt ellipsize, int ellipsizedWidth) {
        super(ellipsize == null ? source : (source instanceof Spanned ? new Layout.SpannedEllipsizer(source) : new Layout.Ellipsizer(source)), paint, outerwidth, align, spacingmult, spacingadd);
        if (ellipsize != null) {
            Layout.Ellipsizer e = (Layout.Ellipsizer)this.getText();
            e.mLayout = this;
            e.mWidth = ellipsizedWidth;
            e.mMethod = ellipsize;
            this.mEllipsizedWidth = ellipsizedWidth;
            this.mColumns = 5;
        } else {
            this.mColumns = 3;
            this.mEllipsizedWidth = outerwidth;
        }
        this.mLines = new int[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mLineDirections = new Layout.Directions[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mMeasured = MeasuredText.obtain();
        this.generate(source, bufstart, bufend, paint, outerwidth, align, spacingmult, spacingadd, includepad, includepad, ellipsizedWidth, ellipsize);
        this.mMeasured = MeasuredText.recycle(this.mMeasured);
        this.mFontMetricsInt = null;
    }

    public StaticLayout(boolean ellipsize) {
        super(null, null, 0, null, 0.0f, 0.0f);
        this.mColumns = 5;
        this.mLines = new int[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mLineDirections = new Layout.Directions[ArrayUtils.idealIntArraySize(2 * this.mColumns)];
        this.mMeasured = MeasuredText.obtain();
    }

    public void generate(CharSequence source, int bufStart, int bufEnd, TextPaint paint, int outerWidth, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, boolean trackpad, float ellipsizedWidth, TextUtils.TruncateAt ellipsize) {
        this.mLineCount = 0;
        int v = 0;
        boolean needMultiply = spacingmult != 1.0f || spacingadd != 0.0f;
        Paint.FontMetricsInt fm = this.mFontMetricsInt;
        int[] chooseHtv = null;
        MeasuredText measured = this.mMeasured;
        Spanned spanned = null;
        if (source instanceof Spanned) {
            spanned = (Spanned)source;
        }
        int DEFAULT_DIR = 1;
        int paraStart = bufStart;
        while (paraStart <= bufEnd) {
            int spanStart;
            int paraEnd = TextUtils.indexOf(source, '\n', paraStart, bufEnd);
            paraEnd = paraEnd < 0 ? bufEnd : ++paraEnd;
            int firstWidthLineLimit = this.mLineCount + 1;
            int firstWidth = outerWidth;
            int restWidth = outerWidth;
            LineHeightSpan[] chooseHt = null;
            if (spanned != null) {
                int i;
                LeadingMarginSpan[] sp = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LeadingMarginSpan.class);
                for (i = 0; i < sp.length; ++i) {
                    LeadingMarginSpan lms = sp[i];
                    firstWidth -= sp[i].getLeadingMargin(true);
                    restWidth -= sp[i].getLeadingMargin(false);
                    if (!(lms instanceof LeadingMarginSpan.LeadingMarginSpan2)) continue;
                    LeadingMarginSpan.LeadingMarginSpan2 lms2 = (LeadingMarginSpan.LeadingMarginSpan2)lms;
                    int lmsFirstLine = this.getLineForOffset(spanned.getSpanStart(lms2));
                    firstWidthLineLimit = lmsFirstLine + lms2.getLeadingMarginLineCount();
                }
                chooseHt = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, LineHeightSpan.class);
                if (chooseHt.length != 0) {
                    if (chooseHtv == null || chooseHtv.length < chooseHt.length) {
                        chooseHtv = new int[ArrayUtils.idealIntArraySize(chooseHt.length)];
                    }
                    for (i = 0; i < chooseHt.length; ++i) {
                        int o = spanned.getSpanStart(chooseHt[i]);
                        chooseHtv[i] = o < paraStart ? this.getLineTop(this.getLineForOffset(o)) : v;
                    }
                }
            }
            measured.setPara(source, paraStart, paraEnd, 2);
            char[] chs = measured.mChars;
            float[] widths = measured.mWidths;
            byte[] chdirs = measured.mLevels;
            int dir = measured.mDir;
            boolean easy = measured.mEasy;
            int width = firstWidth;
            float w = 0.0f;
            int here = paraStart;
            int ok = paraStart;
            float okWidth = w;
            int okAscent = 0;
            int okDescent = 0;
            int okTop = 0;
            int okBottom = 0;
            int fit = paraStart;
            float fitWidth = w;
            int fitAscent = 0;
            int fitDescent = 0;
            int fitTop = 0;
            int fitBottom = 0;
            boolean hasTabOrEmoji = false;
            boolean hasTab = false;
            Layout.TabStops tabStops = null;
            int spanEnd = spanStart = paraStart;
            while (spanStart < paraEnd) {
                if (spanStart == spanEnd) {
                    spanEnd = spanned == null ? paraEnd : spanned.nextSpanTransition(spanStart, paraEnd, MetricAffectingSpan.class);
                    int spanLen = spanEnd - spanStart;
                    if (spanned == null) {
                        measured.addStyleRun(paint, spanLen, fm);
                    } else {
                        MetricAffectingSpan[] spans = spanned.getSpans(spanStart, spanEnd, MetricAffectingSpan.class);
                        measured.addStyleRun(paint, spans, spanLen, fm);
                    }
                }
                int nextSpanStart = spanEnd;
                int fmTop = fm.top;
                int fmBottom = fm.bottom;
                int fmAscent = fm.ascent;
                int fmDescent = fm.descent;
                for (int j = spanStart; j < spanEnd; ++j) {
                    char c = chs[j - paraStart];
                    if (c != '\n') {
                        if (c == '\t') {
                            if (!hasTab) {
                                Object[] spans;
                                hasTab = true;
                                hasTabOrEmoji = true;
                                if (spanned != null && (spans = StaticLayout.getParagraphSpans(spanned, paraStart, paraEnd, TabStopSpan.class)).length > 0) {
                                    tabStops = new Layout.TabStops(20, spans);
                                }
                            }
                            w = tabStops != null ? tabStops.nextTab(w) : Layout.TabStops.nextDefaultStop(w, 20);
                        } else if (c >= '\ud800' && c <= '\udfff' && j + 1 < spanEnd) {
                            int emoji = Character.codePointAt(chs, j - paraStart);
                            if (emoji >= MIN_EMOJI && emoji <= MAX_EMOJI) {
                                Bitmap bm = EMOJI_FACTORY.getBitmapFromAndroidPua(emoji);
                                if (bm != null) {
                                    TextPaint whichPaint = spanned == null ? paint : this.mWorkPaint;
                                    float wid = (float)bm.getWidth() * -whichPaint.ascent() / (float)bm.getHeight();
                                    w += wid;
                                    hasTabOrEmoji = true;
                                    ++j;
                                } else {
                                    w += widths[j - paraStart];
                                }
                            } else {
                                w += widths[j - paraStart];
                            }
                        } else {
                            w += widths[j - paraStart];
                        }
                    }
                    if (w <= (float)width) {
                        fitWidth = w;
                        fit = j + 1;
                        if (fmTop < fitTop) {
                            fitTop = fmTop;
                        }
                        if (fmAscent < fitAscent) {
                            fitAscent = fmAscent;
                        }
                        if (fmDescent > fitDescent) {
                            fitDescent = fmDescent;
                        }
                        if (fmBottom > fitBottom) {
                            fitBottom = fmBottom;
                        }
                        if (c != ' ' && c != '\t' && (c != '.' && c != ',' && c != ':' && c != ';' || j - 1 >= here && Character.isDigit(chs[j - 1 - paraStart]) || j + 1 < spanEnd && Character.isDigit(chs[j + 1 - paraStart])) && (c != '/' && c != '-' || j + 1 < spanEnd && Character.isDigit(chs[j + 1 - paraStart])) && (c < '\u2e80' || !StaticLayout.isIdeographic(c, true) || j + 1 >= spanEnd || !StaticLayout.isIdeographic(chs[j + 1 - paraStart], false))) continue;
                        okWidth = w;
                        ok = j + 1;
                        if (fitTop < okTop) {
                            okTop = fitTop;
                        }
                        if (fitAscent < okAscent) {
                            okAscent = fitAscent;
                        }
                        if (fitDescent > okDescent) {
                            okDescent = fitDescent;
                        }
                        if (fitBottom <= okBottom) continue;
                        okBottom = fitBottom;
                        continue;
                    }
                    if (ok != here) {
                        while (ok < spanEnd && chs[ok - paraStart] == ' ') {
                            ++ok;
                        }
                        v = this.out(source, here, ok, okAscent, okDescent, okTop, okBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, ok == bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, okWidth, paint);
                        here = ok;
                    } else if (fit != here) {
                        v = this.out(source, here, fit, fitAscent, fitDescent, fitTop, fitBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, fit == bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, fitWidth, paint);
                        here = fit;
                    } else {
                        v = this.out(source, here, here + 1, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, here + 1 == bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, widths[here - paraStart], paint);
                        ++here;
                    }
                    j = here < spanStart ? (nextSpanStart = here) : here - 1;
                    ok = fit = here;
                    w = 0.0f;
                    fitBottom = 0;
                    fitTop = 0;
                    fitDescent = 0;
                    fitAscent = 0;
                    okBottom = 0;
                    okTop = 0;
                    okDescent = 0;
                    okAscent = 0;
                    if (--firstWidthLineLimit > 0) continue;
                    width = restWidth;
                }
                spanStart = nextSpanStart;
            }
            if (paraEnd != here) {
                if (!(fitTop | fitBottom | fitDescent | fitAscent)) {
                    paint.getFontMetricsInt(fm);
                    fitTop = fm.top;
                    fitBottom = fm.bottom;
                    fitAscent = fm.ascent;
                    fitDescent = fm.descent;
                }
                v = this.out(source, here, paraEnd, fitAscent, fitDescent, fitTop, fitBottom, v, spacingmult, spacingadd, chooseHt, chooseHtv, fm, hasTabOrEmoji, needMultiply, paraStart, chdirs, dir, easy, paraEnd == bufEnd, includepad, trackpad, chs, widths, paraStart, ellipsize, ellipsizedWidth, w, paint);
            }
            paraStart = paraEnd;
            if (paraEnd == bufEnd) break;
            paraStart = paraEnd;
        }
        if (bufEnd == bufStart || source.charAt(bufEnd - 1) == '\n') {
            paint.getFontMetricsInt(fm);
            v = this.out(source, bufEnd, bufEnd, fm.ascent, fm.descent, fm.top, fm.bottom, v, spacingmult, spacingadd, null, null, fm, false, needMultiply, bufEnd, null, DEFAULT_DIR, true, true, includepad, trackpad, null, null, bufStart, ellipsize, ellipsizedWidth, 0.0f, paint);
        }
    }

    public static boolean isIdeographic(char c, boolean includeNonStarters) {
        if (c >= '\u2e80' && c <= '\u2fff') {
            return true;
        }
        if (c == '\u3000') {
            return true;
        }
        if (c >= '\u3040' && c <= '\u309f') {
            if (!includeNonStarters) {
                switch (c) {
                    case '\u3041': 
                    case '\u3043': 
                    case '\u3045': 
                    case '\u3047': 
                    case '\u3049': 
                    case '\u3063': 
                    case '\u3083': 
                    case '\u3085': 
                    case '\u3087': 
                    case '\u308e': 
                    case '\u3095': 
                    case '\u3096': 
                    case '\u309b': 
                    case '\u309c': 
                    case '\u309d': 
                    case '\u309e': {
                        return false;
                    }
                }
            }
            return true;
        }
        if (c >= '\u30a0' && c <= '\u30ff') {
            if (!includeNonStarters) {
                switch (c) {
                    case '\u30a0': 
                    case '\u30a1': 
                    case '\u30a3': 
                    case '\u30a5': 
                    case '\u30a7': 
                    case '\u30a9': 
                    case '\u30c3': 
                    case '\u30e3': 
                    case '\u30e5': 
                    case '\u30e7': 
                    case '\u30ee': 
                    case '\u30f5': 
                    case '\u30f6': 
                    case '\u30fb': 
                    case '\u30fc': 
                    case '\u30fd': 
                    case '\u30fe': {
                        return false;
                    }
                }
            }
            return true;
        }
        if (c >= '\u3400' && c <= '\u4db5') {
            return true;
        }
        if (c >= '\u4e00' && c <= '\u9fbb') {
            return true;
        }
        if (c >= '\uf900' && c <= '\ufad9') {
            return true;
        }
        if (c >= '\ua000' && c <= '\ua48f') {
            return true;
        }
        if (c >= '\ua490' && c <= '\ua4cf') {
            return true;
        }
        if (c >= '\ufe62' && c <= '\ufe66') {
            return true;
        }
        return c >= '\uff10' && c <= '\uff19';
    }

    public int out(CharSequence text, int start, int end, int above, int below, int top, int bottom, int v, float spacingmult, float spacingadd, LineHeightSpan[] chooseHt, int[] chooseHtv, Paint.FontMetricsInt fm, boolean hasTabOrEmoji, boolean needMultiply, int pstart, byte[] chdirs, int dir, boolean easy, boolean last, boolean includePad, boolean trackPad, char[] chs, float[] widths, int widthStart, TextUtils.TruncateAt ellipsize, float ellipsisWidth, float textWidth, TextPaint paint) {
        double ex;
        int j = this.mLineCount;
        int off = j * this.mColumns;
        int want = off + this.mColumns + 1;
        int[] lines = this.mLines;
        if (want >= lines.length) {
            int nlen = ArrayUtils.idealIntArraySize(want + 1);
            int[] grow = new int[nlen];
            System.arraycopy(lines, 0, grow, 0, lines.length);
            this.mLines = grow;
            lines = grow;
            Layout.Directions[] grow2 = new Layout.Directions[nlen];
            System.arraycopy(this.mLineDirections, 0, grow2, 0, this.mLineDirections.length);
            this.mLineDirections = grow2;
        }
        if (chooseHt != null) {
            fm.ascent = above;
            fm.descent = below;
            fm.top = top;
            fm.bottom = bottom;
            for (int i = 0; i < chooseHt.length; ++i) {
                if (chooseHt[i] instanceof LineHeightSpan.WithDensity) {
                    ((LineHeightSpan.WithDensity)chooseHt[i]).chooseHeight(text, start, end, chooseHtv[i], v, fm, paint);
                    continue;
                }
                chooseHt[i].chooseHeight(text, start, end, chooseHtv[i], v, fm);
            }
            above = fm.ascent;
            below = fm.descent;
            top = fm.top;
            bottom = fm.bottom;
        }
        if (j == 0) {
            if (trackPad) {
                this.mTopPadding = top - above;
            }
            if (includePad) {
                above = top;
            }
        }
        if (last) {
            if (trackPad) {
                this.mBottomPadding = bottom - below;
            }
            if (includePad) {
                below = bottom;
            }
        }
        int extra = needMultiply ? ((ex = (double)((float)(below - above) * (spacingmult - 1.0f) + spacingadd)) >= 0.0 ? (int)(ex + 0.5) : -((int)(-ex + 0.5))) : 0;
        lines[off + 0] = start;
        lines[off + 1] = v;
        lines[off + 2] = below + extra;
        lines[off + this.mColumns + 0] = end;
        lines[off + this.mColumns + 1] = v += below - above + extra;
        if (hasTabOrEmoji) {
            int n = off + 0;
            lines[n] = lines[n] | 0x20000000;
        }
        int n = off + 0;
        lines[n] = lines[n] | dir << 30;
        Layout.Directions linedirs = DIRS_ALL_LEFT_TO_RIGHT;
        this.mLineDirections[j] = easy ? linedirs : AndroidBidi.directions(dir, chdirs, start - widthStart, chs, start - widthStart, end - start);
        if (ellipsize != null && (ellipsize != TextUtils.TruncateAt.MARQUEE || j != 0)) {
            this.calculateEllipsis(start, end, widths, widthStart, ellipsisWidth, ellipsize, j, textWidth, paint);
        }
        ++this.mLineCount;
        return v;
    }

    public void calculateEllipsis(int lineStart, int lineEnd, float[] widths, int widthStart, float avail, TextUtils.TruncateAt where, int line, float textWidth, TextPaint paint) {
        int ellipsisCount;
        int ellipsisStart;
        if (textWidth <= avail) {
            this.mLines[this.mColumns * line + 3] = 0;
            this.mLines[this.mColumns * line + 4] = 0;
            return;
        }
        float ellipsisWidth = paint.measureText(HORIZONTAL_ELLIPSIS);
        int len = lineEnd - lineStart;
        if (where == TextUtils.TruncateAt.START) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = len; i >= 0 && !((w = widths[i - 1 + lineStart - widthStart]) + sum + ellipsisWidth > avail); --i) {
                sum += w;
            }
            ellipsisStart = 0;
            ellipsisCount = i;
        } else if (where == TextUtils.TruncateAt.END || where == TextUtils.TruncateAt.MARQUEE) {
            float w;
            int i;
            float sum = 0.0f;
            for (i = 0; i < len && !((w = widths[i + lineStart - widthStart]) + sum + ellipsisWidth > avail); ++i) {
                sum += w;
            }
            ellipsisStart = i;
            ellipsisCount = len - i;
        } else {
            float w;
            float w2;
            float lsum = 0.0f;
            float rsum = 0.0f;
            int left = 0;
            int right = len;
            float ravail = (avail - ellipsisWidth) / 2.0f;
            for (right = len; right >= 0 && !((w2 = widths[right - 1 + lineStart - widthStart]) + rsum > ravail); --right) {
                rsum += w2;
            }
            float lavail = avail - ellipsisWidth - rsum;
            for (left = 0; left < right && !((w = widths[left + lineStart - widthStart]) + lsum > lavail); ++left) {
                lsum += w;
            }
            ellipsisStart = left;
            ellipsisCount = right - left;
        }
        this.mLines[this.mColumns * line + 3] = ellipsisStart;
        this.mLines[this.mColumns * line + 4] = ellipsisCount;
    }

    public int getLineForVertical(int vertical) {
        int high = this.mLineCount;
        int low = -1;
        int[] lines = this.mLines;
        while (high - low > 1) {
            int guess = high + low >> 1;
            if (lines[this.mColumns * guess + 1] > vertical) {
                high = guess;
                continue;
            }
            low = guess;
        }
        if (low < 0) {
            return 0;
        }
        return low;
    }

    public int getLineCount() {
        return this.mLineCount;
    }

    public int getLineTop(int line) {
        int top = this.mLines[this.mColumns * line + 1];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount && line != this.mLineCount) {
            top += this.getBottomPadding();
        }
        return top;
    }

    public int getLineDescent(int line) {
        int descent = this.mLines[this.mColumns * line + 2];
        if (this.mMaximumVisibleLineCount > 0 && line >= this.mMaximumVisibleLineCount - 1 && line != this.mLineCount) {
            descent += this.getBottomPadding();
        }
        return descent;
    }

    public int getLineStart(int line) {
        return this.mLines[this.mColumns * line + 0] & 0x1FFFFFFF;
    }

    public int getParagraphDirection(int line) {
        return this.mLines[this.mColumns * line + 0] >> 30;
    }

    public boolean getLineContainsTab(int line) {
        return (this.mLines[this.mColumns * line + 0] & 0x20000000) != 0;
    }

    public Layout.Directions getLineDirections(int line) {
        return this.mLineDirections[line];
    }

    public int getTopPadding() {
        return this.mTopPadding;
    }

    public int getBottomPadding() {
        return this.mBottomPadding;
    }

    public int getEllipsisCount(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 4];
    }

    public int getEllipsisStart(int line) {
        if (this.mColumns < 5) {
            return 0;
        }
        return this.mLines[this.mColumns * line + 3];
    }

    public int getEllipsizedWidth() {
        return this.mEllipsizedWidth;
    }

    public void setMaximumVisibleLineCount(int lineCount) {
        this.mMaximumVisibleLineCount = lineCount;
    }
}

