/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.text.Layout;
import android.text.Spannable;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.Touch;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.widget.TextView;

public class BaseMovementMethod
implements MovementMethod {
    public boolean canSelectArbitrarily() {
        return false;
    }

    public void initialize(TextView widget, Spannable text) {
    }

    public boolean onKeyDown(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        int movementMetaState = this.getMovementMetaState(text, event);
        boolean handled = this.handleMovementKey(widget, text, keyCode, movementMetaState, event);
        if (handled) {
            MetaKeyKeyListener.adjustMetaAfterKeypress(text);
            MetaKeyKeyListener.resetLockedMeta(text);
        }
        return handled;
    }

    public boolean onKeyOther(TextView widget, Spannable text, KeyEvent event) {
        int movementMetaState = this.getMovementMetaState(text, event);
        int keyCode = event.getKeyCode();
        if (keyCode != 0 && event.getAction() == 2) {
            int repeat = event.getRepeatCount();
            boolean handled = false;
            for (int i = 0; i < repeat && this.handleMovementKey(widget, text, keyCode, movementMetaState, event); ++i) {
                handled = true;
            }
            if (handled) {
                MetaKeyKeyListener.adjustMetaAfterKeypress(text);
                MetaKeyKeyListener.resetLockedMeta(text);
            }
            return handled;
        }
        return false;
    }

    public boolean onKeyUp(TextView widget, Spannable text, int keyCode, KeyEvent event) {
        return false;
    }

    public void onTakeFocus(TextView widget, Spannable text, int direction) {
    }

    public boolean onTouchEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public boolean onTrackballEvent(TextView widget, Spannable text, MotionEvent event) {
        return false;
    }

    public boolean onGenericMotionEvent(TextView widget, Spannable text, MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    float hscroll;
                    float vscroll;
                    if ((event.getMetaState() & 1) != 0) {
                        vscroll = 0.0f;
                        hscroll = event.getAxisValue(9);
                    } else {
                        vscroll = -event.getAxisValue(9);
                        hscroll = event.getAxisValue(10);
                    }
                    boolean handled = false;
                    if (hscroll < 0.0f) {
                        handled |= this.scrollLeft(widget, text, (int)Math.ceil(-hscroll));
                    } else if (hscroll > 0.0f) {
                        handled |= this.scrollRight(widget, text, (int)Math.ceil(hscroll));
                    }
                    if (vscroll < 0.0f) {
                        handled |= this.scrollUp(widget, text, (int)Math.ceil(-vscroll));
                    } else if (vscroll > 0.0f) {
                        handled |= this.scrollDown(widget, text, (int)Math.ceil(vscroll));
                    }
                    return handled;
                }
            }
        }
        return false;
    }

    public int getMovementMetaState(Spannable buffer, KeyEvent event) {
        int metaState = (event.getMetaState() | MetaKeyKeyListener.getMetaState(buffer)) & 0xFFFFF9FF;
        return KeyEvent.normalizeMetaState(metaState) & 0xFFFFFF3E;
    }

    public boolean handleMovementKey(TextView widget, Spannable buffer, int keyCode, int movementMetaState, KeyEvent event) {
        switch (keyCode) {
            case 21: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.left(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.lineStart(widget, buffer);
            }
            case 22: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.right(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.lineEnd(widget, buffer);
            }
            case 19: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.up(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.top(widget, buffer);
            }
            case 20: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.down(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.bottom(widget, buffer);
            }
            case 92: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.pageUp(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.top(widget, buffer);
            }
            case 93: {
                if (KeyEvent.metaStateHasNoModifiers(movementMetaState)) {
                    return this.pageDown(widget, buffer);
                }
                if (!KeyEvent.metaStateHasModifiers(movementMetaState, 2)) break;
                return this.bottom(widget, buffer);
            }
            case 122: {
                if (!KeyEvent.metaStateHasNoModifiers(movementMetaState)) break;
                return this.home(widget, buffer);
            }
            case 123: {
                if (!KeyEvent.metaStateHasNoModifiers(movementMetaState)) break;
                return this.end(widget, buffer);
            }
        }
        return false;
    }

    public boolean left(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean right(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean up(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean down(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean pageUp(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean pageDown(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean top(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean bottom(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean lineStart(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean lineEnd(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean home(TextView widget, Spannable buffer) {
        return false;
    }

    public boolean end(TextView widget, Spannable buffer) {
        return false;
    }

    public int getTopLine(TextView widget) {
        return widget.getLayout().getLineForVertical(widget.getScrollY());
    }

    public int getBottomLine(TextView widget) {
        return widget.getLayout().getLineForVertical(widget.getScrollY() + this.getInnerHeight(widget));
    }

    public int getInnerWidth(TextView widget) {
        return widget.getWidth() - widget.getTotalPaddingLeft() - widget.getTotalPaddingRight();
    }

    public int getInnerHeight(TextView widget) {
        return widget.getHeight() - widget.getTotalPaddingTop() - widget.getTotalPaddingBottom();
    }

    public int getCharacterWidth(TextView widget) {
        return (int)Math.ceil(widget.getPaint().getFontSpacing());
    }

    public int getScrollBoundsLeft(TextView widget) {
        int bottomLine;
        Layout layout2 = widget.getLayout();
        int topLine = this.getTopLine(widget);
        if (topLine > (bottomLine = this.getBottomLine(widget))) {
            return 0;
        }
        int left = Integer.MAX_VALUE;
        for (int line = topLine; line <= bottomLine; ++line) {
            int lineLeft = (int)Math.floor(layout2.getLineLeft(line));
            if (lineLeft >= left) continue;
            left = lineLeft;
        }
        return left;
    }

    public int getScrollBoundsRight(TextView widget) {
        int bottomLine;
        Layout layout2 = widget.getLayout();
        int topLine = this.getTopLine(widget);
        if (topLine > (bottomLine = this.getBottomLine(widget))) {
            return 0;
        }
        int right = Integer.MIN_VALUE;
        for (int line = topLine; line <= bottomLine; ++line) {
            int lineRight = (int)Math.ceil(layout2.getLineRight(line));
            if (lineRight <= right) continue;
            right = lineRight;
        }
        return right;
    }

    public boolean scrollLeft(TextView widget, Spannable buffer, int amount) {
        int minScrollX = this.getScrollBoundsLeft(widget);
        int scrollX = widget.getScrollX();
        if (scrollX > minScrollX) {
            scrollX = Math.max(scrollX - this.getCharacterWidth(widget) * amount, minScrollX);
            widget.scrollTo(scrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean scrollRight(TextView widget, Spannable buffer, int amount) {
        int maxScrollX = this.getScrollBoundsRight(widget) - this.getInnerWidth(widget);
        int scrollX = widget.getScrollX();
        if (scrollX < maxScrollX) {
            scrollX = Math.min(scrollX + this.getCharacterWidth(widget) * amount, maxScrollX);
            widget.scrollTo(scrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean scrollUp(TextView widget, Spannable buffer, int amount) {
        int top;
        int topLine;
        Layout layout2 = widget.getLayout();
        if (layout2.getLineTop(topLine = layout2.getLineForVertical(top = widget.getScrollY())) == top) {
            --topLine;
        }
        if (topLine >= 0) {
            topLine = Math.max(topLine - amount + 1, 0);
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(topLine));
            return true;
        }
        return false;
    }

    public boolean scrollDown(TextView widget, Spannable buffer, int amount) {
        int limit;
        Layout layout2 = widget.getLayout();
        int innerHeight = this.getInnerHeight(widget);
        int bottom = widget.getScrollY() + innerHeight;
        int bottomLine = layout2.getLineForVertical(bottom);
        if (layout2.getLineTop(bottomLine + 1) < bottom + 1) {
            ++bottomLine;
        }
        if (bottomLine <= (limit = layout2.getLineCount() - 1)) {
            bottomLine = Math.min(bottomLine + amount - 1, limit);
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(bottomLine + 1) - innerHeight);
            return true;
        }
        return false;
    }

    public boolean scrollPageUp(TextView widget, Spannable buffer) {
        int top;
        Layout layout2 = widget.getLayout();
        int topLine = layout2.getLineForVertical(top = widget.getScrollY() - this.getInnerHeight(widget));
        if (topLine >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(topLine));
            return true;
        }
        return false;
    }

    public boolean scrollPageDown(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int innerHeight = this.getInnerHeight(widget);
        int bottom = widget.getScrollY() + innerHeight + innerHeight;
        int bottomLine = layout2.getLineForVertical(bottom);
        if (bottomLine <= layout2.getLineCount() - 1) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(bottomLine + 1) - innerHeight);
            return true;
        }
        return false;
    }

    public boolean scrollTop(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        if (this.getTopLine(widget) >= 0) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(0));
            return true;
        }
        return false;
    }

    public boolean scrollBottom(TextView widget, Spannable buffer) {
        Layout layout2 = widget.getLayout();
        int lineCount = layout2.getLineCount();
        if (this.getBottomLine(widget) <= lineCount - 1) {
            Touch.scrollTo(widget, layout2, widget.getScrollX(), layout2.getLineTop(lineCount) - this.getInnerHeight(widget));
            return true;
        }
        return false;
    }

    public boolean scrollLineStart(TextView widget, Spannable buffer) {
        int minScrollX = this.getScrollBoundsLeft(widget);
        int scrollX = widget.getScrollX();
        if (scrollX > minScrollX) {
            widget.scrollTo(minScrollX, widget.getScrollY());
            return true;
        }
        return false;
    }

    public boolean scrollLineEnd(TextView widget, Spannable buffer) {
        int maxScrollX = this.getScrollBoundsRight(widget) - this.getInnerWidth(widget);
        int scrollX = widget.getScrollX();
        if (scrollX < maxScrollX) {
            widget.scrollTo(maxScrollX, widget.getScrollY());
            return true;
        }
        return false;
    }
}

