/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.AbstractSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastImmutableArraySet<T>
extends AbstractSet<T> {
    public FastIterator<T> mIterator;
    public T[] mContents;

    public FastImmutableArraySet(T[] contents) {
        this.mContents = contents;
    }

    @Override
    public Iterator<T> iterator() {
        FastIterator<T> it = this.mIterator;
        if (it == null) {
            this.mIterator = it = new FastIterator<T>(this.mContents);
        } else {
            it.mIndex = 0;
        }
        return it;
    }

    @Override
    public int size() {
        return this.mContents.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FastIterator<T>
    implements Iterator<T> {
        public final T[] mContents;
        public int mIndex;

        public FastIterator(T[] contents) {
            this.mContents = contents;
        }

        @Override
        public boolean hasNext() {
            return this.mIndex != this.mContents.length;
        }

        @Override
        public T next() {
            return this.mContents[this.mIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

