/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.SystemClock;
import android.util.Log;
import android.view.DisplayList;
import android.view.GLES20Canvas;
import android.view.GLES20DisplayList;
import android.view.GLES20Layer;
import android.view.HardwareCanvas;
import android.view.HardwareLayer;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.View;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;

public abstract class HardwareRenderer {
    public static final String LOG_TAG = "HardwareRenderer";
    public static final boolean RENDER_DIRTY_REGIONS = true;
    public static final String RENDER_DIRTY_REGIONS_PROPERTY = "hwui.render_dirty_regions";
    public static final boolean DEBUG_DIRTY_REGION = false;
    public static boolean sRendererDisabled = false;
    public boolean mEnabled;
    public boolean mRequested = true;

    public static void disable() {
        sRendererDisabled = true;
    }

    public static boolean isAvailable() {
        return GLES20Canvas.isAvailable();
    }

    public abstract void destroy(boolean var1);

    public abstract boolean initialize(SurfaceHolder var1) throws Surface.OutOfResourcesException;

    public abstract void updateSurface(SurfaceHolder var1) throws Surface.OutOfResourcesException;

    public abstract void setup(int var1, int var2);

    public abstract void draw(View var1, View.AttachInfo var2, HardwareDrawCallbacks var3, Rect var4);

    public abstract DisplayList createDisplayList(View var1);

    public abstract HardwareLayer createHardwareLayer(int var1, int var2, boolean var3);

    public void initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, SurfaceHolder holder) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(holder)) {
            this.setup(width, height);
        }
    }

    public static HardwareRenderer createGlRenderer(int glVersion, boolean translucent) {
        switch (glVersion) {
            case 2: {
                return Gl20Renderer.create(translucent);
            }
        }
        throw new IllegalArgumentException("Unknown GL version: " + glVersion);
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isRequested() {
        return this.mRequested;
    }

    public void setRequested(boolean requested) {
        this.mRequested = requested;
    }

    public static class Gl20Renderer
    extends GlRenderer {
        public GLES20Canvas mGlCanvas;

        public Gl20Renderer(boolean translucent) {
            super(2, translucent);
        }

        public GLES20Canvas createCanvas() {
            this.mGlCanvas = new GLES20Canvas(this.mTranslucent);
            return this.mGlCanvas;
        }

        public boolean canDraw() {
            return super.canDraw() && this.mGlCanvas != null;
        }

        public void onPreDraw(Rect dirty) {
            this.mGlCanvas.onPreDraw(dirty);
        }

        public void onPostDraw() {
            this.mGlCanvas.onPostDraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy(boolean full) {
            try {
                super.destroy(full);
            }
            finally {
                if (full && this.mGlCanvas != null) {
                    this.mGlCanvas = null;
                }
            }
        }

        public DisplayList createDisplayList(View v) {
            return new GLES20DisplayList(v);
        }

        public HardwareLayer createHardwareLayer(int width, int height, boolean isOpaque) {
            return new GLES20Layer(width, height, isOpaque);
        }

        public static HardwareRenderer create(boolean translucent) {
            if (GLES20Canvas.isAvailable()) {
                return new Gl20Renderer(translucent);
            }
            return null;
        }
    }

    public static abstract class GlRenderer
    extends HardwareRenderer {
        public static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
        public static final int EGL_SURFACE_TYPE = 12339;
        public static final int EGL_SWAP_BEHAVIOR_PRESERVED_BIT = 1024;
        public static final int SURFACE_STATE_ERROR = 0;
        public static final int SURFACE_STATE_SUCCESS = 1;
        public static final int SURFACE_STATE_UPDATED = 2;
        public static EGLContext sEglContext;
        public static EGL10 sEgl;
        public static EGLDisplay sEglDisplay;
        public static EGLConfig sEglConfig;
        public static Thread sEglThread;
        public EGLSurface mEglSurface;
        public GL mGl;
        public HardwareCanvas mCanvas;
        public int mFrameCount;
        public Paint mDebugPaint;
        public boolean mDirtyRegions;
        public final int mGlVersion;
        public final boolean mTranslucent;
        public boolean mDestroyed;
        public final Rect mRedrawClip = new Rect();

        public GlRenderer(int glVersion, boolean translucent) {
            this.mGlVersion = glVersion;
            this.mTranslucent = translucent;
            String dirtyProperty = System.getProperty(HardwareRenderer.RENDER_DIRTY_REGIONS_PROPERTY, "true");
            this.mDirtyRegions = "true".equalsIgnoreCase(dirtyProperty);
        }

        public static String getEGLErrorString(int error) {
            switch (error) {
                case 12288: {
                    return "EGL_SUCCESS";
                }
                case 12289: {
                    return "EGL_NOT_INITIALIZED";
                }
                case 12290: {
                    return "EGL_BAD_ACCESS";
                }
                case 12291: {
                    return "EGL_BAD_ALLOC";
                }
                case 12292: {
                    return "EGL_BAD_ATTRIBUTE";
                }
                case 12293: {
                    return "EGL_BAD_CONFIG";
                }
                case 12294: {
                    return "EGL_BAD_CONTEXT";
                }
                case 12295: {
                    return "EGL_BAD_CURRENT_SURFACE";
                }
                case 12296: {
                    return "EGL_BAD_DISPLAY";
                }
                case 12297: {
                    return "EGL_BAD_MATCH";
                }
                case 12298: {
                    return "EGL_BAD_NATIVE_PIXMAP";
                }
                case 12299: {
                    return "EGL_BAD_NATIVE_WINDOW";
                }
                case 12300: {
                    return "EGL_BAD_PARAMETER";
                }
                case 12301: {
                    return "EGL_BAD_SURFACE";
                }
                case 12302: {
                    return "EGL_CONTEXT_LOST";
                }
            }
            return "0x" + Integer.toHexString(error);
        }

        public void checkEglErrors() {
            int error;
            if (this.isEnabled() && (error = sEgl.eglGetError()) != 12288) {
                this.fallback(error != 12302);
                Log.w(HardwareRenderer.LOG_TAG, "EGL error: " + GlRenderer.getEGLErrorString(error));
            }
        }

        public void fallback(boolean fallback) {
            this.destroy(true);
            if (fallback) {
                this.setRequested(false);
                Log.w(HardwareRenderer.LOG_TAG, "Mountain View, we've had a problem here. Switching back to software rendering.");
            }
        }

        public boolean initialize(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (this.isRequested() && !this.isEnabled()) {
                this.initializeEgl();
                this.mGl = this.createEglSurface(holder);
                this.mDestroyed = false;
                if (this.mGl != null) {
                    int err = sEgl.eglGetError();
                    if (err != 12288) {
                        this.destroy(true);
                        this.setRequested(false);
                    } else {
                        if (this.mCanvas == null) {
                            this.mCanvas = this.createCanvas();
                        }
                        if (this.mCanvas != null) {
                            this.setEnabled(true);
                        } else {
                            Log.w(HardwareRenderer.LOG_TAG, "Hardware accelerated Canvas could not be created");
                        }
                    }
                    return this.mCanvas != null;
                }
            }
            return false;
        }

        public void updateSurface(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (this.isRequested() && this.isEnabled()) {
                this.createEglSurface(holder);
            }
        }

        public abstract GLES20Canvas createCanvas();

        public void initializeEgl() {
            if (sEglContext != null) {
                return;
            }
            sEglThread = Thread.currentThread();
            sEgl = (EGL10)EGLContext.getEGL();
            sEglDisplay = sEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            if (sEglDisplay == EGL10.EGL_NO_DISPLAY) {
                throw new RuntimeException("eglGetDisplay failed " + GlRenderer.getEGLErrorString(sEgl.eglGetError()));
            }
            int[] version = new int[2];
            if (!sEgl.eglInitialize(sEglDisplay, version)) {
                throw new RuntimeException("eglInitialize failed " + GlRenderer.getEGLErrorString(sEgl.eglGetError()));
            }
            sEglConfig = this.getConfigChooser(this.mGlVersion).chooseConfig(sEgl, sEglDisplay);
            if (sEglConfig == null) {
                if (this.mDirtyRegions) {
                    this.mDirtyRegions = false;
                    sEglConfig = this.getConfigChooser(this.mGlVersion).chooseConfig(sEgl, sEglDisplay);
                    if (sEglConfig == null) {
                        throw new RuntimeException("eglConfig not initialized");
                    }
                } else {
                    throw new RuntimeException("eglConfig not initialized");
                }
            }
            sEglContext = this.createContext(sEgl, sEglDisplay, sEglConfig);
        }

        public GL createEglSurface(SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (sEgl == null) {
                throw new RuntimeException("egl not initialized");
            }
            if (sEglDisplay == null) {
                throw new RuntimeException("eglDisplay not initialized");
            }
            if (sEglConfig == null) {
                throw new RuntimeException("eglConfig not initialized");
            }
            if (Thread.currentThread() != sEglThread) {
                throw new IllegalStateException("HardwareRenderer cannot be used from multiple threads");
            }
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
            }
            this.mEglSurface = sEgl.eglCreateWindowSurface(sEglDisplay, sEglConfig, holder, null);
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = sEgl.eglGetError();
                if (error == 12299) {
                    Log.e(HardwareRenderer.LOG_TAG, "createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                    return null;
                }
                throw new RuntimeException("createWindowSurface failed " + GlRenderer.getEGLErrorString(error));
            }
            if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, sEglContext)) {
                throw new Surface.OutOfResourcesException("eglMakeCurrent failed " + GlRenderer.getEGLErrorString(sEgl.eglGetError()));
            }
            if (this.mDirtyRegions && !GLES20Canvas.preserveBackBuffer()) {
                Log.w(HardwareRenderer.LOG_TAG, "Backbuffer cannot be preserved");
            }
            return sEglContext.getGL();
        }

        public EGLContext createContext(EGL10 egl, EGLDisplay eglDisplay, EGLConfig eglConfig) {
            int[] attrib_list = new int[]{12440, this.mGlVersion, 12344};
            return egl.eglCreateContext(eglDisplay, eglConfig, EGL10.EGL_NO_CONTEXT, (int[])(this.mGlVersion != 0 ? attrib_list : null));
        }

        public void initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, SurfaceHolder holder) throws Surface.OutOfResourcesException {
            if (this.isRequested()) {
                this.checkEglErrors();
                super.initializeIfNeeded(width, height, attachInfo, holder);
            }
        }

        public void destroy(boolean full) {
            if (full && this.mCanvas != null) {
                this.mCanvas = null;
            }
            if (!this.isEnabled() || this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            sEgl.eglMakeCurrent(sEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            sEgl.eglDestroySurface(sEglDisplay, this.mEglSurface);
            this.mEglSurface = null;
            this.mGl = null;
            this.setEnabled(false);
        }

        public void setup(int width, int height) {
            this.mCanvas.setViewport(width, height);
        }

        public boolean canDraw() {
            return this.mGl != null && this.mCanvas != null;
        }

        public void onPreDraw(Rect dirty) {
        }

        public void onPostDraw() {
        }

        public EglConfigChooser getConfigChooser(int glVersion) {
            return new ComponentSizeChooser(glVersion, 8, 8, 8, 8, 0, 0, this.mDirtyRegions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void draw(View view, View.AttachInfo attachInfo, HardwareDrawCallbacks callbacks, Rect dirty) {
            if (this.canDraw()) {
                if (!this.mDirtyRegions) {
                    dirty = null;
                }
                attachInfo.mDrawingTime = SystemClock.uptimeMillis();
                attachInfo.mIgnoreDirtyState = true;
                view.mPrivateFlags |= 0x20;
                int surfaceState = this.checkCurrent();
                if (surfaceState != 0) {
                    if (surfaceState == 2) {
                        dirty = null;
                    }
                    this.onPreDraw(dirty);
                    HardwareCanvas canvas = this.mCanvas;
                    attachInfo.mHardwareCanvas = canvas;
                    int saveCount = canvas.save();
                    callbacks.onHardwarePreDraw(canvas);
                    try {
                        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
                        view.mPrivateFlags &= Integer.MAX_VALUE;
                        DisplayList displayList = view.getDisplayList();
                        if (displayList != null) {
                            if (canvas.drawDisplayList(displayList, view.getWidth(), view.getHeight(), this.mRedrawClip)) {
                                if (this.mRedrawClip.isEmpty() || view.getParent() == null) {
                                    view.invalidate();
                                } else {
                                    view.getParent().invalidateChild(view, this.mRedrawClip);
                                }
                                this.mRedrawClip.setEmpty();
                            }
                        } else {
                            view.draw(canvas);
                        }
                    }
                    finally {
                        callbacks.onHardwarePostDraw(canvas);
                        canvas.restoreToCount(saveCount);
                        view.mRecreateDisplayList = false;
                    }
                    this.onPostDraw();
                    attachInfo.mIgnoreDirtyState = false;
                    sEgl.eglSwapBuffers(sEglDisplay, this.mEglSurface);
                    this.checkEglErrors();
                }
            }
        }

        public int checkCurrent() {
            if (!sEglContext.equals(sEgl.eglGetCurrentContext()) || !this.mEglSurface.equals(sEgl.eglGetCurrentSurface(12377))) {
                if (!sEgl.eglMakeCurrent(sEglDisplay, this.mEglSurface, this.mEglSurface, sEglContext)) {
                    this.fallback(true);
                    Log.e(HardwareRenderer.LOG_TAG, "eglMakeCurrent failed " + GlRenderer.getEGLErrorString(sEgl.eglGetError()));
                    return 0;
                }
                return 2;
            }
            return 1;
        }

        public static class ComponentSizeChooser
        extends EglConfigChooser {
            public int[] mValue = new int[1];
            public final int mRedSize;
            public final int mGreenSize;
            public final int mBlueSize;
            public final int mAlphaSize;
            public final int mDepthSize;
            public final int mStencilSize;
            public final boolean mDirtyRegions;

            public ComponentSizeChooser(int glVersion, int redSize, int greenSize, int blueSize, int alphaSize, int depthSize, int stencilSize, boolean dirtyRegions) {
                super(glVersion, new int[]{12324, redSize, 12323, greenSize, 12322, blueSize, 12321, alphaSize, 12325, depthSize, 12326, stencilSize, 12339, 4 | (dirtyRegions ? 1024 : 0), 12344});
                this.mRedSize = redSize;
                this.mGreenSize = greenSize;
                this.mBlueSize = blueSize;
                this.mAlphaSize = alphaSize;
                this.mDepthSize = depthSize;
                this.mStencilSize = stencilSize;
                this.mDirtyRegions = dirtyRegions;
            }

            public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
                for (EGLConfig config : configs) {
                    int surfaceType;
                    int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                    int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                    if (d < this.mDepthSize || s < this.mStencilSize) continue;
                    int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                    int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                    int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                    int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                    boolean backBuffer = this.mDirtyRegions ? ((surfaceType = this.findConfigAttrib(egl, display, config, 12339, 0)) & 0x400) != 0 : true;
                    if (r < this.mRedSize || g < this.mGreenSize || b < this.mBlueSize || a < this.mAlphaSize || !backBuffer) continue;
                    return config;
                }
                return null;
            }

            public int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
                if (egl.eglGetConfigAttrib(display, config, attribute, this.mValue)) {
                    return this.mValue[0];
                }
                return defaultValue;
            }
        }

        public static abstract class EglConfigChooser {
            public final int[] mConfigSpec;
            public final int mGlVersion;

            public EglConfigChooser(int glVersion, int[] configSpec) {
                this.mGlVersion = glVersion;
                this.mConfigSpec = this.filterConfigSpec(configSpec);
            }

            public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
                int[] index = new int[1];
                if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, index)) {
                    throw new IllegalArgumentException("eglChooseConfig failed " + GlRenderer.getEGLErrorString(egl.eglGetError()));
                }
                int numConfigs = index[0];
                if (numConfigs <= 0) {
                    throw new IllegalArgumentException("No configs match configSpec");
                }
                EGLConfig[] configs = new EGLConfig[numConfigs];
                if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, numConfigs, index)) {
                    throw new IllegalArgumentException("eglChooseConfig failed " + GlRenderer.getEGLErrorString(egl.eglGetError()));
                }
                EGLConfig config = this.chooseConfig(egl, display, configs);
                if (config == null) {
                    throw new IllegalArgumentException("No config chosen");
                }
                return config;
            }

            public abstract EGLConfig chooseConfig(EGL10 var1, EGLDisplay var2, EGLConfig[] var3);

            public int[] filterConfigSpec(int[] configSpec) {
                if (this.mGlVersion != 2) {
                    return configSpec;
                }
                int len = configSpec.length;
                int[] newConfigSpec = new int[len + 2];
                System.arraycopy(configSpec, 0, newConfigSpec, 0, len - 1);
                newConfigSpec[len - 1] = 12352;
                newConfigSpec[len] = 4;
                newConfigSpec[len + 1] = 12344;
                return newConfigSpec;
            }
        }
    }

    public static interface HardwareDrawCallbacks {
        public void onHardwarePreDraw(Canvas var1);

        public void onHardwarePostDraw(Canvas var1);
    }
}

