/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.IWindowManager;
import android.view.KeyCharacterMap;
import android.view.MotionEvent;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDevice
implements Parcelable {
    public int mId;
    public String mName;
    public int mSources;
    public int mKeyboardType;
    public final ArrayList<MotionRange> mMotionRanges = new ArrayList();
    public static final int SOURCE_CLASS_MASK = 255;
    public static final int SOURCE_CLASS_BUTTON = 1;
    public static final int SOURCE_CLASS_POINTER = 2;
    public static final int SOURCE_CLASS_TRACKBALL = 4;
    public static final int SOURCE_CLASS_POSITION = 8;
    public static final int SOURCE_CLASS_JOYSTICK = 16;
    public static final int SOURCE_UNKNOWN = 0;
    public static final int SOURCE_KEYBOARD = 257;
    public static final int SOURCE_DPAD = 513;
    public static final int SOURCE_GAMEPAD = 1025;
    public static final int SOURCE_TOUCHSCREEN = 4098;
    public static final int SOURCE_MOUSE = 8194;
    public static final int SOURCE_TRACKBALL = 65540;
    public static final int SOURCE_TOUCHPAD = 0x100008;
    public static final int SOURCE_JOYSTICK = 0x1000010;
    public static final int SOURCE_ANY = -256;
    @Deprecated
    public static final int MOTION_RANGE_X = 0;
    @Deprecated
    public static final int MOTION_RANGE_Y = 1;
    @Deprecated
    public static final int MOTION_RANGE_PRESSURE = 2;
    @Deprecated
    public static final int MOTION_RANGE_SIZE = 3;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MAJOR = 4;
    @Deprecated
    public static final int MOTION_RANGE_TOUCH_MINOR = 5;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MAJOR = 6;
    @Deprecated
    public static final int MOTION_RANGE_TOOL_MINOR = 7;
    @Deprecated
    public static final int MOTION_RANGE_ORIENTATION = 8;
    public static final int KEYBOARD_TYPE_NONE = 0;
    public static final int KEYBOARD_TYPE_NON_ALPHABETIC = 1;
    public static final int KEYBOARD_TYPE_ALPHABETIC = 2;
    public static final Parcelable.Creator<InputDevice> CREATOR = new Parcelable.Creator<InputDevice>(){

        @Override
        public InputDevice createFromParcel(Parcel in) {
            InputDevice result = new InputDevice(null);
            result.readFromParcel(in);
            return result;
        }

        public InputDevice[] newArray(int size) {
            return new InputDevice[size];
        }
    };

    public InputDevice() {
    }

    public static InputDevice getDevice(int id2) {
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            return wm.getInputDevice(id2);
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Could not get input device information from Window Manager.", ex);
        }
    }

    public static int[] getDeviceIds() {
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        try {
            return wm.getInputDeviceIds();
        }
        catch (RemoteException ex) {
            throw new RuntimeException("Could not get input device ids from Window Manager.", ex);
        }
    }

    public int getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public int getSources() {
        return this.mSources;
    }

    public int getKeyboardType() {
        return this.mKeyboardType;
    }

    public KeyCharacterMap getKeyCharacterMap() {
        return KeyCharacterMap.load(this.mId);
    }

    public MotionRange getMotionRange(int axis) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis) continue;
            return range;
        }
        return null;
    }

    public MotionRange getMotionRange(int axis, int source) {
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            if (range.mAxis != axis || range.mSource != source) continue;
            return range;
        }
        return null;
    }

    public List<MotionRange> getMotionRanges() {
        return this.mMotionRanges;
    }

    public void addMotionRange(int axis, int source, float min, float max, float flat, float fuzz) {
        this.mMotionRanges.add(new MotionRange(axis, source, min, max, flat, fuzz, null));
    }

    public void readFromParcel(Parcel in) {
        int axis;
        this.mId = in.readInt();
        this.mName = in.readString();
        this.mSources = in.readInt();
        this.mKeyboardType = in.readInt();
        while ((axis = in.readInt()) >= 0) {
            this.addMotionRange(axis, in.readInt(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
        }
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mId);
        out.writeString(this.mName);
        out.writeInt(this.mSources);
        out.writeInt(this.mKeyboardType);
        int numRanges = this.mMotionRanges.size();
        for (int i = 0; i < numRanges; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            out.writeInt(range.mAxis);
            out.writeInt(range.mSource);
            out.writeFloat(range.mMin);
            out.writeFloat(range.mMax);
            out.writeFloat(range.mFlat);
            out.writeFloat(range.mFuzz);
        }
        out.writeInt(-1);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        StringBuilder description = new StringBuilder();
        description.append("Input Device ").append(this.mId).append(": ").append(this.mName).append("\n");
        description.append("  Keyboard Type: ");
        switch (this.mKeyboardType) {
            case 0: {
                description.append("none");
                break;
            }
            case 1: {
                description.append("non-alphabetic");
                break;
            }
            case 2: {
                description.append("alphabetic");
            }
        }
        description.append("\n");
        description.append("  Sources: 0x").append(Integer.toHexString(this.mSources)).append(" (");
        this.appendSourceDescriptionIfApplicable(description, 257, "keyboard");
        this.appendSourceDescriptionIfApplicable(description, 513, "dpad");
        this.appendSourceDescriptionIfApplicable(description, 4098, "touchscreen");
        this.appendSourceDescriptionIfApplicable(description, 8194, "mouse");
        this.appendSourceDescriptionIfApplicable(description, 65540, "trackball");
        this.appendSourceDescriptionIfApplicable(description, 0x100008, "touchpad");
        this.appendSourceDescriptionIfApplicable(description, 0x1000010, "joystick");
        this.appendSourceDescriptionIfApplicable(description, 1025, "gamepad");
        description.append(" )\n");
        int numAxes = this.mMotionRanges.size();
        for (int i = 0; i < numAxes; ++i) {
            MotionRange range = this.mMotionRanges.get(i);
            description.append("    ").append(MotionEvent.axisToString(range.mAxis));
            description.append(": source=0x").append(Integer.toHexString(range.mSource));
            description.append(" min=").append(range.mMin);
            description.append(" max=").append(range.mMax);
            description.append(" flat=").append(range.mFlat);
            description.append(" fuzz=").append(range.mFuzz);
            description.append("\n");
        }
        return description.toString();
    }

    public void appendSourceDescriptionIfApplicable(StringBuilder description, int source, String sourceName) {
        if ((this.mSources & source) == source) {
            description.append(" ");
            description.append(sourceName);
        }
    }

    public /* synthetic */ InputDevice(1 x0) {
        this();
    }

    public static class MotionRange {
        public int mAxis;
        public int mSource;
        public float mMin;
        public float mMax;
        public float mFlat;
        public float mFuzz;

        public MotionRange(int axis, int source, float min, float max, float flat, float fuzz) {
            this.mAxis = axis;
            this.mSource = source;
            this.mMin = min;
            this.mMax = max;
            this.mFlat = flat;
            this.mFuzz = fuzz;
        }

        public int getAxis() {
            return this.mAxis;
        }

        public int getSource() {
            return this.mSource;
        }

        public float getMin() {
            return this.mMin;
        }

        public float getMax() {
            return this.mMax;
        }

        public float getRange() {
            return this.mMax - this.mMin;
        }

        public float getFlat() {
            return this.mFlat;
        }

        public float getFuzz() {
            return this.mFuzz;
        }

        public /* synthetic */ MotionRange(int x0, int x1, float x2, float x3, float x4, float x5, 1 x6) {
            this(x0, x1, x2, x3, x4, x5);
        }
    }
}

