/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.InputEvent;
import android.view.KeyEvent;
import com.android.tools.layoutlib.create.OverrideMethod;

public class MotionEvent
extends InputEvent
implements Parcelable {
    public static final long NS_PER_MS = 1000000L;
    public static final boolean TRACK_RECYCLED_LOCATION = false;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_HOVER_MOVE = 7;
    public static final int ACTION_SCROLL = 8;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int AXIS_X = 0;
    public static final int AXIS_Y = 1;
    public static final int AXIS_PRESSURE = 2;
    public static final int AXIS_SIZE = 3;
    public static final int AXIS_TOUCH_MAJOR = 4;
    public static final int AXIS_TOUCH_MINOR = 5;
    public static final int AXIS_TOOL_MAJOR = 6;
    public static final int AXIS_TOOL_MINOR = 7;
    public static final int AXIS_ORIENTATION = 8;
    public static final int AXIS_VSCROLL = 9;
    public static final int AXIS_HSCROLL = 10;
    public static final int AXIS_Z = 11;
    public static final int AXIS_RX = 12;
    public static final int AXIS_RY = 13;
    public static final int AXIS_RZ = 14;
    public static final int AXIS_HAT_X = 15;
    public static final int AXIS_HAT_Y = 16;
    public static final int AXIS_LTRIGGER = 17;
    public static final int AXIS_RTRIGGER = 18;
    public static final int AXIS_THROTTLE = 19;
    public static final int AXIS_RUDDER = 20;
    public static final int AXIS_WHEEL = 21;
    public static final int AXIS_GAS = 22;
    public static final int AXIS_BRAKE = 23;
    public static final int AXIS_GENERIC_1 = 32;
    public static final int AXIS_GENERIC_2 = 33;
    public static final int AXIS_GENERIC_3 = 34;
    public static final int AXIS_GENERIC_4 = 35;
    public static final int AXIS_GENERIC_5 = 36;
    public static final int AXIS_GENERIC_6 = 37;
    public static final int AXIS_GENERIC_7 = 38;
    public static final int AXIS_GENERIC_8 = 39;
    public static final int AXIS_GENERIC_9 = 40;
    public static final int AXIS_GENERIC_10 = 41;
    public static final int AXIS_GENERIC_11 = 42;
    public static final int AXIS_GENERIC_12 = 43;
    public static final int AXIS_GENERIC_13 = 44;
    public static final int AXIS_GENERIC_14 = 45;
    public static final int AXIS_GENERIC_15 = 46;
    public static final int AXIS_GENERIC_16 = 47;
    public static final SparseArray<String> AXIS_SYMBOLIC_NAMES = new SparseArray();
    public static final int HISTORY_CURRENT = Integer.MIN_VALUE;
    public static final int MAX_RECYCLED = 10;
    public static final Object gRecyclerLock;
    public static int gRecyclerUsed;
    public static MotionEvent gRecyclerTop;
    public static final PointerCoords[] gTmpPointerCoords;
    public static final int[] gTmpPointerIds;
    public int mNativePtr;
    public MotionEvent mNext;
    public RuntimeException mRecycledLocation;
    public boolean mRecycled;
    public static final Parcelable.Creator<MotionEvent> CREATOR;

    public static void populateAxisSymbolicNames() {
        SparseArray<String> names = AXIS_SYMBOLIC_NAMES;
        names.append(0, "AXIS_X");
        names.append(1, "AXIS_Y");
        names.append(2, "AXIS_PRESSURE");
        names.append(3, "AXIS_SIZE");
        names.append(4, "AXIS_TOUCH_MAJOR");
        names.append(5, "AXIS_TOUCH_MINOR");
        names.append(6, "AXIS_TOOL_MAJOR");
        names.append(7, "AXIS_TOOL_MINOR");
        names.append(8, "AXIS_ORIENTATION");
        names.append(9, "AXIS_VSCROLL");
        names.append(10, "AXIS_HSCROLL");
        names.append(11, "AXIS_Z");
        names.append(12, "AXIS_RX");
        names.append(13, "AXIS_RY");
        names.append(14, "AXIS_RZ");
        names.append(15, "AXIS_HAT_X");
        names.append(16, "AXIS_HAT_Y");
        names.append(17, "AXIS_LTRIGGER");
        names.append(18, "AXIS_RTRIGGER");
        names.append(19, "AXIS_THROTTLE");
        names.append(20, "AXIS_RUDDER");
        names.append(21, "AXIS_WHEEL");
        names.append(22, "AXIS_GAS");
        names.append(23, "AXIS_BRAKE");
        names.append(32, "AXIS_GENERIC_1");
        names.append(33, "AXIS_GENERIC_2");
        names.append(34, "AXIS_GENERIC_3");
        names.append(35, "AXIS_GENERIC_4");
        names.append(36, "AXIS_GENERIC_5");
        names.append(37, "AXIS_GENERIC_6");
        names.append(38, "AXIS_GENERIC_7");
        names.append(39, "AXIS_GENERIC_8");
        names.append(40, "AXIS_GENERIC_9");
        names.append(41, "AXIS_GENERIC_10");
        names.append(42, "AXIS_GENERIC_11");
        names.append(43, "AXIS_GENERIC_12");
        names.append(44, "AXIS_GENERIC_13");
        names.append(45, "AXIS_GENERIC_14");
        names.append(46, "AXIS_GENERIC_15");
        names.append(47, "AXIS_GENERIC_16");
    }

    public static int nativeInitialize(int n, int n2, int n3, int n4, int n5, int n6, int n7, float f, float f2, float f3, float f4, long l, long l2, int n8, int[] nArray, PointerCoords[] pointerCoordsArray) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeInitialize(IIIIIIIFFFFJJI[I[Landroid/view/MotionEvent$PointerCoords;)I", true, null);
    }

    public static int nativeCopy(int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeCopy(IIZ)I", true, null);
    }

    public static void nativeDispose(int n) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeDispose(I)V", true, null);
    }

    public static void nativeAddBatch(int n, long l, PointerCoords[] pointerCoordsArray, int n2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeAddBatch(IJ[Landroid/view/MotionEvent$PointerCoords;I)V", true, null);
    }

    public static int nativeGetDeviceId(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetDeviceId(I)I", true, null);
    }

    public static int nativeGetSource(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetSource(I)I", true, null);
    }

    public static int nativeSetSource(int n, int n2) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeSetSource(II)I", true, null);
    }

    public static int nativeGetAction(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetAction(I)I", true, null);
    }

    public static void nativeSetAction(int n, int n2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetAction(II)V", true, null);
    }

    public static boolean nativeIsTouchEvent(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeIsTouchEvent(I)Z", true, null) != 0;
    }

    public static int nativeGetFlags(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetFlags(I)I", true, null);
    }

    public static int nativeGetEdgeFlags(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetEdgeFlags(I)I", true, null);
    }

    public static void nativeSetEdgeFlags(int n, int n2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeSetEdgeFlags(II)V", true, null);
    }

    public static int nativeGetMetaState(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetMetaState(I)I", true, null);
    }

    public static void nativeOffsetLocation(int n, float f, float f2) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeOffsetLocation(IFF)V", true, null);
    }

    public static float nativeGetXPrecision(int n) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetXPrecision(I)F", true, null);
    }

    public static float nativeGetYPrecision(int n) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetYPrecision(I)F", true, null);
    }

    public static long nativeGetDownTimeNanos(int n) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeGetDownTimeNanos(I)J", true, null);
    }

    public static int nativeGetPointerCount(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetPointerCount(I)I", true, null);
    }

    public static int nativeGetPointerId(int n, int n2) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetPointerId(II)I", true, null);
    }

    public static int nativeFindPointerIndex(int n, int n2) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeFindPointerIndex(II)I", true, null);
    }

    public static int nativeGetHistorySize(int n) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeGetHistorySize(I)I", true, null);
    }

    public static long nativeGetEventTimeNanos(int n, int n2) {
        return OverrideMethod.invokeL("android.view.MotionEvent#nativeGetEventTimeNanos(II)J", true, null);
    }

    public static float nativeGetRawAxisValue(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetRawAxisValue(IIII)F", true, null);
    }

    public static float nativeGetAxisValue(int n, int n2, int n3, int n4) {
        return OverrideMethod.invokeF("android.view.MotionEvent#nativeGetAxisValue(IIII)F", true, null);
    }

    public static void nativeGetPointerCoords(int n, int n2, int n3, PointerCoords pointerCoords) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeGetPointerCoords(IIILandroid/view/MotionEvent$PointerCoords;)V", true, null);
    }

    public static void nativeScale(int n, float f) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeScale(IF)V", true, null);
    }

    public static void nativeTransform(int n, Matrix matrix) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeTransform(ILandroid/graphics/Matrix;)V", true, null);
    }

    public static int nativeReadFromParcel(int n, Parcel parcel) {
        return OverrideMethod.invokeI("android.view.MotionEvent#nativeReadFromParcel(ILandroid/os/Parcel;)I", true, null);
    }

    public static void nativeWriteToParcel(int n, Parcel parcel) {
        OverrideMethod.invokeV("android.view.MotionEvent#nativeWriteToParcel(ILandroid/os/Parcel;)V", true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.mNativePtr != 0) {
                MotionEvent.nativeDispose(this.mNativePtr);
                this.mNativePtr = 0;
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain() {
        MotionEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            ev = gRecyclerTop;
            if (ev == null) {
                return new MotionEvent();
            }
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mRecycledLocation = null;
        ev.mRecycled = false;
        ev.mNext = null;
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointers, int[] pointerIds, PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, source, action, flags, edgeFlags, metaState, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, pointers, pointerIds, pointerCoords);
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        PointerCoords[] pointerCoordsArray = gTmpPointerCoords;
        synchronized (gTmpPointerCoords) {
            PointerCoords pc = gTmpPointerCoords[0];
            pc.clear();
            pc.x = x;
            pc.y = y;
            pc.pressure = pressure;
            pc.size = size;
            MotionEvent ev = MotionEvent.obtain();
            ev.mNativePtr = MotionEvent.nativeInitialize(ev.mNativePtr, deviceId, 0, action, 0, edgeFlags, metaState, 0.0f, 0.0f, xPrecision, yPrecision, downTime * 1000000L, eventTime * 1000000L, 1, gTmpPointerIds, gTmpPointerCoords);
            // ** MonitorExit[var14_12] (shouldn't be in output)
            return ev;
        }
    }

    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointers, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags);
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, 1.0f, 1.0f, metaState, 1.0f, 1.0f, 0, 0);
    }

    public static MotionEvent obtain(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, true);
        return ev;
    }

    public static MotionEvent obtainNoHistory(MotionEvent other) {
        if (other == null) {
            throw new IllegalArgumentException("other motion event must not be null");
        }
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeCopy(ev.mNativePtr, other.mNativePtr, false);
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public void scale(float scale) {
        MotionEvent.nativeScale(this.mNativePtr, scale);
    }

    public int getDeviceId() {
        return MotionEvent.nativeGetDeviceId(this.mNativePtr);
    }

    public int getSource() {
        return MotionEvent.nativeGetSource(this.mNativePtr);
    }

    public void setSource(int source) {
        MotionEvent.nativeSetSource(this.mNativePtr, source);
    }

    public int getAction() {
        return MotionEvent.nativeGetAction(this.mNativePtr);
    }

    public int getActionMasked() {
        return MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF;
    }

    public int getActionIndex() {
        return (MotionEvent.nativeGetAction(this.mNativePtr) & 0xFF00) >> 8;
    }

    public boolean isTouchEvent() {
        return MotionEvent.nativeIsTouchEvent(this.mNativePtr);
    }

    public int getFlags() {
        return MotionEvent.nativeGetFlags(this.mNativePtr);
    }

    public long getDownTime() {
        return MotionEvent.nativeGetDownTimeNanos(this.mNativePtr) / 1000000L;
    }

    public long getEventTime() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE) / 1000000L;
    }

    public long getEventTimeNano() {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, Integer.MIN_VALUE);
    }

    public float getX() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public float getY() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public float getPressure() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, Integer.MIN_VALUE);
    }

    public float getSize() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, Integer.MIN_VALUE);
    }

    public float getTouchMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, Integer.MIN_VALUE);
    }

    public float getTouchMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, Integer.MIN_VALUE);
    }

    public float getToolMajor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, Integer.MIN_VALUE);
    }

    public float getToolMinor() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, Integer.MIN_VALUE);
    }

    public float getOrientation() {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, Integer.MIN_VALUE);
    }

    public float getAxisValue(int axis) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, Integer.MIN_VALUE);
    }

    public int getPointerCount() {
        return MotionEvent.nativeGetPointerCount(this.mNativePtr);
    }

    public int getPointerId(int pointerIndex) {
        return MotionEvent.nativeGetPointerId(this.mNativePtr, pointerIndex);
    }

    public int findPointerIndex(int pointerId) {
        return MotionEvent.nativeFindPointerIndex(this.mNativePtr, pointerId);
    }

    public float getX(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, Integer.MIN_VALUE);
    }

    public float getY(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, Integer.MIN_VALUE);
    }

    public float getPressure(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, Integer.MIN_VALUE);
    }

    public float getSize(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, Integer.MIN_VALUE);
    }

    public float getTouchMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, Integer.MIN_VALUE);
    }

    public float getTouchMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, Integer.MIN_VALUE);
    }

    public float getToolMajor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, Integer.MIN_VALUE);
    }

    public float getToolMinor(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, Integer.MIN_VALUE);
    }

    public float getOrientation(int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, Integer.MIN_VALUE);
    }

    public float getAxisValue(int axis, int pointerIndex) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, Integer.MIN_VALUE);
    }

    public void getPointerCoords(int pointerIndex, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, Integer.MIN_VALUE, outPointerCoords);
    }

    public int getMetaState() {
        return MotionEvent.nativeGetMetaState(this.mNativePtr);
    }

    public float getRawX() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 0, 0, Integer.MIN_VALUE);
    }

    public float getRawY() {
        return MotionEvent.nativeGetRawAxisValue(this.mNativePtr, 1, 0, Integer.MIN_VALUE);
    }

    public float getXPrecision() {
        return MotionEvent.nativeGetXPrecision(this.mNativePtr);
    }

    public float getYPrecision() {
        return MotionEvent.nativeGetYPrecision(this.mNativePtr);
    }

    public int getHistorySize() {
        return MotionEvent.nativeGetHistorySize(this.mNativePtr);
    }

    public long getHistoricalEventTime(int pos) {
        return MotionEvent.nativeGetEventTimeNanos(this.mNativePtr, pos) / 1000000L;
    }

    public float getHistoricalX(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, 0, pos);
    }

    public float getHistoricalY(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, 0, pos);
    }

    public float getHistoricalPressure(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, 0, pos);
    }

    public float getHistoricalSize(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, 0, pos);
    }

    public float getHistoricalTouchMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, 0, pos);
    }

    public float getHistoricalTouchMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, 0, pos);
    }

    public float getHistoricalToolMajor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, 0, pos);
    }

    public float getHistoricalToolMinor(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, 0, pos);
    }

    public float getHistoricalOrientation(int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, 0, pos);
    }

    public float getHistoricalAxisValue(int axis, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, 0, pos);
    }

    public float getHistoricalX(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 0, pointerIndex, pos);
    }

    public float getHistoricalY(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 1, pointerIndex, pos);
    }

    public float getHistoricalPressure(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 2, pointerIndex, pos);
    }

    public float getHistoricalSize(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 3, pointerIndex, pos);
    }

    public float getHistoricalTouchMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 4, pointerIndex, pos);
    }

    public float getHistoricalTouchMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 5, pointerIndex, pos);
    }

    public float getHistoricalToolMajor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 6, pointerIndex, pos);
    }

    public float getHistoricalToolMinor(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 7, pointerIndex, pos);
    }

    public float getHistoricalOrientation(int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, 8, pointerIndex, pos);
    }

    public float getHistoricalAxisValue(int axis, int pointerIndex, int pos) {
        return MotionEvent.nativeGetAxisValue(this.mNativePtr, axis, pointerIndex, pos);
    }

    public void getHistoricalPointerCoords(int pointerIndex, int pos, PointerCoords outPointerCoords) {
        MotionEvent.nativeGetPointerCoords(this.mNativePtr, pointerIndex, pos, outPointerCoords);
    }

    public int getEdgeFlags() {
        return MotionEvent.nativeGetEdgeFlags(this.mNativePtr);
    }

    public void setEdgeFlags(int flags) {
        MotionEvent.nativeSetEdgeFlags(this.mNativePtr, flags);
    }

    public void setAction(int action) {
        MotionEvent.nativeSetAction(this.mNativePtr, action);
    }

    public void offsetLocation(float deltaX, float deltaY) {
        MotionEvent.nativeOffsetLocation(this.mNativePtr, deltaX, deltaY);
    }

    public void setLocation(float x, float y) {
        float oldX = this.getX();
        float oldY = this.getY();
        MotionEvent.nativeOffsetLocation(this.mNativePtr, x - oldX, y - oldY);
    }

    public void transform(Matrix matrix) {
        if (matrix == null) {
            throw new IllegalArgumentException("matrix must not be null");
        }
        MotionEvent.nativeTransform(this.mNativePtr, matrix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        PointerCoords[] pointerCoordsArray = gTmpPointerCoords;
        synchronized (gTmpPointerCoords) {
            PointerCoords pc = gTmpPointerCoords[0];
            pc.clear();
            pc.x = x;
            pc.y = y;
            pc.pressure = pressure;
            pc.size = size;
            MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, gTmpPointerCoords, metaState);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            return;
        }
    }

    public void addBatch(long eventTime, PointerCoords[] pointerCoords, int metaState) {
        MotionEvent.nativeAddBatch(this.mNativePtr, eventTime * 1000000L, pointerCoords, metaState);
    }

    public String toString() {
        return "MotionEvent{" + Integer.toHexString(System.identityHashCode(this)) + " pointerId=" + this.getPointerId(0) + " action=" + MotionEvent.actionToString(this.getAction()) + " x=" + this.getX() + " y=" + this.getY() + " pressure=" + this.getPressure() + " size=" + this.getSize() + " touchMajor=" + this.getTouchMajor() + " touchMinor=" + this.getTouchMinor() + " toolMajor=" + this.getToolMajor() + " toolMinor=" + this.getToolMinor() + " orientation=" + this.getOrientation() + " meta=" + KeyEvent.metaStateToString(this.getMetaState()) + " pointerCount=" + this.getPointerCount() + " historySize=" + this.getHistorySize() + " flags=0x" + Integer.toHexString(this.getFlags()) + " edgeFlags=0x" + Integer.toHexString(this.getEdgeFlags()) + " device=" + this.getDeviceId() + " source=0x" + Integer.toHexString(this.getSource()) + (this.getPointerCount() > 1 ? " pointerId2=" + this.getPointerId(1) + " x2=" + this.getX(1) + " y2=" + this.getY(1) : "") + "}";
    }

    public static String actionToString(int action) {
        switch (action) {
            case 0: {
                return "ACTION_DOWN";
            }
            case 1: {
                return "ACTION_UP";
            }
            case 3: {
                return "ACTION_CANCEL";
            }
            case 4: {
                return "ACTION_OUTSIDE";
            }
            case 2: {
                return "ACTION_MOVE";
            }
            case 7: {
                return "ACTION_HOVER_MOVE";
            }
            case 8: {
                return "ACTION_SCROLL";
            }
        }
        int index = (action & 0xFF00) >> 8;
        switch (action & 0xFF) {
            case 5: {
                return "ACTION_POINTER_DOWN(" + index + ")";
            }
            case 6: {
                return "ACTION_POINTER_UP(" + index + ")";
            }
        }
        return Integer.toString(action);
    }

    public static String axisToString(int axis) {
        String symbolicName = AXIS_SYMBOLIC_NAMES.get(axis);
        return symbolicName != null ? symbolicName : Integer.toString(axis);
    }

    public static int axisFromString(String symbolicName) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("symbolicName must not be null");
        }
        int count = AXIS_SYMBOLIC_NAMES.size();
        for (int i = 0; i < count; ++i) {
            if (!symbolicName.equals(AXIS_SYMBOLIC_NAMES.valueAt(i))) continue;
            return i;
        }
        try {
            return Integer.parseInt(symbolicName, 10);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public static MotionEvent createFromParcelBody(Parcel in) {
        MotionEvent ev = MotionEvent.obtain();
        ev.mNativePtr = MotionEvent.nativeReadFromParcel(ev.mNativePtr, in);
        return ev;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        MotionEvent.nativeWriteToParcel(this.mNativePtr, out);
    }

    static {
        MotionEvent.populateAxisSymbolicNames();
        gRecyclerLock = new Object();
        gTmpPointerCoords = new PointerCoords[]{new PointerCoords()};
        gTmpPointerIds = new int[]{0};
        CREATOR = new Parcelable.Creator<MotionEvent>(){

            @Override
            public MotionEvent createFromParcel(Parcel in) {
                in.readInt();
                return MotionEvent.createFromParcelBody(in);
            }

            public MotionEvent[] newArray(int size) {
                return new MotionEvent[size];
            }
        };
    }

    public static class PointerCoords {
        public static final int INITIAL_PACKED_AXIS_VALUES = 8;
        public long mPackedAxisBits;
        public float[] mPackedAxisValues;
        public float x;
        public float y;
        public float pressure;
        public float size;
        public float touchMajor;
        public float touchMinor;
        public float toolMajor;
        public float toolMinor;
        public float orientation;

        public PointerCoords() {
        }

        public PointerCoords(PointerCoords other) {
            this.copyFrom(other);
        }

        public void clear() {
            this.mPackedAxisBits = 0L;
            this.x = 0.0f;
            this.y = 0.0f;
            this.pressure = 0.0f;
            this.size = 0.0f;
            this.touchMajor = 0.0f;
            this.touchMinor = 0.0f;
            this.toolMajor = 0.0f;
            this.toolMinor = 0.0f;
            this.orientation = 0.0f;
        }

        public void copyFrom(PointerCoords other) {
            long bits;
            this.mPackedAxisBits = bits = other.mPackedAxisBits;
            if (bits != 0L) {
                float[] otherValues = other.mPackedAxisValues;
                int count = Long.bitCount(bits);
                float[] values = this.mPackedAxisValues;
                if (values == null || count > values.length) {
                    this.mPackedAxisValues = values = new float[otherValues.length];
                }
                System.arraycopy(otherValues, 0, values, 0, count);
            }
            this.x = other.x;
            this.y = other.y;
            this.pressure = other.pressure;
            this.size = other.size;
            this.touchMajor = other.touchMajor;
            this.touchMinor = other.touchMinor;
            this.toolMajor = other.toolMajor;
            this.toolMinor = other.toolMinor;
            this.orientation = other.orientation;
        }

        public float getAxisValue(int axis) {
            switch (axis) {
                case 0: {
                    return this.x;
                }
                case 1: {
                    return this.y;
                }
                case 2: {
                    return this.pressure;
                }
                case 3: {
                    return this.size;
                }
                case 4: {
                    return this.touchMajor;
                }
                case 5: {
                    return this.touchMinor;
                }
                case 6: {
                    return this.toolMajor;
                }
                case 7: {
                    return this.toolMinor;
                }
                case 8: {
                    return this.orientation;
                }
            }
            if (axis < 0 || axis > 63) {
                throw new IllegalArgumentException("Axis out of range.");
            }
            long bits = this.mPackedAxisBits;
            long axisBit = 1L << axis;
            if ((bits & axisBit) == 0L) {
                return 0.0f;
            }
            int index = Long.bitCount(bits & axisBit - 1L);
            return this.mPackedAxisValues[index];
        }

        public void setAxisValue(int axis, float value) {
            switch (axis) {
                case 0: {
                    this.x = value;
                    break;
                }
                case 1: {
                    this.y = value;
                    break;
                }
                case 2: {
                    this.pressure = value;
                    break;
                }
                case 3: {
                    this.size = value;
                    break;
                }
                case 4: {
                    this.touchMajor = value;
                    break;
                }
                case 5: {
                    this.touchMinor = value;
                    break;
                }
                case 6: {
                    this.toolMajor = value;
                    break;
                }
                case 7: {
                    this.toolMinor = value;
                    break;
                }
                case 8: {
                    this.orientation = value;
                    break;
                }
                default: {
                    if (axis < 0 || axis > 63) {
                        throw new IllegalArgumentException("Axis out of range.");
                    }
                    long bits = this.mPackedAxisBits;
                    long axisBit = 1L << axis;
                    int index = Long.bitCount(bits & axisBit - 1L);
                    float[] values = this.mPackedAxisValues;
                    if ((bits & axisBit) == 0L) {
                        if (values == null) {
                            this.mPackedAxisValues = values = new float[8];
                        } else {
                            int count = Long.bitCount(bits);
                            if (count < values.length) {
                                if (index != count) {
                                    System.arraycopy(values, index, values, index + 1, count - index);
                                }
                            } else {
                                float[] newValues = new float[count * 2];
                                System.arraycopy(values, 0, newValues, 0, index);
                                System.arraycopy(values, index, newValues, index + 1, count - index);
                                this.mPackedAxisValues = values = newValues;
                            }
                        }
                        this.mPackedAxisBits = bits | axisBit;
                    }
                    values[index] = value;
                }
            }
        }
    }
}

