/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.FloatMath;
import android.util.Log;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    public static final String TAG = "ScaleGestureDetector";
    public static final float PRESSURE_THRESHOLD = 0.67f;
    public final Context mContext;
    public final OnScaleGestureListener mListener;
    public boolean mGestureInProgress;
    public MotionEvent mPrevEvent;
    public MotionEvent mCurrEvent;
    public float mFocusX;
    public float mFocusY;
    public float mPrevFingerDiffX;
    public float mPrevFingerDiffY;
    public float mCurrFingerDiffX;
    public float mCurrFingerDiffY;
    public float mCurrLen;
    public float mPrevLen;
    public float mScaleFactor;
    public float mCurrPressure;
    public float mPrevPressure;
    public long mTimeDelta;
    public final float mEdgeSlop;
    public float mRightSlopEdge;
    public float mBottomSlopEdge;
    public boolean mSloppyGesture;
    public boolean mInvalidGesture;
    public int mActiveId0;
    public int mActiveId1;
    public boolean mActive0MostRecent;

    public ScaleGestureDetector(Context context, OnScaleGestureListener listener) {
        ViewConfiguration config = ViewConfiguration.get(context);
        this.mContext = context;
        this.mListener = listener;
        this.mEdgeSlop = config.getScaledEdgeSlop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        boolean handled = true;
        if (action == 0) {
            this.reset();
        }
        if (this.mInvalidGesture) {
            return false;
        }
        if (!this.mGestureInProgress) {
            switch (action) {
                case 0: {
                    this.mActiveId0 = event.getPointerId(0);
                    this.mActive0MostRecent = true;
                    return handled;
                }
                case 1: {
                    this.reset();
                    return handled;
                }
                case 5: {
                    boolean p1sloppy;
                    DisplayMetrics metrics = this.mContext.getResources().getDisplayMetrics();
                    this.mRightSlopEdge = (float)metrics.widthPixels - this.mEdgeSlop;
                    this.mBottomSlopEdge = (float)metrics.heightPixels - this.mEdgeSlop;
                    if (this.mPrevEvent != null) {
                        this.mPrevEvent.recycle();
                    }
                    this.mPrevEvent = MotionEvent.obtain(event);
                    this.mTimeDelta = 0L;
                    int index1 = event.getActionIndex();
                    int index0 = event.findPointerIndex(this.mActiveId0);
                    this.mActiveId1 = event.getPointerId(index1);
                    if (index0 < 0 || index0 == index1) {
                        index0 = this.findNewActiveIndex(event, index0 == index1 ? -1 : this.mActiveId1, index0);
                        this.mActiveId0 = event.getPointerId(index0);
                    }
                    this.mActive0MostRecent = false;
                    this.setContext(event);
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    float x0 = ScaleGestureDetector.getRawX(event, index0);
                    float y0 = ScaleGestureDetector.getRawY(event, index0);
                    float x1 = ScaleGestureDetector.getRawX(event, index1);
                    float y1 = ScaleGestureDetector.getRawY(event, index1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        this.mSloppyGesture = true;
                        return handled;
                    }
                    if (p0sloppy) {
                        this.mFocusX = event.getX(index1);
                        this.mFocusY = event.getY(index1);
                        this.mSloppyGesture = true;
                        return handled;
                    }
                    if (p1sloppy) {
                        this.mFocusX = event.getX(index0);
                        this.mFocusY = event.getY(index0);
                        this.mSloppyGesture = true;
                        return handled;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return handled;
                }
                case 2: {
                    int index;
                    boolean p1sloppy;
                    if (!this.mSloppyGesture) return handled;
                    float edgeSlop = this.mEdgeSlop;
                    float rightSlop = this.mRightSlopEdge;
                    float bottomSlop = this.mBottomSlopEdge;
                    int index0 = event.findPointerIndex(this.mActiveId0);
                    int index1 = event.findPointerIndex(this.mActiveId1);
                    float x0 = ScaleGestureDetector.getRawX(event, index0);
                    float y0 = ScaleGestureDetector.getRawY(event, index0);
                    float x1 = ScaleGestureDetector.getRawX(event, index1);
                    float y1 = ScaleGestureDetector.getRawY(event, index1);
                    boolean p0sloppy = x0 < edgeSlop || y0 < edgeSlop || x0 > rightSlop || y0 > bottomSlop;
                    boolean bl = p1sloppy = x1 < edgeSlop || y1 < edgeSlop || x1 > rightSlop || y1 > bottomSlop;
                    if (p0sloppy && (index = this.findNewActiveIndex(event, this.mActiveId1, index0)) >= 0) {
                        index0 = index;
                        this.mActiveId0 = event.getPointerId(index);
                        x0 = ScaleGestureDetector.getRawX(event, index);
                        y0 = ScaleGestureDetector.getRawY(event, index);
                        p0sloppy = false;
                    }
                    if (p1sloppy && (index = this.findNewActiveIndex(event, this.mActiveId0, index1)) >= 0) {
                        index1 = index;
                        this.mActiveId1 = event.getPointerId(index);
                        x1 = ScaleGestureDetector.getRawX(event, index);
                        y1 = ScaleGestureDetector.getRawY(event, index);
                        p1sloppy = false;
                    }
                    if (p0sloppy && p1sloppy) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        return handled;
                    }
                    if (p0sloppy) {
                        this.mFocusX = event.getX(index1);
                        this.mFocusY = event.getY(index1);
                        return handled;
                    }
                    if (p1sloppy) {
                        this.mFocusX = event.getX(index0);
                        this.mFocusY = event.getY(index0);
                        return handled;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return handled;
                }
                case 6: {
                    if (!this.mSloppyGesture) return handled;
                    int pointerCount = event.getPointerCount();
                    int actionIndex = event.getActionIndex();
                    int actionId = event.getPointerId(actionIndex);
                    if (pointerCount > 2) {
                        if (actionId == this.mActiveId0) {
                            int newIndex = this.findNewActiveIndex(event, this.mActiveId1, actionIndex);
                            if (newIndex < 0) return handled;
                            this.mActiveId0 = event.getPointerId(newIndex);
                            return handled;
                        }
                        if (actionId != this.mActiveId1) return handled;
                        int newIndex = this.findNewActiveIndex(event, this.mActiveId0, actionIndex);
                        if (newIndex < 0) return handled;
                        this.mActiveId1 = event.getPointerId(newIndex);
                        return handled;
                    }
                    int index = event.findPointerIndex(actionId == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0);
                    this.mActiveId0 = event.getPointerId(index);
                    this.mActive0MostRecent = true;
                    this.mActiveId1 = -1;
                    this.mFocusX = event.getX(index);
                    this.mFocusY = event.getY(index);
                }
            }
            return handled;
        } else {
            switch (action) {
                case 5: {
                    this.mListener.onScaleEnd(this);
                    int oldActive0 = this.mActiveId0;
                    int oldActive1 = this.mActiveId1;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain(event);
                    this.mActiveId0 = this.mActive0MostRecent ? oldActive0 : oldActive1;
                    this.mActiveId1 = event.getPointerId(event.getActionIndex());
                    this.mActive0MostRecent = false;
                    int index0 = event.findPointerIndex(this.mActiveId0);
                    if (index0 < 0 || this.mActiveId0 == this.mActiveId1) {
                        Log.e(TAG, "Got " + MotionEvent.actionToString(action) + " with bad state while a gesture was in progress. " + "Did you forget to pass an event to " + "ScaleGestureDetector#onTouchEvent?");
                        index0 = this.findNewActiveIndex(event, this.mActiveId0 == this.mActiveId1 ? -1 : this.mActiveId1, index0);
                        this.mActiveId0 = event.getPointerId(index0);
                    }
                    this.setContext(event);
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return handled;
                }
                case 6: {
                    int pointerCount = event.getPointerCount();
                    int actionIndex = event.getActionIndex();
                    int actionId = event.getPointerId(actionIndex);
                    boolean gestureEnded = false;
                    if (pointerCount > 2) {
                        int newIndex;
                        if (actionId == this.mActiveId0) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId1, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId0 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = true;
                                this.mPrevEvent = MotionEvent.obtain(event);
                                this.setContext(event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                gestureEnded = true;
                            }
                        } else if (actionId == this.mActiveId1) {
                            newIndex = this.findNewActiveIndex(event, this.mActiveId0, actionIndex);
                            if (newIndex >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId1 = event.getPointerId(newIndex);
                                this.mActive0MostRecent = false;
                                this.mPrevEvent = MotionEvent.obtain(event);
                                this.setContext(event);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                gestureEnded = true;
                            }
                        }
                        this.mPrevEvent.recycle();
                        this.mPrevEvent = MotionEvent.obtain(event);
                        this.setContext(event);
                    } else {
                        gestureEnded = true;
                    }
                    if (!gestureEnded) return handled;
                    this.setContext(event);
                    int activeId = actionId == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0;
                    int index = event.findPointerIndex(activeId);
                    this.mFocusX = event.getX(index);
                    this.mFocusY = event.getY(index);
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    this.mActiveId0 = activeId;
                    this.mActive0MostRecent = true;
                    return handled;
                }
                case 3: {
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    return handled;
                }
                case 1: {
                    this.reset();
                    return handled;
                }
                case 2: {
                    boolean updatePrevious;
                    this.setContext(event);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(updatePrevious = this.mListener.onScale(this))) return handled;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain(event);
                }
            }
        }
        return handled;
    }

    public int findNewActiveIndex(MotionEvent ev, int otherActiveId, int oldIndex) {
        int pointerCount = ev.getPointerCount();
        int otherActiveIndex = ev.findPointerIndex(otherActiveId);
        int newActiveIndex = -1;
        for (int i = 0; i < pointerCount; ++i) {
            if (i == oldIndex || i == otherActiveIndex) continue;
            float edgeSlop = this.mEdgeSlop;
            float rightSlop = this.mRightSlopEdge;
            float bottomSlop = this.mBottomSlopEdge;
            float x = ScaleGestureDetector.getRawX(ev, i);
            float y = ScaleGestureDetector.getRawY(ev, i);
            if (!(x >= edgeSlop) || !(y >= edgeSlop) || !(x <= rightSlop) || !(y <= bottomSlop)) continue;
            newActiveIndex = i;
            break;
        }
        return newActiveIndex;
    }

    public static float getRawX(MotionEvent event, int pointerIndex) {
        if (pointerIndex < 0) {
            return Float.MIN_VALUE;
        }
        if (pointerIndex == 0) {
            return event.getRawX();
        }
        float offset = event.getRawX() - event.getX();
        return event.getX(pointerIndex) + offset;
    }

    public static float getRawY(MotionEvent event, int pointerIndex) {
        if (pointerIndex < 0) {
            return Float.MIN_VALUE;
        }
        if (pointerIndex == 0) {
            return event.getRawY();
        }
        float offset = event.getRawY() - event.getY();
        return event.getY(pointerIndex) + offset;
    }

    public void setContext(MotionEvent curr) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain(curr);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent prev = this.mPrevEvent;
        int prevIndex0 = prev.findPointerIndex(this.mActiveId0);
        int prevIndex1 = prev.findPointerIndex(this.mActiveId1);
        int currIndex0 = curr.findPointerIndex(this.mActiveId0);
        int currIndex1 = curr.findPointerIndex(this.mActiveId1);
        if (prevIndex0 < 0 || prevIndex1 < 0 || currIndex0 < 0 || currIndex1 < 0) {
            this.mInvalidGesture = true;
            Log.e(TAG, "Invalid MotionEvent stream detected.", new Throwable());
            if (this.mGestureInProgress) {
                this.mListener.onScaleEnd(this);
            }
            return;
        }
        float px0 = prev.getX(prevIndex0);
        float py0 = prev.getY(prevIndex0);
        float px1 = prev.getX(prevIndex1);
        float py1 = prev.getY(prevIndex1);
        float cx0 = curr.getX(currIndex0);
        float cy0 = curr.getY(currIndex0);
        float cx1 = curr.getX(currIndex1);
        float cy1 = curr.getY(currIndex1);
        float pvx = px1 - px0;
        float pvy = py1 - py0;
        float cvx = cx1 - cx0;
        float cvy = cy1 - cy0;
        this.mPrevFingerDiffX = pvx;
        this.mPrevFingerDiffY = pvy;
        this.mCurrFingerDiffX = cvx;
        this.mCurrFingerDiffY = cvy;
        this.mFocusX = cx0 + cvx * 0.5f;
        this.mFocusY = cy0 + cvy * 0.5f;
        this.mTimeDelta = curr.getEventTime() - prev.getEventTime();
        this.mCurrPressure = curr.getPressure(currIndex0) + curr.getPressure(currIndex1);
        this.mPrevPressure = prev.getPressure(prevIndex0) + prev.getPressure(prevIndex1);
    }

    public void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
        this.mActiveId0 = -1;
        this.mActiveId1 = -1;
        this.mInvalidGesture = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float cvx = this.mCurrFingerDiffX;
            float cvy = this.mCurrFingerDiffY;
            this.mCurrLen = FloatMath.sqrt(cvx * cvx + cvy * cvy);
        }
        return this.mCurrLen;
    }

    public float getCurrentSpanX() {
        return this.mCurrFingerDiffX;
    }

    public float getCurrentSpanY() {
        return this.mCurrFingerDiffY;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float pvx = this.mPrevFingerDiffX;
            float pvy = this.mPrevFingerDiffY;
            this.mPrevLen = FloatMath.sqrt(pvx * pvx + pvy * pvy);
        }
        return this.mPrevLen;
    }

    public float getPreviousSpanX() {
        return this.mPrevFingerDiffX;
    }

    public float getPreviousSpanY() {
        return this.mPrevFingerDiffY;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector detector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

