/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class ViewPropertyAnimator {
    public View mView;
    public long mDuration;
    public boolean mDurationSet = false;
    public TimeInterpolator mInterpolator;
    public boolean mInterpolatorSet = false;
    public Animator.AnimatorListener mListener = null;
    public AnimatorEventListener mAnimatorEventListener = new AnimatorEventListener(null);
    public ArrayList<NameValuesHolder> mPendingAnimations = new ArrayList();
    public static final int NONE = 0;
    public static final int TRANSLATION_X = 1;
    public static final int TRANSLATION_Y = 2;
    public static final int SCALE_X = 4;
    public static final int SCALE_Y = 8;
    public static final int ROTATION = 16;
    public static final int ROTATION_X = 32;
    public static final int ROTATION_Y = 64;
    public static final int X = 128;
    public static final int Y = 256;
    public static final int ALPHA = 512;
    public static final int TRANSFORM_MASK = 511;
    public Runnable mAnimationStarter = new Runnable(){

        public void run() {
            ViewPropertyAnimator.this.startAnimation();
        }
    };
    public HashMap<Animator, PropertyBundle> mAnimatorMap = new HashMap();

    public ViewPropertyAnimator(View view) {
        this.mView = view;
    }

    public ViewPropertyAnimator setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animators cannot have negative duration: " + duration);
        }
        this.mDurationSet = true;
        this.mDuration = duration;
        return this;
    }

    public ViewPropertyAnimator setInterpolator(TimeInterpolator interpolator2) {
        this.mInterpolatorSet = true;
        this.mInterpolator = interpolator2;
        return this;
    }

    public ViewPropertyAnimator setListener(Animator.AnimatorListener listener) {
        this.mListener = listener;
        return this;
    }

    public ViewPropertyAnimator x(float value) {
        this.animateProperty(128, value);
        return this;
    }

    public ViewPropertyAnimator xBy(float value) {
        this.animatePropertyBy(128, value);
        return this;
    }

    public ViewPropertyAnimator y(float value) {
        this.animateProperty(256, value);
        return this;
    }

    public ViewPropertyAnimator yBy(float value) {
        this.animatePropertyBy(256, value);
        return this;
    }

    public ViewPropertyAnimator rotation(float value) {
        this.animateProperty(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationBy(float value) {
        this.animatePropertyBy(16, value);
        return this;
    }

    public ViewPropertyAnimator rotationX(float value) {
        this.animateProperty(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationXBy(float value) {
        this.animatePropertyBy(32, value);
        return this;
    }

    public ViewPropertyAnimator rotationY(float value) {
        this.animateProperty(64, value);
        return this;
    }

    public ViewPropertyAnimator rotationYBy(float value) {
        this.animatePropertyBy(64, value);
        return this;
    }

    public ViewPropertyAnimator translationX(float value) {
        this.animateProperty(1, value);
        return this;
    }

    public ViewPropertyAnimator translationXBy(float value) {
        this.animatePropertyBy(1, value);
        return this;
    }

    public ViewPropertyAnimator translationY(float value) {
        this.animateProperty(2, value);
        return this;
    }

    public ViewPropertyAnimator translationYBy(float value) {
        this.animatePropertyBy(2, value);
        return this;
    }

    public ViewPropertyAnimator scaleX(float value) {
        this.animateProperty(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleXBy(float value) {
        this.animatePropertyBy(4, value);
        return this;
    }

    public ViewPropertyAnimator scaleY(float value) {
        this.animateProperty(8, value);
        return this;
    }

    public ViewPropertyAnimator scaleYBy(float value) {
        this.animatePropertyBy(8, value);
        return this;
    }

    public ViewPropertyAnimator alpha(float value) {
        this.animateProperty(512, value);
        return this;
    }

    public ViewPropertyAnimator alphaBy(float value) {
        this.animatePropertyBy(512, value);
        return this;
    }

    public void startAnimation() {
        ValueAnimator animator2 = ValueAnimator.ofFloat(1.0f);
        ArrayList nameValueList = (ArrayList)this.mPendingAnimations.clone();
        this.mPendingAnimations.clear();
        int propertyMask = 0;
        int propertyCount = nameValueList.size();
        for (int i = 0; i < propertyCount; ++i) {
            NameValuesHolder nameValuesHolder = (NameValuesHolder)nameValueList.get(i);
            propertyMask |= nameValuesHolder.mNameConstant;
        }
        this.mAnimatorMap.put(animator2, new PropertyBundle(propertyMask, nameValueList));
        animator2.addUpdateListener(this.mAnimatorEventListener);
        animator2.addListener(this.mAnimatorEventListener);
        if (this.mDurationSet) {
            animator2.setDuration(this.mDuration);
        }
        if (this.mInterpolatorSet) {
            animator2.setInterpolator(this.mInterpolator);
        }
        animator2.start();
    }

    public void animateProperty(int constantName, float toValue) {
        float fromValue = this.getValue(constantName);
        float deltaValue = toValue - fromValue;
        this.animatePropertyBy(constantName, fromValue, deltaValue);
    }

    public void animatePropertyBy(int constantName, float byValue) {
        float fromValue = this.getValue(constantName);
        this.animatePropertyBy(constantName, fromValue, byValue);
    }

    public void animatePropertyBy(int constantName, float startValue, float byValue) {
        if (this.mAnimatorMap.size() > 0) {
            Animator animatorToCancel = null;
            Set<Animator> animatorSet = this.mAnimatorMap.keySet();
            for (Animator runningAnim : animatorSet) {
                PropertyBundle bundle = this.mAnimatorMap.get(runningAnim);
                if (!bundle.cancel(constantName) || bundle.mPropertyMask != 0) continue;
                animatorToCancel = runningAnim;
                break;
            }
            if (animatorToCancel != null) {
                animatorToCancel.cancel();
            }
        }
        NameValuesHolder nameValuePair = new NameValuesHolder(constantName, startValue, byValue);
        this.mPendingAnimations.add(nameValuePair);
        this.mView.getHandler().removeCallbacks(this.mAnimationStarter);
        this.mView.post(this.mAnimationStarter);
    }

    public void setValue(int propertyConstant, float value) {
        switch (propertyConstant) {
            case 1: {
                this.mView.mTranslationX = value;
                break;
            }
            case 2: {
                this.mView.mTranslationY = value;
                break;
            }
            case 16: {
                this.mView.mRotation = value;
                break;
            }
            case 32: {
                this.mView.mRotationX = value;
                break;
            }
            case 64: {
                this.mView.mRotationY = value;
                break;
            }
            case 4: {
                this.mView.mScaleX = value;
                break;
            }
            case 8: {
                this.mView.mScaleY = value;
                break;
            }
            case 128: {
                this.mView.mTranslationX = value - (float)this.mView.mLeft;
                break;
            }
            case 256: {
                this.mView.mTranslationY = value - (float)this.mView.mTop;
                break;
            }
            case 512: {
                this.mView.mAlpha = value;
            }
        }
    }

    public float getValue(int propertyConstant) {
        switch (propertyConstant) {
            case 1: {
                return this.mView.mTranslationX;
            }
            case 2: {
                return this.mView.mTranslationY;
            }
            case 16: {
                return this.mView.mRotation;
            }
            case 32: {
                return this.mView.mRotationX;
            }
            case 64: {
                return this.mView.mRotationY;
            }
            case 4: {
                return this.mView.mScaleX;
            }
            case 8: {
                return this.mView.mScaleY;
            }
            case 128: {
                return (float)this.mView.mLeft + this.mView.mTranslationX;
            }
            case 256: {
                return (float)this.mView.mTop + this.mView.mTranslationY;
            }
            case 512: {
                return this.mView.mAlpha;
            }
        }
        return 0.0f;
    }

    public class AnimatorEventListener
    implements Animator.AnimatorListener,
    ValueAnimator.AnimatorUpdateListener {
        public AnimatorEventListener() {
        }

        public void onAnimationStart(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationStart(animation);
            }
        }

        public void onAnimationCancel(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationCancel(animation);
            }
        }

        public void onAnimationRepeat(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationRepeat(animation);
            }
        }

        public void onAnimationEnd(Animator animation) {
            if (ViewPropertyAnimator.this.mListener != null) {
                ViewPropertyAnimator.this.mListener.onAnimationEnd(animation);
            }
            ViewPropertyAnimator.this.mAnimatorMap.remove(animation);
        }

        public void onAnimationUpdate(ValueAnimator animation) {
            ArrayList<NameValuesHolder> valueList;
            boolean alphaHandled = false;
            ViewPropertyAnimator.this.mView.invalidateParentCaches();
            float fraction2 = animation.getAnimatedFraction();
            PropertyBundle propertyBundle = (PropertyBundle)ViewPropertyAnimator.this.mAnimatorMap.get(animation);
            int propertyMask = propertyBundle.mPropertyMask;
            if ((propertyMask & 0x1FF) != 0) {
                ViewPropertyAnimator.this.mView.invalidate(false);
            }
            if ((valueList = propertyBundle.mNameValuesHolder) != null) {
                int count = valueList.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder values = valueList.get(i);
                    float value = values.mFromValue + fraction2 * values.mDeltaValue;
                    if (values.mNameConstant == 512) {
                        alphaHandled = ViewPropertyAnimator.this.mView.setAlphaNoInvalidation(value);
                        continue;
                    }
                    ViewPropertyAnimator.this.setValue(values.mNameConstant, value);
                }
            }
            if ((propertyMask & 0x1FF) != 0) {
                ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mMatrixDirty = true;
                ((ViewPropertyAnimator)ViewPropertyAnimator.this).mView.mPrivateFlags |= 0x20;
            }
            ViewPropertyAnimator.this.mView.invalidate(alphaHandled);
        }

        public /* synthetic */ AnimatorEventListener(1 x1) {
            this();
        }
    }

    public static class NameValuesHolder {
        public int mNameConstant;
        public float mFromValue;
        public float mDeltaValue;

        public NameValuesHolder(int nameConstant, float fromValue, float deltaValue) {
            this.mNameConstant = nameConstant;
            this.mFromValue = fromValue;
            this.mDeltaValue = deltaValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyBundle {
        public int mPropertyMask;
        public ArrayList<NameValuesHolder> mNameValuesHolder;

        public PropertyBundle(int propertyMask, ArrayList<NameValuesHolder> nameValuesHolder) {
            this.mPropertyMask = propertyMask;
            this.mNameValuesHolder = nameValuesHolder;
        }

        public boolean cancel(int propertyConstant) {
            if ((this.mPropertyMask & propertyConstant) != 0 && this.mNameValuesHolder != null) {
                int count = this.mNameValuesHolder.size();
                for (int i = 0; i < count; ++i) {
                    NameValuesHolder nameValuesHolder = this.mNameValuesHolder.get(i);
                    if (nameValuesHolder.mNameConstant != propertyConstant) continue;
                    this.mNameValuesHolder.remove(i);
                    this.mPropertyMask &= ~propertyConstant;
                    return true;
                }
            }
            return false;
        }
    }
}

