/*
 * Decompiled with CFR 0.152.
 */
package android.view.animation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.Transformation;
import com.android.internal.R;
import dalvik.system.CloseGuard;

public abstract class Animation
implements Cloneable {
    public static final int INFINITE = -1;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int START_ON_FIRST_FRAME = -1;
    public static final int ABSOLUTE = 0;
    public static final int RELATIVE_TO_SELF = 1;
    public static final int RELATIVE_TO_PARENT = 2;
    public static final int ZORDER_NORMAL = 0;
    public static final int ZORDER_TOP = 1;
    public static final int ZORDER_BOTTOM = -1;
    public static final boolean USE_CLOSEGUARD = SystemProperties.getBoolean("log.closeguard.Animation", false);
    public boolean mEnded = false;
    public boolean mStarted = false;
    public boolean mCycleFlip = false;
    public boolean mInitialized = false;
    public boolean mFillBefore = true;
    public boolean mFillAfter = false;
    public boolean mFillEnabled = false;
    public long mStartTime = -1L;
    public long mStartOffset;
    public long mDuration;
    public int mRepeatCount = 0;
    public int mRepeated = 0;
    public int mRepeatMode = 1;
    public Interpolator mInterpolator;
    public AnimationListener mListener;
    public int mZAdjustment;
    public int mBackgroundColor;
    public float mScaleFactor = 1.0f;
    public boolean mDetachWallpaper = false;
    public boolean mMore = true;
    public boolean mOneMoreTime = true;
    public RectF mPreviousRegion = new RectF();
    public RectF mRegion = new RectF();
    public Transformation mTransformation = new Transformation();
    public Transformation mPreviousTransformation = new Transformation();
    public final CloseGuard guard = CloseGuard.get();

    public Animation() {
        this.ensureInterpolator();
    }

    public Animation(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Animation);
        this.setDuration(a.getInt(2, 0));
        this.setStartOffset(a.getInt(5, 0));
        this.setFillEnabled(a.getBoolean(9, this.mFillEnabled));
        this.setFillBefore(a.getBoolean(3, this.mFillBefore));
        this.setFillAfter(a.getBoolean(4, this.mFillAfter));
        int resID = a.getResourceId(1, 0);
        if (resID > 0) {
            this.setInterpolator(context, resID);
        }
        this.setRepeatCount(a.getInt(6, this.mRepeatCount));
        this.setRepeatMode(a.getInt(7, 1));
        this.setZAdjustment(a.getInt(8, 0));
        this.setBackgroundColor(a.getInt(0, 0));
        this.setDetachWallpaper(a.getBoolean(10, false));
        this.ensureInterpolator();
        a.recycle();
    }

    public Animation clone() throws CloneNotSupportedException {
        Animation animation = (Animation)super.clone();
        animation.mPreviousRegion = new RectF();
        animation.mRegion = new RectF();
        animation.mTransformation = new Transformation();
        animation.mPreviousTransformation = new Transformation();
        return animation;
    }

    public void reset() {
        this.mPreviousRegion.setEmpty();
        this.mPreviousTransformation.clear();
        this.mInitialized = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
        this.mOneMoreTime = true;
    }

    public void cancel() {
        if (this.mStarted && !this.mEnded) {
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
            this.mEnded = true;
            this.guard.close();
        }
        this.mStartTime = Long.MIN_VALUE;
        this.mOneMoreTime = false;
        this.mMore = false;
    }

    public void detach() {
        if (this.mStarted && !this.mEnded) {
            this.mEnded = true;
            this.guard.close();
            if (this.mListener != null) {
                this.mListener.onAnimationEnd(this);
            }
        }
    }

    public boolean isInitialized() {
        return this.mInitialized;
    }

    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        this.reset();
        this.mInitialized = true;
    }

    public void setInterpolator(Context context, int resID) {
        this.setInterpolator(AnimationUtils.loadInterpolator(context, resID));
    }

    public void setInterpolator(Interpolator i) {
        this.mInterpolator = i;
    }

    public void setStartOffset(long startOffset) {
        this.mStartOffset = startOffset;
    }

    public void setDuration(long durationMillis) {
        if (durationMillis < 0L) {
            throw new IllegalArgumentException("Animation duration cannot be negative");
        }
        this.mDuration = durationMillis;
    }

    public void restrictDuration(long durationMillis) {
        if (this.mStartOffset > durationMillis) {
            this.mStartOffset = durationMillis;
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        long dur = this.mDuration + this.mStartOffset;
        if (dur > durationMillis) {
            this.mDuration = durationMillis - this.mStartOffset;
            dur = durationMillis;
        }
        if (this.mDuration <= 0L) {
            this.mDuration = 0L;
            this.mRepeatCount = 0;
            return;
        }
        if (this.mRepeatCount < 0 || (long)this.mRepeatCount > durationMillis || dur * (long)this.mRepeatCount > durationMillis) {
            this.mRepeatCount = (int)(durationMillis / dur) - 1;
            if (this.mRepeatCount < 0) {
                this.mRepeatCount = 0;
            }
        }
    }

    public void scaleCurrentDuration(float scale) {
        this.mDuration = (long)((float)this.mDuration * scale);
    }

    public void setStartTime(long startTimeMillis) {
        this.mStartTime = startTimeMillis;
        this.mEnded = false;
        this.mStarted = false;
        this.mCycleFlip = false;
        this.mRepeated = 0;
        this.mMore = true;
    }

    public void start() {
        this.setStartTime(-1L);
    }

    public void startNow() {
        this.setStartTime(AnimationUtils.currentAnimationTimeMillis());
    }

    public void setRepeatMode(int repeatMode) {
        this.mRepeatMode = repeatMode;
    }

    public void setRepeatCount(int repeatCount) {
        if (repeatCount < 0) {
            repeatCount = -1;
        }
        this.mRepeatCount = repeatCount;
    }

    public boolean isFillEnabled() {
        return this.mFillEnabled;
    }

    public void setFillEnabled(boolean fillEnabled) {
        this.mFillEnabled = fillEnabled;
    }

    public void setFillBefore(boolean fillBefore) {
        this.mFillBefore = fillBefore;
    }

    public void setFillAfter(boolean fillAfter) {
        this.mFillAfter = fillAfter;
    }

    public void setZAdjustment(int zAdjustment) {
        this.mZAdjustment = zAdjustment;
    }

    public void setBackgroundColor(int bg) {
        this.mBackgroundColor = bg;
    }

    public float getScaleFactor() {
        return this.mScaleFactor;
    }

    public void setDetachWallpaper(boolean detachWallpaper) {
        this.mDetachWallpaper = detachWallpaper;
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public long getStartOffset() {
        return this.mStartOffset;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public boolean getFillBefore() {
        return this.mFillBefore;
    }

    public boolean getFillAfter() {
        return this.mFillAfter;
    }

    public int getZAdjustment() {
        return this.mZAdjustment;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public boolean getDetachWallpaper() {
        return this.mDetachWallpaper;
    }

    public boolean willChangeTransformationMatrix() {
        return true;
    }

    public boolean willChangeBounds() {
        return true;
    }

    public void setAnimationListener(AnimationListener listener) {
        this.mListener = listener;
    }

    public void ensureInterpolator() {
        if (this.mInterpolator == null) {
            this.mInterpolator = new AccelerateDecelerateInterpolator();
        }
    }

    public long computeDurationHint() {
        return (this.getStartOffset() + this.getDuration()) * (long)(this.getRepeatCount() + 1);
    }

    public boolean getTransformation(long currentTime, Transformation outTransformation) {
        if (this.mStartTime == -1L) {
            this.mStartTime = currentTime;
        }
        long startOffset = this.getStartOffset();
        long duration = this.mDuration;
        float normalizedTime = duration != 0L ? (float)(currentTime - (this.mStartTime + startOffset)) / (float)duration : (currentTime < this.mStartTime ? 0.0f : 1.0f);
        boolean expired = normalizedTime >= 1.0f;
        boolean bl = this.mMore = !expired;
        if (!this.mFillEnabled) {
            normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
        }
        if ((normalizedTime >= 0.0f || this.mFillBefore) && (normalizedTime <= 1.0f || this.mFillAfter)) {
            if (!this.mStarted) {
                if (this.mListener != null) {
                    this.mListener.onAnimationStart(this);
                }
                this.mStarted = true;
                if (USE_CLOSEGUARD) {
                    this.guard.open("cancel or detach or getTransformation");
                }
            }
            if (this.mFillEnabled) {
                normalizedTime = Math.max(Math.min(normalizedTime, 1.0f), 0.0f);
            }
            if (this.mCycleFlip) {
                normalizedTime = 1.0f - normalizedTime;
            }
            float interpolatedTime = this.mInterpolator.getInterpolation(normalizedTime);
            this.applyTransformation(interpolatedTime, outTransformation);
        }
        if (expired) {
            if (this.mRepeatCount == this.mRepeated) {
                if (!this.mEnded) {
                    this.mEnded = true;
                    this.guard.close();
                    if (this.mListener != null) {
                        this.mListener.onAnimationEnd(this);
                    }
                }
            } else {
                if (this.mRepeatCount > 0) {
                    ++this.mRepeated;
                }
                if (this.mRepeatMode == 2) {
                    this.mCycleFlip = !this.mCycleFlip;
                }
                this.mStartTime = -1L;
                this.mMore = true;
                if (this.mListener != null) {
                    this.mListener.onAnimationRepeat(this);
                }
            }
        }
        if (!this.mMore && this.mOneMoreTime) {
            this.mOneMoreTime = false;
            return true;
        }
        return this.mMore;
    }

    public boolean getTransformation(long currentTime, Transformation outTransformation, float scale) {
        this.mScaleFactor = scale;
        return this.getTransformation(currentTime, outTransformation);
    }

    public boolean hasStarted() {
        return this.mStarted;
    }

    public boolean hasEnded() {
        return this.mEnded;
    }

    public void applyTransformation(float interpolatedTime, Transformation t) {
    }

    public float resolveSize(int type, float value, int size, int parentSize) {
        switch (type) {
            case 0: {
                return value;
            }
            case 1: {
                return (float)size * value;
            }
            case 2: {
                return (float)parentSize * value;
            }
        }
        return value;
    }

    public void getInvalidateRegion(int left, int top, int right, int bottom, RectF invalidate, Transformation transformation) {
        RectF tempRegion = this.mRegion;
        RectF previousRegion = this.mPreviousRegion;
        invalidate.set(left, top, right, bottom);
        transformation.getMatrix().mapRect(invalidate);
        invalidate.inset(-1.0f, -1.0f);
        tempRegion.set(invalidate);
        invalidate.union(previousRegion);
        previousRegion.set(tempRegion);
        Transformation tempTransformation = this.mTransformation;
        Transformation previousTransformation = this.mPreviousTransformation;
        tempTransformation.set(transformation);
        transformation.set(previousTransformation);
        previousTransformation.set(tempTransformation);
    }

    public void initializeInvalidateRegion(int left, int top, int right, int bottom) {
        RectF region = this.mPreviousRegion;
        region.set(left, top, right, bottom);
        region.inset(-1.0f, -1.0f);
        if (this.mFillBefore) {
            Transformation previousTransformation = this.mPreviousTransformation;
            this.applyTransformation(this.mInterpolator.getInterpolation(0.0f), previousTransformation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static interface AnimationListener {
        public void onAnimationStart(Animation var1);

        public void onAnimationEnd(Animation var1);

        public void onAnimationRepeat(Animation var1);
    }

    public static class Description {
        public int type;
        public float value;

        public static Description parseValue(TypedValue value) {
            Description d = new Description();
            if (value == null) {
                d.type = 0;
                d.value = 0.0f;
            } else {
                if (value.type == 6) {
                    d.type = (value.data & 0xF) == 1 ? 2 : 1;
                    d.value = TypedValue.complexToFloat(value.data);
                    return d;
                }
                if (value.type == 4) {
                    d.type = 0;
                    d.value = value.getFloat();
                    return d;
                }
                if (value.type >= 16 && value.type <= 31) {
                    d.type = 0;
                    d.value = value.data;
                    return d;
                }
            }
            d.type = 0;
            d.value = 0.0f;
            return d;
        }
    }
}

