/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import android.view.inputmethod.InputMethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputMethodSubtype
implements Parcelable {
    public static final String TAG = InputMethodSubtype.class.getSimpleName();
    public static final String EXTRA_VALUE_PAIR_SEPARATOR = ",";
    public static final String EXTRA_VALUE_KEY_VALUE_SEPARATOR = "=";
    public final int mSubtypeNameResId;
    public final int mSubtypeIconResId;
    public final String mSubtypeLocale;
    public final String mSubtypeMode;
    public final String mSubtypeExtraValue;
    public final int mSubtypeHashCode;
    public HashMap<String, String> mExtraValueHashMapCache;
    public static final Parcelable.Creator<InputMethodSubtype> CREATOR = new Parcelable.Creator<InputMethodSubtype>(){

        @Override
        public InputMethodSubtype createFromParcel(Parcel source) {
            return new InputMethodSubtype(source);
        }

        public InputMethodSubtype[] newArray(int size) {
            return new InputMethodSubtype[size];
        }
    };

    public InputMethodSubtype(int nameId, int iconId, String locale, String mode, String extraValue) {
        this.mSubtypeNameResId = nameId;
        this.mSubtypeIconResId = iconId;
        this.mSubtypeLocale = locale != null ? locale : "";
        this.mSubtypeMode = mode != null ? mode : "";
        this.mSubtypeExtraValue = extraValue != null ? extraValue : "";
        this.mSubtypeHashCode = InputMethodSubtype.hashCodeInternal(this.mSubtypeNameResId, this.mSubtypeIconResId, this.mSubtypeLocale, this.mSubtypeMode, this.mSubtypeExtraValue);
    }

    public InputMethodSubtype(Parcel source) {
        this.mSubtypeNameResId = source.readInt();
        this.mSubtypeIconResId = source.readInt();
        String s = source.readString();
        this.mSubtypeLocale = s != null ? s : "";
        s = source.readString();
        this.mSubtypeMode = s != null ? s : "";
        s = source.readString();
        this.mSubtypeExtraValue = s != null ? s : "";
        this.mSubtypeHashCode = InputMethodSubtype.hashCodeInternal(this.mSubtypeNameResId, this.mSubtypeIconResId, this.mSubtypeLocale, this.mSubtypeMode, this.mSubtypeExtraValue);
    }

    public int getNameResId() {
        return this.mSubtypeNameResId;
    }

    public int getIconResId() {
        return this.mSubtypeIconResId;
    }

    public String getLocale() {
        return this.mSubtypeLocale;
    }

    public String getMode() {
        return this.mSubtypeMode;
    }

    public String getExtraValue() {
        return this.mSubtypeExtraValue;
    }

    public HashMap<String, String> getExtraValueHashMap() {
        if (this.mExtraValueHashMapCache == null) {
            this.mExtraValueHashMapCache = new HashMap();
            String[] pairs = this.mSubtypeExtraValue.split(EXTRA_VALUE_PAIR_SEPARATOR);
            int N = pairs.length;
            for (int i = 0; i < N; ++i) {
                String[] pair = pairs[i].split(EXTRA_VALUE_KEY_VALUE_SEPARATOR);
                if (pair.length == 1) {
                    this.mExtraValueHashMapCache.put(pair[0], null);
                    continue;
                }
                if (pair.length <= 1) continue;
                if (pair.length > 2) {
                    Slog.w(TAG, "ExtraValue has two or more '='s");
                }
                this.mExtraValueHashMapCache.put(pair[0], pair[1]);
            }
        }
        return this.mExtraValueHashMapCache;
    }

    public boolean containsExtraValueKey(String key) {
        return this.getExtraValueHashMap().containsKey(key);
    }

    public String getExtraValueOf(String key) {
        return this.getExtraValueHashMap().get(key);
    }

    public int hashCode() {
        return this.mSubtypeHashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof InputMethodSubtype) {
            InputMethodSubtype subtype = (InputMethodSubtype)o;
            return subtype.hashCode() == this.hashCode() && subtype.getNameResId() == this.getNameResId() && subtype.getMode().equals(this.getMode()) && subtype.getIconResId() == this.getIconResId() && subtype.getLocale().equals(this.getLocale()) && subtype.getExtraValue().equals(this.getExtraValue());
        }
        return false;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int parcelableFlags) {
        dest.writeInt(this.mSubtypeNameResId);
        dest.writeInt(this.mSubtypeIconResId);
        dest.writeString(this.mSubtypeLocale);
        dest.writeString(this.mSubtypeMode);
        dest.writeString(this.mSubtypeExtraValue);
    }

    public static int hashCodeInternal(int nameResId, int iconResId, String locale, String mode, String extraValue) {
        return Arrays.hashCode(new Object[]{nameResId, iconResId, locale, mode, extraValue});
    }

    public static List<InputMethodSubtype> sort(Context context, int flags, InputMethodInfo imi, List<InputMethodSubtype> subtypeList) {
        if (imi == null) {
            return subtypeList;
        }
        HashSet<InputMethodSubtype> inputSubtypesSet = new HashSet<InputMethodSubtype>(subtypeList);
        ArrayList<InputMethodSubtype> sortedList = new ArrayList<InputMethodSubtype>();
        int N = imi.getSubtypeCount();
        for (int i = 0; i < N; ++i) {
            InputMethodSubtype subtype = imi.getSubtypeAt(i);
            if (!inputSubtypesSet.contains(subtype)) continue;
            sortedList.add(subtype);
            inputSubtypesSet.remove(subtype);
        }
        for (InputMethodSubtype subtype : inputSubtypesSet) {
            sortedList.add(subtype);
        }
        return sortedList;
    }
}

