/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.security.Credentials;
import android.util.Log;
import com.android.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.android.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.android.org.bouncycastle.jce.netscape.NetscapeCertRequest;
import com.android.org.bouncycastle.util.encoders.Base64;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.HashMap;

public class CertTool {
    public static final String LOGTAG = "CertTool";
    public static final AlgorithmIdentifier MD5_WITH_RSA = new AlgorithmIdentifier(PKCSObjectIdentifiers.md5WithRSAEncryption);
    public static final String CERT = "CERT";
    public static final String PKCS12 = "PKCS12";
    public static HashMap<String, String> sCertificateTypeMap = new HashMap();

    public static String[] getKeyStrengthList() {
        return new String[]{"High Grade", "Medium Grade"};
    }

    public static String getSignedPublicKey(Context context, int index, String challenge) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(index == 0 ? 2048 : 1024);
            KeyPair pair = generator.genKeyPair();
            NetscapeCertRequest request = new NetscapeCertRequest(challenge, MD5_WITH_RSA, pair.getPublic());
            request.sign(pair.getPrivate());
            byte[] signed = request.toASN1Object().getDEREncoded();
            Credentials.getInstance().install(context, pair);
            return new String(Base64.encode((byte[])signed));
        }
        catch (Exception e) {
            Log.w(LOGTAG, e);
            return null;
        }
    }

    public static void addCertificate(Context context, String type, byte[] value) {
        Credentials.getInstance().install(context, type, value);
    }

    public static String getCertType(String mimeType) {
        return sCertificateTypeMap.get(mimeType);
    }

    static {
        sCertificateTypeMap.put("application/x-x509-ca-cert", CERT);
        sCertificateTypeMap.put("application/x-x509-user-cert", CERT);
        sCertificateTypeMap.put("application/x-pkcs12", PKCS12);
    }
}

