/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.webkit.DeviceMotionAndOrientationManager;
import java.util.List;

public class DeviceOrientationService
implements SensorEventListener {
    public float[] mGravityVector;
    public float[] mMagneticFieldVector;
    public DeviceMotionAndOrientationManager mManager;
    public boolean mIsRunning;
    public Handler mHandler;
    public SensorManager mSensorManager;
    public Context mContext;
    public Double mAlpha;
    public Double mBeta;
    public Double mGamma;
    public boolean mHaveSentErrorEvent;
    public static final double DELTA_DEGRESS = 1.0;

    public DeviceOrientationService(DeviceMotionAndOrientationManager manager, Context context) {
        this.mManager = manager;
        assert (this.mManager != null);
        this.mContext = context;
        assert (this.mContext != null);
    }

    public void start() {
        this.mIsRunning = true;
        this.registerForSensors();
    }

    public void stop() {
        this.mIsRunning = false;
        this.unregisterFromSensors();
    }

    public void suspend() {
        if (this.mIsRunning) {
            this.unregisterFromSensors();
        }
    }

    public void resume() {
        if (this.mIsRunning) {
            this.registerForSensors();
        }
    }

    public void sendErrorEvent() {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (this.mHaveSentErrorEvent) {
            return;
        }
        this.mHaveSentErrorEvent = true;
        this.mHandler.post(new Runnable(){

            public void run() {
                assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
                if (DeviceOrientationService.this.mIsRunning) {
                    DeviceOrientationService.this.mManager.onOrientationChange(null, null, null);
                }
            }
        });
    }

    public void registerForSensors() {
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if (!this.registerForAccelerometerSensor() || !this.registerForMagneticFieldSensor()) {
            this.unregisterFromSensors();
            this.sendErrorEvent();
        }
    }

    public void getOrientationUsingGetRotationMatrix() {
        double gamma;
        double beta;
        double alpha;
        if (this.mGravityVector == null || this.mMagneticFieldVector == null) {
            return;
        }
        float[] deviceRotationMatrix = new float[9];
        if (!SensorManager.getRotationMatrix(deviceRotationMatrix, null, this.mGravityVector, this.mMagneticFieldVector)) {
            return;
        }
        float[] rotationAngles = new float[3];
        SensorManager.getOrientation(deviceRotationMatrix, rotationAngles);
        for (alpha = Math.toDegrees(-rotationAngles[0]) - 90.0; alpha < 0.0; alpha += 360.0) {
        }
        for (beta = Math.toDegrees(-rotationAngles[1]); beta < -180.0; beta += 360.0) {
        }
        for (gamma = Math.toDegrees(rotationAngles[2]); gamma < -90.0; gamma += 360.0) {
        }
        this.maybeSendChange(alpha, beta, gamma);
    }

    public SensorManager getSensorManager() {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (this.mSensorManager == null) {
            this.mSensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        }
        return this.mSensorManager;
    }

    public boolean registerForAccelerometerSensor() {
        List<Sensor> sensors = this.getSensorManager().getSensorList(1);
        if (sensors.isEmpty()) {
            return false;
        }
        return this.getSensorManager().registerListener(this, sensors.get(0), 0, this.mHandler);
    }

    public boolean registerForMagneticFieldSensor() {
        List<Sensor> sensors = this.getSensorManager().getSensorList(2);
        if (sensors.isEmpty()) {
            return false;
        }
        return this.getSensorManager().registerListener(this, sensors.get(0), 0, this.mHandler);
    }

    public void unregisterFromSensors() {
        this.getSensorManager().unregisterListener(this);
    }

    public void maybeSendChange(double alpha, double beta, double gamma) {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (this.mAlpha == null || this.mBeta == null || this.mGamma == null || Math.abs(alpha - this.mAlpha) > 1.0 || Math.abs(beta - this.mBeta) > 1.0 || Math.abs(gamma - this.mGamma) > 1.0) {
            this.mAlpha = alpha;
            this.mBeta = beta;
            this.mGamma = gamma;
            this.mManager.onOrientationChange(this.mAlpha, this.mBeta, this.mGamma);
            this.mHaveSentErrorEvent = false;
        }
    }

    public void onSensorChanged(SensorEvent event) {
        assert (event.values.length == 3);
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
        if (!this.mIsRunning) {
            return;
        }
        switch (event.sensor.getType()) {
            case 1: {
                if (this.mGravityVector == null) {
                    this.mGravityVector = new float[3];
                }
                this.mGravityVector[0] = event.values[0];
                this.mGravityVector[1] = event.values[1];
                this.mGravityVector[2] = event.values[2];
                this.getOrientationUsingGetRotationMatrix();
                break;
            }
            case 2: {
                if (this.mMagneticFieldVector == null) {
                    this.mMagneticFieldVector = new float[3];
                }
                this.mMagneticFieldVector[0] = event.values[0];
                this.mMagneticFieldVector[1] = event.values[1];
                this.mMagneticFieldVector[2] = event.values[2];
                this.getOrientationUsingGetRotationMatrix();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
        assert ("WebViewCoreThread".equals(Thread.currentThread().getName()));
    }
}

