/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.net.ParseException;
import android.net.http.ErrorStrings;
import android.net.http.RequestHandle;
import android.os.Build;
import android.webkit.CacheLoader;
import android.webkit.CacheManager;
import android.webkit.ContentLoader;
import android.webkit.CookieManager;
import android.webkit.DataLoader;
import android.webkit.FileLoader;
import android.webkit.JniUtil;
import android.webkit.LoadListener;
import android.webkit.Network;
import android.webkit.URLUtil;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebViewWorker;
import java.util.HashMap;
import java.util.Map;

public class FrameLoader {
    public final LoadListener mListener;
    public final String mMethod;
    public final WebSettings mSettings;
    public Map<String, String> mHeaders;
    public byte[] mPostData;
    public Network mNetwork;
    public int mCacheMode;
    public String mReferrer;
    public String mContentType;
    public final String mUaprofHeader;
    public final WebResourceResponse mInterceptResponse;
    public static final int URI_PROTOCOL = 256;
    public static final String CONTENT_TYPE = "content-type";
    public static final String mAboutBlank = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EB\"><html><head><title>about:blank</title></head><body></body></html>";
    public static final String HEADER_STR = "text/xml, text/html, application/xhtml+xml, image/png, text/plain, */*;q=0.8";
    public static final String LOGTAG = "webkit";

    public FrameLoader(LoadListener listener, WebSettings settings, String method, WebResourceResponse interceptResponse) {
        assert (!JniUtil.useChromiumHttpStack());
        this.mListener = listener;
        this.mHeaders = null;
        this.mMethod = method;
        this.mCacheMode = 0;
        this.mSettings = settings;
        this.mInterceptResponse = interceptResponse;
        this.mUaprofHeader = this.mListener.getContext().getResources().getString(17039390, Build.MODEL);
    }

    public void setReferrer(String ref) {
        if (URLUtil.isNetworkUrl(ref)) {
            this.mReferrer = ref;
        }
    }

    public void setPostData(byte[] postData) {
        this.mPostData = postData;
    }

    public void setContentTypeForPost(String postContentType) {
        this.mContentType = postContentType;
    }

    public void setCacheMode(int cacheMode) {
        this.mCacheMode = cacheMode;
    }

    public void setHeaders(HashMap headers) {
        this.mHeaders = headers;
    }

    public LoadListener getLoadListener() {
        return this.mListener;
    }

    public boolean executeLoad() {
        String url = this.mListener.url();
        if (this.mInterceptResponse != null) {
            if (this.mListener.isSynchronous()) {
                this.mInterceptResponse.loader(this.mListener).load();
            } else {
                WebViewWorker.getHandler().obtainMessage(101, this.mInterceptResponse.loader(this.mListener)).sendToTarget();
            }
            return true;
        }
        if (URLUtil.isNetworkUrl(url)) {
            if (this.mSettings.getBlockNetworkLoads()) {
                this.mListener.error(-12, this.mListener.getContext().getString(17039367));
                return false;
            }
            if (!URLUtil.verifyURLEncoding(this.mListener.host())) {
                this.mListener.error(-12, this.mListener.getContext().getString(17039367));
                return false;
            }
            this.mNetwork = Network.getInstance(this.mListener.getContext());
            if (this.mListener.isSynchronous()) {
                return this.handleHTTPLoad();
            }
            WebViewWorker.getHandler().obtainMessage(102, this).sendToTarget();
            return true;
        }
        if (FrameLoader.handleLocalFile(url, this.mListener, this.mSettings)) {
            return true;
        }
        this.mListener.error(-10, ((Object)this.mListener.getContext().getText(17039368)).toString());
        return false;
    }

    public static boolean handleLocalFile(String url, LoadListener loadListener, WebSettings settings) {
        assert (!JniUtil.useChromiumHttpStack());
        try {
            url = new String(URLUtil.decode(url.getBytes()));
        }
        catch (IllegalArgumentException e) {
            loadListener.error(-12, loadListener.getContext().getString(17039367));
            return true;
        }
        if (URLUtil.isAssetUrl(url)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(url, loadListener, 1, true).load();
            } else {
                WebViewWorker.getHandler().obtainMessage(101, new FileLoader(url, loadListener, 1, true)).sendToTarget();
            }
            return true;
        }
        if (URLUtil.isResourceUrl(url)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(url, loadListener, 2, true).load();
            } else {
                WebViewWorker.getHandler().obtainMessage(101, new FileLoader(url, loadListener, 2, true)).sendToTarget();
            }
            return true;
        }
        if (URLUtil.isFileUrl(url)) {
            if (loadListener.isSynchronous()) {
                new FileLoader(url, loadListener, 3, settings.getAllowFileAccess()).load();
            } else {
                WebViewWorker.getHandler().obtainMessage(101, new FileLoader(url, loadListener, 3, settings.getAllowFileAccess())).sendToTarget();
            }
            return true;
        }
        if (settings.getAllowContentAccess() && URLUtil.isContentUrl(url)) {
            if (loadListener.isSynchronous()) {
                new ContentLoader(loadListener.url(), loadListener).load();
            } else {
                WebViewWorker.getHandler().obtainMessage(101, new ContentLoader(loadListener.url(), loadListener)).sendToTarget();
            }
            return true;
        }
        if (URLUtil.isDataUrl(url)) {
            new DataLoader(url, loadListener).load();
            return true;
        }
        if (URLUtil.isAboutUrl(url)) {
            loadListener.data(mAboutBlank.getBytes(), mAboutBlank.length());
            loadListener.endData();
            return true;
        }
        return false;
    }

    public boolean handleHTTPLoad() {
        if (this.mHeaders == null) {
            this.mHeaders = new HashMap<String, String>();
        }
        this.populateStaticHeaders();
        this.populateHeaders();
        if (this.handleCache()) {
            this.mListener.setRequestData(this.mMethod, this.mHeaders, this.mPostData);
            return true;
        }
        boolean ret = false;
        int error = -10;
        try {
            ret = this.mNetwork.requestURL(this.mMethod, this.mHeaders, this.mPostData, this.mListener);
        }
        catch (ParseException ex) {
            error = -12;
        }
        catch (RuntimeException ex) {
            error = -12;
        }
        if (!ret) {
            this.mListener.error(error, ErrorStrings.getString(error, this.mListener.getContext()));
            return false;
        }
        return true;
    }

    public void startCacheLoad(CacheManager.CacheResult result) {
        CacheLoader cacheLoader = new CacheLoader(this.mListener, result);
        this.mListener.setCacheLoader(cacheLoader);
        if (this.mListener.isSynchronous()) {
            cacheLoader.load();
        } else {
            WebViewWorker.getHandler().obtainMessage(101, cacheLoader).sendToTarget();
        }
    }

    public boolean handleCache() {
        switch (this.mCacheMode) {
            case 2: {
                break;
            }
            case 3: {
                CacheManager.CacheResult result = CacheManager.getCacheFile(this.mListener.url(), this.mListener.postIdentifier(), null);
                if (result != null) {
                    this.startCacheLoad(result);
                } else {
                    int err = -14;
                    this.mListener.error(err, ErrorStrings.getString(err, this.mListener.getContext()));
                }
                return true;
            }
            case 1: {
                CacheManager.CacheResult result = CacheManager.getCacheFile(this.mListener.url(), this.mListener.postIdentifier(), null);
                if (result == null) break;
                this.startCacheLoad(result);
                return true;
            }
            default: {
                return this.mListener.checkCache(this.mHeaders);
            }
        }
        return false;
    }

    public void populateStaticHeaders() {
        String accept = this.mHeaders.get("Accept");
        if (accept == null || accept.length() == 0) {
            this.mHeaders.put("Accept", HEADER_STR);
        }
        this.mHeaders.put("Accept-Charset", "utf-8, iso-8859-1, utf-16, *;q=0.7");
        String acceptLanguage = this.mSettings.getAcceptLanguage();
        if (acceptLanguage.length() > 0) {
            this.mHeaders.put("Accept-Language", acceptLanguage);
        }
        this.mHeaders.put("User-Agent", this.mSettings.getUserAgentString());
        if (this.mUaprofHeader != null && this.mUaprofHeader.length() > 0) {
            this.mHeaders.put("x-wap-profile", this.mUaprofHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateHeaders() {
        String cookie;
        if (this.mReferrer != null) {
            this.mHeaders.put("Referer", this.mReferrer);
        }
        if (this.mContentType != null) {
            this.mHeaders.put(CONTENT_TYPE, this.mContentType);
        }
        if (this.mNetwork.isValidProxySet()) {
            String password;
            String username;
            Network network = this.mNetwork;
            synchronized (network) {
                username = this.mNetwork.getProxyUsername();
                password = this.mNetwork.getProxyPassword();
            }
            if (username != null && password != null) {
                String proxyHeader = RequestHandle.authorizationHeader(true);
                this.mHeaders.put(proxyHeader, "Basic " + RequestHandle.computeBasicAuthResponse(username, password));
            }
        }
        if ((cookie = CookieManager.getInstance().getCookie(this.mListener.getWebAddress())) != null && cookie.length() > 0) {
            this.mHeaders.put("Cookie", cookie);
        }
    }
}

