/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.os.Handler;
import android.os.Message;
import android.webkit.ValueCallback;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeolocationPermissions {
    public static final String TAG = "geolocationPermissions";
    public static GeolocationPermissions sInstance;
    public Handler mHandler;
    public Handler mUIHandler;
    public Vector<Message> mQueuedMessages;
    public static final int GET_ORIGINS = 0;
    public static final int GET_ALLOWED = 1;
    public static final int CLEAR = 2;
    public static final int ALLOW = 3;
    public static final int CLEAR_ALL = 4;
    public static final int RETURN_ORIGINS = 0;
    public static final int RETURN_ALLOWED = 1;
    public static final String ORIGINS = "origins";
    public static final String ORIGIN = "origin";
    public static final String CALLBACK = "callback";
    public static final String ALLOWED = "allowed";

    public static GeolocationPermissions getInstance() {
        if (sInstance == null) {
            sInstance = new GeolocationPermissions();
        }
        return sInstance;
    }

    public void createUIHandler() {
        if (this.mUIHandler == null) {
            this.mUIHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Map values = (Map)msg.obj;
                            Set origins = (Set)values.get(GeolocationPermissions.ORIGINS);
                            ValueCallback callback = (ValueCallback)values.get(GeolocationPermissions.CALLBACK);
                            callback.onReceiveValue(origins);
                            break;
                        }
                        case 1: {
                            Map values = (Map)msg.obj;
                            Boolean allowed = (Boolean)values.get(GeolocationPermissions.ALLOWED);
                            ValueCallback callback = (ValueCallback)values.get(GeolocationPermissions.CALLBACK);
                            callback.onReceiveValue(allowed);
                        }
                    }
                }
            };
        }
    }

    public synchronized void createHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(){

                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 0: {
                            Set origins = GeolocationPermissions.nativeGetOrigins();
                            ValueCallback callback = (ValueCallback)msg.obj;
                            HashMap<String, Object> values = new HashMap<String, Object>();
                            values.put(GeolocationPermissions.CALLBACK, callback);
                            values.put(GeolocationPermissions.ORIGINS, origins);
                            GeolocationPermissions.this.postUIMessage(Message.obtain(null, 0, values));
                            break;
                        }
                        case 1: {
                            Map values = (Map)msg.obj;
                            String origin = (String)values.get(GeolocationPermissions.ORIGIN);
                            ValueCallback callback = (ValueCallback)values.get(GeolocationPermissions.CALLBACK);
                            boolean allowed = GeolocationPermissions.nativeGetAllowed(origin);
                            HashMap<String, Object> retValues = new HashMap<String, Object>();
                            retValues.put(GeolocationPermissions.CALLBACK, callback);
                            retValues.put(GeolocationPermissions.ALLOWED, allowed);
                            GeolocationPermissions.this.postUIMessage(Message.obtain(null, 1, retValues));
                            break;
                        }
                        case 2: {
                            GeolocationPermissions.nativeClear((String)msg.obj);
                            break;
                        }
                        case 3: {
                            GeolocationPermissions.nativeAllow((String)msg.obj);
                            break;
                        }
                        case 4: {
                            GeolocationPermissions.nativeClearAll();
                        }
                    }
                }
            };
            if (this.mQueuedMessages != null) {
                while (!this.mQueuedMessages.isEmpty()) {
                    this.mHandler.sendMessage(this.mQueuedMessages.remove(0));
                }
                this.mQueuedMessages = null;
            }
        }
    }

    public synchronized void postMessage(Message msg) {
        if (this.mHandler == null) {
            if (this.mQueuedMessages == null) {
                this.mQueuedMessages = new Vector();
            }
            this.mQueuedMessages.add(msg);
        } else {
            this.mHandler.sendMessage(msg);
        }
    }

    public void postUIMessage(Message msg) {
        if (this.mUIHandler != null) {
            this.mUIHandler.sendMessage(msg);
        }
    }

    public void getOrigins(ValueCallback<Set<String>> callback) {
        if (callback != null) {
            if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
                Set origins = GeolocationPermissions.nativeGetOrigins();
                callback.onReceiveValue(origins);
            } else {
                this.postMessage(Message.obtain(null, 0, callback));
            }
        }
    }

    public void getAllowed(String origin, ValueCallback<Boolean> callback) {
        if (callback == null) {
            return;
        }
        if (origin == null) {
            callback.onReceiveValue(null);
            return;
        }
        if ("WebViewCoreThread".equals(Thread.currentThread().getName())) {
            boolean allowed = GeolocationPermissions.nativeGetAllowed(origin);
            callback.onReceiveValue(new Boolean(allowed));
        } else {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put(ORIGIN, origin);
            values.put(CALLBACK, callback);
            this.postMessage(Message.obtain(null, 1, values));
        }
    }

    public void clear(String origin) {
        this.postMessage(Message.obtain(null, 2, origin));
    }

    public void allow(String origin) {
        this.postMessage(Message.obtain(null, 3, origin));
    }

    public void clearAll() {
        this.postMessage(Message.obtain(null, 4));
    }

    public static Set nativeGetOrigins() {
        return (Set)OverrideMethod.invokeA("android.webkit.GeolocationPermissions#nativeGetOrigins()Ljava/util/Set;", true, null);
    }

    public static boolean nativeGetAllowed(String string2) {
        return OverrideMethod.invokeI("android.webkit.GeolocationPermissions#nativeGetAllowed(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static void nativeClear(String string2) {
        OverrideMethod.invokeV("android.webkit.GeolocationPermissions#nativeClear(Ljava/lang/String;)V", true, null);
    }

    public static void nativeAllow(String string2) {
        OverrideMethod.invokeV("android.webkit.GeolocationPermissions#nativeAllow(Ljava/lang/String;)V", true, null);
    }

    public static void nativeClearAll() {
        OverrideMethod.invokeV("android.webkit.GeolocationPermissions#nativeClearAll()V", true, null);
    }

    public static interface Callback {
        public void invoke(String var1, boolean var2, boolean var3);
    }
}

