/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.media.MediaFile;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import android.util.SparseBooleanArray;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SurfaceView;
import android.view.View;
import android.webkit.BrowserFrame;
import android.webkit.CacheManager;
import android.webkit.CallbackProxy;
import android.webkit.CookieManager;
import android.webkit.DeviceMotionAndOrientationManager;
import android.webkit.DeviceMotionService;
import android.webkit.DeviceOrientationService;
import android.webkit.GeolocationPermissions;
import android.webkit.JniUtil;
import android.webkit.Network;
import android.webkit.PluginManager;
import android.webkit.ValueCallback;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebIconDatabase;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewWorker;
import android.webkit.ZoomManager;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebViewCore {
    public static final String LOGTAG = "webcore";
    public WebView mWebView;
    public final CallbackProxy mCallbackProxy;
    public final WebSettings mSettings;
    public final Context mContext;
    public int mNativeClass;
    public BrowserFrame mBrowserFrame;
    public Map<String, Object> mJavascriptInterfaces;
    public int mViewportWidth = -1;
    public int mViewportHeight = -1;
    public int mViewportInitialScale = 0;
    public int mViewportMinimumScale = 0;
    public int mViewportMaximumScale = 0;
    public boolean mViewportUserScalable = true;
    public int mViewportDensityDpi = -1;
    public float mRestoredScale = 0.0f;
    public float mRestoredTextWrapScale = 0.0f;
    public int mRestoredX = 0;
    public int mRestoredY = 0;
    public DeviceMotionAndOrientationManager mDeviceMotionAndOrientationManager = new DeviceMotionAndOrientationManager(this);
    public DeviceMotionService mDeviceMotionService;
    public DeviceOrientationService mDeviceOrientationService;
    public int mLowMemoryUsageThresholdMb;
    public int mHighMemoryUsageThresholdMb;
    public int mHighUsageDeltaMb;
    public static final String THREAD_NAME = "WebViewCoreThread";
    public final EventHub mEventHub;
    public static Handler sWebCoreHandler;
    public static final int ACTION_LONGPRESS = 256;
    public static final int ACTION_DOUBLETAP = 512;
    public static final String[] HandlerDebugString;
    public int mCurrentViewWidth = 0;
    public int mCurrentViewHeight = 0;
    public float mCurrentViewScale = 1.0f;
    public boolean mDrawIsScheduled;
    public boolean mDrawLayersIsScheduled;
    public boolean mSplitPictureIsScheduled;
    public boolean mDrawIsPaused;
    public ViewState mInitialViewState = null;
    public static boolean mRepaintScheduled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebViewCore(Context context, WebView w, CallbackProxy proxy, Map<String, Object> javascriptInterfaces) {
        this.mCallbackProxy = proxy;
        this.mWebView = w;
        this.mJavascriptInterfaces = javascriptInterfaces;
        this.mContext = context;
        Class<WebViewCore> clazz = WebViewCore.class;
        synchronized (WebViewCore.class) {
            if (sWebCoreHandler == null) {
                Thread t = new Thread(new WebCoreThread(null));
                t.setName(THREAD_NAME);
                t.start();
                try {
                    WebViewCore.class.wait();
                }
                catch (InterruptedException e) {
                    Log.e(LOGTAG, "Caught exception while waiting for thread creation.");
                    Log.e(LOGTAG, Log.getStackTraceString(e));
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.mEventHub = new EventHub(null);
            this.mSettings = new WebSettings(this.mContext, this.mWebView);
            WebIconDatabase.getInstance();
            WebStorage.getInstance().createUIHandler();
            GeolocationPermissions.getInstance().createUIHandler();
            ActivityManager manager = (ActivityManager)this.mContext.getSystemService("activity");
            ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
            manager.getMemoryInfo(memInfo);
            this.mLowMemoryUsageThresholdMb = manager.getLargeMemoryClass();
            this.mHighMemoryUsageThresholdMb = (int)((double)this.mLowMemoryUsageThresholdMb * 1.5);
            this.mHighUsageDeltaMb = this.mLowMemoryUsageThresholdMb / 32;
            Message init = sWebCoreHandler.obtainMessage(0, this);
            sWebCoreHandler.sendMessage(init);
            return;
        }
    }

    public void initialize() {
        this.mBrowserFrame = new BrowserFrame(this.mContext, this, this.mCallbackProxy, this.mSettings, this.mJavascriptInterfaces);
        this.mJavascriptInterfaces = null;
        this.mSettings.syncSettingsAndCreateHandler(this.mBrowserFrame);
        WebIconDatabase.getInstance().createHandler();
        WebStorage.getInstance().createHandler();
        GeolocationPermissions.getInstance().createHandler();
        this.mEventHub.transferMessages();
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 107, this.mNativeClass, 0).sendToTarget();
        }
    }

    public void initializeSubwindow() {
        this.initialize();
        sWebCoreHandler.removeMessages(0, this);
    }

    public BrowserFrame getBrowserFrame() {
        return this.mBrowserFrame;
    }

    public static void pauseTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.pause();
    }

    public static void resumeTimers() {
        if (BrowserFrame.sJavaBridge == null) {
            throw new IllegalStateException("No WebView has been created in this process!");
        }
        BrowserFrame.sJavaBridge.resume();
    }

    public WebSettings getSettings() {
        return this.mSettings;
    }

    public static boolean isSupportedMediaMimeType(String mimeType) {
        int fileType = MediaFile.getFileTypeForMimeType(mimeType);
        return MediaFile.isAudioFileType(fileType) || MediaFile.isVideoFileType(fileType) || MediaFile.isPlayListFileType(fileType) || mimeType != null && mimeType.startsWith("video/m4v");
    }

    public void addMessageToConsole(String message, int lineNumber, String sourceID, int msgLevel) {
        this.mCallbackProxy.addMessageToConsole(message, lineNumber, sourceID, msgLevel);
    }

    public void jsAlert(String url, String message) {
        this.mCallbackProxy.onJsAlert(url, message);
    }

    public void formDidBlur(int nodePointer) {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 124, nodePointer, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openFileChooser(String acceptType) {
        Uri uri = this.mCallbackProxy.openFileChooser(acceptType);
        if (uri != null) {
            String filePath = "";
            Cursor cursor = this.mContext.getContentResolver().query(uri, new String[]{"_data"}, null, null, null);
            if (cursor != null) {
                try {
                    if (cursor.moveToNext()) {
                        filePath = cursor.getString(0);
                    }
                    Object var6_5 = null;
                    cursor.close();
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    cursor.close();
                    throw throwable;
                }
            } else {
                filePath = uri.getLastPathSegment();
            }
            String uriString = uri.toString();
            BrowserFrame.sJavaBridge.storeFilePathForContentUri(filePath, uriString);
            return uriString;
        }
        return "";
    }

    public void exceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize) {
        this.mCallbackProxy.onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long quota) {
                WebViewCore.this.nativeSetNewStorageLimit(quota);
            }
        });
    }

    public void reachedMaxAppCacheSize(long spaceNeeded) {
        this.mCallbackProxy.onReachedMaxAppCacheSize(spaceNeeded, this.getUsedQuota(), new WebStorage.QuotaUpdater(){

            public void updateQuota(long quota) {
                WebViewCore.this.nativeSetNewStorageLimit(quota);
            }
        });
    }

    public void populateVisitedLinks() {
        ValueCallback<String[]> callback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(String[] value) {
                WebViewCore.this.sendMessage(181, value);
            }
        };
        this.mCallbackProxy.getVisitedHistory(callback);
    }

    public void geolocationPermissionsShowPrompt(String origin) {
        this.mCallbackProxy.onGeolocationPermissionsShowPrompt(origin, new GeolocationPermissions.Callback(){

            public void invoke(String origin, boolean allow, boolean remember) {
                GeolocationPermissionsData data = new GeolocationPermissionsData();
                data.mOrigin = origin;
                data.mAllow = allow;
                data.mRemember = remember;
                WebViewCore.this.sendMessage(180, data);
            }
        });
    }

    public void geolocationPermissionsHidePrompt() {
        this.mCallbackProxy.onGeolocationPermissionsHidePrompt();
    }

    public boolean jsConfirm(String url, String message) {
        return this.mCallbackProxy.onJsConfirm(url, message);
    }

    public String jsPrompt(String url, String message, String defaultValue) {
        return this.mCallbackProxy.onJsPrompt(url, message, defaultValue);
    }

    public boolean jsUnload(String url, String message) {
        return this.mCallbackProxy.onJsBeforeUnload(url, message);
    }

    public boolean jsInterrupt() {
        return this.mCallbackProxy.onJsTimeout();
    }

    public void setInstallableWebApp() {
        this.mCallbackProxy.setInstallableWebApp();
    }

    public void enterFullscreenForVideoLayer(int layerId, String url) {
        if (this.mWebView == null) {
            return;
        }
        Message message = Message.obtain(this.mWebView.mPrivateHandler, 137, layerId, 0);
        message.obj = url;
        message.sendToTarget();
    }

    public static String nativeFindAddress(String string2, boolean bl) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeFindAddress(Ljava/lang/String;Z)Ljava/lang/String;", true, null);
    }

    public void nativeClearContent() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeClearContent()V", true, this);
    }

    public void nativeContentInvalidateAll() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeContentInvalidateAll()V", true, this);
    }

    public int nativeRecordContent(Region region, Point point) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeRecordContent(Landroid/graphics/Region;Landroid/graphics/Point;)I", true, this);
    }

    public int nativeUpdateLayers(Region region) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeUpdateLayers(Landroid/graphics/Region;)I", true, this);
    }

    public boolean nativeFocusBoundsChanged() {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeFocusBoundsChanged()Z", true, this) != 0;
    }

    public void nativeSplitContent(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSplitContent(I)V", true, this);
    }

    public boolean nativeKey(int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeKey(IIIZZZZ)Z", true, this) != 0;
    }

    public void nativeClick(int n, int n2, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeClick(IIZ)V", true, this);
    }

    public void nativeSendListBoxChoices(boolean[] blArray, int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSendListBoxChoices([ZI)V", true, this);
    }

    public void nativeSendListBoxChoice(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSendListBoxChoice(I)V", true, this);
    }

    public void nativeSetSize(int n, int n2, int n3, float f, int n4, int n5, int n6, int n7, boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetSize(IIIFIIIIZ)V", true, this);
    }

    public int nativeGetContentMinPrefWidth() {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeGetContentMinPrefWidth()I", true, this);
    }

    public void nativeReplaceTextfieldText(int n, int n2, String string2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeReplaceTextfieldText(IILjava/lang/String;III)V", true, this);
    }

    public void passToJs(int n, String string2, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#passToJs(ILjava/lang/String;IIZZZZ)V", true, this);
    }

    public void nativeSetFocusControllerActive(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetFocusControllerActive(Z)V", true, this);
    }

    public void nativeSaveDocumentState(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSaveDocumentState(I)V", true, this);
    }

    public void nativeMoveFocus(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeMoveFocus(II)V", true, this);
    }

    public void nativeMoveMouse(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeMoveMouse(III)V", true, this);
    }

    public void nativeMoveMouseIfLatest(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeMoveMouseIfLatest(IIII)V", true, this);
    }

    public String nativeRetrieveHref(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveHref(II)Ljava/lang/String;", true, this);
    }

    public String nativeRetrieveAnchorText(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveAnchorText(II)Ljava/lang/String;", true, this);
    }

    public String nativeRetrieveImageSource(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRetrieveImageSource(II)Ljava/lang/String;", true, this);
    }

    public void nativeStopPaintingCaret() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeStopPaintingCaret()V", true, this);
    }

    public void nativeTouchUp(int n, int n2, int n3, int n4, int n5) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeTouchUp(IIIII)V", true, this);
    }

    public boolean nativeHandleTouchEvent(int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, int n4) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeHandleTouchEvent(I[I[I[IIII)Z", true, this) != 0;
    }

    public void nativeUpdateFrameCache() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeUpdateFrameCache()V", true, this);
    }

    public void nativeSetBackgroundColor(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetBackgroundColor(I)V", true, this);
    }

    public void nativeDumpDomTree(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpDomTree(Z)V", true, this);
    }

    public void nativeDumpRenderTree(boolean bl) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpRenderTree(Z)V", true, this);
    }

    public void nativeDumpNavTree() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpNavTree()V", true, this);
    }

    public void nativeDumpV8Counters() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDumpV8Counters()V", true, this);
    }

    public void nativeSetJsFlags(String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetJsFlags(Ljava/lang/String;)V", true, this);
    }

    public void nativeDeleteSelection(int n, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeDeleteSelection(III)V", true, this);
    }

    public void nativeSetSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetSelection(II)V", true, this);
    }

    public void nativeRegisterURLSchemeAsLocal(String string2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeRegisterURLSchemeAsLocal(Ljava/lang/String;)V", true, this);
    }

    public void nativeSetNewStorageLimit(long l) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetNewStorageLimit(J)V", true, this);
    }

    public void nativeGeolocationPermissionsProvide(String string2, boolean bl, boolean bl2) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeGeolocationPermissionsProvide(Ljava/lang/String;ZZ)V", true, this);
    }

    public void nativeProvideVisitedHistory(String[] stringArray) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeProvideVisitedHistory([Ljava/lang/String;)V", true, this);
    }

    public String nativeModifySelection(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeModifySelection(II)Ljava/lang/String;", true, this);
    }

    public void stopLoading() {
        if (this.mBrowserFrame != null) {
            this.mBrowserFrame.stopLoading();
        }
    }

    public void sendMessage(Message msg) {
        this.mEventHub.sendMessage(msg);
    }

    public void sendMessage(int what) {
        this.mEventHub.sendMessage(Message.obtain(null, what));
    }

    public void sendMessage(int what, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, obj));
    }

    public void sendMessage(int what, int arg1) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0));
    }

    public void sendMessage(int what, int arg1, int arg2) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2));
    }

    public void sendMessage(int what, int arg1, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, 0, obj));
    }

    public void sendMessage(int what, int arg1, int arg2, Object obj) {
        this.mEventHub.sendMessage(Message.obtain(null, what, arg1, arg2, obj));
    }

    public void sendMessageAtFrontOfQueue(int what, Object obj) {
        this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, what, obj));
    }

    public void sendMessageDelayed(int what, Object obj, long delay) {
        this.mEventHub.sendMessageDelayed(Message.obtain(null, what, obj), delay);
    }

    public void removeMessages(int what) {
        this.mEventHub.removeMessages(what);
    }

    public void removeMessages() {
        this.mEventHub.removeMessages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        EventHub eventHub = this.mEventHub;
        synchronized (eventHub) {
            boolean hasResume = this.mEventHub.hasMessages(110);
            boolean hasPause = this.mEventHub.hasMessages(109);
            this.mEventHub.removeMessages();
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 200));
            if (hasPause) {
                this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 109));
            }
            if (hasResume) {
                this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 110));
            }
            this.mEventHub.blockMessages();
        }
    }

    public void clearCache(boolean includeDiskFiles) {
        this.mBrowserFrame.clearCache();
        if (includeDiskFiles) {
            CacheManager.removeAllCacheFiles();
        }
    }

    public void loadUrl(String url, Map<String, String> extraHeaders) {
        this.mBrowserFrame.loadUrl(url, extraHeaders);
    }

    public String saveWebArchive(String filename, boolean autoname) {
        return this.mBrowserFrame.saveWebArchive(filename, autoname);
    }

    public void key(KeyEvent evt, boolean isDown) {
        int keyCode = evt.getKeyCode();
        int unicodeChar = evt.getUnicodeChar();
        if (keyCode == 0 && evt.getCharacters() != null && evt.getCharacters().length() > 0) {
            unicodeChar = evt.getCharacters().codePointAt(0);
        }
        if (!this.nativeKey(keyCode, unicodeChar, evt.getRepeatCount(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed(), isDown) && keyCode != 66) {
            if (keyCode >= 19 && keyCode <= 22) {
                if (this.mWebView != null && evt.isDown()) {
                    Message.obtain(this.mWebView.mPrivateHandler, 110, keyCode, 0).sendToTarget();
                }
                return;
            }
            this.mCallbackProxy.onUnhandledKeyEvent(evt);
        }
    }

    public void viewSizeChanged(WebView.ViewSizeData data) {
        int w = data.mWidth;
        int h = data.mHeight;
        int textwrapWidth = data.mTextWrapWidth;
        float scale = data.mScale;
        if (w == 0) {
            Log.w(LOGTAG, "skip viewSizeChanged as w is 0");
            return;
        }
        int width = this.calculateWindowWidth(w, textwrapWidth);
        int height = h;
        if (width != w) {
            float heightWidthRatio = data.mHeightWidthRatio;
            float ratio = heightWidthRatio > 0.0f ? heightWidthRatio : (float)h / (float)w;
            height = Math.round(ratio * (float)width);
        }
        this.nativeSetSize(width, height, textwrapWidth, scale, w, data.mActualViewHeight > 0 ? data.mActualViewHeight : h, data.mAnchorX, data.mAnchorY, data.mIgnoreHeight);
        boolean needInvalidate = this.mCurrentViewWidth == 0;
        this.mCurrentViewWidth = w;
        this.mCurrentViewHeight = h;
        this.mCurrentViewScale = scale;
        if (needInvalidate) {
            this.contentDraw();
        }
        this.mEventHub.sendMessage(Message.obtain(null, 117));
    }

    public int calculateWindowWidth(int viewWidth, int textwrapWidth) {
        int width = viewWidth;
        if (this.mSettings.getUseWideViewPort()) {
            width = this.mViewportWidth == -1 ? (this.mSettings.getLayoutAlgorithm() == WebSettings.LayoutAlgorithm.NORMAL || this.mSettings.getUseFixedViewport() ? 980 : Math.min(WebView.sMaxViewportWidth, Math.max(viewWidth, Math.max(980, this.nativeGetContentMinPrefWidth())))) : (this.mViewportWidth > 0 ? (this.mSettings.getUseFixedViewport() ? this.mViewportWidth : Math.max(viewWidth, this.mViewportWidth)) : (this.mSettings.getUseFixedViewport() ? this.mWebView.getViewWidth() : textwrapWidth));
        }
        return width;
    }

    public void sendUpdateTextEntry() {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 106).sendToTarget();
        }
    }

    public long getUsedQuota() {
        WebStorage webStorage = WebStorage.getInstance();
        Collection<WebStorage.Origin> origins = webStorage.getOriginsSync();
        if (origins == null) {
            return 0L;
        }
        long usedQuota = 0L;
        for (WebStorage.Origin website : origins) {
            usedQuota += website.getQuota();
        }
        return usedQuota;
    }

    public void splitContent(int content) {
        if (!this.mSplitPictureIsScheduled) {
            this.mSplitPictureIsScheduled = true;
            this.sendMessage(133, content, 0);
        }
    }

    public void webkitDrawLayers() {
        this.mDrawLayersIsScheduled = false;
        if (this.mDrawIsScheduled) {
            this.removeMessages(130);
            this.webkitDraw();
            return;
        }
        DrawData draw = new DrawData();
        draw.mBaseLayer = this.nativeUpdateLayers(draw.mInvalRegion);
        this.webkitDraw(draw);
    }

    public void webkitDraw() {
        this.mDrawIsScheduled = false;
        DrawData draw = new DrawData();
        draw.mBaseLayer = this.nativeRecordContent(draw.mInvalRegion, draw.mContentSize);
        if (draw.mBaseLayer == 0) {
            return;
        }
        this.webkitDraw(draw);
    }

    public void webkitDraw(DrawData draw) {
        if (this.mWebView != null) {
            draw.mFocusSizeChanged = this.nativeFocusBoundsChanged();
            draw.mViewSize = new Point(this.mCurrentViewWidth, this.mCurrentViewHeight);
            if (this.mSettings.getUseWideViewPort()) {
                draw.mMinPrefWidth = Math.max(this.mViewportWidth == -1 ? 980 : (this.mViewportWidth == 0 ? this.mCurrentViewWidth : this.mViewportWidth), this.nativeGetContentMinPrefWidth());
            }
            if (this.mInitialViewState != null) {
                draw.mViewState = this.mInitialViewState;
                this.mInitialViewState = null;
            }
            Message.obtain(this.mWebView.mPrivateHandler, 105, draw).sendToTarget();
        }
    }

    public static void reducePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(1));
    }

    public static void resumePriority() {
        sWebCoreHandler.removeMessages(1);
        sWebCoreHandler.removeMessages(2);
        sWebCoreHandler.sendMessageAtFrontOfQueue(sWebCoreHandler.obtainMessage(2));
    }

    public static void sendStaticMessage(int messageType, Object argument) {
        if (sWebCoreHandler == null) {
            return;
        }
        sWebCoreHandler.sendMessage(sWebCoreHandler.obtainMessage(messageType, argument));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.getSettings().enableSmoothTransition()) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                core.mDrawIsPaused = true;
                if (core.mDrawIsScheduled) {
                    core.mEventHub.removeMessages(130);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeUpdatePicture(WebViewCore core) {
        if (core != null) {
            if (!core.mDrawIsPaused && !core.getSettings().enableSmoothTransition()) {
                return;
            }
            WebViewCore webViewCore = core;
            synchronized (webViewCore) {
                core.mDrawIsPaused = false;
                core.mDrawIsScheduled = false;
                core.nativeContentInvalidateAll();
                core.contentDraw();
            }
        }
    }

    public void restoreState(int index) {
        WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
        int size = list.getSize();
        for (int i = 0; i < size; ++i) {
            list.getItemAtIndex(i).inflate(this.mBrowserFrame.mNativeFrame);
        }
        this.mBrowserFrame.mLoadInitFromJava = true;
        WebBackForwardList.restoreIndex(this.mBrowserFrame.mNativeFrame, index);
        this.mBrowserFrame.mLoadInitFromJava = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentDraw() {
        if (this.mCurrentViewWidth == 0 || !this.mBrowserFrame.firstLayoutDone()) {
            return;
        }
        WebViewCore webViewCore = this;
        synchronized (webViewCore) {
            if (this.mDrawIsScheduled) {
                return;
            }
            this.mDrawIsScheduled = true;
            if (this.mDrawIsPaused) {
                return;
            }
            this.mEventHub.sendMessage(Message.obtain(null, 130));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layersDraw() {
        WebViewCore webViewCore = this;
        synchronized (webViewCore) {
            if (this.mDrawLayersIsScheduled) {
                return;
            }
            this.mDrawLayersIsScheduled = true;
            this.mEventHub.sendMessage(Message.obtain(null, 148));
        }
    }

    public void contentScrollTo(int x, int y, boolean animate, boolean onlyIfImeIsShowing) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredX = x;
            this.mRestoredY = y;
            return;
        }
        if (this.mWebView != null) {
            Message msg = Message.obtain(this.mWebView.mPrivateHandler, 101, animate ? 1 : 0, onlyIfImeIsShowing ? 1 : 0, new Point(x, y));
            if (this.mDrawIsScheduled) {
                this.mEventHub.sendMessage(Message.obtain(null, 125, msg));
            } else {
                msg.sendToTarget();
            }
        }
    }

    public void sendNotifyProgressFinished() {
        this.sendUpdateTextEntry();
        if (!JniUtil.useChromiumHttpStack()) {
            WebViewWorker.getHandler().removeMessages(110);
            WebViewWorker.getHandler().sendEmptyMessage(110);
        }
        this.contentDraw();
    }

    public void sendViewInvalidate(int left, int top, int right, int bottom) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 117, new Rect(left, top, right, bottom)).sendToTarget();
        }
    }

    public void signalRepaintDone() {
        mRepaintScheduled = false;
    }

    public WebView getWebView() {
        return this.mWebView;
    }

    public void setViewportSettingsFromNative() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#setViewportSettingsFromNative()V", true, this);
    }

    public void didFirstLayout(boolean standardLoad) {
        this.mBrowserFrame.didFirstLayout();
        if (this.mWebView == null) {
            return;
        }
        boolean updateViewState = standardLoad || this.mRestoredScale > 0.0f;
        this.setupViewport(updateViewState);
        if (!updateViewState) {
            this.mWebView.mViewManager.postReadyToDrawAll();
        }
        if (this.getSettings().supportTouchOnly()) {
            this.mEventHub.sendMessage(Message.obtain(null, 188));
        }
        this.mRestoredY = 0;
        this.mRestoredX = 0;
        this.mRestoredTextWrapScale = 0.0f;
        this.mRestoredScale = 0.0f;
    }

    public void updateViewport() {
        if (this.mBrowserFrame.firstLayoutDone()) {
            this.setupViewport(true);
        }
    }

    public void setupViewport(boolean updateViewState) {
        int webViewWidth;
        this.setViewportSettingsFromNative();
        float adjust = 1.0f;
        if (this.mViewportDensityDpi == -1) {
            if (this.mWebView != null && (int)(this.mWebView.getDefaultZoomScale() * 100.0f) != 100) {
                adjust = this.mWebView.getDefaultZoomScale();
            }
        } else if (this.mViewportDensityDpi > 0) {
            adjust = (float)this.mContext.getResources().getDisplayMetrics().densityDpi / (float)this.mViewportDensityDpi;
        }
        int defaultScale = (int)(adjust * 100.0f);
        if (this.mViewportInitialScale > 0) {
            this.mViewportInitialScale = (int)((float)this.mViewportInitialScale * adjust);
        }
        if (this.mViewportMinimumScale > 0) {
            this.mViewportMinimumScale = (int)((float)this.mViewportMinimumScale * adjust);
        }
        if (this.mViewportMaximumScale > 0) {
            this.mViewportMaximumScale = (int)((float)this.mViewportMaximumScale * adjust);
        }
        if (this.mViewportWidth == 0 && this.mViewportInitialScale == 0) {
            this.mViewportInitialScale = defaultScale;
        }
        if (!this.mViewportUserScalable) {
            this.mViewportInitialScale = defaultScale;
            this.mViewportMinimumScale = defaultScale;
            this.mViewportMaximumScale = defaultScale;
        }
        if (this.mViewportMinimumScale > this.mViewportInitialScale && this.mViewportInitialScale != 0) {
            this.mViewportMinimumScale = this.mViewportInitialScale;
        }
        if (this.mViewportMaximumScale > 0 && this.mViewportMaximumScale < this.mViewportInitialScale) {
            this.mViewportMaximumScale = this.mViewportInitialScale;
        }
        if (this.mViewportWidth < 0 && this.mViewportInitialScale == defaultScale) {
            this.mViewportWidth = 0;
        }
        if (this.mViewportWidth != 0 && !updateViewState) {
            ViewState viewState = new ViewState();
            viewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
            viewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
            viewState.mDefaultScale = adjust;
            viewState.mMobileSite = false;
            viewState.mScrollX = 0;
            Message.obtain(this.mWebView.mPrivateHandler, 109, viewState).sendToTarget();
            return;
        }
        int viewportWidth = this.mCurrentViewWidth;
        if (viewportWidth == 0) {
            webViewWidth = this.mWebView.getViewWidth();
            viewportWidth = (int)((float)webViewWidth / adjust);
            if (viewportWidth == 0) {
                Log.w(LOGTAG, "Can't get the viewWidth after the first layout");
            }
        } else {
            webViewWidth = Math.round((float)viewportWidth * this.mCurrentViewScale);
        }
        this.mInitialViewState = new ViewState();
        this.mInitialViewState.mMinScale = (float)this.mViewportMinimumScale / 100.0f;
        this.mInitialViewState.mMaxScale = (float)this.mViewportMaximumScale / 100.0f;
        this.mInitialViewState.mDefaultScale = adjust;
        this.mInitialViewState.mScrollX = this.mRestoredX;
        this.mInitialViewState.mScrollY = this.mRestoredY;
        boolean bl = this.mInitialViewState.mMobileSite = 0 == this.mViewportWidth;
        if (this.mRestoredScale > 0.0f) {
            this.mInitialViewState.mIsRestored = true;
            this.mInitialViewState.mViewScale = this.mRestoredScale;
            this.mInitialViewState.mTextWrapScale = this.mRestoredTextWrapScale > 0.0f ? this.mRestoredTextWrapScale : this.mInitialViewState.mViewScale;
        } else if (this.mViewportInitialScale > 0) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)this.mViewportInitialScale / 100.0f;
        } else if (this.mViewportWidth > 0 && this.mViewportWidth < webViewWidth && !this.mWebView.getSettings().getUseFixedViewport()) {
            this.mInitialViewState.mViewScale = this.mInitialViewState.mTextWrapScale = (float)webViewWidth / (float)this.mViewportWidth;
        } else {
            this.mInitialViewState.mTextWrapScale = adjust;
            this.mInitialViewState.mViewScale = 0.0f;
        }
        if (this.mWebView.mHeightCanMeasure) {
            this.mWebView.mLastHeightSent = 0;
            WebView.ViewSizeData data = new WebView.ViewSizeData();
            data.mWidth = this.mWebView.mLastWidthSent;
            data.mHeight = 0;
            data.mTextWrapWidth = data.mWidth;
            data.mScale = -1.0f;
            data.mIgnoreHeight = false;
            data.mAnchorY = 0;
            data.mAnchorX = 0;
            this.mEventHub.removeMessages(105);
            this.mEventHub.sendMessageAtFrontOfQueue(Message.obtain(null, 105, data));
        } else if (this.mSettings.getUseWideViewPort()) {
            if (viewportWidth == 0) {
                this.mWebView.mLastWidthSent = 0;
            } else {
                WebView.ViewSizeData data = new WebView.ViewSizeData();
                float tentativeScale = this.mInitialViewState.mViewScale;
                if (tentativeScale == 0.0f) {
                    tentativeScale = this.mInitialViewState.mTextWrapScale;
                    int tentativeViewWidth = Math.round((float)webViewWidth / tentativeScale);
                    int windowWidth = this.calculateWindowWidth(tentativeViewWidth, tentativeViewWidth);
                    data.mScale = (float)webViewWidth / (float)windowWidth;
                    if (!this.mSettings.getLoadWithOverviewMode()) {
                        data.mScale = Math.max(data.mScale, tentativeScale);
                    }
                    if (this.mSettings.isNarrowColumnLayout() && this.mSettings.getUseFixedViewport()) {
                        this.mInitialViewState.mTextWrapScale = ZoomManager.computeReadingLevelScale(data.mScale);
                    }
                } else {
                    data.mScale = tentativeScale;
                }
                data.mWidth = Math.round((float)webViewWidth / data.mScale);
                data.mHeight = this.mCurrentViewHeight == 0 ? Math.round((float)this.mWebView.getViewHeight() / data.mScale) : Math.round((float)this.mCurrentViewHeight * (float)data.mWidth / (float)viewportWidth);
                data.mTextWrapWidth = Math.round((float)webViewWidth / this.mInitialViewState.mTextWrapScale);
                data.mIgnoreHeight = false;
                data.mAnchorY = 0;
                data.mAnchorX = 0;
                this.mEventHub.removeMessages(105);
                this.viewSizeChanged(data);
            }
        }
    }

    public void restoreScale(float scale, float textWrapScale) {
        if (!this.mBrowserFrame.firstLayoutDone()) {
            this.mRestoredScale = scale;
            if (this.mSettings.getUseWideViewPort()) {
                this.mRestoredTextWrapScale = textWrapScale;
            }
        }
    }

    public void needTouchEvents(boolean need) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 116, need ? 1 : 0, 0).sendToTarget();
        }
    }

    public void updateTextfield(int ptr, boolean changeToPassword, String text, int textGeneration) {
        if (this.mWebView != null) {
            Message msg = Message.obtain(this.mWebView.mPrivateHandler, 108, ptr, textGeneration, text);
            msg.getData().putBoolean("password", changeToPassword);
            msg.sendToTarget();
        }
    }

    public void updateTextSelection(int pointer, int start, int end, int textGeneration) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 112, pointer, textGeneration, new TextSelectionData(start, end)).sendToTarget();
        }
    }

    public void clearTextEntry() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 111).sendToTarget();
    }

    public void sendFindAgain() {
        if (this.mWebView == null) {
            return;
        }
        Message.obtain(this.mWebView.mPrivateHandler, 126).sendToTarget();
    }

    public void nativeUpdateFrameCacheIfLoading() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeUpdateFrameCacheIfLoading()V", true, this);
    }

    public void nativeRevealSelection() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeRevealSelection()V", true, this);
    }

    public String nativeRequestLabel(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeRequestLabel(II)Ljava/lang/String;", true, this);
    }

    public void nativeScrollFocusedTextInput(float f, int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeScrollFocusedTextInput(FI)V", true, this);
    }

    public void nativeSetScrollOffset(int n, boolean bl, int n2, int n3) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetScrollOffset(IZII)V", true, this);
    }

    public void nativeSetGlobalBounds(int n, int n2, int n3, int n4) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeSetGlobalBounds(IIII)V", true, this);
    }

    public void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(array2, enabledArray, selectedArray);
        }
    }

    public void requestListBox(String[] array2, int[] enabledArray, int selection) {
        if (this.mWebView != null) {
            this.mWebView.requestListBox(array2, enabledArray, selection);
        }
    }

    public void requestKeyboardWithSelection(int pointer, int selStart, int selEnd, int textGeneration) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 128, pointer, textGeneration, new TextSelectionData(selStart, selEnd)).sendToTarget();
        }
    }

    public void requestKeyboard(boolean showKeyboard) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 118, showKeyboard ? 1 : 0, 0).sendToTarget();
        }
    }

    public void setWebTextViewAutoFillable(int queryId, String preview) {
        if (this.mWebView != null) {
            Message.obtain(this.mWebView.mPrivateHandler, 133, new AutoFillData(queryId, preview)).sendToTarget();
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public void keepScreenOn(boolean screenOn) {
        if (this.mWebView != null) {
            Message message = this.mWebView.mPrivateHandler.obtainMessage(136);
            message.arg1 = screenOn ? 1 : 0;
            message.sendToTarget();
        }
    }

    public Class<?> getPluginClass(String libName, String clsName) {
        if (this.mWebView == null) {
            return null;
        }
        PluginManager pluginManager = PluginManager.getInstance(null);
        String pkgName = pluginManager.getPluginsAPKName(libName);
        if (pkgName == null) {
            Log.w(LOGTAG, "Unable to resolve " + libName + " to a plugin APK");
            return null;
        }
        try {
            return pluginManager.getPluginClass(pkgName, clsName);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin classloader for the apk (" + pkgName + ")");
        }
        catch (ClassNotFoundException e) {
            Log.e(LOGTAG, "Unable to find plugin class (" + clsName + ") in the apk (" + pkgName + ")");
        }
        return null;
    }

    public void showFullScreenPlugin(ViewManager.ChildView childView, int npp) {
        if (this.mWebView == null) {
            return;
        }
        Message message = this.mWebView.mPrivateHandler.obtainMessage(120);
        message.obj = childView.mView;
        message.arg1 = npp;
        message.sendToTarget();
    }

    public void hideFullScreenPlugin() {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(121).sendToTarget();
    }

    public ViewManager.ChildView createSurface(View pluginView) {
        if (this.mWebView == null) {
            return null;
        }
        if (pluginView == null) {
            Log.e(LOGTAG, "Attempted to add an empty plugin view to the view hierarchy");
            return null;
        }
        pluginView.setWillNotDraw(false);
        if (pluginView instanceof SurfaceView) {
            ((SurfaceView)pluginView).setZOrderOnTop(true);
        }
        ViewManager.ChildView view = this.mWebView.mViewManager.createView();
        view.mView = pluginView;
        return view;
    }

    public ViewManager.ChildView addSurface(View pluginView, int x, int y, int width, int height) {
        ViewManager.ChildView view = this.createSurface(pluginView);
        view.attachView(x, y, width, height);
        return view;
    }

    public void updateSurface(ViewManager.ChildView childView, int x, int y, int width, int height) {
        childView.attachView(x, y, width, height);
    }

    public void destroySurface(ViewManager.ChildView childView) {
        childView.removeView();
    }

    public void showRect(int left, int top, int width, int height, int contentWidth, int contentHeight, float xPercentInDoc, float xPercentInView, float yPercentInDoc, float yPercentInView) {
        if (this.mWebView != null) {
            ShowRectData data = new ShowRectData();
            data.mLeft = left;
            data.mTop = top;
            data.mWidth = width;
            data.mHeight = height;
            data.mContentWidth = contentWidth;
            data.mContentHeight = contentHeight;
            data.mXPercentInDoc = xPercentInDoc;
            data.mXPercentInView = xPercentInView;
            data.mYPercentInDoc = yPercentInDoc;
            data.mYPercentInView = yPercentInView;
            Message.obtain(this.mWebView.mPrivateHandler, 113, data).sendToTarget();
        }
    }

    public void centerFitRect(int x, int y, int width, int height) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(127, new Rect(x, y, x + width, y + height)).sendToTarget();
    }

    public void setScrollbarModes(int hMode, int vMode) {
        if (this.mWebView == null) {
            return;
        }
        this.mWebView.mPrivateHandler.obtainMessage(129, hMode, vMode).sendToTarget();
    }

    public void selectAt(int x, int y) {
        if (this.mWebView != null) {
            this.mWebView.mPrivateHandler.obtainMessage(135, x, y).sendToTarget();
        }
    }

    public void useMockDeviceOrientation() {
        this.mDeviceMotionAndOrientationManager.useMock();
    }

    public void setMockDeviceOrientation(boolean canProvideAlpha, double alpha, boolean canProvideBeta, double beta, boolean canProvideGamma, double gamma) {
        this.mDeviceMotionAndOrientationManager.setMockOrientation(canProvideAlpha, alpha, canProvideBeta, beta, canProvideGamma, gamma);
    }

    public DeviceMotionService getDeviceMotionService() {
        if (this.mDeviceMotionService == null) {
            this.mDeviceMotionService = new DeviceMotionService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceMotionService;
    }

    public DeviceOrientationService getDeviceOrientationService() {
        if (this.mDeviceOrientationService == null) {
            this.mDeviceOrientationService = new DeviceOrientationService(this.mDeviceMotionAndOrientationManager, this.mContext);
        }
        return this.mDeviceOrientationService;
    }

    public void nativePause() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativePause()V", true, this);
    }

    public void nativeResume() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeResume()V", true, this);
    }

    public void nativeFreeMemory() {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeFreeMemory()V", true, this);
    }

    public void nativeFullScreenPluginHidden(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeFullScreenPluginHidden(I)V", true, this);
    }

    public boolean nativeValidNodeAndBounds(int n, int n2, Rect rect) {
        return OverrideMethod.invokeI("android.webkit.WebViewCore#nativeValidNodeAndBounds(IILandroid/graphics/Rect;)Z", true, this) != 0;
    }

    public ArrayList<Rect> nativeGetTouchHighlightRects(int n, int n2, int n3) {
        return (ArrayList)OverrideMethod.invokeA("android.webkit.WebViewCore#nativeGetTouchHighlightRects(III)Ljava/util/ArrayList;", true, this);
    }

    public void nativeAutoFillForm(int n) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeAutoFillForm(I)V", true, this);
    }

    public void nativeScrollLayer(int n, Rect rect) {
        OverrideMethod.invokeV("android.webkit.WebViewCore#nativeScrollLayer(ILandroid/graphics/Rect;)V", true, this);
    }

    static {
        try {
            System.loadLibrary(LOGTAG);
        }
        catch (UnsatisfiedLinkError e) {
            Log.e(LOGTAG, "Unable to load webcore library");
        }
        HandlerDebugString = new String[]{"REVEAL_SELECTION", "REQUEST_LABEL", "UPDATE_FRAME_CACHE_IF_LOADING", "SCROLL_TEXT_INPUT", "LOAD_URL", "STOP_LOADING", "RELOAD", "KEY_DOWN", "KEY_UP", "VIEW_SIZE_CHANGED", "GO_BACK_FORWARD", "SET_SCROLL_OFFSET", "RESTORE_STATE", "PAUSE_TIMERS", "RESUME_TIMERS", "CLEAR_CACHE", "CLEAR_HISTORY", "SET_SELECTION", "REPLACE_TEXT", "PASS_TO_JS", "SET_GLOBAL_BOUNDS", "UPDATE_CACHE_AND_TEXT_ENTRY", "CLICK", "SET_NETWORK_STATE", "DOC_HAS_IMAGES", "FAKE_CLICK", "DELETE_SELECTION", "LISTBOX_CHOICES", "SINGLE_LISTBOX_CHOICE", "MESSAGE_RELAY", "SET_BACKGROUND_COLOR", "SET_MOVE_FOCUS", "SAVE_DOCUMENT_STATE", "129", "WEBKIT_DRAW", "131", "POST_URL", "SPLIT_PICTURE_SET", "CLEAR_CONTENT", "SET_MOVE_MOUSE", "SET_MOVE_MOUSE_IF_LATEST", "REQUEST_CURSOR_HREF", "ADD_JS_INTERFACE", "LOAD_DATA", "TOUCH_UP", "TOUCH_EVENT", "SET_ACTIVE", "ON_PAUSE", "ON_RESUME", "FREE_MEMORY", "VALID_NODE_BOUNDS", "SAVE_WEBARCHIVE", "WEBKIT_DRAW_LAYERS", "REMOVE_JS_INTERFACE"};
        mRepaintScheduled = false;
    }

    public static class ShowRectData {
        public int mLeft;
        public int mTop;
        public int mWidth;
        public int mHeight;
        public int mContentWidth;
        public int mContentHeight;
        public float mXPercentInDoc;
        public float mXPercentInView;
        public float mYPercentInDoc;
        public float mYPercentInView;
    }

    public static class DrawData {
        public int mBaseLayer = 0;
        public Region mInvalRegion = new Region();
        public Point mViewSize;
        public Point mContentSize = new Point();
        public int mMinPrefWidth;
        public ViewState mViewState;
        public boolean mFocusSizeChanged;
    }

    public static class ViewState {
        public float mMinScale;
        public float mMaxScale;
        public float mViewScale;
        public float mTextWrapScale;
        public float mDefaultScale;
        public int mScrollX;
        public int mScrollY;
        public boolean mMobileSite;
        public boolean mIsRestored;
    }

    public class EventHub {
        public static final int REVEAL_SELECTION = 96;
        public static final int REQUEST_LABEL = 97;
        public static final int UPDATE_FRAME_CACHE_IF_LOADING = 98;
        public static final int SCROLL_TEXT_INPUT = 99;
        public static final int LOAD_URL = 100;
        public static final int STOP_LOADING = 101;
        public static final int RELOAD = 102;
        public static final int KEY_DOWN = 103;
        public static final int KEY_UP = 104;
        public static final int VIEW_SIZE_CHANGED = 105;
        public static final int GO_BACK_FORWARD = 106;
        public static final int SET_SCROLL_OFFSET = 107;
        public static final int RESTORE_STATE = 108;
        public static final int PAUSE_TIMERS = 109;
        public static final int RESUME_TIMERS = 110;
        public static final int CLEAR_CACHE = 111;
        public static final int CLEAR_HISTORY = 112;
        public static final int SET_SELECTION = 113;
        public static final int REPLACE_TEXT = 114;
        public static final int PASS_TO_JS = 115;
        public static final int SET_GLOBAL_BOUNDS = 116;
        public static final int UPDATE_CACHE_AND_TEXT_ENTRY = 117;
        public static final int CLICK = 118;
        public static final int SET_NETWORK_STATE = 119;
        public static final int DOC_HAS_IMAGES = 120;
        public static final int FAKE_CLICK = 121;
        public static final int DELETE_SELECTION = 122;
        public static final int LISTBOX_CHOICES = 123;
        public static final int SINGLE_LISTBOX_CHOICE = 124;
        public static final int MESSAGE_RELAY = 125;
        public static final int SET_BACKGROUND_COLOR = 126;
        public static final int SET_MOVE_FOCUS = 127;
        public static final int SAVE_DOCUMENT_STATE = 128;
        public static final int WEBKIT_DRAW = 130;
        public static final int POST_URL = 132;
        public static final int SPLIT_PICTURE_SET = 133;
        public static final int CLEAR_CONTENT = 134;
        public static final int SET_MOVE_MOUSE = 135;
        public static final int SET_MOVE_MOUSE_IF_LATEST = 136;
        public static final int REQUEST_CURSOR_HREF = 137;
        public static final int ADD_JS_INTERFACE = 138;
        public static final int LOAD_DATA = 139;
        public static final int TOUCH_UP = 140;
        public static final int TOUCH_EVENT = 141;
        public static final int SET_ACTIVE = 142;
        public static final int ON_PAUSE = 143;
        public static final int ON_RESUME = 144;
        public static final int FREE_MEMORY = 145;
        public static final int VALID_NODE_BOUNDS = 146;
        public static final int SAVE_WEBARCHIVE = 147;
        public static final int WEBKIT_DRAW_LAYERS = 148;
        public static final int REMOVE_JS_INTERFACE = 149;
        public static final int CLEAR_SSL_PREF_TABLE = 150;
        public static final int REQUEST_EXT_REPRESENTATION = 160;
        public static final int REQUEST_DOC_AS_TEXT = 161;
        public static final int DUMP_DOMTREE = 170;
        public static final int DUMP_RENDERTREE = 171;
        public static final int DUMP_NAVTREE = 172;
        public static final int DUMP_V8COUNTERS = 173;
        public static final int SET_JS_FLAGS = 174;
        public static final int GEOLOCATION_PERMISSIONS_PROVIDE = 180;
        public static final int POPULATE_VISITED_LINKS = 181;
        public static final int HIDE_FULLSCREEN = 182;
        public static final int SET_NETWORK_TYPE = 183;
        public static final int ADD_PACKAGE_NAMES = 184;
        public static final int ADD_PACKAGE_NAME = 185;
        public static final int REMOVE_PACKAGE_NAME = 186;
        public static final int GET_TOUCH_HIGHLIGHT_RECTS = 187;
        public static final int REMOVE_TOUCH_HIGHLIGHT_RECTS = 188;
        public static final int MODIFY_SELECTION = 190;
        public static final int USE_MOCK_DEVICE_ORIENTATION = 191;
        public static final int AUTOFILL_FORM = 192;
        public static final int PROXY_CHANGED = 193;
        public static final int EXECUTE_JS = 194;
        public static final int DESTROY = 200;
        public Handler mHandler;
        public ArrayList<Message> mMessages = new ArrayList();
        public boolean mBlockMessages;
        public int mTid;
        public int mSavedPriority;
        public static final int FIRST_PACKAGE_MSG_ID = 96;
        public static final int LAST_PACKAGE_MSG_ID = 146;

        public EventHub() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transferMessages() {
            this.mTid = Process.myTid();
            this.mSavedPriority = Process.getThreadPriority(this.mTid);
            this.mHandler = new Handler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleMessage(Message msg) {
                    switch (msg.what) {
                        case 130: {
                            WebViewCore.this.webkitDraw();
                            break;
                        }
                        case 148: {
                            WebViewCore.this.webkitDrawLayers();
                            break;
                        }
                        case 200: {
                            WebViewCore webViewCore = WebViewCore.this;
                            synchronized (webViewCore) {
                                WebViewCore.this.mBrowserFrame.destroy();
                                WebViewCore.this.mBrowserFrame = null;
                                WebViewCore.this.mSettings.onDestroyed();
                                WebViewCore.this.mNativeClass = 0;
                                WebViewCore.this.mWebView = null;
                                break;
                            }
                        }
                        case 96: {
                            WebViewCore.this.nativeRevealSelection();
                            break;
                        }
                        case 97: {
                            int nodePointer;
                            String label;
                            if (WebViewCore.this.mWebView == null || (label = WebViewCore.this.nativeRequestLabel(msg.arg1, nodePointer = msg.arg2)) == null || label.length() <= 0) break;
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler, 125, nodePointer, 0, label).sendToTarget();
                            break;
                        }
                        case 98: {
                            WebViewCore.this.nativeUpdateFrameCacheIfLoading();
                            break;
                        }
                        case 99: {
                            float xPercent = msg.obj == null ? 0.0f : ((Float)msg.obj).floatValue();
                            WebViewCore.this.nativeScrollFocusedTextInput(xPercent, msg.arg2);
                            break;
                        }
                        case 100: {
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            GetUrlData param = (GetUrlData)msg.obj;
                            WebViewCore.this.loadUrl(param.mUrl, param.mExtraHeaders);
                            break;
                        }
                        case 132: {
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            PostUrlData param = (PostUrlData)msg.obj;
                            WebViewCore.this.mBrowserFrame.postUrl(param.mUrl, param.mPostData);
                            break;
                        }
                        case 139: {
                            String scheme;
                            int i;
                            CookieManager.getInstance().waitForCookieOperationsToComplete();
                            BaseUrlData loadParams = (BaseUrlData)msg.obj;
                            String baseUrl = loadParams.mBaseUrl;
                            if (!(baseUrl == null || (i = baseUrl.indexOf(58)) <= 0 || (scheme = baseUrl.substring(0, i)).startsWith("http") || scheme.startsWith("ftp") || scheme.startsWith("about") || scheme.startsWith("javascript"))) {
                                WebViewCore.this.nativeRegisterURLSchemeAsLocal(scheme);
                            }
                            WebViewCore.this.mBrowserFrame.loadData(baseUrl, loadParams.mData, loadParams.mMimeType, loadParams.mEncoding, loadParams.mHistoryUrl);
                            break;
                        }
                        case 101: {
                            if (WebViewCore.this.mBrowserFrame.committed() && !WebViewCore.this.mBrowserFrame.firstLayoutDone()) {
                                WebViewCore.this.mBrowserFrame.didFirstLayout();
                            }
                            WebViewCore.this.stopLoading();
                            break;
                        }
                        case 102: {
                            WebViewCore.this.mBrowserFrame.reload(false);
                            break;
                        }
                        case 103: {
                            WebViewCore.this.key((KeyEvent)msg.obj, true);
                            break;
                        }
                        case 104: {
                            WebViewCore.this.key((KeyEvent)msg.obj, false);
                            break;
                        }
                        case 121: {
                            WebViewCore.this.nativeClick(msg.arg1, msg.arg2, true);
                            break;
                        }
                        case 118: {
                            WebViewCore.this.nativeClick(msg.arg1, msg.arg2, false);
                            break;
                        }
                        case 105: {
                            WebViewCore.this.viewSizeChanged((WebView.ViewSizeData)msg.obj);
                            break;
                        }
                        case 107: {
                            Point pt = (Point)msg.obj;
                            WebViewCore.this.nativeSetScrollOffset(msg.arg1, msg.arg2 == 1, pt.x, pt.y);
                            break;
                        }
                        case 116: {
                            Rect r = (Rect)msg.obj;
                            WebViewCore.this.nativeSetGlobalBounds(r.left, r.top, r.width(), r.height());
                            break;
                        }
                        case 106: {
                            if (!WebViewCore.this.mBrowserFrame.committed() && msg.arg1 == -1 && WebViewCore.this.mBrowserFrame.loadType() == 0) {
                                WebViewCore.this.mBrowserFrame.reload(true);
                                break;
                            }
                            WebViewCore.this.mBrowserFrame.goBackOrForward(msg.arg1);
                            break;
                        }
                        case 108: {
                            WebViewCore.this.stopLoading();
                            WebViewCore.this.restoreState(msg.arg1);
                            break;
                        }
                        case 109: {
                            EventHub.this.mSavedPriority = Process.getThreadPriority(EventHub.this.mTid);
                            Process.setThreadPriority(EventHub.this.mTid, 10);
                            WebViewCore.pauseTimers();
                            if (JniUtil.useChromiumHttpStack()) break;
                            WebViewWorker.getHandler().sendEmptyMessage(111);
                            break;
                        }
                        case 110: {
                            Process.setThreadPriority(EventHub.this.mTid, EventHub.this.mSavedPriority);
                            WebViewCore.resumeTimers();
                            if (JniUtil.useChromiumHttpStack()) break;
                            WebViewWorker.getHandler().sendEmptyMessage(112);
                            break;
                        }
                        case 143: {
                            WebViewCore.this.nativePause();
                            break;
                        }
                        case 144: {
                            WebViewCore.this.nativeResume();
                            break;
                        }
                        case 145: {
                            WebViewCore.this.clearCache(false);
                            WebViewCore.this.nativeFreeMemory();
                            break;
                        }
                        case 119: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.setNetworkOnLine(msg.arg1 == 1);
                            break;
                        }
                        case 183: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            Map map = (Map)msg.obj;
                            BrowserFrame.sJavaBridge.setNetworkType((String)map.get("type"), (String)map.get("subtype"));
                            break;
                        }
                        case 111: {
                            WebViewCore.this.clearCache(msg.arg1 == 1);
                            break;
                        }
                        case 112: {
                            WebViewCore.this.mCallbackProxy.getBackForwardList().close(((WebViewCore)WebViewCore.this).mBrowserFrame.mNativeFrame);
                            break;
                        }
                        case 114: {
                            ReplaceTextData rep = (ReplaceTextData)msg.obj;
                            WebViewCore.this.nativeReplaceTextfieldText(msg.arg1, msg.arg2, rep.mReplace, rep.mNewStart, rep.mNewEnd, rep.mTextGeneration);
                            break;
                        }
                        case 115: {
                            JSKeyData jsData = (JSKeyData)msg.obj;
                            KeyEvent evt = jsData.mEvent;
                            int keyCode = evt.getKeyCode();
                            int keyValue = evt.getUnicodeChar();
                            int generation = msg.arg1;
                            WebViewCore.this.passToJs(generation, jsData.mCurrentText, keyCode, keyValue, evt.isDown(), evt.isShiftPressed(), evt.isAltPressed(), evt.isSymPressed());
                            break;
                        }
                        case 128: {
                            CursorData cDat = (CursorData)msg.obj;
                            WebViewCore.this.nativeSaveDocumentState(cDat.mFrame);
                            break;
                        }
                        case 150: {
                            Network.getInstance(WebViewCore.this.mContext).clearUserSslPrefTable();
                            break;
                        }
                        case 140: {
                            TouchUpData touchUpData = (TouchUpData)msg.obj;
                            if (touchUpData.mNativeLayer != 0) {
                                WebViewCore.this.nativeScrollLayer(touchUpData.mNativeLayer, touchUpData.mNativeLayerRect);
                            }
                            WebViewCore.this.nativeTouchUp(touchUpData.mMoveGeneration, touchUpData.mFrame, touchUpData.mNode, touchUpData.mX, touchUpData.mY);
                            break;
                        }
                        case 141: {
                            TouchEventData ted = (TouchEventData)msg.obj;
                            int count = ted.mPoints.length;
                            int[] xArray = new int[count];
                            int[] yArray = new int[count];
                            for (int c = 0; c < count; ++c) {
                                xArray[c] = ted.mPoints[c].x;
                                yArray[c] = ted.mPoints[c].y;
                            }
                            if (ted.mNativeLayer != 0) {
                                WebViewCore.this.nativeScrollLayer(ted.mNativeLayer, ted.mNativeLayerRect);
                            }
                            ted.mNativeResult = WebViewCore.this.nativeHandleTouchEvent(ted.mAction, ted.mIds, xArray, yArray, count, ted.mActionIndex, ted.mMetaState);
                            Message.obtain(((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler, 115, ted.mAction, ted.mNativeResult ? 1 : 0, ted).sendToTarget();
                            break;
                        }
                        case 142: {
                            WebViewCore.this.nativeSetFocusControllerActive(msg.arg1 == 1);
                            break;
                        }
                        case 138: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.addJavascriptInterface(jsData.mObject, jsData.mInterfaceName);
                            break;
                        }
                        case 149: {
                            JSInterfaceData jsData = (JSInterfaceData)msg.obj;
                            WebViewCore.this.mBrowserFrame.removeJavascriptInterface(jsData.mInterfaceName);
                            break;
                        }
                        case 160: {
                            WebViewCore.this.mBrowserFrame.externalRepresentation((Message)msg.obj);
                            break;
                        }
                        case 161: {
                            WebViewCore.this.mBrowserFrame.documentAsText((Message)msg.obj);
                            break;
                        }
                        case 127: {
                            CursorData focusData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveFocus(focusData.mFrame, focusData.mNode);
                            break;
                        }
                        case 135: {
                            CursorData cursorData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveMouse(cursorData.mFrame, cursorData.mX, cursorData.mY);
                            break;
                        }
                        case 136: {
                            CursorData cData = (CursorData)msg.obj;
                            WebViewCore.this.nativeMoveMouseIfLatest(cData.mMoveGeneration, cData.mFrame, cData.mX, cData.mY);
                            if (msg.arg1 != 1) break;
                            WebViewCore.this.nativeStopPaintingCaret();
                            break;
                        }
                        case 137: {
                            Message hrefMsg = (Message)msg.obj;
                            hrefMsg.getData().putString("url", WebViewCore.this.nativeRetrieveHref(msg.arg1, msg.arg2));
                            hrefMsg.getData().putString("title", WebViewCore.this.nativeRetrieveAnchorText(msg.arg1, msg.arg2));
                            hrefMsg.getData().putString("src", WebViewCore.this.nativeRetrieveImageSource(msg.arg1, msg.arg2));
                            hrefMsg.sendToTarget();
                            break;
                        }
                        case 117: {
                            WebViewCore.this.nativeUpdateFrameCache();
                            if (WebViewCore.this.mWebView != null) {
                                WebViewCore.this.mWebView.postInvalidate();
                            }
                            WebViewCore.this.sendUpdateTextEntry();
                            break;
                        }
                        case 120: {
                            Message imageResult = (Message)msg.obj;
                            imageResult.arg1 = WebViewCore.this.mBrowserFrame.documentHasImages() ? 1 : 0;
                            imageResult.sendToTarget();
                            break;
                        }
                        case 122: {
                            TextSelectionData deleteSelectionData = (TextSelectionData)msg.obj;
                            WebViewCore.this.nativeDeleteSelection(deleteSelectionData.mStart, deleteSelectionData.mEnd, msg.arg1);
                            break;
                        }
                        case 113: {
                            WebViewCore.this.nativeSetSelection(msg.arg1, msg.arg2);
                            break;
                        }
                        case 190: {
                            String modifiedSelectionString = WebViewCore.this.nativeModifySelection(msg.arg1, msg.arg2);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(130, modifiedSelectionString).sendToTarget();
                            break;
                        }
                        case 123: {
                            SparseBooleanArray choices = (SparseBooleanArray)msg.obj;
                            int choicesSize = msg.arg1;
                            boolean[] choicesArray = new boolean[choicesSize];
                            for (int c = 0; c < choicesSize; ++c) {
                                choicesArray[c] = choices.get(c);
                            }
                            WebViewCore.this.nativeSendListBoxChoices(choicesArray, choicesSize);
                            break;
                        }
                        case 124: {
                            WebViewCore.this.nativeSendListBoxChoice(msg.arg1);
                            break;
                        }
                        case 126: {
                            WebViewCore.this.nativeSetBackgroundColor(msg.arg1);
                            break;
                        }
                        case 170: {
                            WebViewCore.this.nativeDumpDomTree(msg.arg1 == 1);
                            break;
                        }
                        case 171: {
                            WebViewCore.this.nativeDumpRenderTree(msg.arg1 == 1);
                            break;
                        }
                        case 172: {
                            WebViewCore.this.nativeDumpNavTree();
                            break;
                        }
                        case 173: {
                            WebViewCore.this.nativeDumpV8Counters();
                            break;
                        }
                        case 174: {
                            WebViewCore.this.nativeSetJsFlags((String)msg.obj);
                            break;
                        }
                        case 147: {
                            WebView.SaveWebArchiveMessage saveMessage = (WebView.SaveWebArchiveMessage)msg.obj;
                            saveMessage.mResultFile = WebViewCore.this.saveWebArchive(saveMessage.mBasename, saveMessage.mAutoname);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(132, saveMessage).sendToTarget();
                            break;
                        }
                        case 180: {
                            GeolocationPermissionsData data = (GeolocationPermissionsData)msg.obj;
                            WebViewCore.this.nativeGeolocationPermissionsProvide(data.mOrigin, data.mAllow, data.mRemember);
                            break;
                        }
                        case 133: {
                            WebViewCore.this.nativeSplitContent(msg.arg1);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(123, msg.arg1, 0);
                            WebViewCore.this.mSplitPictureIsScheduled = false;
                            break;
                        }
                        case 134: {
                            WebViewCore.this.nativeClearContent();
                            break;
                        }
                        case 125: {
                            ((Message)msg.obj).sendToTarget();
                            break;
                        }
                        case 181: {
                            WebViewCore.this.nativeProvideVisitedHistory((String[])msg.obj);
                            break;
                        }
                        case 146: {
                            MotionUpData motionUpData = (MotionUpData)msg.obj;
                            if (!WebViewCore.this.nativeValidNodeAndBounds(motionUpData.mFrame, motionUpData.mNode, motionUpData.mBounds)) {
                                WebViewCore.this.nativeUpdateFrameCache();
                            }
                            Message message = ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(119, motionUpData.mX, motionUpData.mY);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.sendMessageAtFrontOfQueue(message);
                            break;
                        }
                        case 182: {
                            WebViewCore.this.nativeFullScreenPluginHidden(msg.arg1);
                            break;
                        }
                        case 184: {
                            if (BrowserFrame.sJavaBridge == null) {
                                throw new IllegalStateException("No WebView has been created in this process!");
                            }
                            BrowserFrame.sJavaBridge.addPackageNames((Set)msg.obj);
                            break;
                        }
                        case 187: {
                            TouchHighlightData d = (TouchHighlightData)msg.obj;
                            ArrayList rects = WebViewCore.this.nativeGetTouchHighlightRects(d.mX, d.mY, d.mSlop);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(131, rects).sendToTarget();
                            break;
                        }
                        case 188: {
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(131, null).sendToTarget();
                            break;
                        }
                        case 191: {
                            WebViewCore.this.useMockDeviceOrientation();
                            break;
                        }
                        case 192: {
                            WebViewCore.this.nativeAutoFillForm(msg.arg1);
                            ((WebViewCore)WebViewCore.this).mWebView.mPrivateHandler.obtainMessage(134, null).sendToTarget();
                            break;
                        }
                        case 194: {
                            if (!(msg.obj instanceof String)) break;
                            WebViewCore.this.mBrowserFrame.stringByEvaluatingJavaScriptFromString((String)msg.obj);
                        }
                    }
                }
            };
            EventHub eventHub = this;
            synchronized (eventHub) {
                int size = this.mMessages.size();
                for (int i = 0; i < size; ++i) {
                    this.mHandler.sendMessage(this.mMessages.get(i));
                }
                this.mMessages = null;
            }
        }

        public synchronized void sendMessage(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(msg);
            } else {
                this.mHandler.sendMessage(msg);
            }
        }

        public synchronized void removeMessages(int what) {
            if (this.mBlockMessages) {
                return;
            }
            if (what == 130) {
                WebViewCore.this.mDrawIsScheduled = false;
            }
            if (this.mMessages != null) {
                Log.w(WebViewCore.LOGTAG, "Not supported in this case.");
            } else {
                this.mHandler.removeMessages(what);
            }
        }

        public synchronized boolean hasMessages(int what) {
            if (this.mBlockMessages) {
                return false;
            }
            if (this.mMessages != null) {
                Log.w(WebViewCore.LOGTAG, "hasMessages() is not supported in this case.");
                return false;
            }
            return this.mHandler.hasMessages(what);
        }

        public synchronized void sendMessageDelayed(Message msg, long delay) {
            if (this.mBlockMessages) {
                return;
            }
            this.mHandler.sendMessageDelayed(msg, delay);
        }

        public synchronized void sendMessageAtFrontOfQueue(Message msg) {
            if (this.mBlockMessages) {
                return;
            }
            if (this.mMessages != null) {
                this.mMessages.add(0, msg);
            } else {
                this.mHandler.sendMessageAtFrontOfQueue(msg);
            }
        }

        public synchronized void removeMessages() {
            WebViewCore.this.mDrawIsScheduled = false;
            WebViewCore.this.mSplitPictureIsScheduled = false;
            if (this.mMessages != null) {
                this.mMessages.clear();
            } else {
                this.mHandler.removeCallbacksAndMessages(null);
            }
        }

        public synchronized void blockMessages() {
            this.mBlockMessages = true;
        }

        public /* synthetic */ EventHub(1 x1) {
            this();
        }
    }

    public static class GeolocationPermissionsData {
        public String mOrigin;
        public boolean mAllow;
        public boolean mRemember;
    }

    public static class TouchEventData {
        public int mAction;
        public int[] mIds;
        public Point[] mPoints;
        public Point[] mPointsInView;
        public int mActionIndex;
        public int mMetaState;
        public boolean mReprocess;
        public MotionEvent mMotionEvent;
        public int mNativeLayer;
        public Rect mNativeLayerRect = new Rect();
        public long mSequence;
        public boolean mNativeResult;
    }

    public static class AutoFillData {
        public int mQueryId;
        public String mPreview;

        public AutoFillData() {
            this.mQueryId = -1;
            this.mPreview = "";
        }

        public AutoFillData(int queryId, String preview) {
            this.mQueryId = queryId;
            this.mPreview = preview;
        }

        public int getQueryId() {
            return this.mQueryId;
        }

        public String getPreviewString() {
            return this.mPreview;
        }
    }

    public static class TouchHighlightData {
        public int mX;
        public int mY;
        public int mSlop;
    }

    public static class TouchUpData {
        public int mMoveGeneration;
        public int mFrame;
        public int mNode;
        public int mX;
        public int mY;
        public int mNativeLayer;
        public Rect mNativeLayerRect = new Rect();
    }

    public static class TextSelectionData {
        public int mStart;
        public int mEnd;

        public TextSelectionData(int start, int end) {
            this.mStart = start;
            this.mEnd = end;
        }
    }

    public static class ReplaceTextData {
        public String mReplace;
        public int mNewStart;
        public int mNewEnd;
        public int mTextGeneration;
    }

    public static class PostUrlData {
        public String mUrl;
        public byte[] mPostData;
    }

    public static class GetUrlData {
        public String mUrl;
        public Map<String, String> mExtraHeaders;
    }

    public static class MotionUpData {
        public int mFrame;
        public int mNode;
        public Rect mBounds;
        public int mX;
        public int mY;
    }

    public static class JSKeyData {
        public String mCurrentText;
        public KeyEvent mEvent;
    }

    public static class JSInterfaceData {
        public Object mObject;
        public String mInterfaceName;
    }

    public static class CursorData {
        public int mMoveGeneration;
        public int mFrame;
        public int mNode;
        public int mX;
        public int mY;

        public CursorData() {
        }

        public CursorData(int frame, int node, int x, int y) {
            this.mFrame = frame;
            this.mNode = node;
            this.mX = x;
            this.mY = y;
        }
    }

    public static class BaseUrlData {
        public String mBaseUrl;
        public String mData;
        public String mMimeType;
        public String mEncoding;
        public String mHistoryUrl;
    }

    public static class WebCoreThread
    implements Runnable {
        public static final int INITIALIZE = 0;
        public static final int REDUCE_PRIORITY = 1;
        public static final int RESUME_PRIORITY = 2;

        public WebCoreThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Looper.prepare();
            Assert.assertNull((Object)sWebCoreHandler);
            Class<WebViewCore> clazz = WebViewCore.class;
            synchronized (WebViewCore.class) {
                sWebCoreHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        switch (msg.what) {
                            case 0: {
                                WebViewCore core = (WebViewCore)msg.obj;
                                core.initialize();
                                break;
                            }
                            case 1: {
                                Process.setThreadPriority(3);
                                break;
                            }
                            case 2: {
                                Process.setThreadPriority(0);
                                break;
                            }
                            case 185: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.addPackageName((String)msg.obj);
                                break;
                            }
                            case 186: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.removePackageName((String)msg.obj);
                                break;
                            }
                            case 193: {
                                if (BrowserFrame.sJavaBridge == null) {
                                    throw new IllegalStateException("No WebView has been created in this process!");
                                }
                                BrowserFrame.sJavaBridge.updateProxy((String)msg.obj);
                            }
                        }
                    }
                };
                WebViewCore.class.notify();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                return;
            }
        }

        public /* synthetic */ WebCoreThread(1 x0) {
            this();
        }
    }
}

