/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.AnimatorInflater;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.Advanceable;
import android.widget.FrameLayout;
import android.widget.RemoteViewsAdapter;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdapterViewAnimator
extends AdapterView<Adapter>
implements RemoteViewsAdapter.RemoteAdapterConnectionCallback,
Advanceable {
    public static final String TAG = "RemoteViewAnimator";
    public int mWhichChild = 0;
    public int mRestoreWhichChild = -1;
    public boolean mAnimateFirstTime = true;
    public int mActiveOffset = 0;
    public int mMaxNumActiveViews = 1;
    public HashMap<Integer, ViewAndIndex> mViewsMap = new HashMap();
    public ArrayList<Integer> mPreviousViews;
    public int mCurrentWindowStart = 0;
    public int mCurrentWindowEnd = -1;
    public int mCurrentWindowStartUnbounded = 0;
    public Handler mMainQueue;
    public AdapterView.AdapterDataSetObserver mDataSetObserver;
    public Adapter mAdapter;
    public RemoteViewsAdapter mRemoteViewsAdapter;
    public boolean mFirstTime = true;
    public boolean mLoopViews = true;
    public int mReferenceChildWidth = -1;
    public int mReferenceChildHeight = -1;
    public ObjectAnimator mInAnimation;
    public ObjectAnimator mOutAnimation;
    public int mTouchMode = 0;
    public static final int TOUCH_MODE_NONE = 0;
    public static final int TOUCH_MODE_DOWN_IN_CURRENT_VIEW = 1;
    public static final int TOUCH_MODE_HANDLED = 2;
    public Runnable mPendingCheckForTap;
    public static final int DEFAULT_ANIMATION_DURATION = 200;

    public AdapterViewAnimator(Context context) {
        super(context);
        this.initViewAnimator();
    }

    public AdapterViewAnimator(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AdapterViewAnimator);
        int resource = a.getResourceId(0, 0);
        if (resource > 0) {
            this.setInAnimation(context, resource);
        } else {
            this.setInAnimation(this.getDefaultInAnimation());
        }
        resource = a.getResourceId(1, 0);
        if (resource > 0) {
            this.setOutAnimation(context, resource);
        } else {
            this.setOutAnimation(this.getDefaultOutAnimation());
        }
        boolean flag = a.getBoolean(2, true);
        this.setAnimateFirstView(flag);
        this.mLoopViews = a.getBoolean(3, false);
        a.recycle();
        this.initViewAnimator();
    }

    public void initViewAnimator() {
        this.mMainQueue = new Handler(Looper.myLooper());
        this.mPreviousViews = new ArrayList();
    }

    public void configureViewAnimator(int numVisibleViews, int activeOffset) {
        if (activeOffset > numVisibleViews - 1) {
            // empty if block
        }
        this.mMaxNumActiveViews = numVisibleViews;
        this.mActiveOffset = activeOffset;
        this.mPreviousViews.clear();
        this.mViewsMap.clear();
        this.removeAllViewsInLayout();
        this.mCurrentWindowStart = 0;
        this.mCurrentWindowEnd = -1;
    }

    public void transformViewForTransition(int fromIndex, int toIndex, View view, boolean animate) {
        if (fromIndex == -1) {
            this.mInAnimation.setTarget(view);
            this.mInAnimation.start();
        } else if (toIndex == -1) {
            this.mOutAnimation.setTarget(view);
            this.mOutAnimation.start();
        }
    }

    public ObjectAnimator getDefaultInAnimation() {
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(null, "alpha", 0.0f, 1.0f);
        anim2.setDuration(200L);
        return anim2;
    }

    public ObjectAnimator getDefaultOutAnimation() {
        ObjectAnimator anim2 = ObjectAnimator.ofFloat(null, "alpha", 1.0f, 0.0f);
        anim2.setDuration(200L);
        return anim2;
    }

    @RemotableViewMethod
    public void setDisplayedChild(int whichChild) {
        this.setDisplayedChild(whichChild, true);
    }

    public void setDisplayedChild(int whichChild, boolean animate) {
        if (this.mAdapter != null) {
            this.mWhichChild = whichChild;
            if (whichChild >= this.getWindowSize()) {
                this.mWhichChild = this.mLoopViews ? 0 : this.getWindowSize() - 1;
            } else if (whichChild < 0) {
                this.mWhichChild = this.mLoopViews ? this.getWindowSize() - 1 : 0;
            }
            boolean hasFocus = this.getFocusedChild() != null;
            this.showOnly(this.mWhichChild, animate);
            if (hasFocus) {
                this.requestFocus(2);
            }
        }
    }

    public void applyTransformForChildAtIndex(View child, int relativeIndex) {
    }

    public int getDisplayedChild() {
        return this.mWhichChild;
    }

    public void showNext() {
        this.setDisplayedChild(this.mWhichChild + 1);
    }

    public void showPrevious() {
        this.setDisplayedChild(this.mWhichChild - 1);
    }

    public int modulo(int pos, int size) {
        if (size > 0) {
            return (size + pos % size) % size;
        }
        return 0;
    }

    public View getViewAtRelativeIndex(int relativeIndex) {
        int i;
        if (relativeIndex >= 0 && relativeIndex <= this.getNumActiveViews() - 1 && this.mAdapter != null && this.mViewsMap.get(i = this.modulo(this.mCurrentWindowStartUnbounded + relativeIndex, this.getWindowSize())) != null) {
            return this.mViewsMap.get((Object)Integer.valueOf((int)i)).view;
        }
        return null;
    }

    public int getNumActiveViews() {
        if (this.mAdapter != null) {
            return Math.min(this.getCount() + 1, this.mMaxNumActiveViews);
        }
        return this.mMaxNumActiveViews;
    }

    public int getWindowSize() {
        if (this.mAdapter != null) {
            int adapterCount = this.getCount();
            if (adapterCount <= this.getNumActiveViews() && this.mLoopViews) {
                return adapterCount * this.mMaxNumActiveViews;
            }
            return adapterCount;
        }
        return 0;
    }

    public ViewGroup.LayoutParams createOrReuseLayoutParams(View v) {
        ViewGroup.LayoutParams currentLp = v.getLayoutParams();
        if (currentLp instanceof ViewGroup.LayoutParams) {
            ViewGroup.LayoutParams lp = currentLp;
            return lp;
        }
        return new ViewGroup.LayoutParams(0, 0);
    }

    public void refreshChildren() {
        if (this.mAdapter == null) {
            return;
        }
        for (int i = this.mCurrentWindowStart; i <= this.mCurrentWindowEnd; ++i) {
            int index = this.modulo(i, this.getWindowSize());
            int adapterCount = this.getCount();
            View updatedChild = this.mAdapter.getView(this.modulo(i, adapterCount), null, this);
            if (!this.mViewsMap.containsKey(index)) continue;
            FrameLayout fl = (FrameLayout)this.mViewsMap.get((Object)Integer.valueOf((int)index)).view;
            if (updatedChild == null) continue;
            fl.removeAllViewsInLayout();
            fl.addView(updatedChild);
        }
    }

    public FrameLayout getFrameForChild() {
        return new FrameLayout(this.mContext);
    }

    public void showOnly(int childIndex, boolean animate) {
        if (this.mAdapter == null) {
            return;
        }
        int adapterCount = this.getCount();
        if (adapterCount == 0) {
            return;
        }
        for (int i = 0; i < this.mPreviousViews.size(); ++i) {
            View viewToRemove = this.mViewsMap.get((Object)this.mPreviousViews.get((int)i)).view;
            this.mViewsMap.remove(this.mPreviousViews.get(i));
            viewToRemove.clearAnimation();
            if (viewToRemove instanceof ViewGroup) {
                ViewGroup vg = (ViewGroup)viewToRemove;
                vg.removeAllViewsInLayout();
            }
            this.applyTransformForChildAtIndex(viewToRemove, -1);
            this.removeViewInLayout(viewToRemove);
        }
        this.mPreviousViews.clear();
        int newWindowStartUnbounded = childIndex - this.mActiveOffset;
        int newWindowEndUnbounded = newWindowStartUnbounded + this.getNumActiveViews() - 1;
        int newWindowStart = Math.max(0, newWindowStartUnbounded);
        int newWindowEnd = Math.min(adapterCount - 1, newWindowEndUnbounded);
        if (this.mLoopViews) {
            newWindowStart = newWindowStartUnbounded;
            newWindowEnd = newWindowEndUnbounded;
        }
        int rangeStart = this.modulo(newWindowStart, this.getWindowSize());
        int rangeEnd = this.modulo(newWindowEnd, this.getWindowSize());
        boolean wrap = false;
        if (rangeStart > rangeEnd) {
            wrap = true;
        }
        for (Integer index : this.mViewsMap.keySet()) {
            boolean remove = false;
            if (!(wrap || index >= rangeStart && index <= rangeEnd)) {
                remove = true;
            } else if (wrap && index > rangeEnd && index < rangeStart) {
                remove = true;
            }
            if (!remove) continue;
            View previousView = this.mViewsMap.get((Object)index).view;
            int oldRelativeIndex = this.mViewsMap.get((Object)index).index;
            this.mPreviousViews.add(index);
            this.transformViewForTransition(oldRelativeIndex, -1, previousView, animate);
        }
        if (newWindowStart != this.mCurrentWindowStart || newWindowEnd != this.mCurrentWindowEnd || newWindowStartUnbounded != this.mCurrentWindowStartUnbounded) {
            for (int i = newWindowStart; i <= newWindowEnd; ++i) {
                boolean inOldRange;
                int index = this.modulo(i, this.getWindowSize());
                int oldRelativeIndex = this.mViewsMap.containsKey(index) ? this.mViewsMap.get((Object)Integer.valueOf((int)index)).index : -1;
                int newRelativeIndex = i - newWindowStartUnbounded;
                boolean bl = inOldRange = this.mViewsMap.containsKey(index) && !this.mPreviousViews.contains(index);
                if (inOldRange) {
                    View view = this.mViewsMap.get((Object)Integer.valueOf((int)index)).view;
                    this.mViewsMap.get((Object)Integer.valueOf((int)index)).index = newRelativeIndex;
                    this.applyTransformForChildAtIndex(view, newRelativeIndex);
                    this.transformViewForTransition(oldRelativeIndex, newRelativeIndex, view, animate);
                } else {
                    View newView = this.mAdapter.getView(this.modulo(i, adapterCount), null, this);
                    FrameLayout fl = this.getFrameForChild();
                    if (newView != null) {
                        fl.addView(newView);
                    }
                    this.mViewsMap.put(index, new ViewAndIndex(fl, newRelativeIndex));
                    this.addChild(fl);
                    this.applyTransformForChildAtIndex(fl, newRelativeIndex);
                    this.transformViewForTransition(-1, newRelativeIndex, fl, animate);
                }
                this.mViewsMap.get((Object)Integer.valueOf((int)index)).view.bringToFront();
            }
            this.mCurrentWindowStart = newWindowStart;
            this.mCurrentWindowEnd = newWindowEnd;
            this.mCurrentWindowStartUnbounded = newWindowStartUnbounded;
        }
        this.requestLayout();
        this.invalidate();
    }

    public void addChild(View child) {
        this.addViewInLayout(child, -1, this.createOrReuseLayoutParams(child));
        if (this.mReferenceChildWidth == -1 || this.mReferenceChildHeight == -1) {
            int measureSpec = View.MeasureSpec.makeMeasureSpec(0, 0);
            child.measure(measureSpec, measureSpec);
            this.mReferenceChildWidth = child.getMeasuredWidth();
            this.mReferenceChildHeight = child.getMeasuredHeight();
        }
    }

    public void showTapFeedback(View v) {
        v.setPressed(true);
    }

    public void hideTapFeedback(View v) {
        v.setPressed(false);
    }

    public void cancelHandleClick() {
        View v = this.getCurrentView();
        if (v != null) {
            this.hideTapFeedback(v);
        }
        this.mTouchMode = 0;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        boolean handled = false;
        switch (action) {
            case 0: {
                View v = this.getCurrentView();
                if (v == null || !this.isTransformedTouchPointInView(ev.getX(), ev.getY(), v, null)) break;
                if (this.mPendingCheckForTap == null) {
                    this.mPendingCheckForTap = new CheckForTap();
                }
                this.mTouchMode = 1;
                this.postDelayed(this.mPendingCheckForTap, ViewConfiguration.getTapTimeout());
                break;
            }
            case 2: {
                break;
            }
            case 6: {
                break;
            }
            case 1: {
                View v;
                if (this.mTouchMode == 1 && (v = this.getCurrentView()) != null && this.isTransformedTouchPointInView(ev.getX(), ev.getY(), v, null)) {
                    Handler handler = this.getHandler();
                    if (handler != null) {
                        handler.removeCallbacks(this.mPendingCheckForTap);
                    }
                    this.showTapFeedback(v);
                    this.postDelayed(new Runnable(){

                        public void run() {
                            AdapterViewAnimator.this.hideTapFeedback(v);
                            AdapterViewAnimator.this.post(new Runnable(){

                                public void run() {
                                    AdapterViewAnimator.this.performItemClick(v, 0, 0L);
                                }
                            });
                        }
                    }, ViewConfiguration.getPressedStateDuration());
                    handled = true;
                }
                this.mTouchMode = 0;
                break;
            }
            case 3: {
                View v = this.getCurrentView();
                if (v != null) {
                    this.hideTapFeedback(v);
                }
                this.mTouchMode = 0;
            }
        }
        return handled;
    }

    public void measureChildren() {
        int count = this.getChildCount();
        int childWidth = this.getMeasuredWidth() - this.mPaddingLeft - this.mPaddingRight;
        int childHeight = this.getMeasuredHeight() - this.mPaddingTop - this.mPaddingBottom;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            child.measure(View.MeasureSpec.makeMeasureSpec(childWidth, 0x40000000), View.MeasureSpec.makeMeasureSpec(childHeight, 0x40000000));
        }
    }

    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean haveChildRefSize;
        int widthSpecSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode(heightMeasureSpec);
        boolean bl = haveChildRefSize = this.mReferenceChildWidth != -1 && this.mReferenceChildHeight != -1;
        if (heightSpecMode == 0) {
            heightSpecSize = haveChildRefSize ? this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE && haveChildRefSize) {
            int height = this.mReferenceChildHeight + this.mPaddingTop + this.mPaddingBottom;
            heightSpecSize = height > heightSpecSize ? (heightSpecSize |= 0x1000000) : height;
        }
        if (widthSpecMode == 0) {
            widthSpecSize = haveChildRefSize ? this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight : 0;
        } else if (heightSpecMode == Integer.MIN_VALUE && haveChildRefSize) {
            int width = this.mReferenceChildWidth + this.mPaddingLeft + this.mPaddingRight;
            widthSpecSize = width > widthSpecSize ? (widthSpecSize |= 0x1000000) : width;
        }
        this.setMeasuredDimension(widthSpecSize, heightSpecSize);
        this.measureChildren();
    }

    public void checkForAndHandleDataChanged() {
        boolean dataChanged = this.mDataChanged;
        if (dataChanged) {
            this.post(new Runnable(){

                public void run() {
                    AdapterViewAnimator.this.handleDataChanged();
                    if (AdapterViewAnimator.this.mWhichChild >= AdapterViewAnimator.this.getWindowSize()) {
                        AdapterViewAnimator.this.mWhichChild = 0;
                        AdapterViewAnimator.this.showOnly(AdapterViewAnimator.this.mWhichChild, false);
                    } else if (AdapterViewAnimator.this.mOldItemCount != AdapterViewAnimator.this.getCount()) {
                        AdapterViewAnimator.this.showOnly(AdapterViewAnimator.this.mWhichChild, false);
                    }
                    AdapterViewAnimator.this.refreshChildren();
                    AdapterViewAnimator.this.requestLayout();
                }
            });
        }
        this.mDataChanged = false;
    }

    @Override
    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.checkForAndHandleDataChanged();
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            int childRight = this.mPaddingLeft + child.getMeasuredWidth();
            int childBottom = this.mPaddingTop + child.getMeasuredHeight();
            child.layout(this.mPaddingLeft, this.mPaddingTop, childRight, childBottom);
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mWhichChild);
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mWhichChild = ss.whichChild;
        if (this.mRemoteViewsAdapter != null && this.mAdapter == null) {
            this.mRestoreWhichChild = this.mWhichChild;
        } else {
            this.setDisplayedChild(this.mWhichChild, false);
        }
    }

    public View getCurrentView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    public ObjectAnimator getInAnimation() {
        return this.mInAnimation;
    }

    public void setInAnimation(ObjectAnimator inAnimation) {
        this.mInAnimation = inAnimation;
    }

    public ObjectAnimator getOutAnimation() {
        return this.mOutAnimation;
    }

    public void setOutAnimation(ObjectAnimator outAnimation) {
        this.mOutAnimation = outAnimation;
    }

    public void setInAnimation(Context context, int resourceID) {
        this.setInAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, resourceID));
    }

    public void setOutAnimation(Context context, int resourceID) {
        this.setOutAnimation((ObjectAnimator)AnimatorInflater.loadAnimator(context, resourceID));
    }

    public void setAnimateFirstView(boolean animate) {
        this.mAnimateFirstTime = animate;
    }

    @Override
    public int getBaseline() {
        return this.getCurrentView() != null ? this.getCurrentView().getBaseline() : super.getBaseline();
    }

    @Override
    public Adapter getAdapter() {
        return this.mAdapter;
    }

    @Override
    public void setAdapter(Adapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.mAdapter = adapter;
        this.checkFocus();
        if (this.mAdapter != null) {
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mItemCount = this.mAdapter.getCount();
        }
        this.setFocusable(true);
        this.mWhichChild = 0;
        this.showOnly(this.mWhichChild, false);
    }

    @RemotableViewMethod
    public void setRemoteViewsAdapter(Intent intent) {
        Intent.FilterComparison fcOld;
        Intent.FilterComparison fcNew;
        if (this.mRemoteViewsAdapter != null && (fcNew = new Intent.FilterComparison(intent)).equals(fcOld = new Intent.FilterComparison(this.mRemoteViewsAdapter.getRemoteViewsServiceIntent()))) {
            return;
        }
        this.mRemoteViewsAdapter = new RemoteViewsAdapter(this.getContext(), intent, this);
    }

    @Override
    public void setSelection(int position) {
        this.setDisplayedChild(position);
    }

    @Override
    public View getSelectedView() {
        return this.getViewAtRelativeIndex(this.mActiveOffset);
    }

    @Override
    public boolean onRemoteAdapterConnected() {
        if (this.mRemoteViewsAdapter != this.mAdapter) {
            this.setAdapter(this.mRemoteViewsAdapter);
            if (this.mRestoreWhichChild > -1) {
                this.setDisplayedChild(this.mRestoreWhichChild, false);
                this.mRestoreWhichChild = -1;
            }
            return false;
        }
        if (this.mRemoteViewsAdapter != null) {
            this.mRemoteViewsAdapter.superNotifyDataSetChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onRemoteAdapterDisconnected() {
    }

    @Override
    public void advance() {
        this.showNext();
    }

    @Override
    public void fyiWillBeAdvancedByHostKThx() {
    }

    public static class SavedState
    extends View.BaseSavedState {
        public int whichChild;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState, int whichChild) {
            super(superState);
            this.whichChild = whichChild;
        }

        public SavedState(Parcel in) {
            super(in);
            this.whichChild = in.readInt();
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.whichChild);
        }

        public String toString() {
            return "AdapterViewAnimator.SavedState{ whichChild = " + this.whichChild + " }";
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public class CheckForTap
    implements Runnable {
        public void run() {
            if (AdapterViewAnimator.this.mTouchMode == 1) {
                View v = AdapterViewAnimator.this.getCurrentView();
                AdapterViewAnimator.this.showTapFeedback(v);
            }
        }
    }

    public class ViewAndIndex {
        public View view;
        public int index;

        public ViewAndIndex(View v, int i) {
            this.view = v;
            this.index = i;
        }
    }
}

