/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.widget.RemoteViews;
import com.android.internal.widget.IRemoteViewsFactory;
import java.util.HashMap;

public abstract class RemoteViewsService
extends Service {
    public static final String LOG_TAG = "RemoteViewsService";
    public static final HashMap<Intent.FilterComparison, RemoteViewsFactory> sRemoteViewFactories = new HashMap();
    public static final Object sLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        Object object = sLock;
        synchronized (object) {
            Intent.FilterComparison fc = new Intent.FilterComparison(intent);
            RemoteViewsFactory factory = null;
            boolean isCreated = false;
            if (!sRemoteViewFactories.containsKey(fc)) {
                factory = this.onGetViewFactory(intent);
                sRemoteViewFactories.put(fc, factory);
                factory.onCreate();
                isCreated = false;
            } else {
                factory = sRemoteViewFactories.get(fc);
                isCreated = true;
            }
            return new RemoteViewsFactoryAdapter(factory, isCreated);
        }
    }

    public abstract RemoteViewsFactory onGetViewFactory(Intent var1);

    public static class RemoteViewsFactoryAdapter
    extends IRemoteViewsFactory.Stub {
        public RemoteViewsFactory mFactory;
        public boolean mIsCreated;

        public RemoteViewsFactoryAdapter(RemoteViewsFactory factory, boolean isCreated) {
            this.mFactory = factory;
            this.mIsCreated = isCreated;
        }

        public synchronized boolean isCreated() {
            return this.mIsCreated;
        }

        public synchronized void onDataSetChanged() {
            this.mFactory.onDataSetChanged();
        }

        public synchronized int getCount() {
            return this.mFactory.getCount();
        }

        public synchronized RemoteViews getViewAt(int position) {
            RemoteViews rv = this.mFactory.getViewAt(position);
            rv.setIsWidgetCollectionChild(true);
            return rv;
        }

        public synchronized RemoteViews getLoadingView() {
            return this.mFactory.getLoadingView();
        }

        public synchronized int getViewTypeCount() {
            return this.mFactory.getViewTypeCount();
        }

        public synchronized long getItemId(int position) {
            return this.mFactory.getItemId(position);
        }

        public synchronized boolean hasStableIds() {
            return this.mFactory.hasStableIds();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDestroy(Intent intent) {
            Object object = sLock;
            synchronized (object) {
                Intent.FilterComparison fc = new Intent.FilterComparison(intent);
                if (sRemoteViewFactories.containsKey(fc)) {
                    RemoteViewsFactory factory = (RemoteViewsFactory)sRemoteViewFactories.get(fc);
                    factory.onDestroy();
                    sRemoteViewFactories.remove(fc);
                }
            }
        }
    }

    public static interface RemoteViewsFactory {
        public void onCreate();

        public void onDataSetChanged();

        public void onDestroy();

        public int getCount();

        public RemoteViews getViewAt(int var1);

        public RemoteViews getLoadingView();

        public int getViewTypeCount();

        public long getItemId(int var1);

        public boolean hasStableIds();
    }
}

