/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.util.Calendar;

public class TimePicker
extends FrameLayout {
    public static final boolean DEFAULT_ENABLED_STATE = true;
    public static final int HOURS_IN_HALF_DAY = 12;
    public static final OnTimeChangedListener NO_OP_CHANGE_LISTENER = new OnTimeChangedListener(){

        public void onTimeChanged(TimePicker view, int hourOfDay, int minute) {
        }
    };
    public boolean mIs24HourView;
    public boolean mIsAm;
    public final NumberPicker mHourSpinner;
    public final NumberPicker mMinuteSpinner;
    public final NumberPicker mAmPmSpinner;
    public final TextView mDivider;
    public final Button mAmPmButton;
    public final String[] mAmPmStrings;
    public boolean mIsEnabled = true;
    public OnTimeChangedListener mOnTimeChangedListener;
    public Calendar mTempCalendar;

    public TimePicker(Context context) {
        this(context, null);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        this(context, attrs, 16843633);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyle, 0);
        int layoutResourceId = attributesArray.getResourceId(0, 17367187);
        attributesArray.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        inflater.inflate(layoutResourceId, (ViewGroup)this, true);
        this.mHourSpinner = (NumberPicker)this.findViewById(16908987);
        this.mHourSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                if (!TimePicker.this.is24HourView() && (oldVal == 11 && newVal == 12 || oldVal == 12 && newVal == 11)) {
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mDivider = (TextView)this.findViewById(16908916);
        if (this.mDivider != null) {
            this.mDivider.setText(17039533);
        }
        this.mMinuteSpinner = (NumberPicker)this.findViewById(16908988);
        this.mMinuteSpinner.setMinValue(0);
        this.mMinuteSpinner.setMaxValue(59);
        this.mMinuteSpinner.setOnLongPressUpdateInterval(100L);
        this.mMinuteSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        this.mMinuteSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

            public void onValueChange(NumberPicker spinner, int oldVal, int newVal) {
                int minValue = TimePicker.this.mMinuteSpinner.getMinValue();
                int maxValue = TimePicker.this.mMinuteSpinner.getMaxValue();
                if (oldVal == maxValue && newVal == minValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() + 1;
                    if (!TimePicker.this.is24HourView() && newHour == 12) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                } else if (oldVal == minValue && newVal == maxValue) {
                    int newHour = TimePicker.this.mHourSpinner.getValue() - 1;
                    if (!TimePicker.this.is24HourView() && newHour == 11) {
                        TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                        TimePicker.this.updateAmPmControl();
                    }
                    TimePicker.this.mHourSpinner.setValue(newHour);
                }
                TimePicker.this.onTimeChanged();
            }
        });
        this.mAmPmStrings = new DateFormatSymbols().getAmPmStrings();
        View amPmView = this.findViewById(16908989);
        if (amPmView instanceof Button) {
            this.mAmPmSpinner = null;
            this.mAmPmButton = (Button)amPmView;
            this.mAmPmButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View button) {
                    button.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
            });
        } else {
            this.mAmPmButton = null;
            this.mAmPmSpinner = (NumberPicker)amPmView;
            this.mAmPmSpinner.setMinValue(0);
            this.mAmPmSpinner.setMaxValue(1);
            this.mAmPmSpinner.setDisplayedValues(this.mAmPmStrings);
            this.mAmPmSpinner.setOnValueChangedListener(new NumberPicker.OnValueChangeListener(){

                public void onValueChange(NumberPicker picker, int oldVal, int newVal) {
                    picker.requestFocus();
                    TimePicker.this.mIsAm = !TimePicker.this.mIsAm;
                    TimePicker.this.updateAmPmControl();
                }
            });
        }
        this.updateHourControl();
        this.updateAmPmControl();
        this.mTempCalendar = Calendar.getInstance();
        this.setOnTimeChangedListener(NO_OP_CHANGE_LISTENER);
        this.setCurrentHour(this.mTempCalendar.get(11));
        this.setCurrentMinute(this.mTempCalendar.get(12));
        if (!this.isEnabled()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.mIsEnabled == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mMinuteSpinner.setEnabled(enabled);
        if (this.mDivider != null) {
            this.mDivider.setEnabled(enabled);
        }
        this.mHourSpinner.setEnabled(enabled);
        if (this.mAmPmSpinner != null) {
            this.mAmPmSpinner.setEnabled(enabled);
        } else {
            this.mAmPmButton.setEnabled(enabled);
        }
        this.mIsEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mIsEnabled;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.getCurrentHour(), this.getCurrentMinute(), null);
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setCurrentHour(ss.getHour());
        this.setCurrentMinute(ss.getMinute());
    }

    public void setOnTimeChangedListener(OnTimeChangedListener onTimeChangedListener) {
        this.mOnTimeChangedListener = onTimeChangedListener;
    }

    public Integer getCurrentHour() {
        int currentHour = this.mHourSpinner.getValue();
        if (this.is24HourView()) {
            return currentHour;
        }
        if (this.mIsAm) {
            return currentHour % 12;
        }
        return currentHour % 12 + 12;
    }

    public void setCurrentHour(Integer currentHour) {
        if (currentHour == null || currentHour == this.getCurrentHour()) {
            return;
        }
        if (!this.is24HourView()) {
            if (currentHour >= 12) {
                this.mIsAm = false;
                if (currentHour > 12) {
                    currentHour = currentHour - 12;
                }
            } else {
                this.mIsAm = true;
                if (currentHour == 0) {
                    currentHour = 12;
                }
            }
            this.updateAmPmControl();
        }
        this.mHourSpinner.setValue(currentHour);
        this.onTimeChanged();
    }

    public void setIs24HourView(Boolean is24HourView) {
        if (this.mIs24HourView == is24HourView) {
            return;
        }
        this.mIs24HourView = is24HourView;
        int currentHour = this.getCurrentHour();
        this.updateHourControl();
        this.setCurrentHour(currentHour);
        this.updateAmPmControl();
    }

    public boolean is24HourView() {
        return this.mIs24HourView;
    }

    public Integer getCurrentMinute() {
        return this.mMinuteSpinner.getValue();
    }

    public void setCurrentMinute(Integer currentMinute) {
        if (currentMinute == this.getCurrentMinute()) {
            return;
        }
        this.mMinuteSpinner.setValue(currentMinute);
        this.onTimeChanged();
    }

    public int getBaseline() {
        return this.mHourSpinner.getBaseline();
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        int flags = 1;
        flags = this.mIs24HourView ? (flags |= 0x80) : (flags |= 0x40);
        this.mTempCalendar.set(11, this.getCurrentHour());
        this.mTempCalendar.set(12, this.getCurrentMinute());
        String selectedDateUtterance = DateUtils.formatDateTime(this.mContext, this.mTempCalendar.getTimeInMillis(), flags);
        event.getText().add(selectedDateUtterance);
        return true;
    }

    public void updateHourControl() {
        if (this.is24HourView()) {
            this.mHourSpinner.setMinValue(0);
            this.mHourSpinner.setMaxValue(23);
            this.mHourSpinner.setFormatter(NumberPicker.TWO_DIGIT_FORMATTER);
        } else {
            this.mHourSpinner.setMinValue(1);
            this.mHourSpinner.setMaxValue(12);
            this.mHourSpinner.setFormatter(null);
        }
    }

    public void updateAmPmControl() {
        if (this.is24HourView()) {
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setVisibility(8);
            } else {
                this.mAmPmButton.setVisibility(8);
            }
        } else {
            int index;
            int n = index = this.mIsAm ? 0 : 1;
            if (this.mAmPmSpinner != null) {
                this.mAmPmSpinner.setValue(index);
                this.mAmPmSpinner.setVisibility(0);
            } else {
                this.mAmPmButton.setText(this.mAmPmStrings[index]);
                this.mAmPmButton.setVisibility(0);
            }
        }
        this.sendAccessibilityEvent(4);
    }

    public void onTimeChanged() {
        this.sendAccessibilityEvent(4);
        if (this.mOnTimeChangedListener != null) {
            this.mOnTimeChangedListener.onTimeChanged(this, this.getCurrentHour(), this.getCurrentMinute());
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public final int mHour;
        public final int mMinute;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState, int hour, int minute) {
            super(superState);
            this.mHour = hour;
            this.mMinute = minute;
        }

        public SavedState(Parcel in) {
            super(in);
            this.mHour = in.readInt();
            this.mMinute = in.readInt();
        }

        public int getHour() {
            return this.mHour;
        }

        public int getMinute() {
            return this.mMinute;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mHour);
            dest.writeInt(this.mMinute);
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }

        public /* synthetic */ SavedState(Parcelable x0, int x1, int x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    public static interface OnTimeChangedListener {
        public void onTimeChanged(TimePicker var1, int var2, int var3);
    }
}

