/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.ListFragment;
import android.app.backup.BackupManager;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import java.text.Collator;
import java.util.Arrays;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalePicker
extends ListFragment {
    public static final String TAG = "LocalePicker";
    public static final boolean DEBUG = false;
    public LocaleSelectionListener mListener;

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context) {
        return LocalePicker.constructAdapter(context, 17367126, 16908758);
    }

    public static ArrayAdapter<LocaleInfo> constructAdapter(Context context, int layoutId, int fieldId) {
        Resources resources = context.getResources();
        Object[] locales = Resources.getSystem().getAssets().getLocales();
        String[] specialLocaleCodes = resources.getStringArray(17235977);
        String[] specialLocaleNames = resources.getStringArray(17235978);
        Arrays.sort(locales);
        int origSize = locales.length;
        LocaleInfo[] preprocess = new LocaleInfo[origSize];
        int finalSize = 0;
        for (int i = 0; i < origSize; ++i) {
            Object s = locales[i];
            int len = ((String)s).length();
            if (len != 5) continue;
            String language = ((String)s).substring(0, 2);
            String country = ((String)s).substring(3, 5);
            Locale l = new Locale(language, country);
            if (finalSize == 0) {
                preprocess[finalSize++] = new LocaleInfo(LocalePicker.toTitleCase(l.getDisplayLanguage(l)), l);
                continue;
            }
            if (preprocess[finalSize - 1].locale.getLanguage().equals(language)) {
                preprocess[finalSize - 1].label = LocalePicker.toTitleCase(LocalePicker.getDisplayName(preprocess[finalSize - 1].locale, specialLocaleCodes, specialLocaleNames));
                preprocess[finalSize++] = new LocaleInfo(LocalePicker.toTitleCase(LocalePicker.getDisplayName(l, specialLocaleCodes, specialLocaleNames)), l);
                continue;
            }
            String displayName = ((String)s).equals("zz_ZZ") ? "Pseudo..." : LocalePicker.toTitleCase(l.getDisplayLanguage(l));
            preprocess[finalSize++] = new LocaleInfo(displayName, l);
        }
        Object[] localeInfos = new LocaleInfo[finalSize];
        for (int i = 0; i < finalSize; ++i) {
            localeInfos[i] = preprocess[i];
        }
        Arrays.sort(localeInfos);
        return new ArrayAdapter<Object>(context, layoutId, fieldId, localeInfos);
    }

    public static String toTitleCase(String s) {
        if (s.length() == 0) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static String getDisplayName(Locale l, String[] specialLocaleCodes, String[] specialLocaleNames) {
        String code = l.toString();
        for (int i = 0; i < specialLocaleCodes.length; ++i) {
            if (!specialLocaleCodes[i].equals(code)) continue;
            return specialLocaleNames[i];
        }
        return l.getDisplayName(l);
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        ArrayAdapter<LocaleInfo> adapter = LocalePicker.constructAdapter(this.getActivity());
        this.setListAdapter(adapter);
    }

    public void setLocaleSelectionListener(LocaleSelectionListener listener) {
        this.mListener = listener;
    }

    @Override
    public void onResume() {
        super.onResume();
        this.getListView().requestFocus();
    }

    @Override
    public void onListItemClick(ListView l, View v, int position, long id2) {
        if (this.mListener != null) {
            Locale locale = ((LocaleInfo)this.getListAdapter().getItem((int)position)).locale;
            this.mListener.onLocaleSelected(locale);
        }
    }

    public static void updateLocale(Locale locale) {
        try {
            IActivityManager am = ActivityManagerNative.getDefault();
            Configuration config = am.getConfiguration();
            config.locale = locale;
            config.userSetLocale = true;
            am.updateConfiguration(config);
            BackupManager.dataChanged("com.android.providers.settings");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocaleInfo
    implements Comparable<LocaleInfo> {
        public static final Collator sCollator = Collator.getInstance();
        public String label;
        public Locale locale;

        public LocaleInfo(String label, Locale locale) {
            this.label = label;
            this.locale = locale;
        }

        public String getLabel() {
            return this.label;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            return this.label;
        }

        @Override
        public int compareTo(LocaleInfo another) {
            return sCollator.compare(this.label, another.label);
        }
    }

    public static interface LocaleSelectionListener {
        public void onLocaleSelected(Locale var1);
    }
}

