/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.net;

import android.net.NetworkUtils;
import android.util.Log;
import com.android.internal.net.DNParser;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;

public class DomainNameValidator {
    public static final String TAG = "DomainNameValidator";
    public static final boolean DEBUG = false;
    public static final boolean LOG_ENABLED = false;
    public static final int ALT_DNS_NAME = 2;
    public static final int ALT_IPA_NAME = 7;

    public static boolean match(X509Certificate certificate, String thisDomain) {
        if (certificate == null || thisDomain == null || thisDomain.length() == 0) {
            return false;
        }
        if (!DomainNameValidator.isIpAddress(thisDomain = thisDomain.toLowerCase())) {
            return DomainNameValidator.matchDns(certificate, thisDomain);
        }
        return DomainNameValidator.matchIpAddress(certificate, thisDomain);
    }

    public static boolean isIpAddress(String domain) {
        boolean rval;
        boolean bl = rval = domain != null && domain.length() != 0;
        if (rval) {
            try {
                rval = domain.equals(NetworkUtils.numericToInetAddress(domain).getHostAddress());
            }
            catch (IllegalArgumentException e) {
                rval = false;
            }
        }
        return rval;
    }

    public static boolean matchIpAddress(X509Certificate certificate, String thisDomain) {
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    String altName;
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 7 || (altName = (String)altNameEntry.get(1)) == null || !thisDomain.equalsIgnoreCase(altName)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        return false;
    }

    public static boolean matchDns(X509Certificate certificate, String thisDomain) {
        String cn;
        boolean hasDns = false;
        try {
            Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
            if (subjectAltNames != null) {
                for (List<?> altNameEntry : subjectAltNames) {
                    Integer altNameType;
                    if (altNameEntry == null || 2 > altNameEntry.size() || (altNameType = (Integer)altNameEntry.get(0)) == null || altNameType != 2) continue;
                    hasDns = true;
                    String altName = (String)altNameEntry.get(1);
                    if (altName == null || !DomainNameValidator.matchDns(thisDomain, altName)) continue;
                    return true;
                }
            }
        }
        catch (CertificateParsingException e) {
            String errorMessage = e.getMessage();
            if (errorMessage == null) {
                errorMessage = "failed to parse certificate";
            }
            Log.w(TAG, "DomainNameValidator.matchDns(): " + errorMessage);
            return false;
        }
        if (!hasDns && (cn = new DNParser(certificate.getSubjectX500Principal()).find("cn")) != null) {
            return DomainNameValidator.matchDns(thisDomain, cn);
        }
        return false;
    }

    public static boolean matchDns(String thisDomain, String thatDomain) {
        if (thisDomain == null || thisDomain.length() == 0 || thatDomain == null || thatDomain.length() == 0) {
            return false;
        }
        boolean rval = thisDomain.equals(thatDomain = thatDomain.toLowerCase());
        if (!rval) {
            String[] thatDomainTokens;
            int thatDomainTokensNum;
            String[] thisDomainTokens = thisDomain.split("\\.");
            int thisDomainTokensNum = thisDomainTokens.length;
            if (thisDomainTokensNum >= (thatDomainTokensNum = (thatDomainTokens = thatDomain.split("\\.")).length)) {
                for (int i = thatDomainTokensNum - 1; i >= 0; --i) {
                    rval = thisDomainTokens[i].equals(thatDomainTokens[i]);
                    if (rval) continue;
                    boolean bl = rval = i == 0 && thisDomainTokensNum == thatDomainTokensNum;
                    if (rval && !(rval = thatDomainTokens[0].equals("*"))) {
                        rval = DomainNameValidator.domainTokenMatch(thisDomainTokens[0], thatDomainTokens[0]);
                    }
                    break;
                }
            } else {
                rval = thatDomain.equals("*." + thisDomain);
            }
        }
        return rval;
    }

    public static boolean domainTokenMatch(String thisDomainToken, String thatDomainToken) {
        int starIndex;
        if (thisDomainToken != null && thatDomainToken != null && (starIndex = thatDomainToken.indexOf(42)) >= 0 && thatDomainToken.length() - 1 <= thisDomainToken.length()) {
            String prefix = thatDomainToken.substring(0, starIndex);
            String suffix = thatDomainToken.substring(starIndex + 1);
            return thisDomainToken.startsWith(prefix) && thisDomainToken.endsWith(suffix);
        }
        return false;
    }
}

