/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ActivityManagerNative;
import android.app.ApplicationErrorReport;
import android.ddm.DdmRegister;
import android.os.Build;
import android.os.Debug;
import android.os.IBinder;
import android.os.Process;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.logging.AndroidConfig;
import com.android.internal.os.AndroidPrintStream;
import com.android.internal.os.ZygoteInit;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.VMRuntime;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TimeZone;
import java.util.logging.LogManager;
import org.apache.harmony.luni.internal.util.TimezoneGetter;

public class RuntimeInit {
    public static final String TAG = "AndroidRuntime";
    public static boolean initialized;
    public static IBinder mApplicationObject;
    public static volatile boolean mCrashing;

    public static void commonInit() {
        Thread.setDefaultUncaughtExceptionHandler(new UncaughtHandler(null));
        int hasQwerty = RuntimeInit.getQwertyKeyboard();
        if (hasQwerty == 1) {
            System.setProperty("qwerty", "1");
        }
        TimezoneGetter.setInstance(new TimezoneGetter(){

            public String getId() {
                return SystemProperties.get("persist.sys.timezone");
            }
        });
        TimeZone.setDefault(null);
        LogManager.getLogManager().reset();
        new AndroidConfig();
        String userAgent = RuntimeInit.getDefaultUserAgent();
        System.setProperty("http.agent", userAgent);
        String trace = SystemProperties.get("ro.kernel.android.tracing");
        if (trace.equals("1")) {
            Slog.i(TAG, "NOTE: emulator trace profiling enabled");
            Debug.enableEmulatorTraceOutput();
        }
        initialized = true;
    }

    public static String getDefaultUserAgent() {
        String id2;
        String model;
        StringBuilder result = new StringBuilder(64);
        result.append("Dalvik/");
        result.append(System.getProperty("java.vm.version"));
        result.append(" (Linux; U; Android ");
        String version = Build.VERSION.RELEASE;
        result.append(version.length() > 0 ? version : "1.0");
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            result.append("; ");
            result.append(model);
        }
        if ((id2 = Build.ID).length() > 0) {
            result.append(" Build/");
            result.append(id2);
        }
        result.append(")");
        return result.toString();
    }

    public static void invokeStaticMain(String className, String[] argv) throws ZygoteInit.MethodAndArgsCaller {
        Method m;
        Class<?> cl;
        VMRuntime.getRuntime().setTargetHeapUtilization(0.75f);
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Missing class when invoking static main " + className, ex);
        }
        try {
            m = cl.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("Missing static main on " + className, ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException("Problem getting static main on " + className, ex);
        }
        int modifiers = m.getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new RuntimeException("Main method is not public and static on " + className);
        }
        throw new ZygoteInit.MethodAndArgsCaller(m, argv);
    }

    public static void main(String[] argv) {
        RuntimeInit.commonInit();
        RuntimeInit.finishInit();
    }

    public static void finishInit() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#finishInit()V", true, null);
    }

    public static void zygoteInit(String[] argv) throws ZygoteInit.MethodAndArgsCaller {
        int curArg;
        System.out.close();
        System.setOut(new AndroidPrintStream(4, "System.out"));
        System.err.close();
        System.setErr(new AndroidPrintStream(5, "System.err"));
        RuntimeInit.commonInit();
        RuntimeInit.zygoteInitNative();
        for (curArg = 0; curArg < argv.length; ++curArg) {
            String arg = argv[curArg];
            if (arg.equals("--")) {
                ++curArg;
                break;
            }
            if (!arg.startsWith("--")) break;
            if (!arg.startsWith("--nice-name=")) continue;
            String niceName = arg.substring(arg.indexOf(61) + 1);
            Process.setArgV0(niceName);
        }
        if (curArg == argv.length) {
            Slog.e(TAG, "Missing classname argument to RuntimeInit!");
            return;
        }
        String startClass = argv[curArg++];
        String[] startArgs = new String[argv.length - curArg];
        System.arraycopy(argv, curArg, startArgs, 0, startArgs.length);
        RuntimeInit.invokeStaticMain(startClass, startArgs);
    }

    public static void zygoteInitNative() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#zygoteInitNative()V", true, null);
    }

    public static int isComputerOn() {
        return OverrideMethod.invokeI("com.android.internal.os.RuntimeInit#isComputerOn()I", true, null);
    }

    public static void turnComputerOn() {
        OverrideMethod.invokeV("com.android.internal.os.RuntimeInit#turnComputerOn()V", true, null);
    }

    public static int getQwertyKeyboard() {
        return OverrideMethod.invokeI("com.android.internal.os.RuntimeInit#getQwertyKeyboard()I", true, null);
    }

    public static void wtf(String tag, Throwable t) {
        try {
            if (ActivityManagerNative.getDefault().handleApplicationWtf(mApplicationObject, tag, new ApplicationErrorReport.CrashInfo(t))) {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }
        catch (Throwable t2) {
            Slog.e(TAG, "Error reporting WTF", t2);
        }
    }

    public static void setApplicationObject(IBinder app) {
        mApplicationObject = app;
    }

    public static IBinder getApplicationObject() {
        return mApplicationObject;
    }

    static {
        mCrashing = false;
        DdmRegister.registerHandlers();
    }

    public static class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        public UncaughtHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uncaughtException(Thread t, Throwable e) {
            try {
                if (mCrashing) {
                    return;
                }
                mCrashing = true;
                if (mApplicationObject == null) {
                    Slog.e(RuntimeInit.TAG, "*** FATAL EXCEPTION IN SYSTEM PROCESS: " + t.getName(), e);
                } else {
                    Slog.e(RuntimeInit.TAG, "FATAL EXCEPTION: " + t.getName(), e);
                }
                ActivityManagerNative.getDefault().handleApplicationCrash(mApplicationObject, new ApplicationErrorReport.CrashInfo(e));
            }
            catch (Throwable t2) {
                try {
                    Slog.e(RuntimeInit.TAG, "Error reporting crash", t2);
                }
                catch (Throwable t3) {
                    // empty catch block
                }
            }
            finally {
                Process.killProcess(Process.myPid());
                System.exit(10);
            }
        }

        public /* synthetic */ UncaughtHandler(1 x0) {
            this();
        }
    }
}

